// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

/* This file is part of the GMOD package */

#ifndef __protosH
#define __protosH

#ifndef STDIO__H
#include <stdio.h>
#endif

/* in compress.c */
short compressVoice (short lastVoice, short position, int notesPerTrack,
		      int skip, short firstVoice = 0);

/* in cvtPeriod.c */
void periodToNote (int period, int *note, int *pitchbend);

/* in gmod.c */
int startPlayback (unsigned char);

/* in init.c */
void initVoices (void);

/* int load_669.c */
int load_669_module (FILE * modFd, struct songInfo *songChar,
		     struct optionsInfo options, unsigned char *buffer);

/* in loadMod.c */
int loadModule (char *name, struct songInfo *songChar,
		 struct optionsInfo options);

/* in loadMtm.c */
int loadMtmModule (FILE * modFd, struct songInfo *songChar, 
		     unsigned char *buffer);

/* in loadS3m.c */
int loadS3mModule (FILE ** modFd, struct songInfo *songChar,
		     struct optionsInfo options, unsigned char *buffer,
		     char *command);

/* in loadUlt.c */
int loadUltModule (FILE * modFd, struct songInfo *songChar,
		     struct optionsInfo options, unsigned char *buffer);

/* in loadXm.c */
int loadXmModule (FILE ** modFd, struct songInfo *songChar,
		    struct optionsInfo options, unsigned char *buffer,
		    char *command);

/* in misc.c */
int panning (int ch);
void syncTime (void);
void freePatterns();
void removeNoprint (char *string);

/* in parse.c */
int parseArgs (int argc, char *argv[], struct optionsInfo *options);

/* in playMod.c */
void playModule (int startPosition, struct songInfo *songChar,
		 struct optionsInfo options, int startDelay);
int playNextPosition (void);
int endModule (unsigned char);

/* in playNote.c */
int playNote (int channel, int position, int pattern, struct noteInfo *pat,
	       struct songInfo *songChar, struct effectInfo *effects,
	       struct optionsInfo *options);

#ifndef USE_X
/* in procEvent.c */
void NoXProcessEvent (void);
#endif

/* in procInput.c */
unsigned int procInput (void);

#ifndef USE_X
/* in signals.c */
void timerSet (int mode);
void timerHandler (int sig);

/* in terminal.c */
void terminalSet (int mode);
#endif
#endif
