/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail.attributes.code;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.io.IOException;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserHistory;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.ConstantPoolHyperlinkListener;
import org.gjt.jclasslib.browser.detail.attributes.code.ByteCodeDetailPane;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.bytecode.BranchInstruction;
import org.gjt.jclasslib.bytecode.ImmediateByteInstruction;
import org.gjt.jclasslib.bytecode.ImmediateIntInstruction;
import org.gjt.jclasslib.bytecode.ImmediateShortInstruction;
import org.gjt.jclasslib.bytecode.IncrementInstruction;
import org.gjt.jclasslib.bytecode.InvokeInterfaceInstruction;
import org.gjt.jclasslib.bytecode.LookupSwitchInstruction;
import org.gjt.jclasslib.bytecode.MatchOffsetPair;
import org.gjt.jclasslib.bytecode.MultianewarrayInstruction;
import org.gjt.jclasslib.bytecode.OpcodesUtil;
import org.gjt.jclasslib.bytecode.TableSwitchInstruction;
import org.gjt.jclasslib.io.ByteCodeReader;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;

public class ByteCodeDisplay
extends JPanel
implements Scrollable {
    public static final int MARGIN_X = 3;
    public static final int MARGIN_Y = 3;
    public static final Border BORDER = new EmptyBorder(3, 3, 3, 3);
    private static Map STYLE_BASE;
    private static Map STYLE_NORMAL;
    private static Map STYLE_SMALL;
    private static Map STYLE_LINK;
    private static Map STYLE_OFFSET;
    private static Map STYLE_INSTRUCTION;
    private static Map STYLE_IMMEDIATE_VALUE;
    private static final String TAB_STRING = "        ";
    private ByteCodeDetailPane detailPane;
    private CodeAttribute codeAttribute;
    private ClassFile classFile;
    private int offsetWidth;
    private String offsetBlank;
    private HashMap offsetToLine = new HashMap();
    private ArrayList lines = new ArrayList();
    private ArrayList textLines = new ArrayList();
    private TextLayout[] textLayouts;
    private Map lineToLink = new HashMap();
    private LinkedList currentLineCache = new LinkedList();
    private FontRenderContext frc;
    private float currentHeight;
    private float currentWidth;
    private int lineHeight;
    private int ascent;
    private int characterWidth;

    public static void initStyles(Font font) {
        STYLE_BASE = new HashMap(2);
        if (font != null) {
            STYLE_BASE.put(TextAttribute.FAMILY, font.getFamily());
        } else {
            font = UIManager.getFont("TextArea.font");
            STYLE_BASE.put(TextAttribute.FAMILY, "MonoSpaced");
        }
        STYLE_BASE.put(TextAttribute.SIZE, new Float(font.getSize()));
        STYLE_NORMAL = new HashMap(0);
        STYLE_SMALL = new HashMap(1);
        STYLE_SMALL.put(TextAttribute.SIZE, new Float(font.getSize() - 1));
        STYLE_LINK = new HashMap(3);
        STYLE_LINK.put(TextAttribute.FOREGROUND, new Color(0, 128, 0));
        STYLE_LINK.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        STYLE_LINK.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        STYLE_OFFSET = new HashMap(1);
        STYLE_OFFSET.put(TextAttribute.FOREGROUND, new Color(128, 0, 0));
        STYLE_INSTRUCTION = new HashMap(1);
        STYLE_INSTRUCTION.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        STYLE_IMMEDIATE_VALUE = new HashMap(2);
        STYLE_IMMEDIATE_VALUE.put(TextAttribute.FOREGROUND, Color.magenta);
        STYLE_IMMEDIATE_VALUE.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
    }

    public static String getPaddedValue(int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        String string = String.valueOf(n);
        for (int i = n3 = string.length(); i < n2; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public ByteCodeDisplay(ByteCodeDetailPane byteCodeDetailPane) {
        this.detailPane = byteCodeDetailPane;
        this.setupComponent();
        this.setupEventHandlers();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 10;
        }
        if (this.lineHeight == 0) {
            return 1;
        }
        int n3 = ((JViewport)this.getParent()).getViewPosition().y;
        float f = 1.0f * (float)(n3 - 3) / (float)this.lineHeight;
        int n4 = (int)(n2 < 0 ? Math.floor(f) - 1.0 : Math.ceil(f) + 1.0);
        int n5 = 3 + n4 * this.lineHeight + 1;
        return Math.abs(n3 - n5);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        JViewport jViewport = (JViewport)this.getParent();
        if (n == 0) {
            return jViewport.getWidth();
        }
        if (this.lineHeight == 0) {
            return 1;
        }
        int n3 = jViewport.getViewPosition().y;
        int n4 = n3 + (n2 < 0 ? -1 : 1) * jViewport.getHeight();
        float f = 1.0f * (float)(n4 - 3) / (float)this.lineHeight;
        int n5 = (int)(n2 < 0 ? Math.ceil(f) : Math.floor(f));
        int n6 = 3 + n5 * this.lineHeight + 1;
        return Math.abs(n3 - n6);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public CodeAttribute getCodeAttribute() {
        return this.codeAttribute;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setCodeAttribute(CodeAttribute codeAttribute, ClassFile classFile) {
        this.codeAttribute = codeAttribute;
        this.classFile = classFile;
        this.frc = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        this.setupTextLayouts();
        this.invalidate();
    }

    public void link(Point point) {
        BytecodeLink bytecodeLink = this.getLink(point);
        if (bytecodeLink == null) {
            return;
        }
        this.updateHistory(bytecodeLink.sourceOffset);
        if (bytecodeLink instanceof ConstantPoolLink) {
            ConstantPoolHyperlinkListener.link(this.detailPane.getBrowserServices(), ((ConstantPoolLink)bytecodeLink).cpIndex);
        } else if (bytecodeLink instanceof OffsetLink) {
            int n = ((OffsetLink)bytecodeLink).targetOffset;
            this.scrollToOffset(n);
            this.updateHistory(n);
        }
    }

    public boolean isLink(Point point) {
        return this.getLink(point) != null;
    }

    public void scrollToOffset(int n) {
        Integer n2 = (Integer)this.offsetToLine.get(new Integer(n));
        if (n2 == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(0, n2 * this.lineHeight + 3 + 1, 10, this.getParent().getHeight());
        this.scrollRectToVisible(rectangle);
    }

    public void copyToClipboard() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.textLines.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
        }
        object = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.lineHeight == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(3, 3);
        Rectangle rectangle = graphics.getClipBounds();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fill(rectangle);
        graphics2D.setPaint(paint);
        int n = Math.max(0, rectangle.y / this.lineHeight - 1);
        int n2 = Math.min(this.lines.size(), (rectangle.y + rectangle.height) / this.lineHeight + 1);
        for (int i = n; i < n2; ++i) {
            TextLayout textLayout = this.getOrCreateTextLayout(i);
            textLayout.draw(graphics2D, 0.0f, (float)(i * this.lineHeight) + textLayout.getAscent());
        }
        graphics2D.translate(-3, -3);
    }

    private TextLayout getOrCreateTextLayout(int n) {
        TextLayout textLayout = this.textLayouts[n];
        if (textLayout == null) {
            textLayout = this.textLayouts[n] = new TextLayout(((AttributedString)this.lines.get(n)).getIterator(), this.frc);
        }
        return textLayout;
    }

    private void setupComponent() {
        this.setBorder(BORDER);
        this.setDoubleBuffered(false);
        this.setOpaque(false);
    }

    private void setupEventHandlers() {
    }

    private BytecodeLink getLink(Point point) {
        if (this.lineHeight == 0) {
            return null;
        }
        int n = point.x - 3;
        int n2 = point.y - 3;
        int n3 = n2 / this.lineHeight;
        BytecodeLink bytecodeLink = (BytecodeLink)this.lineToLink.get(new Integer(n3));
        if (bytecodeLink == null) {
            return null;
        }
        TextLayout textLayout = this.getOrCreateTextLayout(n3);
        TextHitInfo textHitInfo = textLayout.hitTestChar(n, n2 - n3 * this.lineHeight);
        int n4 = textHitInfo.getCharIndex();
        if (n4 >= bytecodeLink.startCharIndex && n4 < bytecodeLink.endCharIndex) {
            return bytecodeLink;
        }
        return null;
    }

    private void updateHistory(int n) {
        BrowserServices browserServices = this.detailPane.getBrowserServices();
        TreePath treePath = browserServices.getBrowserComponent().getTreePane().getTree().getSelectionPath();
        BrowserHistory browserHistory = browserServices.getBrowserComponent().getHistory();
        browserHistory.updateHistory(treePath, new Integer(n));
    }

    private void setupTextLayouts() {
        this.lineHeight = 0;
        this.currentHeight = 0.0f;
        this.currentWidth = 0.0f;
        this.textLines.clear();
        this.lines.clear();
        this.textLayouts = null;
        this.offsetToLine.clear();
        this.lineToLink.clear();
        byte[] byArray = this.codeAttribute.getCode();
        try {
            List list = ByteCodeReader.readByteCode(byArray);
            this.calculateOffsetWidth(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AbstractInstruction abstractInstruction = (AbstractInstruction)iterator.next();
                this.addInstructionToDocument(abstractInstruction);
            }
            this.textLayouts = new TextLayout[this.lines.size()];
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setPreferredSize(new Dimension((int)this.currentWidth + 6, (int)this.currentHeight + 6));
    }

    private void calculateOffsetWidth(List list) {
        Object object;
        int n = list.size();
        if (n > 0) {
            object = (AbstractInstruction)list.get(n - 1);
            this.offsetWidth = String.valueOf(((AbstractInstruction)object).getOffset()).length();
        } else {
            this.offsetWidth = 1;
        }
        object = new StringBuffer(this.offsetWidth);
        for (int i = 0; i < this.offsetWidth; ++i) {
            ((StringBuffer)object).append(' ');
        }
        this.offsetBlank = ((StringBuffer)object).toString();
    }

    private void addInstructionToDocument(AbstractInstruction abstractInstruction) {
        int n = abstractInstruction.getOffset();
        this.addOffsetReference(n);
        this.appendString(ByteCodeDisplay.getPaddedValue(n, this.offsetWidth), STYLE_OFFSET);
        this.appendString(" " + abstractInstruction.getOpcodeVerbose(), STYLE_INSTRUCTION);
        this.addOpcodeSpecificInfo(abstractInstruction);
        this.newLine();
    }

    private void addOffsetReference(int n) {
        this.offsetToLine.put(new Integer(n), new Integer(this.getCurrentLine()));
    }

    private void addOpcodeSpecificInfo(AbstractInstruction abstractInstruction) {
        if (abstractInstruction instanceof ImmediateByteInstruction) {
            this.addImmediateByteSpecificInfo((ImmediateByteInstruction)abstractInstruction);
        } else if (abstractInstruction instanceof ImmediateShortInstruction) {
            this.addImmediateShortSpecificInfo((ImmediateShortInstruction)abstractInstruction);
        } else if (abstractInstruction instanceof ImmediateIntInstruction) {
            this.addImmediateIntSpecificInfo((ImmediateIntInstruction)abstractInstruction);
        } else if (abstractInstruction instanceof BranchInstruction) {
            this.addBranchSpecificInfo((BranchInstruction)abstractInstruction);
        } else if (abstractInstruction instanceof TableSwitchInstruction) {
            this.addTableSwitchSpecificInfo((TableSwitchInstruction)abstractInstruction);
        } else if (abstractInstruction instanceof LookupSwitchInstruction) {
            this.addLookupSwitchSpecificInfo((LookupSwitchInstruction)abstractInstruction);
        }
    }

    private void addImmediateByteSpecificInfo(ImmediateByteInstruction immediateByteInstruction) {
        int n = immediateByteInstruction.getOpcode();
        int n2 = immediateByteInstruction.getOffset();
        int n3 = immediateByteInstruction.getImmediateByte();
        if (n == 18) {
            this.addConstantPoolLink(n3, n2);
        } else if (n == 188) {
            String string = OpcodesUtil.getArrayTypeVerbose(n3);
            this.appendString(" " + n3 + " (" + string + ")", STYLE_IMMEDIATE_VALUE);
        } else {
            this.appendString(" " + n3, STYLE_IMMEDIATE_VALUE);
            if (immediateByteInstruction instanceof IncrementInstruction) {
                this.appendString(" by", STYLE_NORMAL);
                this.appendString(" " + ((IncrementInstruction)immediateByteInstruction).getIncrementConst(), STYLE_IMMEDIATE_VALUE);
            }
        }
    }

    private void addImmediateShortSpecificInfo(ImmediateShortInstruction immediateShortInstruction) {
        int n = immediateShortInstruction.getOpcode();
        int n2 = immediateShortInstruction.getOffset();
        int n3 = immediateShortInstruction.getImmediateShort();
        if (n == 17) {
            this.appendString(" " + n3, STYLE_IMMEDIATE_VALUE);
        } else {
            this.addConstantPoolLink(n3, n2);
            if (immediateShortInstruction instanceof InvokeInterfaceInstruction) {
                this.appendString(" count " + ((InvokeInterfaceInstruction)immediateShortInstruction).getCount(), STYLE_IMMEDIATE_VALUE);
            } else if (immediateShortInstruction instanceof MultianewarrayInstruction) {
                this.appendString(" dim " + ((MultianewarrayInstruction)immediateShortInstruction).getDimensions(), STYLE_IMMEDIATE_VALUE);
            }
        }
    }

    private void addImmediateIntSpecificInfo(ImmediateIntInstruction immediateIntInstruction) {
        int n = immediateIntInstruction.getImmediateInt();
        int n2 = immediateIntInstruction.getOffset();
        this.addConstantPoolLink(n, n2);
    }

    private void addBranchSpecificInfo(BranchInstruction branchInstruction) {
        int n = branchInstruction.getBranchOffset();
        int n2 = branchInstruction.getOffset();
        this.addOffsetLink(n, n2);
    }

    private void addTableSwitchSpecificInfo(TableSwitchInstruction tableSwitchInstruction) {
        int n = tableSwitchInstruction.getOffset();
        int n2 = tableSwitchInstruction.getLowByte();
        int n3 = tableSwitchInstruction.getHighByte();
        int[] nArray = tableSwitchInstruction.getJumpOffsets();
        this.appendString(" " + n2 + " to " + n3, STYLE_IMMEDIATE_VALUE);
        this.newLine();
        for (int i = 0; i <= n3 - n2; ++i) {
            this.appendString(this.offsetBlank + TAB_STRING + (i + n2) + ": ", STYLE_IMMEDIATE_VALUE);
            this.addOffsetLink(nArray[i], n);
            this.newLine();
        }
        this.appendString(this.offsetBlank + TAB_STRING + "default: ", STYLE_IMMEDIATE_VALUE);
        this.addOffsetLink(tableSwitchInstruction.getDefaultOffset(), n);
    }

    private void addLookupSwitchSpecificInfo(LookupSwitchInstruction lookupSwitchInstruction) {
        int n = lookupSwitchInstruction.getOffset();
        List list = lookupSwitchInstruction.getMatchOffsetPairs();
        int n2 = list.size();
        this.appendString(" " + n2, STYLE_IMMEDIATE_VALUE);
        this.newLine();
        for (int i = 0; i < n2; ++i) {
            MatchOffsetPair matchOffsetPair = (MatchOffsetPair)list.get(i);
            this.appendString(this.offsetBlank + TAB_STRING + matchOffsetPair.getMatch() + ": ", STYLE_IMMEDIATE_VALUE);
            this.addOffsetLink(matchOffsetPair.getOffset(), n);
            this.newLine();
        }
        this.appendString(this.offsetBlank + TAB_STRING + "default: ", STYLE_IMMEDIATE_VALUE);
        this.addOffsetLink(lookupSwitchInstruction.getDefaultOffset(), n);
    }

    private void addConstantPoolLink(int n, int n2) {
        this.appendString(" ", STYLE_NORMAL);
        int n3 = this.getCurrentCharIndex();
        this.appendString("#" + n, STYLE_LINK);
        int n4 = this.getCurrentCharIndex();
        this.lineToLink.put(new Integer(this.getCurrentLine()), new ConstantPoolLink(n3, n4, n2, n));
        try {
            String string = this.classFile.getConstantPoolEntryName(n);
            if (string.length() > 0) {
                this.appendString(" <" + string + ">", STYLE_SMALL);
            }
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            // empty catch block
        }
    }

    private void addOffsetLink(int n, int n2) {
        int n3 = n + n2;
        this.appendString(" ", STYLE_NORMAL);
        int n4 = this.getCurrentCharIndex();
        this.appendString(String.valueOf(n3), STYLE_LINK);
        int n5 = this.getCurrentCharIndex();
        this.lineToLink.put(new Integer(this.getCurrentLine()), new OffsetLink(n4, n5, n2, n3));
        this.appendString(" (" + (n > 0 ? "+" : "") + String.valueOf(n) + ")", STYLE_IMMEDIATE_VALUE);
    }

    private int getCurrentCharIndex() {
        Iterator iterator = this.currentLineCache.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            LineCacheEntry lineCacheEntry = (LineCacheEntry)iterator.next();
            n += lineCacheEntry.text.length();
        }
        return n;
    }

    private int getCurrentLine() {
        return this.lines.size();
    }

    private void appendString(String string, Map map) {
        this.currentLineCache.add(new LineCacheEntry(string, map));
    }

    private void newLine() {
        Object object;
        String string = this.getCurrentLineText();
        AttributedString attributedString = new AttributedString(string, STYLE_BASE);
        Iterator iterator = this.currentLineCache.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (LineCacheEntry)iterator.next();
            int n2 = n + ((LineCacheEntry)object).text.length();
            attributedString.addAttributes(((LineCacheEntry)object).attributes, n, n2);
            n = n2;
        }
        this.lines.add(attributedString);
        this.textLines.add(string);
        if (this.lineHeight == 0) {
            object = new TextLayout(attributedString.getIterator(), this.frc);
            this.lineHeight = (int)(((TextLayout)object).getAscent() + ((TextLayout)object).getDescent() + ((TextLayout)object).getLeading());
            this.ascent = (int)((TextLayout)object).getAscent();
            object = new TextLayout("0", STYLE_BASE, this.frc);
            this.characterWidth = (int)((TextLayout)object).getAdvance();
        }
        this.currentHeight += (float)this.lineHeight;
        this.currentWidth = Math.max(this.currentWidth, (float)(this.characterWidth * string.length()));
        this.currentLineCache.clear();
    }

    private String getCurrentLineText() {
        StringBuffer stringBuffer = new StringBuffer(this.getCurrentLineLength());
        Iterator iterator = this.currentLineCache.iterator();
        while (iterator.hasNext()) {
            LineCacheEntry lineCacheEntry = (LineCacheEntry)iterator.next();
            stringBuffer.append(lineCacheEntry.text);
        }
        return stringBuffer.toString();
    }

    private int getCurrentLineLength() {
        int n = 0;
        Iterator iterator = this.currentLineCache.iterator();
        while (iterator.hasNext()) {
            LineCacheEntry lineCacheEntry = (LineCacheEntry)iterator.next();
            n += lineCacheEntry.text.length();
        }
        return n;
    }

    static {
        ByteCodeDisplay.initStyles(null);
    }

    private static class OffsetLink
    extends BytecodeLink {
        private int targetOffset;

        private OffsetLink(int n, int n2, int n3, int n4) {
            super(n, n2, n3);
            this.targetOffset = n4;
        }
    }

    private static class ConstantPoolLink
    extends BytecodeLink {
        private int cpIndex;

        private ConstantPoolLink(int n, int n2, int n3, int n4) {
            super(n, n2, n3);
            this.cpIndex = n4;
        }
    }

    private static class BytecodeLink {
        private int startCharIndex;
        private int endCharIndex;
        protected int sourceOffset;

        private BytecodeLink(int n, int n2, int n3) {
            this.startCharIndex = n;
            this.endCharIndex = n2;
            this.sourceOffset = n3;
        }
    }

    private static class LineCacheEntry {
        private String text;
        private Map attributes;

        private LineCacheEntry(String string, Map map) {
            this.text = string;
            this.attributes = map;
        }
    }
}

