/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public final class AxisExpression
extends ComputedExpression {
    private byte axis;
    private NodeTest test;

    public AxisExpression(byte by, NodeTest nodeTest) {
        this.axis = by;
        this.test = nodeTest;
        if (nodeTest instanceof DocumentNodeTest) {
            throw new UnsupportedOperationException("A document-node() test within a path expression is not yet supported");
        }
    }

    public Expression simplify() {
        ComputedExpression computedExpression = this;
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            computedExpression = new ParentNodeExpression();
            ExpressionTool.copyLocationInfo(this, computedExpression);
        }
        return computedExpression;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)object).axis) {
            return false;
        }
        if (this.test == null && ((AxisExpression)object).test == null) {
            return true;
        }
        return this.test.toString().equals(((AxisExpression)object).test.toString());
    }

    public int hashCode() {
        int n = 9375162 + this.axis << 20;
        if (this.test != null) {
            n ^= this.test.getNodeKind() << 16;
            n ^= this.test.getFingerprint();
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public int computeSpecialProperties() {
        return 0x10000 | (Axis.isForwards[this.axis] ? 131072 : 262144) | (Axis.isPeerAxis[this.axis] ? 524288 : 0) | (Axis.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    public final ItemType getItemType() {
        short s = Axis.principalNodeType[this.axis];
        switch (s) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(s);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(this.test.getNodeKind());
    }

    public final int computeCardinality() {
        return 1792;
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item for an axis step is not set");
        }
        if (!(item instanceof NodeInfo)) {
            this.dynamicError("The context item for an axis step is not a node");
        }
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.dynamicError(unsupportedOperationException.getMessage());
            return null;
        }
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString()));
    }
}

