/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.om.XMLChar;

public class BuggyCharacterSet
implements CharacterSet {
    private CharsetEncoder encoder;
    private byte[] charinfo = new byte[65536];
    private StringBuffer supplementary = new StringBuffer(2);
    private static final byte GOOD = 1;
    private static final byte BAD = 2;

    protected BuggyCharacterSet(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public final boolean inCharset(int n) {
        if (n <= 127) {
            return true;
        }
        try {
            if (n <= 65535) {
                if (this.charinfo[n] == 1) {
                    return true;
                }
                if (this.charinfo[n] == 2) {
                    return false;
                }
                this.charinfo[n] = 2;
                char[] cArray = new char[]{(char)n};
                this.encoder.encode(CharBuffer.wrap(cArray));
                this.charinfo[n] = 1;
                return true;
            }
            char[] cArray = new char[]{XMLChar.highSurrogate(n), XMLChar.lowSurrogate(n)};
            this.encoder.encode(CharBuffer.wrap(cArray));
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    private boolean reallyInCharset(CharSequence charSequence) {
        try {
            this.encoder.encode(CharBuffer.wrap(charSequence));
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }
}

