/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.Molecule;
import WIMSchem.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MoleculeStream {
    public static Molecule readUnknown(InputStream istr) throws IOException {
        return MoleculeStream.readUnknown(new BufferedReader(new InputStreamReader(istr)));
    }

    public static Molecule readUnknown(BufferedReader in) throws IOException {
        Molecule mdlmol = null;
        Molecule elmol = null;
        int BUFFMAX = 100000;
        in.mark(100000);
        try {
            mdlmol = MoleculeStream.readMDLMOL(in);
            if (mdlmol != null) {
                in.mark(100000);
            }
        }
        catch (IOException e) {
            mdlmol = null;
            in.reset();
        }
        try {
            elmol = MoleculeStream.readNative(in);
        }
        catch (IOException e) {
            elmol = null;
        }
        if (elmol != null) {
            return elmol;
        }
        if (mdlmol != null) {
            return mdlmol;
        }
        throw new IOException("Unknown or invalid format.");
    }

    public static Molecule readNative(InputStream istr) throws IOException {
        return MoleculeStream.readNative(new BufferedReader(new InputStreamReader(istr)));
    }

    public static Molecule readNative(BufferedReader in) throws IOException {
        Molecule mol = new Molecule();
        String GENERIC_ERROR = "Invalid WIMSchem file.";
        try {
            String[] bits;
            int n;
            String line = in.readLine();
            if (!line.startsWith("SketchEl!") && !line.startsWith("WIMSchem!")) {
                throw new IOException("Not a WIMSchem file...could not find start tag \"SketchEl!\"");
            }
            int p1 = line.indexOf(40);
            int p2 = line.indexOf(44);
            int p3 = line.indexOf(41);
            if (p1 == 0 || p2 == 0 || p3 == 0) {
                throw new IOException("Invalid WIMSchem file.");
            }
            int numAtoms = Integer.parseInt(line.substring(p1 + 1, p2).trim());
            int numBonds = Integer.parseInt(line.substring(p2 + 1, p3).trim());
            for (n = 0; n < numAtoms; ++n) {
                line = in.readLine();
                bits = line.split("[\\=\\,\\;]");
                if (bits.length < 5) {
                    throw new IOException("WIMSchem format error: to few arguments in atomsection  line" + n);
                }
                int num = mol.addAtom(bits[0], Double.parseDouble(bits[1].trim()), Double.parseDouble(bits[2].trim()), Integer.parseInt(bits[3].trim()), Integer.parseInt(bits[4].trim()));
                for (int i = 5; i < bits.length; ++i) {
                    if (bits[i].length() <= 0) continue;
                    if (bits[i].charAt(0) == 'e') {
                        mol.setAtomHExplicit(num, Integer.parseInt(bits[i].substring(1)));
                        continue;
                    }
                    if (bits[i].charAt(0) != 'n') continue;
                    mol.setAtomMapNum(num, Integer.parseInt(bits[i].substring(1)));
                }
            }
            for (n = 0; n < numBonds; ++n) {
                line = in.readLine();
                bits = line.split("[\\-\\=\\,]");
                if (bits.length < 4) {
                    throw new IOException("WIMSchem fromat error : to few aguments in bondsection line " + n);
                }
                mol.addBond(Integer.parseInt(bits[0].trim()), Integer.parseInt(bits[1].trim()), Integer.parseInt(bits[2].trim()), Integer.parseInt(bits[3].trim()));
            }
            line = in.readLine();
            if (line.compareTo("!End") != 0 && line.compareTo("!FIN") != 0) {
                throw new IOException("could not find the end tag \"!End\"");
            }
        }
        catch (Exception e) {
            throw new IOException("Invalid WIMSchem file.");
        }
        return mol;
    }

    public static void writeNative(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.writeNative(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void writeNative(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        out.write("SketchEl!(" + mol.numAtoms() + "," + mol.numBonds() + ")\n");
        for (n = 1; n <= mol.numAtoms(); ++n) {
            String hy = mol.atomHExplicit(n) != -1 ? "e" + mol.atomHExplicit(n) : "i" + mol.atomHydrogens(n);
            out.write(mol.atomElement(n) + "=" + fmt.format(mol.atomX(n)) + "," + fmt.format(mol.atomY(n)) + ";" + mol.atomCharge(n) + "," + mol.atomUnpaired(n) + "," + hy);
            if (mol.atomMapNum(n) > 0) {
                out.write(",n" + mol.atomMapNum(n));
            }
            out.write("\n");
        }
        for (n = 1; n <= mol.numBonds(); ++n) {
            out.write(mol.bondFrom(n) + "-" + mol.bondTo(n) + "=" + mol.bondOrder(n) + "," + mol.bondType(n) + "\n");
        }
        out.write("!End\n");
        out.flush();
    }

    public static Molecule readMDLMOL(BufferedReader in) throws IOException {
        Molecule mol = new Molecule();
        String GENERIC_ERROR = "Invalid MDL MOL file.";
        try {
            int n;
            String line = null;
            for (int n2 = 0; n2 < 4; ++n2) {
                line = in.readLine();
            }
            if (!line.substring(34, 39).equals("V2000")) {
                throw new IOException("Invalid MDL MOL file.");
            }
            int numAtoms = Integer.parseInt(line.substring(0, 3).trim());
            int numBonds = Integer.parseInt(line.substring(3, 6).trim());
            for (n = 0; n < numAtoms; ++n) {
                line = in.readLine();
                double x = Double.parseDouble(line.substring(0, 10).trim());
                double y = Double.parseDouble(line.substring(10, 20).trim());
                String el = line.substring(31, 34).trim();
                int chg = Integer.parseInt(line.substring(36, 39).trim());
                int rad = 0;
                int mapnum = Integer.parseInt(line.substring(60, 63).trim());
                if (chg > 3) {
                    if (chg == 4) {
                        chg = 0;
                        rad = 2;
                    } else {
                        chg = 4 - chg;
                    }
                }
                mol.addAtom(el, x, y, chg, rad);
                mol.setAtomMapNum(mol.numAtoms(), mapnum);
            }
            for (n = 0; n < numBonds; ++n) {
                line = in.readLine();
                int from = Integer.parseInt(line.substring(0, 3).trim());
                int to = Integer.parseInt(line.substring(3, 6).trim());
                int type = Integer.parseInt(line.substring(6, 9).trim());
                int stereo = Integer.parseInt(line.substring(9, 12).trim());
                if (from == to || from < 1 || from > numAtoms || to < 1 || to > numAtoms) {
                    throw new IOException("Invalid MDL MOL file.");
                }
                int order = type >= 1 && type <= 3 ? type : 1;
                int style = 0;
                if (stereo == 1) {
                    style = 1;
                } else if (stereo == 6) {
                    style = 2;
                }
                mol.addBond(from, to, order, style);
            }
            while (!(line = in.readLine()).startsWith("M  END")) {
                int type = 0;
                if (line.startsWith("M  CHG")) {
                    type = 1;
                } else if (line.startsWith("M  RAD")) {
                    type = 2;
                } else if (line.startsWith("M  RGP")) {
                    type = 3;
                }
                if (type <= 0) continue;
                int len = Integer.parseInt(line.substring(6, 9).trim());
                for (int n3 = 0; n3 < len; ++n3) {
                    int apos = Integer.parseInt(line.substring(9 + 8 * n3, 13 + 8 * n3).trim());
                    int aval = Integer.parseInt(line.substring(13 + 8 * n3, 17 + 8 * n3).trim());
                    if (apos < 1 || apos > mol.numAtoms()) continue;
                    if (type == 1) {
                        mol.setAtomCharge(apos, aval);
                        continue;
                    }
                    if (type == 2) {
                        mol.setAtomUnpaired(apos, aval);
                        continue;
                    }
                    if (type != 3) continue;
                    mol.setAtomElement(apos, "R" + aval);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Invalid MDL MOL file.", e);
        }
        return mol;
    }

    public static void writeMDLMOL(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.writeMDLMOL(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void writeMDLMOL(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        String line;
        int n2;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        out.write("\nWIMSchem molfile\n\n");
        out.write(MoleculeStream.intrpad(mol.numAtoms(), 3) + MoleculeStream.intrpad(mol.numBonds(), 3) + "  0  0  0  0  0  0  0  0999 V2000\n");
        int numRGroups = 0;
        int[] rgAtom = new int[mol.numAtoms()];
        int[] rgNumber = new int[mol.numAtoms()];
        for (n2 = 1; n2 <= mol.numAtoms(); ++n2) {
            String str = fmt.format(mol.atomX(n2));
            line = MoleculeStream.rep(" ", 10 - str.length()) + str;
            str = fmt.format(mol.atomY(n2));
            line = line + MoleculeStream.rep(" ", 10 - str.length()) + str;
            line = line + "    0.0000 ";
            str = mol.atomElement(n2);
            if (str.length() > 1 && str.charAt(0) == 'R' && str.charAt(1) >= '0' && str.charAt(1) <= '9') {
                rgAtom[numRGroups] = n2;
                rgNumber[numRGroups] = Util.safeInt(str.substring(1));
                ++numRGroups;
                str = "R#";
            }
            line = line + str + MoleculeStream.rep(" ", 4 - str.length()) + "0";
            int chg = mol.atomCharge(n2);
            int spin = mol.atomUnpaired(n2);
            int mapnum = mol.atomMapNum(n2);
            if (chg >= -3 && chg <= -1) {
                chg = 4 - chg;
            } else if (chg == 0 && spin == 2) {
                chg = 4;
            } else if (chg < 1 || chg > 3) {
                chg = 0;
            }
            line = line + MoleculeStream.intrpad(chg, 3) + "  0  0  0  0  0  0  0" + MoleculeStream.intrpad(mapnum, 3) + "  0  0";
            out.write(line + "\n");
        }
        for (n2 = 1; n2 <= mol.numBonds(); ++n2) {
            int stereo;
            int type = mol.bondOrder(n2);
            if (type < 1 || type > 3) {
                type = 1;
            }
            if ((stereo = mol.bondType(n2)) != 0) {
                if (stereo == 1) {
                    stereo = 1;
                    type = 1;
                } else if (stereo == 2) {
                    stereo = 6;
                    type = 1;
                } else if (stereo == 3) {
                    stereo = 4;
                    type = 1;
                } else {
                    stereo = 0;
                }
            }
            out.write(MoleculeStream.intrpad(mol.bondFrom(n2), 3) + MoleculeStream.intrpad(mol.bondTo(n2), 3) + MoleculeStream.intrpad(type, 3) + MoleculeStream.intrpad(stereo, 3) + "  0  0  0\n");
        }
        int count = 0;
        line = "";
        for (n = 1; n <= mol.numAtoms(); ++n) {
            if (mol.atomCharge(n) == 0) continue;
            line = line + MoleculeStream.intrpad(n, 4) + MoleculeStream.intrpad(mol.atomCharge(n), 4);
            if (++count != 8) continue;
            out.write("M  CHG" + MoleculeStream.intrpad(count, 3) + line + "\n");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("M  CHG" + MoleculeStream.intrpad(count, 3) + line + "\n");
        }
        count = 0;
        line = "";
        for (n = 1; n <= mol.numAtoms(); ++n) {
            if (mol.atomUnpaired(n) == 0) continue;
            line = line + MoleculeStream.intrpad(n, 4) + MoleculeStream.intrpad(mol.atomUnpaired(n), 4);
            if (++count != 8) continue;
            out.write("M  RAD" + MoleculeStream.intrpad(count, 3) + line + "\n");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("M  RAD" + MoleculeStream.intrpad(count, 3) + line + "\n");
        }
        count = 0;
        line = "";
        for (n = 0; n < numRGroups; ++n) {
            line = line + MoleculeStream.intrpad(rgAtom[n], 4) + MoleculeStream.intrpad(rgNumber[n], 4);
            if (++count != 8) continue;
            out.write("M  RGP" + MoleculeStream.intrpad(count, 3) + line + "\n");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("M  RGP" + MoleculeStream.intrpad(count, 3) + line + "\n");
        }
        out.write("M  END\n");
        out.flush();
    }

    public static void writeCMLXML(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.writeCMLXML(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void writeCMLXML(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        out.write("<cml>\n");
        out.write("  <molecule>\n");
        out.write("    <atomArray>\n");
        for (n = 1; n <= mol.numAtoms(); ++n) {
            out.write("      <atom id=\"a" + n + "\" elementType=\"" + mol.atomElement(n) + "\"" + " x2=\"" + mol.atomX(n) + "\" y2=\"" + mol.atomY(n) + "\" hydrogenCount=\"" + mol.atomHydrogens(n) + "\"/>\n");
        }
        out.write("    </atomArray>\n");
        out.write("    <bondArray>\n");
        for (n = 1; n <= mol.numBonds(); ++n) {
            out.write("      <bond id=\"b" + n + "\" atomRefs2=\"a" + mol.bondFrom(n) + " a" + mol.bondTo(n) + "\" order=\"" + mol.bondOrder(n) + "\"/>\n");
        }
        out.write("    </bondArray>\n");
        out.write("  </molecule>\n");
        out.write("</cml>\n");
        out.flush();
    }

    static boolean examineIsDatabase(FileInputStream istr) throws IOException {
        long lastpos = istr.getChannel().position();
        boolean isdb = MoleculeStream.findNextPosition(istr, 0L) >= 0L;
        istr.getChannel().position(lastpos);
        return isdb;
    }

    static long findNextPosition(FileInputStream istr, long startpos) throws IOException {
        FileChannel fch = istr.getChannel();
        fch.position(startpos);
        long pos = startpos;
        long size = fch.size();
        long nextpos = -1L;
        String rec = "";
        while (nextpos < size) {
            int inp = istr.read();
            ++pos;
            if (inp < 0) break;
            char ch = (char)inp;
            if (ch == '\r' || !(rec = rec.concat(String.valueOf(ch))).endsWith("$$$$\n")) continue;
            nextpos = pos;
            break;
        }
        if (nextpos < 0L) {
            return -1L;
        }
        try {
            BufferedReader in = new BufferedReader(new StringReader(rec));
            Molecule mol = MoleculeStream.readMDLMOL(in);
            if (mol == null) {
                nextpos = -1L;
            }
        }
        catch (IOException e) {
            nextpos = -1L;
        }
        return nextpos;
    }

    static Molecule fetchFromPosition(FileInputStream istr, long pos) throws IOException {
        istr.getChannel().position(pos);
        return MoleculeStream.readMDLMOL(new BufferedReader(new InputStreamReader(istr)));
    }

    static String intrpad(int Val, int Len) {
        String str = Integer.toString(Val);
        if ((str = MoleculeStream.rep(" ", Len - str.length()) + str).length() > Len) {
            str = str.substring(0, Len);
        }
        return str;
    }

    static String rep(String Ch, int Len) {
        if (Len <= 0) {
            return "";
        }
        String str = Ch;
        while (str.length() < Len) {
            str = str + Ch;
        }
        return str;
    }
}

