/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import com.sourceforge.knecs.dsm.authorization.DSIAuthService;
import com.sourceforge.knecs.dsm.authorization.NormalizedAceList;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.util.DAVResourcePropertyVector;
import com.sourceforge.knecs.dsm.util.PedigreeUtils;
import com.sourceforge.knecs.dsm.util.TranslationProperty;
import com.sourceforge.knecs.dsm.util.Xlink;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import com.sourceforge.knecs.util.SimpleDateFormat;
import com.sourceforge.knecs.util.UrlUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.webdav.lib.properties.AclProperty;

public class DAVResource
extends Hashtable
implements Comparable {
    public static final String COLLECTION = "collection";
    private String mContent = "";
    protected NormalizedAceList mAceList;
    protected static Logger mLogger = LoggerUtils.getLogger();
    protected String mServer = null;

    public DAVResource() {
    }

    public DAVResource(String url) {
        this.putResourceURL(url);
    }

    public DAVResource(String url, String serverUrl) {
        this.putResourceURL(url);
        this.mServer = serverUrl;
    }

    public DAVResource(DAVResource resource) {
        Enumeration keys = resource.keys();
        while (keys.hasMoreElements()) {
            NSProperty key = (NSProperty)keys.nextElement();
            super.put(key, new DAVResourcePropertyVector((DAVResourcePropertyVector)resource.get(key)));
        }
        this.mAceList = resource.mAceList == null ? null : new NormalizedAceList(resource.mAceList);
    }

    public void dump() {
        System.out.println("DAVResource Dump: ");
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            NSProperty key = (NSProperty)keys.nextElement();
            System.out.println(key.toString() + "=" + ((DAVResourcePropertyVector)this.get(key)).toString());
        }
    }

    public void setContent(String value) {
        this.mContent = value;
    }

    public String getContent() {
        return this.mContent;
    }

    public String getParentDirectory() {
        return UrlUtils.getParentDir(this.getPath());
    }

    public Object putProperty(DSIProperty property) throws Exception {
        if ("acl".equals(property.getLocalName()) && "DAV:".equals(property.getNamespaceURI())) {
            AclProperty aclprop = new AclProperty(null, property.getElement());
            this.mAceList = DSIAuthService.getNormalizedPrivileges(aclprop.getAces(), property.getOwningURL());
            return this.mAceList;
        }
        DAVResourcePropertyVector propVals = new DAVResourcePropertyVector();
        NSProperty propName = property.getPropertyKey();
        String propValue = property.getPropertyAsString().trim();
        if (propValue.length() > 0) {
            propVals.add(propValue);
        } else {
            propValue = property.getPropertyAsXMLString(true).trim();
            String namespace = property.getNamespaceURI();
            if (propValue != null && !propValue.equals("")) {
                if (propValue.indexOf(60) == -1) {
                    propVals.add(propValue);
                } else if (propValue.indexOf("<translation") != -1) {
                    PedigreeUtils.parseTranslations(propValue, propVals);
                } else if (propValue.indexOf("<Bag") != -1) {
                    PedigreeUtils.parseBag(propValue, propVals);
                } else if (propValue.indexOf("<href") != -1 && !namespace.equals("DAV:")) {
                    Xlink link = new Xlink();
                    PedigreeUtils.parseXlink(propValue, link);
                    propVals.add(link);
                } else if (propValue.indexOf("<authenticated") != -1) {
                    propVals.add("authenticated");
                } else if (propValue.indexOf("<unauthenticated") != -1) {
                    propVals.add("unauthenticated");
                } else if (propValue.indexOf("<notebookroot") != -1) {
                    PedigreeUtils.parseChildren(propValue, propVals);
                } else if (propValue.indexOf("<supportedlock") != -1 || propValue.indexOf("<lockentry") != -1 || propValue.indexOf("<acl-sem") != -1 || propValue.indexOf("<supported-privilege") != -1) {
                    propVals.add(propValue);
                } else {
                    String textContent = null;
                    try {
                        textContent = PedigreeUtils.getTextContent(propValue);
                    }
                    catch (Exception ignore) {
                        mLogger.warning("Can't parse " + propValue);
                    }
                    if (textContent != null) {
                        propVals.add(textContent);
                    } else {
                        propVals.add(propValue);
                    }
                }
            }
        }
        return super.put(propName, propVals);
    }

    public Object put(NSProperty propertyID, Object propertyValue) {
        DAVResourcePropertyVector retVal = null;
        if (propertyValue instanceof DAVResourcePropertyVector) {
            DAVResourcePropertyVector propVals = new DAVResourcePropertyVector((DAVResourcePropertyVector)propertyValue);
            retVal = super.put(propertyID, propVals);
        } else {
            DAVResourcePropertyVector propVals = new DAVResourcePropertyVector();
            propVals.add(propertyValue.toString());
            retVal = super.put(propertyID, propVals);
        }
        return retVal;
    }

    public Object put(Object propertyID, Object propertyValue) throws ClassCastException {
        Object retVal = null;
        if (!(propertyID instanceof NSProperty)) {
            throw new ClassCastException("Property identifier must be a NSProperty object, object class received: " + propertyID.getClass().getName());
        }
        this.put((NSProperty)propertyID, propertyValue);
        return retVal;
    }

    public boolean isCollection() {
        boolean retVal = false;
        DAVResourcePropertyVector resourceTypeVec = this.getResourceType();
        if (resourceTypeVec != null && !resourceTypeVec.isEmpty()) {
            String resourceType = ((String)resourceTypeVec.get(0)).toLowerCase();
            retVal = resourceType.indexOf(COLLECTION) >= 0;
        }
        return retVal;
    }

    public String getComparableResourceType() {
        StringBuffer retVal = new StringBuffer();
        if (this.isCollection()) {
            retVal.insert(0, "aaa");
        } else {
            DAVResourcePropertyVector contentTypeVec = this.getContentType();
            if (contentTypeVec != null && !contentTypeVec.isEmpty()) {
                retVal.append((String)contentTypeVec.get(0));
            }
        }
        if (retVal.length() == 0) {
            retVal.append("zzz");
        }
        return retVal.toString();
    }

    public int compareTo(Object other) throws ClassCastException {
        int compare = 0;
        if (other instanceof DAVResource) {
            boolean otherDir;
            boolean thisDir = this.isCollection();
            if (thisDir == (otherDir = ((DAVResource)other).isCollection())) {
                Comparator stringComp;
                String name1 = this.getDavDisplayName();
                String name2 = ((DAVResource)other).getDavDisplayName();
                if (name1 == null) {
                    name1 = this.getFileName();
                }
                if (name2 == null) {
                    name2 = ((DAVResource)other).getFileName();
                }
                if ((compare = (stringComp = String.CASE_INSENSITIVE_ORDER).compare(name1, name2)) == 0) {
                    compare = name1.compareTo(name2);
                }
            } else {
                compare = thisDir ? -1 : 1;
            }
        } else {
            throw new ClassCastException("Uncomparable object sent to DAVResource, class: " + other.getClass().getName());
        }
        return compare;
    }

    public DAVResourcePropertyVector getTitle() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("title"));
    }

    public DAVResourcePropertyVector getResourceURL() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("resourceurl"));
    }

    public String getAnnotationRoot() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("annotationlink"));
        String ret = null;
        if (vec != null) {
            ret = vec.toString();
        }
        return ret;
    }

    public String getPath() {
        String ret = "";
        DAVResourcePropertyVector vec = this.getResourceURL();
        if (vec != null && vec.size() > 0 && !(ret = (String)vec.elementAt(0)).endsWith("/") && this.isCollection()) {
            ret = ret + "/";
        }
        return ret;
    }

    public String getURL() {
        String ret = this.getPath();
        if (!ret.equals("")) {
            ret = UrlUtils.addServer(ret, this.mServer);
        }
        return ret;
    }

    public String getFileName() {
        String fileName = null;
        DAVResourcePropertyVector vec = this.getResourceURL();
        if (vec != null && vec.size() > 0) {
            int slash;
            String url = (String)vec.elementAt(0);
            if (url.endsWith("/") || url.endsWith("\\")) {
                url = url.substring(0, url.length() - 1);
            }
            if ((slash = url.lastIndexOf(47)) == -1) {
                slash = url.lastIndexOf(92);
            }
            fileName = url.substring(slash + 1);
        }
        return fileName;
    }

    public String getDisplayName() {
        String ret = null;
        DAVResourcePropertyVector vec = this.getTitle();
        ret = vec == null ? this.getFileName() : vec.toString();
        return ret;
    }

    public String getDavDisplayName() {
        String ret = null;
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(new NSProperty("DAV::displayname"));
        if (vec != null) {
            ret = vec.toString();
        }
        return ret;
    }

    public String getCreationDate() {
        String ret = null;
        DAVResourcePropertyVector vec = this.getOriginalDate();
        if (vec == null || vec.toString().equals("")) {
            vec = this.getDavCreationDate();
            if (vec != null) {
                ret = vec.toString();
            }
        } else {
            ret = vec.toString();
        }
        return ret;
    }

    public DAVResourcePropertyVector getDavCreationDate() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("davcreationdate"));
        DAVResourcePropertyVector retVec = new DAVResourcePropertyVector();
        if (vec != null && vec.size() > 0) {
            try {
                String time = vec.toString();
                SimpleDateFormat ft = new SimpleDateFormat();
                Date date = ft.parseDAVCreateDate(time);
                if (date != null) {
                    retVec.add(ft.formatDateTime(date));
                } else {
                    retVec = vec;
                }
            }
            catch (Exception e) {
                LoggerUtils.getLogger(this).info(e.toString());
            }
        }
        return retVec;
    }

    public DAVResourcePropertyVector getOriginalDate() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("originaldate"));
        DAVResourcePropertyVector retVec = new DAVResourcePropertyVector();
        if (vec != null && vec.size() > 0) {
            try {
                String time = vec.toString();
                SimpleDateFormat ft = new SimpleDateFormat();
                Date date = ft.parseDateTime(time);
                if (date != null) {
                    retVec.add(ft.formatDateTime(date));
                } else {
                    retVec = vec;
                }
            }
            catch (Exception e) {
                LoggerUtils.getLogger(this).info(e.toString());
            }
        }
        return retVec;
    }

    public Date getLastModifiedDateAsDate() {
        Date ret = null;
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(new NSProperty("DAV::getlastmodified"));
        if (vec != null) {
            try {
                SimpleDateFormat ft = new SimpleDateFormat();
                ret = ft.parseDAVModifiedDate(vec.toString());
            }
            catch (Exception e) {
                LoggerUtils.getLogger(this).info(e.toString());
            }
        }
        return ret;
    }

    public DAVResourcePropertyVector getLastModifiedDate() {
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(new NSProperty("DAV::getlastmodified"));
        DAVResourcePropertyVector retVec = new DAVResourcePropertyVector();
        if (vec != null && vec.size() > 0) {
            try {
                String time = vec.toString();
                SimpleDateFormat ft = new SimpleDateFormat();
                Date date = ft.parseDAVModifiedDate(time);
                if (date != null) {
                    retVec.add(ft.formatDateTime(date));
                } else {
                    retVec = vec;
                }
            }
            catch (Exception e) {
                LoggerUtils.getLogger(this).info(e.toString());
            }
        }
        return retVec;
    }

    public DAVResourcePropertyVector getCreator() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("creator"));
        if (vec == null || vec.toString().length() == 0) {
            vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("davowner"));
            if (vec != null) {
                int pos;
                String userPrin = vec.toString();
                if (userPrin.endsWith("/")) {
                    userPrin = userPrin.substring(0, userPrin.length() - 1);
                }
                if ((pos = userPrin.lastIndexOf("/")) >= 0) {
                    userPrin = userPrin.substring(pos + 1);
                }
                vec = new DAVResourcePropertyVector();
                vec.add(userPrin);
            }
        }
        return vec;
    }

    public DAVResourcePropertyVector getContentLength() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("contentlength"));
    }

    public DAVResourcePropertyVector getContentType() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("contenttype"));
    }

    public String getMimeType() {
        String ret = "";
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector prop = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("contenttype"));
        if (prop != null && prop.size() > 0) {
            ret = (String)prop.get(0);
        }
        return ret;
    }

    public DAVResourcePropertyVector getResourceType() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("resourcetype"));
    }

    public DAVResourcePropertyVector getTranslations() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("hastranslations"));
    }

    public String getTranslation(String type) {
        String url = null;
        DAVResourcePropertyVector translations = this.getTranslations();
        if (translations != null) {
            for (int tdx = 0; tdx < translations.size(); ++tdx) {
                TranslationProperty translation = (TranslationProperty)translations.get(tdx);
                if (translation.getURL().indexOf(type) < 0) continue;
                url = translation.getURL();
                break;
            }
        }
        return url;
    }

    public DAVResourcePropertyVector getChildren() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        return (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("children"));
    }

    public DAVResourcePropertyVector getDescription() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        NSProperty key = CMCSProperties.getPropertyAsNSProperty("description");
        DAVResourcePropertyVector ret = (DAVResourcePropertyVector)this.get(key);
        return ret;
    }

    public DAVResourcePropertyVector getProp(String propName) {
        NSProperty key = new NSProperty(propName);
        DAVResourcePropertyVector ret = (DAVResourcePropertyVector)this.get(key);
        return ret;
    }

    public void putTitle(String title) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("title"), (Object)title);
    }

    public void putResourceURL(String resourceURL) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("resourceurl"), (Object)resourceURL);
    }

    public void putOriginalDate(String originalDate) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("originaldate"), (Object)originalDate);
    }

    public void putCreator(String creator) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("creator"), (Object)creator);
    }

    public void putContentLength(String contentLength) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("contentlength"), (Object)contentLength);
    }

    public void putContentType(String contentType) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("contenttype"), (Object)contentType);
    }

    public void putResourceType(String resourceType) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("resourcetype"), (Object)resourceType);
    }

    public void putTranslations(String translations) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        this.put(CMCSProperties.getPropertyAsNSProperty("hastranslations"), (Object)translations);
    }

    public boolean equals(DAVResource other) {
        boolean ret = false;
        try {
            if (this.compareTo(other) == 0) {
                ret = true;
            }
        }
        catch (ClassCastException e) {
            ret = false;
        }
        return ret;
    }

    public boolean isAuthorized(String userID, String privName) {
        if (this.mAceList == null) {
            return false;
        }
        return this.mAceList.isAuthorized(userID, privName);
    }

    public void resetAces(NormalizedAceList newAces) {
        this.mAceList = newAces;
    }

    public NormalizedAceList getAces() {
        return this.mAceList;
    }

    public boolean isImageFile() {
        String mimeType;
        boolean ret = false;
        DAVResourcePropertyVector vec = this.getContentType();
        if (vec != null && (mimeType = vec.toString()).indexOf("image") >= 0) {
            ret = true;
        }
        return ret;
    }

    public void setServer(String server) {
        this.mServer = server;
    }

    public String getServer() {
        return this.mServer;
    }
}

