/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.tools.graphviz;

import com.sourceforge.knecs.tools.graphviz.Edge;
import com.sourceforge.knecs.tools.graphviz.GraphvizProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.xml.PrintErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Graphviz {
    private static Logger mLogger = LoggerUtils.getLogger();

    private Graphviz() {
    }

    public static void convertToDot(String GXL, File DotFile) {
        mLogger.entering("GraphViz", "convertToDot");
        try {
            Hashtable allVertices = new Hashtable();
            Vector allEdges = new Vector();
            Graphviz.parseGXL(GXL, allVertices, allEdges);
            String dotString = Graphviz.makeDotString(allVertices, allEdges);
            FileOutputStream fos = new FileOutputStream(DotFile);
            PrintStream ps = new PrintStream(fos);
            ps.print(dotString);
            ps.flush();
            ps.close();
            mLogger.exiting("Graphviz", "convertToDOT");
        }
        catch (Exception e) {
            mLogger.severe("OhOh - exception in convertToDot(): " + e.getMessage());
        }
    }

    public static void createGraph(File DotFile, String format, File ImageFile) throws Exception {
        mLogger.entering("Graphviz", "createGraph");
        GraphvizProperties props = GraphvizProperties.getGraphvizProperties();
        String graphvizExe = props.getProperty("graphvizexecutable");
        Vector imageFormats = props.getPropertyAsVector("graphformats");
        if (!imageFormats.contains(format)) {
            mLogger.info("Graphviz does not support format " + format);
            throw new Exception("Graph format not available.");
        }
        String command = graphvizExe + " -T" + format + " " + DotFile.getAbsolutePath() + " -o " + ImageFile.getAbsolutePath();
        mLogger.info("createGraph: command is " + command);
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor();
        mLogger.exiting("Graphviz", "createGraph");
    }

    public static void parseGXL(String s, Hashtable vertices, Vector edges) throws Exception {
        mLogger.entering("Graphviz", "parseGXL");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new PrintErrorHandler());
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        Document doc = db.parse(is);
        NodeList list = doc.getDocumentElement().getElementsByTagName("graph");
        list = list.item(0).getChildNodes();
        Node node = null;
        for (int i = 0; i < list.getLength(); ++i) {
            node = list.item(i);
            String label = Graphviz.getLabel(node);
            mLogger.info("parseGXL: label is " + label);
            if (node.getAttributes() == null || node.getNodeName() == null) continue;
            String type = node.getNodeName().toString().toLowerCase();
            if (type.equals("node")) {
                String id = null;
                Node tmp = node.getAttributes().getNamedItem("id");
                if (tmp != null) {
                    id = tmp.getNodeValue();
                }
                mLogger.info("Parse GXL: node id is " + id);
                vertices.put(id, label);
                continue;
            }
            if (!type.equals("edge")) continue;
            Node tmp = node.getAttributes().getNamedItem("from");
            String source = null;
            if (tmp != null) {
                source = tmp.getNodeValue();
            }
            tmp = node.getAttributes().getNamedItem("to");
            String target = null;
            if (tmp != null) {
                target = tmp.getNodeValue();
            }
            mLogger.info("Parse GXL: edge start and end are " + source + " " + target);
            Edge newEdge = new Edge(source, target, label);
            edges.add(newEdge);
        }
        mLogger.exiting("Graphviz", "parseGXL");
    }

    protected static String getLabel(Node node) {
        String lab = null;
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node attr = children.item(j);
            if (!attr.getNodeName().equals("attr") || !attr.getAttributes().getNamedItem("name").getNodeValue().equals("Label")) continue;
            NodeList values = attr.getChildNodes();
            for (int k = 0; k < values.getLength(); ++k) {
                Node labelNode;
                if (!values.item(k).getNodeName().equals("string") || (labelNode = values.item(k).getFirstChild()) == null) continue;
                lab = labelNode.getNodeValue();
            }
        }
        return lab != null ? lab : new String("");
    }

    public static String makeDotString(Hashtable nodes, Vector edges) throws Exception {
        mLogger.entering("Graphviz", "makeDotString");
        int numColors = 0;
        GraphvizProperties props = GraphvizProperties.getGraphvizProperties();
        Vector colorList = props.getPropertyAsVector("colorlist");
        Hashtable<String, String> colorsUsedHashtable = new Hashtable<String, String>();
        String dotString = new String("digraph pedigree {\n");
        mLogger.info("makeDotString: first dotString is " + dotString);
        Enumeration e = nodes.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            mLogger.info("makeDotString: id is " + id);
            String label = (String)nodes.get(id);
            mLogger.info("makeDotString: label is " + label);
            dotString = dotString + id + " [shape = box, label = \"" + label + "\"];\n";
        }
        for (Edge currentEdge : edges) {
            String colorString;
            String edgeLabel = currentEdge.get_edge_label();
            String edgeStart = currentEdge.get_edge_start();
            String edgeEnd = currentEdge.get_edge_end();
            mLogger.info("makeDotString: edgeLabel is " + edgeLabel);
            if (colorsUsedHashtable.containsKey(edgeLabel)) {
                colorString = (String)colorsUsedHashtable.get(edgeLabel);
            } else {
                colorString = (String)colorList.elementAt(numColors);
                ++numColors;
                colorsUsedHashtable.put(edgeLabel, colorString);
            }
            mLogger.info("makeDotString: colorString is " + colorString);
            dotString = dotString + edgeStart + " -> " + edgeEnd + " [label = \"" + edgeLabel + "\" color = \"" + colorString + "\"];\n";
        }
        dotString = dotString + "}";
        mLogger.info("makeDotString: final dotString is ::: " + dotString);
        mLogger.exiting("Graphviz", "makeDotString");
        return dotString;
    }
}

