QUnit.test('Reflect.deleteMetadata', assert => {
  const { defineMetadata, hasOwnMetadata, deleteMetadata } = Reflect;
  const { create } = Object;
  assert.isFunction(deleteMetadata);
  assert.arity(deleteMetadata, 2);
  assert.name(deleteMetadata, 'deleteMetadata');
  assert.looksNative(deleteMetadata);
  assert.nonEnumerable(Reflect, 'deleteMetadata');
  assert.throws(() => deleteMetadata('key', undefined, undefined), TypeError);
  assert.false(deleteMetadata('key', {}, undefined));
  let object = {};
  defineMetadata('key', 'value', object, undefined);
  assert.true(deleteMetadata('key', object, undefined));
  const prototype = {};
  defineMetadata('key', 'value', prototype, undefined);
  assert.false(deleteMetadata('key', create(prototype), undefined));
  object = {};
  defineMetadata('key', 'value', object, undefined);
  deleteMetadata('key', object, undefined);
  assert.false(hasOwnMetadata('key', object, undefined));
});
