#ifndef _PACKETS_H
#define _PACKETS_H

/* packets.h
   Data structures and functions related to processing of received packets

   Copyright (C) 2007, 2008, 2009, 2010, 2011, 2012, 2013 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Tcl variable that will store the raw data of a decoded packet.
 * This variable is a Tcl BArray object.
 */
#define PACKETDATA_VARNAME "_(packet)"

/*
 * Tcl variable that will store the raw received packet. This
 * variable is a Tcl Packet object.
 */
#define PACKETRAW_VARNAME "_(raw)"

/*
 * Name of global Tcl variable that holds the name of the Tcl namespace
 * where all Tcl dissection variables will be placed in.
 */
#define DISSECTION_NS_VARNAME "dissection_ns"

extern void pkt_init(const char *);
extern int pkt_show_dissection(Tcl_Interp *);
extern int pkt_clear_dissection(Tcl_Interp *, int, Tcl_Obj * const *);
extern int pkt_dissect_tcl(Tcl_Interp *, const u_char *,
			   struct wtap_pkthdr *, frame_data *,
			   dfilter_t *, const char *, int);
extern void pkt_dissect_show(const u_char *, struct wtap_pkthdr *,
			     frame_data *, int);
extern GByteArray *pkt_hash(Tcl_Interp *, const u_char *,
			    struct wtap_pkthdr *, frame_data *);
extern int pkt_isanswer(Tcl_Interp *,
			const u_char *, struct wtap_pkthdr *, frame_data *,
			const u_char *, struct wtap_pkthdr *, frame_data *);

extern column_info cinfo; 

#endif /* _PACKETS_H */
