## API Report File for "@lumino/dragdrop"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { IDisposable } from '@lumino/disposable';
import { MimeData } from '@lumino/coreutils';

// @public
export class Drag implements IDisposable {
    constructor(options: Drag.IOptions);
    dispose(): void;
    readonly dragImage: HTMLElement | null;
    handleEvent(event: Event): void;
    readonly isDisposed: boolean;
    readonly mimeData: MimeData;
    readonly proposedAction: DropAction;
    readonly source: any;
    start(clientX: number, clientY: number): Promise<DropAction>;
    readonly supportedActions: SupportedActions;
    }

// @public
export namespace Drag {
    export interface IOptions {
        dragImage?: HTMLElement;
        mimeData: MimeData;
        proposedAction?: DropAction;
        source?: any;
        supportedActions?: SupportedActions;
    }
    export function overrideCursor(cursor: string): IDisposable;
}

// @public
export type DropAction = 'none' | 'copy' | 'link' | 'move';

// @public
export interface IDragEvent extends MouseEvent {
    dropAction: DropAction;
    readonly mimeData: MimeData;
    readonly proposedAction: DropAction;
    readonly source: any;
    readonly supportedActions: SupportedActions;
}

// @public
export type SupportedActions = DropAction | 'copy-link' | 'copy-move' | 'link-move' | 'all';


// (No @packageDocumentation comment for this package)

```
