; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mcpu=ppc -mtriple=powerpc64-unknown-linux-gnu | FileCheck %s --check-prefix=LINUXASM
; RUN: llc < %s -mtriple=powerpc64-ibm-aix-xcoff | FileCheck %s  --check-prefix=AIXASM

define noundef i64 @add(i64 noundef %a, i64 noundef %b, ptr nocapture noundef writeonly %ovf) {
; LINUXASM-LABEL: add:
; LINUXASM:       # %bb.0: # %entry
; LINUXASM-NEXT:    li 6, 0
; LINUXASM-NEXT:    addc 3, 3, 4
; LINUXASM-NEXT:    addze 4, 6
; LINUXASM-NEXT:    std 4, 0(5)
; LINUXASM-NEXT:    blr

; AIXASM-LABEL: .add:
; AIXASM:       # %bb.0:                                # %entry
; AIXASM-NEXT:    addc 3, 3, 4
; AIXASM-NEXT:    li 4, 0
; AIXASM-NEXT:    addze 4, 4
; AIXASM-NEXT:    std 4, 0(5)
; AIXASM-NEXT:    blr

entry:
  %0 = tail call { i64, i1 } @llvm.uadd.with.overflow.i64(i64 %a, i64 %b)
  %1 = extractvalue { i64, i1 } %0, 1
  %2 = extractvalue { i64, i1 } %0, 0
  %3 = zext i1 %1 to i64
  store i64 %3, ptr %ovf, align 8
  ret i64 %2
}

declare { i64, i1 } @llvm.uadd.with.overflow.i64(i64, i64)

define noundef zeroext i1 @add_overflow(i64 noundef %a, i64 noundef %b, ptr nocapture noundef writeonly %ovf) {
; LINUXASM-LABEL: add_overflow:
; LINUXASM:       # %bb.0: # %entry
; LINUXASM-NEXT:    li 6, 0
; LINUXASM-NEXT:    addc 4, 3, 4
; LINUXASM-NEXT:    addze 3, 6
; LINUXASM-NEXT:    std 4, 0(5)
; LINUXASM-NEXT:    blr

; AIXASM-LABEL: .add_overflow:
; AIXASM:       # %bb.0:                                # %entry
; AIXASM-NEXT:    addc 4, 3, 4
; AIXASM-NEXT:    li 3, 0
; AIXASM-NEXT:    addze 3, 3
; AIXASM-NEXT:    std 4, 0(5)
; AIXASM-NEXT:    blr

entry:
  %0 = tail call { i64, i1 } @llvm.uadd.with.overflow.i64(i64 %a, i64 %b)
  %1 = extractvalue { i64, i1 } %0, 1
  %2 = extractvalue { i64, i1 } %0, 0
  store i64 %2, ptr %ovf, align 8
  ret i1 %1
}

define noundef i64 @addWithCarryIn (i64 noundef %a, i64 noundef %b, i64 noundef %c, ptr nocapture noundef writeonly %ovf) {
; LINUXASM-LABEL: addWithCarryIn:
; LINUXASM:       # %bb.0:                                # %entry
; LINUXASM-NEXT:    li 7, 0
; LINUXASM-NEXT:    addc 3, 3, 4
; LINUXASM-NEXT:    addze 4, 7
; LINUXASM-NEXT:    addc 3, 3, 5
; LINUXASM-NEXT:    addze 5, 7
; LINUXASM-NEXT:    or 4, 4, 5
; LINUXASM-NEXT:    std 4, 0(6)
; LINUXASM-NEXT:    blr

; AIXASM-LABEL: .addWithCarryIn:
; AIXASM:       # %bb.0:                                # %entry
; AIXASM-NEXT:    addc 3, 3, 4
; AIXASM-NEXT:    li 4, 0
; AIXASM-NEXT:    addze 7, 4
; AIXASM-NEXT:    addc 3, 3, 5
; AIXASM-NEXT:    addze 4, 4
; AIXASM-NEXT:    or 4, 7, 4
; AIXASM-NEXT:    std 4, 0(6)
; AIXASM-NEXT:    blr

entry:
  %0 = tail call { i64, i1 } @llvm.uadd.with.overflow.i64(i64 %a, i64 %b)
  %1 = extractvalue { i64, i1 } %0, 1
  %2 = extractvalue { i64, i1 } %0, 0
  %3 = tail call { i64, i1 } @llvm.uadd.with.overflow.i64(i64 %2, i64 %c)
  %4 = extractvalue { i64, i1 } %3, 1
  %5 = extractvalue { i64, i1 } %3, 0
  %6 = or i1 %1, %4
  %7 = zext i1 %6 to i64
  store i64 %7, ptr %ovf, align 8
  ret i64 %5
}
