// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -internal-isystem %S/Inputs/include \
// RUN:   -internal-isystem %S/../../lib/Headers/cuda_wrappers \
// RUN:   -internal-isystem %S/../../lib/Headers/ \
// RUN:   -fcuda-is-device -triple nvptx64 -emit-llvm %s -o - \
// RUN: | FileCheck %s --check-prefix=CUDA
//
// RUN: %clang_cc1 -internal-isystem %S/Inputs/include \
// RUN:   -internal-isystem %S/../../lib/Headers/cuda_wrappers \
// RUN:   -internal-isystem %S/../../lib/Headers/ \
// RUN:   -fcuda-is-device -triple amdgcn -emit-llvm %s -o - \
// RUN: | FileCheck %s --check-prefix=HIP
//
// RUN: %clang_cc1 -internal-isystem %S/Inputs/include \
// RUN:   -internal-isystem %S/../../lib/Headers/ \
// RUN:   -cl-std=CL3.0 -triple amdgcn -emit-llvm %s -o - \
// RUN: | FileCheck %s --check-prefix=OPENCL
//
// RUN: %clang_cc1 -internal-isystem %S/Inputs/include \
// RUN:   -internal-isystem %S/../../lib/Headers/ -cl-std=CL3.0 \
// RUN:   -fopenmp -fopenmp-targets=amdgcn-amd-amdhsa \
// RUN:   -fopenmp-is-target-device -triple amdgcn -emit-llvm %s -o - \
// RUN: | FileCheck %s --check-prefix=OPENMP
//
// RUN: %clang_cc1 -internal-isystem %S/Inputs/include \
// RUN:   -std=c89 -internal-isystem %S/../../lib/Headers/ \
// RUN:   -triple amdgcn-amd-amdhsa -emit-llvm %s -o - \
// RUN: | FileCheck %s --check-prefix=C89

#define _DEFAULT_FN_ATTRS __attribute__((always_inline))
#include <gpuintrin.h>

#ifdef __device__
__device__ int foo() { return __gpu_thread_id_x(); }
#else
// CUDA-LABEL: define dso_local i32 @foo(
// CUDA-SAME: ) #[[ATTR0:[0-9]+]] {
// CUDA-NEXT:  [[ENTRY:.*:]]
// CUDA-NEXT:    [[TMP0:%.*]] = call {{.*}}i32 @llvm.nvvm.read.ptx.sreg.tid.x()
// CUDA-NEXT:    ret i32 [[TMP0]]
//
// HIP-LABEL: define dso_local i32 @foo(
// HIP-SAME: ) #[[ATTR0:[0-9]+]] {
// HIP-NEXT:  [[ENTRY:.*:]]
// HIP-NEXT:    [[RETVAL_I:%.*]] = alloca i32, align 4, addrspace(5)
// HIP-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4, addrspace(5)
// HIP-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// HIP-NEXT:    [[RETVAL_ASCAST_I:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL_I]] to ptr
// HIP-NEXT:    [[TMP0:%.*]] = call noundef {{.*}}i32 @llvm.amdgcn.workitem.id.x()
// HIP-NEXT:    ret i32 [[TMP0]]
//
// OPENCL-LABEL: define dso_local i32 @foo(
// OPENCL-SAME: ) #[[ATTR0:[0-9]+]] {
// OPENCL-NEXT:  [[ENTRY:.*:]]
// OPENCL-NEXT:    [[TMP0:%.*]] = call noundef {{.*}}i32 @llvm.amdgcn.workitem.id.x()
// OPENCL-NEXT:    ret i32 [[TMP0]]
//
// OPENMP-LABEL: define hidden i32 @foo(
// OPENMP-SAME: ) #[[ATTR0:[0-9]+]] {
// OPENMP-NEXT:  [[ENTRY:.*:]]
// OPENMP-NEXT:    [[TMP0:%.*]] = call noundef {{.*}}i32 @llvm.amdgcn.workitem.id.x()
// OPENMP-NEXT:    ret i32 [[TMP0]]
//
// C89-LABEL: define dso_local i32 @foo(
// C89-SAME: ) #[[ATTR2:[0-9]+]] {
// C89-NEXT:  [[ENTRY:.*:]]
// C89-NEXT:    [[RETVAL_I:%.*]] = alloca i32, align 4, addrspace(5)
// C89-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4, addrspace(5)
// C89-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// C89-NEXT:    [[RETVAL_ASCAST_I:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL_I]] to ptr
// C89-NEXT:    [[TMP0:%.*]] = call noundef {{.*}}i32 @llvm.amdgcn.workitem.id.x()
// C89-NEXT:    ret i32 [[TMP0]]
//
int foo() { return __gpu_thread_id_x(); }
#pragma omp declare target to(foo)
#endif
