// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 4
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v \
// RUN:   -target-feature +zvfbfmin \
// RUN:   -target-feature +zvfbfwma -disable-O0-optnone \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m2_bf16m1(
// CHECK-RV64-SAME: <vscale x 8 x bfloat> [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv8bf16(<vscale x 8 x bfloat> [[SRC]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m2_bf16m1(vbfloat16m2_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m4_bf16m1(
// CHECK-RV64-SAME: <vscale x 16 x bfloat> [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv16bf16(<vscale x 16 x bfloat> [[SRC]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m4_bf16m1(vbfloat16m4_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m8_bf16m1(
// CHECK-RV64-SAME: <vscale x 32 x bfloat> [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv32bf16(<vscale x 32 x bfloat> [[SRC]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m8_bf16m1(vbfloat16m8_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x bfloat> @test_vget_v_bf16m4_bf16m2(
// CHECK-RV64-SAME: <vscale x 16 x bfloat> [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x bfloat> @llvm.vector.extract.nxv8bf16.nxv16bf16(<vscale x 16 x bfloat> [[SRC]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
vbfloat16m2_t test_vget_v_bf16m4_bf16m2(vbfloat16m4_t src, size_t index) {
  return __riscv_vget_bf16m2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x bfloat> @test_vget_v_bf16m8_bf16m2(
// CHECK-RV64-SAME: <vscale x 32 x bfloat> [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x bfloat> @llvm.vector.extract.nxv8bf16.nxv32bf16(<vscale x 32 x bfloat> [[SRC]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
vbfloat16m2_t test_vget_v_bf16m8_bf16m2(vbfloat16m8_t src, size_t index) {
  return __riscv_vget_bf16m2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x bfloat> @test_vget_v_bf16m8_bf16m4(
// CHECK-RV64-SAME: <vscale x 32 x bfloat> [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x bfloat> @llvm.vector.extract.nxv16bf16.nxv32bf16(<vscale x 32 x bfloat> [[SRC]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
vbfloat16m4_t test_vget_v_bf16m8_bf16m4(vbfloat16m8_t src, size_t index) {
  return __riscv_vget_bf16m4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x2_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x2_bf16mf4(vbfloat16mf4x2_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x3_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x3_bf16mf4(vbfloat16mf4x3_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x4_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x4_bf16mf4(vbfloat16mf4x4_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x5_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x5_bf16mf4(vbfloat16mf4x5_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x6_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x6_bf16mf4(vbfloat16mf4x6_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x7_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x7_bf16mf4(vbfloat16mf4x7_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x bfloat> @test_vget_v_bf16mf4x8_bf16mf4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x bfloat> [[TMP0]]
//
vbfloat16mf4_t test_vget_v_bf16mf4x8_bf16mf4(vbfloat16mf4x8_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf4(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x2_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x2_bf16mf2(vbfloat16mf2x2_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x3_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x3_bf16mf2(vbfloat16mf2x3_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x4_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x4_bf16mf2(vbfloat16mf2x4_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x5_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x5_bf16mf2(vbfloat16mf2x5_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x6_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x6_bf16mf2(vbfloat16mf2x6_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x7_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x7_bf16mf2(vbfloat16mf2x7_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x bfloat> @test_vget_v_bf16mf2x8_bf16mf2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x bfloat> [[TMP0]]
//
vbfloat16mf2_t test_vget_v_bf16mf2x8_bf16mf2(vbfloat16mf2x8_t src,
                                             size_t index) {
  return __riscv_vget_bf16mf2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x2_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x2_bf16m1(vbfloat16m1x2_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x3_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x3_bf16m1(vbfloat16m1x3_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x4_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x4_bf16m1(vbfloat16m1x4_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x5_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x5_bf16m1(vbfloat16m1x5_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x6_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x6_bf16m1(vbfloat16m1x6_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x7_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x7_bf16m1(vbfloat16m1x7_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x bfloat> @test_vget_v_bf16m1x8_bf16m1(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x bfloat> [[TMP0]]
//
vbfloat16m1_t test_vget_v_bf16m1x8_bf16m1(vbfloat16m1x8_t src, size_t index) {
  return __riscv_vget_bf16m1(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x bfloat> @test_vget_v_bf16m2x2_bf16m2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
vbfloat16m2_t test_vget_v_bf16m2x2_bf16m2(vbfloat16m2x2_t src, size_t index) {
  return __riscv_vget_bf16m2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x bfloat> @test_vget_v_bf16m2x3_bf16m2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
vbfloat16m2_t test_vget_v_bf16m2x3_bf16m2(vbfloat16m2x3_t src, size_t index) {
  return __riscv_vget_bf16m2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x bfloat> @test_vget_v_bf16m2x4_bf16m2(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
vbfloat16m2_t test_vget_v_bf16m2x4_bf16m2(vbfloat16m2x4_t src, size_t index) {
  return __riscv_vget_bf16m2(src, 0);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x bfloat> @test_vget_v_bf16m4x2_bf16m4(
// CHECK-RV64-SAME: target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[SRC:%.*]], i64 noundef [[INDEX:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x bfloat> @llvm.riscv.tuple.extract.nxv16bf16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[SRC]], i32 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
vbfloat16m4_t test_vget_v_bf16m4x2_bf16m4(vbfloat16m4x2_t src, size_t index) {
  return __riscv_vget_bf16m4(src, 0);
}
