; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-b -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IB
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zba -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IBA

define signext i16 @sh1add(i64 %0, i16* %1) {
; RV32I-LABEL: sh1add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    lh a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: sh1add:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    sh1add a0, a0, a2
; RV32IB-NEXT:    lh a0, 0(a0)
; RV32IB-NEXT:    ret
;
; RV32IBA-LABEL: sh1add:
; RV32IBA:       # %bb.0:
; RV32IBA-NEXT:    sh1add a0, a0, a2
; RV32IBA-NEXT:    lh a0, 0(a0)
; RV32IBA-NEXT:    ret
  %3 = getelementptr inbounds i16, i16* %1, i64 %0
  %4 = load i16, i16* %3
  ret i16 %4
}

define i32 @sh2add(i64 %0, i32* %1) {
; RV32I-LABEL: sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: sh2add:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    sh2add a0, a0, a2
; RV32IB-NEXT:    lw a0, 0(a0)
; RV32IB-NEXT:    ret
;
; RV32IBA-LABEL: sh2add:
; RV32IBA:       # %bb.0:
; RV32IBA-NEXT:    sh2add a0, a0, a2
; RV32IBA-NEXT:    lw a0, 0(a0)
; RV32IBA-NEXT:    ret
  %3 = getelementptr inbounds i32, i32* %1, i64 %0
  %4 = load i32, i32* %3
  ret i32 %4
}

define i64 @sh3add(i64 %0, i64* %1) {
; RV32I-LABEL: sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 3
; RV32I-NEXT:    add a1, a2, a0
; RV32I-NEXT:    lw a0, 0(a1)
; RV32I-NEXT:    lw a1, 4(a1)
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: sh3add:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    sh3add a1, a0, a2
; RV32IB-NEXT:    lw a0, 0(a1)
; RV32IB-NEXT:    lw a1, 4(a1)
; RV32IB-NEXT:    ret
;
; RV32IBA-LABEL: sh3add:
; RV32IBA:       # %bb.0:
; RV32IBA-NEXT:    sh3add a1, a0, a2
; RV32IBA-NEXT:    lw a0, 0(a1)
; RV32IBA-NEXT:    lw a1, 4(a1)
; RV32IBA-NEXT:    ret
  %3 = getelementptr inbounds i64, i64* %1, i64 %0
  %4 = load i64, i64* %3
  ret i64 %4
}
