; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:     FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:     FileCheck %s --check-prefix=CHECK-BE

; This test case tests spilling the CR UN bit on Power10. On Power10, this is
; achieved by setb %reg, %CRREG (un bit) -> stw %reg, $FI instead of:
; mfocrf %reg, %CRREG -> rlwinm %reg1, %reg, $SH, 0, 0 -> stw %reg1, $FI.

; Without fine-grained control over clobbering individual CR bits,
; it is difficult to produce a concise test case that will ensure a specific
; bit of any CR field is spilled. We need to test the spilling of a CR bit
; other than the LT bit. Hence this test case is rather complex.

%0 = type { i32, [768 x i8], [768 x i8], [1024 x i8], [768 x i8], [768 x i8], [768 x i8], [768 x i8], [768 x i8], [1024 x i8], [1024 x i8], i32, i16, i16, i16, i16, i16, i16, i32, i32, i32, i16, i16, i32, i32, i32, i32, i32, i32, i32, i16, i16, i16, i16, [64 x i8], i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i32, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i8, i8, i8, i8, i16, i16, i16, i16, i16, i16, float, float, i32, i16, i16, float, i16, i16, i16, i16}
%1 = type opaque
%2 = type { i8* }
%3 = type { %3*, %3*, %4* (i8*)*, %2, i32, %2, %2*, i8*, double*, float*, i8*, i8*, %4* }
%4 = type { %4*, %4*, %4*, i32, i32, i32, i32, i32, i8*, [3 x float], i8, [64 x i8] }

@global_1 = external dso_local unnamed_addr constant [1 x i8], align 1
@global_2 = external local_unnamed_addr global %0, align 8
@global_3 = external local_unnamed_addr global i8* (i64, i8*)*, align 8
@global_4 = external dso_local unnamed_addr constant [14 x i8], align 1

declare i8 @call_1(%1*) local_unnamed_addr
declare i32 @call_2(%2*, %1*) local_unnamed_addr
declare i32 @call_3(%2*, %1*) local_unnamed_addr
declare %3* @call_4(%4*, i32, i32, i32, i32, i32, i16, i16, %2*, %1*, i32, float, float, float, float, i8*) local_unnamed_addr
declare i32 @call_5(i8*) local_unnamed_addr
declare i8 @call_6(%1*, i32) local_unnamed_addr

define dso_local void @P10_Spill_CR_UN(%2* %arg, %1* %arg1, i32 %arg2) local_unnamed_addr {
; CHECK-LABEL: P10_Spill_CR_UN:
; CHECK:         .localentry P10_Spill_CR_UN, 1
; CHECK-NEXT:  # %bb.0: # %bb
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    mfcr r12
; CHECK-NEXT:    std r0, 16(r1)
; CHECK-NEXT:    stw r12, 8(r1)
; CHECK-NEXT:    stdu r1, -224(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 224
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r27, -40
; CHECK-NEXT:    .cfi_offset r28, -32
; CHECK-NEXT:    .cfi_offset r29, -24
; CHECK-NEXT:    .cfi_offset r30, -16
; CHECK-NEXT:    .cfi_offset cr2, 8
; CHECK-NEXT:    .cfi_offset cr3, 8
; CHECK-NEXT:    .cfi_offset cr4, 8
; CHECK-NEXT:    std r29, 200(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, 208(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    mr r30, r4
; CHECK-NEXT:    std r27, 184(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 192(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r28, r5
; CHECK-NEXT:    bl call_1@notoc
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    mr r3, r29
; CHECK-NEXT:    mr r4, r30
; CHECK-NEXT:    crnot 4*cr2+eq, eq
; CHECK-NEXT:    bl call_2@notoc
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    srwi r3, r28, 4
; CHECK-NEXT:    andi. r3, r3, 1
; CHECK-NEXT:    crmove 4*cr2+gt, gt
; CHECK-NEXT:    bc 12, 4*cr5+lt, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %bb9
; CHECK-NEXT:    mr r3, r29
; CHECK-NEXT:    mr r4, r30
; CHECK-NEXT:    bl call_3@notoc
; CHECK-NEXT:  .LBB0_2: # %bb12
; CHECK-NEXT:    srwi r3, r28, 7
; CHECK-NEXT:    andi. r3, r3, 1
; CHECK-NEXT:    crmove 4*cr2+un, gt
; CHECK-NEXT:    bc 12, 4*cr2+eq, .LBB0_7
; CHECK-NEXT:  # %bb.3: # %bb37
; CHECK-NEXT:    lwz r28, 0(r3)
; CHECK-NEXT:    bc 12, 4*cr5+lt, .LBB0_5
; CHECK-NEXT:  # %bb.4: # %bb37
; CHECK-NEXT:    bc 4, 4*cr5+lt, .LBB0_14
; CHECK-NEXT:  .LBB0_5: # %bb42
; CHECK-NEXT:    li r4, 0
; CHECK-NEXT:    paddi r3, 0, global_1@PCREL, 1
; CHECK-NEXT:    cmpwi r28, 0
; CHECK-NEXT:    isel r3, r3, r4, 4*cr2+gt
; CHECK-NEXT:    crnot 4*cr2+lt, eq
; CHECK-NEXT:    bl call_5@notoc
; CHECK-NEXT:    pld r3, global_2@got@pcrel(0), 1
; CHECK-NEXT:    addi r3, r3, 8682
; CHECK-NEXT:    lxsihzx v2, 0, r3
; CHECK-NEXT:    vextsh2d v2, v2
; CHECK-NEXT:    xscvsxdsp f0, v2
; CHECK-NEXT:    bc 12, 4*cr2+lt, .LBB0_12
; CHECK-NEXT:  # %bb.6: # %bb42
; CHECK-NEXT:    xxspltidp vs1, 1069547520
; CHECK-NEXT:    b .LBB0_13
; CHECK-NEXT:  .LBB0_7: # %bb19
; CHECK-NEXT:    setnbc r3, 4*cr2+un
; CHECK-NEXT:    paddi r4, 0, global_4@PCREL, 1
; CHECK-NEXT:    stw r3, 176(r1)
; CHECK-NEXT:    pld r3, global_3@got@pcrel(0), 1
; CHECK-NEXT:  .Lpcrel0:
; CHECK-NEXT:    .reloc .Lpcrel0-8,R_PPC64_PCREL_OPT,.-(.Lpcrel0-8)
; CHECK-NEXT:    ld r12, 0(r3)
; CHECK-NEXT:    mtctr r12
; CHECK-NEXT:    bctrl
; CHECK-NEXT:    cmpdi cr4, r3, 0
; CHECK-NEXT:    andi. r3, r28, 4
; CHECK-NEXT:    cmpwi cr2, r27, 0
; CHECK-NEXT:    mcrf cr3, cr0
; CHECK-NEXT:    .p2align 5
; CHECK-NEXT:  .LBB0_8: # %bb27
; CHECK-NEXT:    #
; CHECK-NEXT:    mr r3, r30
; CHECK-NEXT:    li r4, 0
; CHECK-NEXT:    bl call_6@notoc
; CHECK-NEXT:    bc 4, 4*cr4+eq, .LBB0_18
; CHECK-NEXT:  # %bb.9: # %bb31
; CHECK-NEXT:    #
; CHECK-NEXT:    bc 4, 4*cr3+eq, .LBB0_18
; CHECK-NEXT:  # %bb.10: # %bb33
; CHECK-NEXT:    #
; CHECK-NEXT:    bc 4, 4*cr2+eq, .LBB0_8
; CHECK-NEXT:  # %bb.11: # %bb36
; CHECK-NEXT:    stb r3, 181(r1)
; CHECK-NEXT:    # implicit-def: $cr2un
; CHECK-NEXT:    mfocrf r3, 32
; CHECK-NEXT:    lwz r4, 176(r1)
; CHECK-NEXT:    rlwimi r3, r4, 21, 11, 11
; CHECK-NEXT:    mtocrf 32, r3
; CHECK-NEXT:    b .LBB0_16
; CHECK-NEXT:  .LBB0_12:
; CHECK-NEXT:    xxspltidp vs1, 1071644672
; CHECK-NEXT:  .LBB0_13: # %bb42
; CHECK-NEXT:    xsmulsp f0, f1, f0
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    b .LBB0_15
; CHECK-NEXT:  .LBB0_14: # %bb41
; CHECK-NEXT:    # implicit-def: $r3
; CHECK-NEXT:  .LBB0_15: # %bb50
; CHECK-NEXT:    li r4, 0
; CHECK-NEXT:    xxspltidp vs3, -1082130432
; CHECK-NEXT:    extsh r9, r3
; CHECK-NEXT:    extsw r6, r28
; CHECK-NEXT:    li r5, 0
; CHECK-NEXT:    std r30, 104(r1)
; CHECK-NEXT:    std r29, 96(r1)
; CHECK-NEXT:    li r7, 0
; CHECK-NEXT:    li r8, 0
; CHECK-NEXT:    li r10, 0
; CHECK-NEXT:    fmr f4, f3
; CHECK-NEXT:    xxlxor f1, f1, f1
; CHECK-NEXT:    std r4, 152(r1)
; CHECK-NEXT:    li r4, -1
; CHECK-NEXT:    std r4, 112(r1)
; CHECK-NEXT:    li r4, 1024
; CHECK-NEXT:    bl call_4@notoc
; CHECK-NEXT:  .LBB0_16: # %bb54
; CHECK-NEXT:    bc 12, 4*cr2+un, .LBB0_19
; CHECK-NEXT:  # %bb.17: # %bb56
; CHECK-NEXT:    ld r30, 208(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 200(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 192(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r27, 184(r1) # 8-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 224
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    lwz r12, 8(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    mtocrf 32, r12
; CHECK-NEXT:    mtocrf 16, r12
; CHECK-NEXT:    mtocrf 8, r12
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB0_18: # %bb30
; CHECK-NEXT:    stb r3, 181(r1)
; CHECK-NEXT:  .LBB0_19: # %bb55
;
; CHECK-BE-LABEL: P10_Spill_CR_UN:
; CHECK-BE:       # %bb.0: # %bb
; CHECK-BE-NEXT:    mflr r0
; CHECK-BE-NEXT:    mfcr r12
; CHECK-BE-NEXT:    std r0, 16(r1)
; CHECK-BE-NEXT:    stw r12, 8(r1)
; CHECK-BE-NEXT:    stdu r1, -240(r1)
; CHECK-BE-NEXT:    .cfi_def_cfa_offset 240
; CHECK-BE-NEXT:    .cfi_offset lr, 16
; CHECK-BE-NEXT:    .cfi_offset r27, -40
; CHECK-BE-NEXT:    .cfi_offset r28, -32
; CHECK-BE-NEXT:    .cfi_offset r29, -24
; CHECK-BE-NEXT:    .cfi_offset r30, -16
; CHECK-BE-NEXT:    .cfi_offset cr2, 8
; CHECK-BE-NEXT:    .cfi_offset cr2, 8
; CHECK-BE-NEXT:    .cfi_offset cr2, 8
; CHECK-BE-NEXT:    std r29, 216(r1) # 8-byte Folded Spill
; CHECK-BE-NEXT:    std r30, 224(r1) # 8-byte Folded Spill
; CHECK-BE-NEXT:    mr r29, r3
; CHECK-BE-NEXT:    mr r3, r4
; CHECK-BE-NEXT:    mr r30, r4
; CHECK-BE-NEXT:    std r27, 200(r1) # 8-byte Folded Spill
; CHECK-BE-NEXT:    std r28, 208(r1) # 8-byte Folded Spill
; CHECK-BE-NEXT:    mr r28, r5
; CHECK-BE-NEXT:    bl call_1
; CHECK-BE-NEXT:    nop
; CHECK-BE-NEXT:    cmpwi r3, 0
; CHECK-BE-NEXT:    mr r3, r29
; CHECK-BE-NEXT:    mr r4, r30
; CHECK-BE-NEXT:    crnot 4*cr2+eq, eq
; CHECK-BE-NEXT:    bl call_2
; CHECK-BE-NEXT:    nop
; CHECK-BE-NEXT:    mr r27, r3
; CHECK-BE-NEXT:    srwi r3, r28, 4
; CHECK-BE-NEXT:    andi. r3, r3, 1
; CHECK-BE-NEXT:    crmove 4*cr2+gt, gt
; CHECK-BE-NEXT:    bc 12, 4*cr5+lt, .LBB0_2
; CHECK-BE-NEXT:  # %bb.1: # %bb9
; CHECK-BE-NEXT:    mr r3, r29
; CHECK-BE-NEXT:    mr r4, r30
; CHECK-BE-NEXT:    bl call_3
; CHECK-BE-NEXT:    nop
; CHECK-BE-NEXT:  .LBB0_2: # %bb12
; CHECK-BE-NEXT:    srwi r3, r28, 7
; CHECK-BE-NEXT:    andi. r3, r3, 1
; CHECK-BE-NEXT:    crmove 4*cr2+un, gt
; CHECK-BE-NEXT:    bc 12, 4*cr2+eq, .LBB0_7
; CHECK-BE-NEXT:  # %bb.3: # %bb37
; CHECK-BE-NEXT:    lwz r28, 0(r3)
; CHECK-BE-NEXT:    addis r3, r2, global_1@toc@ha
; CHECK-BE-NEXT:    bc 12, 4*cr5+lt, .LBB0_5
; CHECK-BE-NEXT:  # %bb.4: # %bb37
; CHECK-BE-NEXT:    bc 4, 4*cr5+lt, .LBB0_14
; CHECK-BE-NEXT:  .LBB0_5: # %bb42
; CHECK-BE-NEXT:    addi r3, r3, global_1@toc@l
; CHECK-BE-NEXT:    li r4, 0
; CHECK-BE-NEXT:    cmpwi r28, 0
; CHECK-BE-NEXT:    isel r3, r3, r4, 4*cr2+gt
; CHECK-BE-NEXT:    crnot 4*cr2+lt, eq
; CHECK-BE-NEXT:    bl call_5
; CHECK-BE-NEXT:    nop
; CHECK-BE-NEXT:    addis r3, r2, .LC0@toc@ha
; CHECK-BE-NEXT:    ld r3, .LC0@toc@l(r3)
; CHECK-BE-NEXT:    addi r3, r3, 8682
; CHECK-BE-NEXT:    lxsihzx v2, 0, r3
; CHECK-BE-NEXT:    vextsh2d v2, v2
; CHECK-BE-NEXT:    xscvsxdsp f0, v2
; CHECK-BE-NEXT:    bc 12, 4*cr2+lt, .LBB0_12
; CHECK-BE-NEXT:  # %bb.6: # %bb42
; CHECK-BE-NEXT:    xxspltidp vs1, 1069547520
; CHECK-BE-NEXT:    b .LBB0_13
; CHECK-BE-NEXT:  .LBB0_7: # %bb19
; CHECK-BE-NEXT:    setnbc r3, 4*cr2+un
; CHECK-BE-NEXT:    addis r4, r2, global_4@toc@ha
; CHECK-BE-NEXT:    stw r3, 192(r1)
; CHECK-BE-NEXT:    addis r3, r2, .LC1@toc@ha
; CHECK-BE-NEXT:    std r2, 40(r1)
; CHECK-BE-NEXT:    addi r4, r4, global_4@toc@l
; CHECK-BE-NEXT:    ld r3, .LC1@toc@l(r3)
; CHECK-BE-NEXT:    ld r3, 0(r3)
; CHECK-BE-NEXT:    ld r2, 8(r3)
; CHECK-BE-NEXT:    ld r11, 16(r3)
; CHECK-BE-NEXT:    ld r3, 0(r3)
; CHECK-BE-NEXT:    mtctr r3
; CHECK-BE-NEXT:    bctrl
; CHECK-BE-NEXT:    ld 2, 40(r1)
; CHECK-BE-NEXT:    cmpdi cr4, r3, 0
; CHECK-BE-NEXT:    andi. r3, r28, 4
; CHECK-BE-NEXT:    cmpwi cr2, r27, 0
; CHECK-BE-NEXT:    mcrf cr3, cr0
; CHECK-BE-NEXT:    .p2align 5
; CHECK-BE-NEXT:  .LBB0_8: # %bb27
; CHECK-BE-NEXT:    #
; CHECK-BE-NEXT:    mr r3, r30
; CHECK-BE-NEXT:    li r4, 0
; CHECK-BE-NEXT:    bl call_6
; CHECK-BE-NEXT:    nop
; CHECK-BE-NEXT:    bc 4, 4*cr4+eq, .LBB0_18
; CHECK-BE-NEXT:  # %bb.9: # %bb31
; CHECK-BE-NEXT:    #
; CHECK-BE-NEXT:    bc 4, 4*cr3+eq, .LBB0_18
; CHECK-BE-NEXT:  # %bb.10: # %bb33
; CHECK-BE-NEXT:    #
; CHECK-BE-NEXT:    bc 4, 4*cr2+eq, .LBB0_8
; CHECK-BE-NEXT:  # %bb.11: # %bb36
; CHECK-BE-NEXT:    stb r3, 197(r1)
; CHECK-BE-NEXT:    # implicit-def: $cr2un
; CHECK-BE-NEXT:    mfocrf r3, 32
; CHECK-BE-NEXT:    lwz r4, 192(r1)
; CHECK-BE-NEXT:    rlwimi r3, r4, 21, 11, 11
; CHECK-BE-NEXT:    mtocrf 32, r3
; CHECK-BE-NEXT:    b .LBB0_16
; CHECK-BE-NEXT:  .LBB0_12:
; CHECK-BE-NEXT:    xxspltidp vs1, 1071644672
; CHECK-BE-NEXT:  .LBB0_13: # %bb42
; CHECK-BE-NEXT:    xsmulsp f0, f1, f0
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mffprwz r3, f0
; CHECK-BE-NEXT:    b .LBB0_15
; CHECK-BE-NEXT:  .LBB0_14: # %bb41
; CHECK-BE-NEXT:    # implicit-def: $r3
; CHECK-BE-NEXT:  .LBB0_15: # %bb50
; CHECK-BE-NEXT:    li r4, 0
; CHECK-BE-NEXT:    xxspltidp vs3, -1082130432
; CHECK-BE-NEXT:    extsh r9, r3
; CHECK-BE-NEXT:    extsw r6, r28
; CHECK-BE-NEXT:    li r5, 0
; CHECK-BE-NEXT:    std r30, 120(r1)
; CHECK-BE-NEXT:    std r29, 112(r1)
; CHECK-BE-NEXT:    li r7, 0
; CHECK-BE-NEXT:    li r8, 0
; CHECK-BE-NEXT:    li r10, 0
; CHECK-BE-NEXT:    fmr f4, f3
; CHECK-BE-NEXT:    xxlxor f1, f1, f1
; CHECK-BE-NEXT:    std r4, 168(r1)
; CHECK-BE-NEXT:    li r4, -1
; CHECK-BE-NEXT:    std r4, 128(r1)
; CHECK-BE-NEXT:    li r4, 1024
; CHECK-BE-NEXT:    bl call_4
; CHECK-BE-NEXT:    nop
; CHECK-BE-NEXT:  .LBB0_16: # %bb54
; CHECK-BE-NEXT:    bc 12, 4*cr2+un, .LBB0_19
; CHECK-BE-NEXT:  # %bb.17: # %bb56
; CHECK-BE-NEXT:    ld r30, 224(r1) # 8-byte Folded Reload
; CHECK-BE-NEXT:    ld r29, 216(r1) # 8-byte Folded Reload
; CHECK-BE-NEXT:    ld r28, 208(r1) # 8-byte Folded Reload
; CHECK-BE-NEXT:    ld r27, 200(r1) # 8-byte Folded Reload
; CHECK-BE-NEXT:    addi r1, r1, 240
; CHECK-BE-NEXT:    ld r0, 16(r1)
; CHECK-BE-NEXT:    lwz r12, 8(r1)
; CHECK-BE-NEXT:    mtlr r0
; CHECK-BE-NEXT:    mtocrf 32, r12
; CHECK-BE-NEXT:    mtocrf 16, r12
; CHECK-BE-NEXT:    mtocrf 8, r12
; CHECK-BE-NEXT:    blr
; CHECK-BE-NEXT:  .LBB0_18: # %bb30
; CHECK-BE-NEXT:    stb r3, 197(r1)
; CHECK-BE-NEXT:  .LBB0_19: # %bb55
bb:
  %tmp = alloca [3 x i8], align 1
  %tmp3 = tail call zeroext i8 @call_1(%1* %arg1)
  %tmp4 = icmp ne i8 %tmp3, 0
  %tmp5 = tail call signext i32 @call_2(%2* %arg, %1* %arg1)
  %tmp6 = and i32 %arg2, 16
  %tmp7 = icmp ne i32 %tmp6, 0
  br label %bb8

bb8:                                              ; preds = %bb
  br i1 undef, label %bb9, label %bb11

bb9:                                              ; preds = %bb8
  %tmp10 = call signext i32 @call_3(%2* %arg, %1* %arg1)
  br label %bb12

bb11:                                             ; preds = %bb8
  br label %bb12

bb12:                                             ; preds = %bb11, %bb9
  %tmp13 = and i32 %arg2, 4
  %tmp14 = and i32 %arg2, 128
  %tmp15 = icmp ne i32 %tmp14, 0
  br label %bb16

bb16:                                             ; preds = %bb12
  %tmp17 = xor i1 %tmp4, true
  %tmp18 = or i1 false, %tmp17
  br i1 %tmp18, label %bb37, label %bb19

bb19:                                             ; preds = %bb16
  %tmp20 = getelementptr inbounds [3 x i8], [3 x i8]* %tmp, i64 0, i64 0
  %tmp21 = load i8* (i64, i8*)*, i8* (i64, i8*)** @global_3, align 8
  %tmp22 = call i8* %tmp21(i64 undef, i8* getelementptr inbounds ([14 x i8], [14 x i8]* @global_4, i64 0, i64 0))
  %tmp23 = bitcast i8* %tmp22 to i32*
  %tmp24 = icmp eq i32* %tmp23, null
  %tmp25 = icmp eq i32 %tmp13, 0
  %tmp26 = zext i32 %tmp5 to i64
  br label %bb27

bb27:                                             ; preds = %bb34, %bb19
  %tmp28 = call zeroext i8 @call_6(%1* %arg1, i32 signext undef)
  store i8 %tmp28, i8* %tmp20, align 1
  br label %bb29

bb29:                                             ; preds = %bb27
  br i1 %tmp24, label %bb31, label %bb30

bb30:                                             ; preds = %bb29
  unreachable

bb31:                                             ; preds = %bb29
  br i1 %tmp25, label %bb33, label %bb32

bb32:                                             ; preds = %bb31
  unreachable

bb33:                                             ; preds = %bb31
  br label %bb34

bb34:                                             ; preds = %bb33
  %tmp35 = icmp eq i64 0, %tmp26
  br i1 %tmp35, label %bb36, label %bb27

bb36:                                             ; preds = %bb34
  br label %bb54

bb37:                                             ; preds = %bb16
  %tmp38 = load i32, i32* undef, align 8
  %tmp39 = select i1 %tmp7, i8* getelementptr inbounds ([1 x i8], [1 x i8]* @global_1, i64 0, i64 0), i8* null
  %tmp40 = icmp ne i32 %tmp38, 0
  switch i32 undef, label %bb41 [
    i32 1, label %bb42
    i32 4, label %bb42
  ]

bb41:                                             ; preds = %bb37
  br label %bb50

bb42:                                             ; preds = %bb37, %bb37
  %tmp43 = call signext i32 @call_5(i8* %tmp39)
  %tmp44 = load i16, i16* getelementptr inbounds (%0, %0* @global_2, i64 0, i32 81), align 4
  %tmp45 = sitofp i16 %tmp44 to float
  %tmp46 = select i1 %tmp40, float 1.750000e+00, float 1.500000e+00
  %tmp47 = fmul fast float %tmp46, %tmp45
  %tmp48 = fadd fast float %tmp47, 0.000000e+00
  %tmp49 = fptosi float %tmp48 to i32
  br label %bb50

bb50:                                             ; preds = %bb42, %bb41
  %tmp51 = phi i32 [ %tmp49, %bb42 ], [ undef, %bb41 ]
  %tmp52 = trunc i32 %tmp51 to i16
  %tmp53 = call %3* @call_4(%4* nonnull undef, i32 signext 1024, i32 signext 0, i32 signext %tmp38, i32 signext 0, i32 signext 0, i16 signext %tmp52, i16 signext undef, %2* %arg, %1* %arg1, i32 signext -1, float 0.000000e+00, float undef, float -1.000000e+00, float -1.000000e+00, i8* null)
  br label %bb54

bb54:                                             ; preds = %bb50, %bb36
  br i1 %tmp15, label %bb55, label %bb56

bb55:                                             ; preds = %bb54
  unreachable

bb56:                                             ; preds = %bb54
  ret void
}
