; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -S -analyze -scalar-evolution < %s | FileCheck %s

; These testcases aren't *identical* but they have the same/similar meaning.

; The obvious case.
define i32 @mul(i32 %val, i32 %num) nounwind {
; CHECK-LABEL: 'mul'
; CHECK-NEXT:  Classifying expressions for: @mul
; CHECK-NEXT:    %tmp1 = mul i32 %val, %num
; CHECK-NEXT:    -->  (%val * %num) U: full-set S: full-set
; CHECK-NEXT:    %tmp2 = udiv i32 %tmp1, %num
; CHECK-NEXT:    -->  ((%val * %num) /u %num) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @mul
;
  %tmp1 = mul i32 %val, %num
  %tmp2 = udiv i32 %tmp1, %num
  ret i32 %tmp2
}

; Or, it could be any number of equivalent patterns with mask:
;   a) x &  (1 << nbits) - 1
;   b) x & ~(-1 << nbits)
;   c) x &  (-1 >> (32 - y))
;   d) x << (32 - y) >> (32 - y)

define i32 @mask_a(i32 %val, i32 %numlowbits) nounwind {
; CHECK-LABEL: 'mask_a'
; CHECK-NEXT:  Classifying expressions for: @mask_a
; CHECK-NEXT:    %onebit = shl i32 1, %numlowbits
; CHECK-NEXT:    -->  %onebit U: full-set S: full-set
; CHECK-NEXT:    %mask = add nsw i32 %onebit, -1
; CHECK-NEXT:    -->  (-1 + %onebit) U: full-set S: full-set
; CHECK-NEXT:    %masked = and i32 %mask, %val
; CHECK-NEXT:    -->  %masked U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @mask_a
;
  %onebit = shl i32 1, %numlowbits
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @mask_b(i32 %val, i32 %numlowbits) nounwind {
; CHECK-LABEL: 'mask_b'
; CHECK-NEXT:  Classifying expressions for: @mask_b
; CHECK-NEXT:    %notmask = shl i32 -1, %numlowbits
; CHECK-NEXT:    -->  %notmask U: full-set S: full-set
; CHECK-NEXT:    %mask = xor i32 %notmask, -1
; CHECK-NEXT:    -->  (-1 + (-1 * %notmask)) U: full-set S: full-set
; CHECK-NEXT:    %masked = and i32 %mask, %val
; CHECK-NEXT:    -->  %masked U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @mask_b
;
  %notmask = shl i32 -1, %numlowbits
  %mask = xor i32 %notmask, -1
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @mask_c(i32 %val, i32 %numlowbits) nounwind {
; CHECK-LABEL: 'mask_c'
; CHECK-NEXT:  Classifying expressions for: @mask_c
; CHECK-NEXT:    %numhighbits = sub i32 32, %numlowbits
; CHECK-NEXT:    -->  (32 + (-1 * %numlowbits)) U: full-set S: full-set
; CHECK-NEXT:    %mask = lshr i32 -1, %numhighbits
; CHECK-NEXT:    -->  %mask U: full-set S: full-set
; CHECK-NEXT:    %masked = and i32 %mask, %val
; CHECK-NEXT:    -->  %masked U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @mask_c
;
  %numhighbits = sub i32 32, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @mask_d(i32 %val, i32 %numlowbits) nounwind {
; CHECK-LABEL: 'mask_d'
; CHECK-NEXT:  Classifying expressions for: @mask_d
; CHECK-NEXT:    %numhighbits = sub i32 32, %numlowbits
; CHECK-NEXT:    -->  (32 + (-1 * %numlowbits)) U: full-set S: full-set
; CHECK-NEXT:    %highbitscleared = shl i32 %val, %numhighbits
; CHECK-NEXT:    -->  %highbitscleared U: full-set S: full-set
; CHECK-NEXT:    %masked = lshr i32 %highbitscleared, %numhighbits
; CHECK-NEXT:    -->  %masked U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @mask_d
;
  %numhighbits = sub i32 32, %numlowbits
  %highbitscleared = shl i32 %val, %numhighbits
  %masked = lshr i32 %highbitscleared, %numhighbits
  ret i32 %masked
}
