import { node } from '../../../../src/frontend';

export abstract class Node<T extends node.Node> {
  private built: boolean = false;

  constructor(public readonly ref: T) {
  }

  public build(out: string[]): void {
    if (this.built) {
      return;
    }

    this.built = true;
    this.doBuild(out);

    if (this.ref.otherwise !== undefined) {
      (this.ref.otherwise.node as Node<T>).build(out);
    }
  }

  protected format(value: string): string {
    let otherwise: string = '';
    if (this.ref.otherwise !== undefined) {
      const otherwiseRef = this.ref.otherwise.node.ref;
      otherwise = ' otherwise' +
        `${this.ref.otherwise.noAdvance ? '-no_adv' : ''}=` +
        `${otherwiseRef.id.name}`;
      if (this.ref.otherwise.value !== undefined) {
        otherwise += `:${this.ref.otherwise.value}`;
      }
    }

    return `<${this.constructor.name} name=${this.ref.id.name} ` +
      `${value}${otherwise}/>`;
  }

  protected abstract doBuild(out: string[]): void;
}
