/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "mainview.h"

#include <QtCore/QString>
#include <QtGui/QToolTip>
#include <QtGui/QWhatsThis>

#include <klocale.h>

MainView::MainView(QWidget* parent, const char* name, bool, Qt::WFlags fl) : QWidget(parent)
{
    Q_UNUSED(name);
    Q_UNUSED(fl);

    setupUi(this);
    DebugOutput = new DebugOutputTextEdit(mainframe);
    QGridLayout *FrameLayout = new QGridLayout(mainframe);
    FrameLayout->addWidget(DebugOutput, 1, 0, 1, 4);
    DebugOutput->setReadOnly(true);
    DebugOutput->clear();
    DebugOutput->setToolTip(i18n("Debug console"));
    DebugOutput->setWhatsThis(i18n("The debug console shows useful debug information to solve problems. You need to turn on debug features for the program you want to produce output for in the preferences dialog."));
}

MainView::~MainView() {}
