/*************************************************************************
 *  Copyright (C) 2008 by Volker Lanz <vl@fidra.de>                      *
 *                                                                       *
 *  This program is free software; you can redistribute it and/or        *
 *  modify it under the terms of the GNU General Public License as       *
 *  published by the Free Software Foundation; either version 3 of       *
 *  the License, or (at your option) any later version.                  *
 *                                                                       *
 *  This program is distributed in the hope that it will be useful,      *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *  GNU General Public License for more details.                         *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.*
 *************************************************************************/

#if !defined(KPMCORE_COPYFILESYSTEMJOB_H)

#define KPMCORE_COPYFILESYSTEMJOB_H

#include "jobs/job.h"

#include <QtGlobal>

class Partition;
class Device;
class Report;

class QString;

/** Copy a FileSystem.

    Copy a FileSystem on a given Partition and Device to another Partition on a (possibly other) Device.

    @author Volker Lanz <vl@fidra.de>
*/
class CopyFileSystemJob : public Job
{
public:
    CopyFileSystemJob(Device& targetdevice, Partition& targetpartition, Device& sourcedevice, Partition& sourcepartition);

public:
    bool run(Report& parent) override;
    qint32 numSteps() const override;
    QString description() const override;

protected:
    Partition& targetPartition() {
        return m_TargetPartition;
    }
    const Partition& targetPartition() const {
        return m_TargetPartition;
    }

    Device& targetDevice() {
        return m_TargetDevice;
    }
    const Device& targetDevice() const {
        return m_TargetDevice;
    }

    Partition& sourcePartition() {
        return m_SourcePartition;
    }
    const Partition& sourcePartition() const {
        return m_SourcePartition;
    }

    Device& sourceDevice() {
        return m_SourceDevice;
    }
    const Device& sourceDevice() const {
        return m_SourceDevice;
    }

private:
    Device& m_TargetDevice;
    Partition& m_TargetPartition;
    Device& m_SourceDevice;
    Partition& m_SourcePartition;
};

#endif
