/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/copyPaste/moveDeclarations")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MoveOnCutPasteTestGenerated extends AbstractMoveOnCutPasteTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInMoveDeclarations() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/copyPaste/moveDeclarations"), Pattern.compile("^([^.]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("ChangePackage.kt")
    public void testChangePackage() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/ChangePackage.kt");
    }

    @TestMetadata("Copy.kt")
    public void testCopy() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/Copy.kt");
    }

    @TestMetadata("FromAnonymousObject.kt")
    public void testFromAnonymousObject() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/FromAnonymousObject.kt");
    }

    @TestMetadata("FromCompanionObjectToTopLevel.kt")
    public void testFromCompanionObjectToTopLevel() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/FromCompanionObjectToTopLevel.kt");
    }

    @TestMetadata("FromObjectToSameFile.kt")
    public void testFromObjectToSameFile() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/FromObjectToSameFile.kt");
    }

    @TestMetadata("FromObjectToTopLevel.kt")
    public void testFromObjectToTopLevel() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/FromObjectToTopLevel.kt");
    }

    @TestMetadata("OptimizeImportsAfterCut.kt")
    public void testOptimizeImportsAfterCut() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/OptimizeImportsAfterCut.kt");
    }

    @TestMetadata("SamePackage.kt")
    public void testSamePackage() throws Exception {
        runTest("idea/testData/copyPaste/moveDeclarations/SamePackage.kt");
    }
}
