/*
    SPDX-FileCopyrightText: 2009-2010 Cristian Oneț <onet.cristian@gmail.com>
    SPDX-FileCopyrightText: 2009-2010 Alvaro Soliverez <asoliverez@gmail.com>
    SPDX-FileCopyrightText: 2011-2017 Thomas Baumgart <tbaumgart@kde.org>
    SPDX-FileCopyrightText: 2017 Łukasz Wojniłowicz <lukasz.wojnilowicz@gmail.com>
    SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "kmymoneypayeecombo.h"

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "mymoneypayee.h"

KMyMoneyPayeeCombo::KMyMoneyPayeeCombo(QWidget* parent) :
    KMyMoneyMVCCombo(true, parent)
{
}

KMyMoneyPayeeCombo::~KMyMoneyPayeeCombo()
{
}

void KMyMoneyPayeeCombo::loadPayees(const QList<MyMoneyPayee>& list)
{
    clear();

    //add a blank item, since the field is optional
    addItem(QString(), QVariant(QString()));

    //add all payees
    QList<MyMoneyPayee>::const_iterator it;
    for (it = list.cbegin(); it != list.cend(); ++it) {
        addItem((*it).name(), QVariant((*it).id()));
    }

    //sort the model, which will sort the list in the combo
    model()->sort(Qt::DisplayRole, Qt::AscendingOrder);

    //set the text to empty and the index to the first item on the list
    setCurrentIndex(0);
    clearEditText();
}
