/***************************************************************************
                             groupmarker_p.h  -  description
                             -------------------
    begin                : Fri Mar 10 2006
    copyright            : (C) 2006 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
                           (C) 2017 by Łukasz Wojniłowicz <lukasz.wojnilowicz@gmail.com>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUPMARKER_P_H
#define GROUPMARKER_P_H

// ----------------------------------------------------------------------------
// QT Includes

#include <QString>
#include <QPixmap>
#include <QFontMetrics>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneyglobalsettings.h"
#include "register.h"
#include "registeritem_p.h"

static unsigned char fancymarker_bg_image[] = {
  /* 200x49 */
  0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A,
  0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52,
  0x00, 0x00, 0x00, 0xC8, 0x00, 0x00, 0x00, 0x31,
  0x08, 0x06, 0x00, 0x00, 0x00, 0x9F, 0xC5, 0xE6,
  0x4F, 0x00, 0x00, 0x00, 0x06, 0x62, 0x4B, 0x47,
  0x44, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0xA0,
  0xBD, 0xA7, 0x93, 0x00, 0x00, 0x00, 0x09, 0x70,
  0x48, 0x59, 0x73, 0x00, 0x00, 0x0B, 0x13, 0x00,
  0x00, 0x0B, 0x13, 0x01, 0x00, 0x9A, 0x9C, 0x18,
  0x00, 0x00, 0x00, 0x86, 0x49, 0x44, 0x41, 0x54,
  0x78, 0xDA, 0xED, 0xDD, 0x31, 0x0A, 0x84, 0x40,
  0x10, 0x44, 0xD1, 0x1A, 0x19, 0x10, 0xCF, 0xE6,
  0xFD, 0x4F, 0xB2, 0x88, 0x08, 0x22, 0x9B, 0x18,
  0x4E, 0x1B, 0x2C, 0x1B, 0x18, 0xBC, 0x07, 0x7D,
  0x81, 0x82, 0x1F, 0x77, 0x4B, 0xB2, 0x06, 0x18,
  0xEA, 0x49, 0x3E, 0x66, 0x00, 0x81, 0x80, 0x40,
  0xE0, 0xDF, 0x81, 0x6C, 0x66, 0x80, 0x3A, 0x90,
  0xDD, 0x0C, 0x50, 0x07, 0x72, 0x98, 0x01, 0xEA,
  0x40, 0x4E, 0x33, 0x40, 0x1D, 0xC8, 0x65, 0x06,
  0x18, 0x6B, 0xF7, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x16, 0x3E,
  0x4C, 0xC1, 0x83, 0x9E, 0x64, 0x32, 0x03, 0x08,
  0x04, 0x7E, 0x0A, 0xA4, 0x9B, 0x01, 0xEA, 0x40,
  0x66, 0x33, 0x40, 0x1D, 0xC8, 0x62, 0x06, 0x18,
  0xFB, 0x02, 0x05, 0x87, 0x08, 0x55, 0xFE, 0xDE,
  0xA2, 0x9D, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

namespace KMyMoneyRegister
{
  class GroupMarkerPrivate : public RegisterItemPrivate
  {
  public:
    void init()
    {
      m_showDate = false;
      m_erroneous = false;
      int h;
      if (m_parent) {
        h = m_parent->rowHeightHint();
      } else {
        QFontMetrics fm(KMyMoneyGlobalSettings::listCellFont());
        h = fm.lineSpacing() + 6;
      }

      if (GroupMarkerPrivate::m_bg && (GroupMarkerPrivate::m_bg->height() != h)) {
        delete GroupMarkerPrivate::m_bg;
        GroupMarkerPrivate::m_bg = 0;
      }

      // convert the backgroud once
      if (GroupMarkerPrivate::m_bg == 0) {
        GroupMarkerPrivate::m_bg = new QPixmap;
        GroupMarkerPrivate::m_bg->loadFromData(fancymarker_bg_image, sizeof(fancymarker_bg_image));
        *GroupMarkerPrivate::m_bg = GroupMarkerPrivate::m_bg->scaled(GroupMarkerPrivate::m_bg->width(), h, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
      }

      ++GroupMarkerPrivate::m_bgRefCnt;
    }

    QString                  m_txt;
    bool                     m_showDate;

    static QPixmap*          m_bg;
    static int               m_bgRefCnt;

    bool                     m_erroneous;
  };
}

#endif
