/*
 * $Id$
 *
 * Copyright (C) 2012 Smile Communications, jason.penton@smilecoms.com
 * Copyright (C) 2012 Smile Communications, richard.good@smilecoms.com
 *
 * The initial version of this code was written by Dragos Vingarzan
 * (dragos(dot)vingarzan(at)fokus(dot)fraunhofer(dot)de and the
 * Fraunhofer FOKUS Institute. It was and still is maintained in a separate
 * branch of the original SER. We are therefore migrating it to
 * Kamailio/SR and look forward to maintaining it from here on out.
 * 2011/2012 Smile Communications, Pty. Ltd.
 * ported/maintained/improved by
 * Jason Penton (jason(dot)penton(at)smilecoms.com and
 * Richard Good (richard(dot)good(at)smilecoms.com) as part of an
 * effort to add full IMS support to Kamailio/SR using a new and
 * improved architecture
 *
 * NB: A lot of this code was originally part of OpenIMSCore,
 * FhG Fokus.
 * Copyright (C) 2004-2006 FhG Fokus
 * Thanks for great work! This is an effort to
 * break apart the various CSCF functions into logically separate
 * components. We hope this will drive wider use. We also feel
 * that in this way the architecture is more complete and thereby easier
 * to manage in the Kamailio/SR environment
 *
 * This file is part of Kamailio, a free SIP server.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Kamailio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * Kamailio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 *
 *
 * History:
 * --------
 *  2011-02-02  initial version (jason.penton)
 */


#include "../cdp_avp/cdp_avp_mod.h"

#include "../../modules/ims_dialog/dlg_load.h"
#include "../ims_usrloc_pcscf/usrloc.h"
#include "rx_authdata.h"

#include "rx_asr.h"
#include "rx_avp.h"
#include "../../lib/ims/ims_getters.h"
#include "ims_qos_stats.h"

extern struct ims_qos_counters_h ims_qos_cnts_h;

/*
 * Called upon receipt of an ASR. Terminates the user session and returns the ASA.
 * Terminates the corresponding dialog
 * @param request - the received request
 * @returns 0 always because ASA will be generated by the State Machine
 *
 */
AAAMessage *rx_process_asr(AAAMessage *request)
{
	AAASession *session;
	unsigned int code = 0;

	rx_authsessiondata_t *p_session_data = 0;

	if(!request || !request->sessionId)
		return 0;

	counter_inc(ims_qos_cnts_h.asrs);

	session = cdpb.AAAGetAuthSession(request->sessionId->data);

	if(!session) {
		LM_DBG("received an ASR but the session is already deleted\n");
		return 0;
	}

	code = rx_get_abort_cause(request);
	LM_DBG("abort-cause code is %u\n", code);

	LM_DBG("PCRF requested an ASR");


	p_session_data = (rx_authsessiondata_t *)session->u.auth.generic_data;
	if(p_session_data->subscribed_to_signaling_path_status) {
		LM_DBG("This is a subscription to signalling status\n");
	} else {
		LM_DBG("This is a normal media bearer -  bearer is released by CDP "
			   "callbacks\n");
	}
	cdpb.AAASessionsUnlock(session->hash);
	return 0;
}
