
/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
 * ../../modules/userblacklist/kamailio-userblacklist.xml.
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

#ifndef db_userblacklist_h
#define db_userblacklist_h


/* necessary includes */
#include "../../lib/srdb1/db.h"
#include "../../str.h"
#include "../../ut.h"

#include <string.h>


/* database variables */

extern str userblacklist_db_url;
extern db1_con_t * userblacklist_dbh;
extern db_func_t userblacklist_dbf;

#define userblacklist_DB_URL { "db_url", STR_PARAM, &userblacklist_db_url.s },

#define userblacklist_DB_TABLE { "userblacklist_table", STR_PARAM, &userblacklist_table.s },

extern str userblacklist_table;

/* column names */
extern str userblacklist_id_col;
extern str userblacklist_username_col;
extern str userblacklist_domain_col;
extern str userblacklist_prefix_col;
extern str userblacklist_whitelist_col;
#define userblacklist_DB_COLS \
{ "userblacklist_id_col", STR_PARAM, &userblacklist_id_col.s }, \
{ "userblacklist_username_col", STR_PARAM, &userblacklist_username_col.s }, \
{ "userblacklist_domain_col", STR_PARAM, &userblacklist_domain_col.s }, \
{ "userblacklist_prefix_col", STR_PARAM, &userblacklist_prefix_col.s }, \
{ "userblacklist_whitelist_col", STR_PARAM, &userblacklist_whitelist_col.s }, \

/* table version */
extern const unsigned int userblacklist_version;

#define globalblacklist_DB_TABLE { "globalblacklist_table", STR_PARAM, &globalblacklist_table.s },

extern str globalblacklist_table;

/* column names */
extern str globalblacklist_id_col;
extern str globalblacklist_prefix_col;
extern str globalblacklist_whitelist_col;
extern str globalblacklist_description_col;
#define globalblacklist_DB_COLS \
{ "globalblacklist_id_col", STR_PARAM, &globalblacklist_id_col.s }, \
{ "globalblacklist_prefix_col", STR_PARAM, &globalblacklist_prefix_col.s }, \
{ "globalblacklist_whitelist_col", STR_PARAM, &globalblacklist_whitelist_col.s }, \
{ "globalblacklist_description_col", STR_PARAM, &globalblacklist_description_col.s }, \

/* table version */
extern const unsigned int globalblacklist_version;


/*
 * Closes the DB connection.
 */
void userblacklist_db_close(void);

/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occured.
 */
int userblacklist_db_init(void);

/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occured.
 */
int userblacklist_db_open(void);

/*!
 * Update the variable length after eventual assignments from the config script.
 * This is necessary because we're using the 'str' type.
 */
void userblacklist_db_vars(void);

#endif
