require_relative '../../spec_helper'

describe "Enumerator#inspect" do
  describe "shows a representation of the Enumerator" do
    it "including receiver and method" do
      (1..3).each.inspect.should == "#<Enumerator: 1..3:each>"
    end

    it "including receiver and method and arguments" do
      (1..3).each_slice(2).inspect.should == "#<Enumerator: 1..3:each_slice(2)>"
    end

    it "including the nested Enumerator" do
      (1..3).each.each_slice(2).inspect.should == "#<Enumerator: #<Enumerator: 1..3:each>:each_slice(2)>"
    end
  end

  it "returns a not initialized representation if #initialized is not called yet" do
    Enumerator.allocate.inspect.should == "#<Enumerator: uninitialized>"
    Enumerator::Lazy.allocate.inspect.should == "#<Enumerator::Lazy: uninitialized>"
  end
end
