; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2022-2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; REQUIRES: regkeys
; RUN: igc_opt --typed-pointers -igc-InsertBranchOpt -regkey EnableAtomicBranch=1 -S %s | FileCheck %s

define i32 @atomicIadd0Raw(i32 %mem, i32 %val) {
; CHECK-LABEL: @atomicIadd0Raw(
; CHECK-NEXT:    [[ADDBEFORE:%.*]] = add i32 [[MEM:%.*]], 10
; CHECK-NEXT:    [[SOMEUNKNOWN:%.*]] = add i32 [[VAL:%.*]], 10
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[SOMEUNKNOWN]], 0
; CHECK-NEXT:    br i1 [[TMP1]], label [[ATOMIC_IF_TRUE:%.*]], label [[ATOMIC_IF_FALSE:%.*]]
; CHECK:       atomic.if.true:
; CHECK-NEXT:    [[ATOMIC:%.*]] = call i32 @llvm.genx.GenISA.intatomicraw.i32.p131073v4f32(<4 x float> addrspace(131073)* null, i32 [[MEM]], i32 [[SOMEUNKNOWN]], i32 0)
; CHECK-NEXT:    br label [[ATOMIC_IF_END:%.*]]
; CHECK:       atomic.if.false:
; CHECK-NEXT:    [[TMP2:%.*]] = call <4 x float> @llvm.genx.GenISA.ldptr.v4f32.p131073v4f32.p131073v4f32(i32 [[MEM]], i32 0, i32 0, i32 0, <4 x float> addrspace(131073)* undef, <4 x float> addrspace(131073)* null, i32 0, i32 0, i32 0)
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x float> [[TMP2]], i64 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float [[TMP3]] to i32
; CHECK-NEXT:    br label [[ATOMIC_IF_END]]
; CHECK:       atomic.if.end:
; CHECK-NEXT:    [[TMP5:%.*]] = phi i32 [ [[ATOMIC]], [[ATOMIC_IF_TRUE]] ], [ [[TMP4]], [[ATOMIC_IF_FALSE]] ]
; CHECK-NEXT:    [[ADDAFTER:%.*]] = add i32 [[TMP5]], 15
; CHECK-NEXT:    ret i32 [[ADDAFTER]]
;
  %addBefore = add i32 %mem, 10
  %someUnknown = add i32 %val, 10
  %atomic = call i32 @llvm.genx.GenISA.intatomicraw.i32.p131073v4f32(<4 x float> addrspace(131073)* null, i32 %mem, i32 %someUnknown, i32 0)
  %addAfter = add i32 %atomic, 15
  ret i32 %addAfter
}

define i32 @atomicIadd0Typed(i32 %mem, i32 %val) {
; CHECK-LABEL: @atomicIadd0Typed(
; CHECK-NEXT:    [[ADDBEFORE:%.*]] = add i32 [[MEM:%.*]], 10
; CHECK-NEXT:    [[SOMEUNKNOWN:%.*]] = add i32 [[VAL:%.*]], 10
; CHECK-NEXT:    [[TMP1:%.*]] = call fast float @llvm.genx.GenISA.DCL.SystemValue.f32(i32 16)
; CHECK-NEXT:    [[GROUPID_Z:%.*]] = bitcast float [[TMP1]] to i32
; CHECK-NEXT:    [[LOCALID_Z:%.*]] = call i32 @llvm.genx.GenISA.DCL.SystemValue.i32(i32 19)
; CHECK-NEXT:    [[U:%.*]] = mul i32 [[GROUPID_Z]], 10
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[SOMEUNKNOWN]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[ATOMIC_IF_TRUE:%.*]], label [[ATOMIC_IF_FALSE:%.*]]
; CHECK:       atomic.if.true:
; CHECK-NEXT:    [[ATOMIC:%.*]] = call i32 @llvm.genx.GenISA.intatomictyped.i32.p131073v4f32(<4 x float> addrspace(131073)* null, i32 [[U]], i32 [[LOCALID_Z]], i32 [[ADDBEFORE]], i32 [[SOMEUNKNOWN]], i32 0)
; CHECK-NEXT:    br label [[ATOMIC_IF_END:%.*]]
; CHECK:       atomic.if.false:
; CHECK-NEXT:    [[TMP3:%.*]] = call <4 x float> @llvm.genx.GenISA.typedread.p131073v4f32(<4 x float> addrspace(131073)* null, i32 [[U]], i32 [[LOCALID_Z]], i32 [[ADDBEFORE]], i32 0)
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x float> [[TMP3]], i64 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast float [[TMP4]] to i32
; CHECK-NEXT:    br label [[ATOMIC_IF_END]]
; CHECK:       atomic.if.end:
; CHECK-NEXT:    [[TMP6:%.*]] = phi i32 [ [[ATOMIC]], [[ATOMIC_IF_TRUE]] ], [ [[TMP5]], [[ATOMIC_IF_FALSE]] ]
; CHECK-NEXT:    ret i32 [[TMP6]]
;
  %addBefore = add i32 %mem, 10
  %someUnknown = add i32 %val, 10
  %1 = call fast float @llvm.genx.GenISA.DCL.SystemValue.f32(i32 16)
  %GroupID_Z = bitcast float %1 to i32
  %LocalID_Z = call i32 @llvm.genx.GenISA.DCL.SystemValue.i32(i32 19)
  %U = mul i32 %GroupID_Z, 10
  %atomic = call i32 @llvm.genx.GenISA.intatomictyped.i32.p131073v4f32(<4 x float> addrspace(131073)* null, i32 %U, i32 %LocalID_Z, i32 %addBefore, i32 %someUnknown, i32 0)
  ret i32 %atomic
}

define i32 @atomicUmax(i32 %mem, i32 %val) {
; CHECK-LABEL: @atomicUmax(
; CHECK-NEXT:    [[ADDBEFORE:%.*]] = add i32 [[MEM:%.*]], 10
; CHECK-NEXT:    [[SOMEUNKOWN:%.*]] = add i32 [[VAL:%.*]], 10
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[SOMEUNKOWN]], 0
; CHECK-NEXT:    br i1 [[TMP1]], label [[ATOMIC_IF_TRUE:%.*]], label [[ATOMIC_IF_FALSE:%.*]]
; CHECK:       atomic.if.true:
; CHECK-NEXT:    [[ATOMIC:%.*]] = call i32 @llvm.genx.GenISA.intatomicraw.i32.p131073v4f32(<4 x float> addrspace(131073)* null, i32 [[MEM]], i32 [[SOMEUNKOWN]], i32 13)
; CHECK-NEXT:    br label [[ATOMIC_IF_END:%.*]]
; CHECK:       atomic.if.false:
; CHECK-NEXT:    [[TMP2:%.*]] = call <4 x float> @llvm.genx.GenISA.ldptr.v4f32.p131073v4f32.p131073v4f32(i32 [[MEM]], i32 0, i32 0, i32 0, <4 x float> addrspace(131073)* undef, <4 x float> addrspace(131073)* null, i32 0, i32 0, i32 0)
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x float> [[TMP2]], i64 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float [[TMP3]] to i32
; CHECK-NEXT:    br label [[ATOMIC_IF_END]]
; CHECK:       atomic.if.end:
; CHECK-NEXT:    [[TMP5:%.*]] = phi i32 [ [[ATOMIC]], [[ATOMIC_IF_TRUE]] ], [ [[TMP4]], [[ATOMIC_IF_FALSE]] ]
; CHECK-NEXT:    [[ADDAFTER:%.*]] = add i32 [[TMP5]], 15
; CHECK-NEXT:    ret i32 [[ADDAFTER]]
;
  %addBefore = add i32 %mem, 10
  %someUnkown = add i32 %val, 10
  %atomic = call i32 @llvm.genx.GenISA.intatomicraw.i32.p131073v4f32(<4 x float> addrspace(131073)* null, i32 %mem, i32 %someUnkown, i32 13)
  %addAfter = add i32 %atomic, 15
  ret i32 %addAfter
}

; Function Desc:
; Output: input reg (generated by this intrin)
; Arg 0: usage
; Function Attrs: nounwind readnone
declare float @llvm.genx.GenISA.DCL.SystemValue.f32(i32) #0

; Function Desc:
; Output: input reg (generated by this intrin)
; Arg 0: usage
; Function Attrs: nounwind readnone
declare i32 @llvm.genx.GenISA.DCL.SystemValue.i32(i32) #0

; Function Desc:
; Output:
; Arg 0: Dst Buffer
; Arg 1: dst address
; Arg 2: src0
; Arg 3: Instruction type (add, or, xor etc)
; Function Attrs: argmemonly nounwind
declare i32 @llvm.genx.GenISA.intatomicraw.i32.p131073v4f32(<4 x float> addrspace(131073)*, i32, i32, i32) #0

; Function Desc:
; Output:
; Arg 0: Dst Buffer
; Arg 1: coordinates u
; Arg 2: coordinates v
; Arg 3: coordinates r
; Arg 4: src0
; Arg 5: Instruction type (add, or, xor etc)
; Function Attrs: argmemonly nounwind
declare i32 @llvm.genx.GenISA.intatomictyped.i32.p131073v4f32(<4 x float> addrspace(131073)*, i32, i32, i32, i32, i32)

attributes #0 = { argmemonly nounwind }
