#define XERR "optbase"
#include "optbase.ih"

// cf: https://stackoverflow.com/questions/19940100/
//              is-there-a-way-to-reset-getopt-for-non-global-use
//
//    optind = 0;   // resets getopt_long, done by OptBase, in which
//
// case argv[optind] is ignored, and remaining argv values specifiy
// options/arguments processed by getopt_long

// optind specifies the index of the next argument processed by
// getopt_long. But when reset to 0 argv[0] must point to a value which
// is ignored by getopt_long, whereafter remaining options and arguments
// follow.

    // by precompopts/precompopts1.cc

OptBase::OptBase(PtrVect &argv)
:
    d_usage(false),
    d_version(false),
    d_argv(argv)
{
                                                // used by ScriptOpts
    if (argv.size() >= 2 and 
        (
            string{argv[1]}.find("-t") == 0     // test for -t, so /tmp is
            or                                  // slipped
            string{argv[1]}.find("-s") == 0
        )
    )
        d_src = basename(argv[2]);
}

