/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "about_dialog.h"
#include "icons.h"
#include "intl.h"

AboutDialog::AboutDialog() : Dialog(_("About Groundhog"))
{
   GtkWidget* table = gtk_table_new(3, 1, FALSE);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->vbox), table, TRUE, TRUE, 
		      10);
   gtk_table_set_row_spacings(GTK_TABLE(table), 10);

   // Create groundhog icon.
   GtkWidget* icon = gtk_image_new_from_stock(GROUNDHOG_STOCK_ABOUT,
					      GTK_ICON_SIZE_DIALOG);
   gtk_table_attach_defaults(GTK_TABLE(table), icon, 0, 1, 1, 2);

   GtkWidget* label = gtk_label_new(
      "Groundhog "
      VERSION
      "\nCopyright (C) 1998-2002 by Maurits Rijk\n"
      "lpeek.mrijk@consunet.nl");
   gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

   label = gtk_label_new("  Released under the GNU General Public License  ");
   gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
}
