#!/bin/bash
#
# install gprbuild package (normally in the chroot that just built it),
# and run the examples using it.

# usage
# cd gprbuild-<version>/debian
# schroot ./test_installed.sh

# We want to test that gprbuild doesn't depend on the current gcc,
# only on current gcc-x.y, because if someone installs gprbuild on a
# 'testing' system that has only gcc-4.3, gcc will stay pointing at
# gcc-4.3. To do that, we install both and old and the current version
# of gcc-x.y, and delete the symlink gcc. Similarly, we don't install
# 'g++', but rather 'g++-4.6', etc.
sudo rm /usr/bin/gcc

upstreamversion=`dpkg-parsechangelog -lchangelog | sed -r -n -e "s/^Version: ([0123456789.]+)-[0123456789]+$/\1/p"`
debversion=`dpkg-parsechangelog -lchangelog | sed -r -n -e "s/^Version: [0123456789.]+-([0123456789]+)$/\1/p"`

# This re-installs the latest version.
sudo dpkg --install ../../gprbuild_${upstreamversion}-${debversion}_i386.deb
sudo dpkg --install ../../gprbuild-doc_${upstreamversion}-${debversion}_all.deb

# tmp is owned by root; we need write permission
sudo chmod -R o+w tmp

cd ../examples
make

# test gprclean
make clean

# test running gprbuild with the default config file
cd first_steps
gprbuild -Pc_main
gprbuild -Pada_main

# clean up for next build
make clean

# test that default gpr search path follows Debian Ada policy
cd ../../debian
gprbuild -P aunit_example
gprclean -P aunit_example

# test that -s (check switches) doesn't attempt to write in system directories
gprbuild bug_571013.gpr

sudo ln -s /usr/bin/gcc-4.6 /usr/bin/gcc

# end of file
