// Demo code for the Image primitive.
package main

import (
	"bytes"
	"encoding/base64"

	"image/jpeg"
	"image/png"

	"github.com/gdamore/tcell/v2"
	"github.com/rivo/tview"
)

const (
	beach = `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`

	chart = `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`
)

func main() {
	app := tview.NewApplication()

	image := tview.NewImage()
	b, _ := base64.StdEncoding.DecodeString(beach)
	photo, _ := jpeg.Decode(bytes.NewReader(b))
	b, _ = base64.StdEncoding.DecodeString(chart)
	graphics, _ := png.Decode(bytes.NewReader(b))
	image.SetImage(photo)

	imgType := tview.NewList().
		ShowSecondaryText(false).
		AddItem("Photo", "", 0, func() { image.SetImage(photo) }).
		AddItem("Graphics", "", 0, func() { image.SetImage(graphics) })
	imgType.SetTitle("Image Type").SetBorder(true)

	colors := tview.NewList().
		ShowSecondaryText(false).
		AddItem("2 colors", "", 0, func() { image.SetColors(2) }).
		AddItem("8 colors", "", 0, func() { image.SetColors(8) }).
		AddItem("256 colors", "", 0, func() { image.SetColors(256) }).
		AddItem("True-color", "", 0, func() { image.SetColors(tview.TrueColor) })
	colors.SetTitle("Colors").SetBorder(true)
	for i, c := range []int{2, 8, 256, tview.TrueColor} {
		if c == image.GetColors() {
			colors.SetCurrentItem(i)
			break
		}
	}

	dithering := tview.NewList().
		ShowSecondaryText(false).
		AddItem("None", "", 0, func() { image.SetDithering(tview.DitheringNone) }).
		AddItem("Floyd-Steinberg", "", 0, func() { image.SetDithering(tview.DitheringFloydSteinberg) }).
		SetCurrentItem(1)
	dithering.SetTitle("Dithering").SetBorder(true)

	selections := []*tview.Box{imgType.Box, colors.Box, dithering.Box}
	for i, box := range selections {
		(func(index int) {
			box.SetInputCapture(func(event *tcell.EventKey) *tcell.EventKey {
				switch event.Key() {
				case tcell.KeyTab:
					app.SetFocus(selections[(index+1)%len(selections)])
					return nil
				case tcell.KeyBacktab:
					app.SetFocus(selections[(index+len(selections)-1)%len(selections)])
					return nil
				}
				return event
			})
		})(i)
	}

	grid := tview.NewGrid().
		SetBorders(false).
		SetColumns(18, -1).
		SetRows(4, 6, 4, -1).
		AddItem(imgType, 0, 0, 1, 1, 0, 0, true).
		AddItem(colors, 1, 0, 1, 1, 0, 0, false).
		AddItem(dithering, 2, 0, 1, 1, 0, 0, false).
		AddItem(image, 0, 1, 4, 1, 0, 0, false)

	if err := app.SetRoot(grid, true).EnableMouse(true).Run(); err != nil {
		panic(err)
	}
}
