# Badgerodon Collections

Maps and slices go a long way in Go, but sometimes you need more. This is a collection of collections that may be useful.

## Queue
A [queue](http://en.wikipedia.org/wiki/Queue_(data_structure%29) is a first-in first-out data structure.

## Set
A [set](http://en.wikipedia.org/wiki/Set_(computer_science%29) is an unordered collection of unique values typically used for testing membership.

## Skip list
A [skip list](http://en.wikipedia.org/wiki/Skip_list) is a data structure that stores nodes in a hierarchy of linked lists. It gives performance similar to binary search trees by using a random number of forward links to skip parts of the list.

## Splay Tree

A [splay tree](http://en.wikipedia.org/wiki/Splay_tree) is a type of binary search tree where every access to the tree results in the tree being rearranged so that the current node gets put on top.

## Stack
A [stack](http://en.wikipedia.org/wiki/Stack_(abstract_data_type%29) is a last-in last-out data structure.

## Trie
A [trie](http://en.wikipedia.org/wiki/Trie) is a type of tree where each node represents one byte of a key.

## Ternary Search Tree

A [ternary search tree](http://en.wikipedia.org/wiki/Ternary_search_tree) is similar to a trie in that nodes store the letters of the key, but instead of either using a list or hash at each node a binary tree is used. Ternary search trees have the performance benefits of a trie without the usual memory costs.