package recoveryservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthType enumerates the values for auth type.
type AuthType string

const (
	// AAD ...
	AAD AuthType = "AAD"
	// AccessControlService ...
	AccessControlService AuthType = "AccessControlService"
	// ACS ...
	ACS AuthType = "ACS"
	// AzureActiveDirectory ...
	AzureActiveDirectory AuthType = "AzureActiveDirectory"
	// Invalid ...
	Invalid AuthType = "Invalid"
)

// PossibleAuthTypeValues returns an array of possible values for the AuthType const type.
func PossibleAuthTypeValues() []AuthType {
	return []AuthType{AAD, AccessControlService, ACS, AzureActiveDirectory, Invalid}
}

// AuthTypeBasicResourceCertificateDetails enumerates the values for auth type basic resource certificate
// details.
type AuthTypeBasicResourceCertificateDetails string

const (
	// AuthTypeAccessControlService ...
	AuthTypeAccessControlService AuthTypeBasicResourceCertificateDetails = "AccessControlService"
	// AuthTypeAzureActiveDirectory ...
	AuthTypeAzureActiveDirectory AuthTypeBasicResourceCertificateDetails = "AzureActiveDirectory"
	// AuthTypeResourceCertificateDetails ...
	AuthTypeResourceCertificateDetails AuthTypeBasicResourceCertificateDetails = "ResourceCertificateDetails"
)

// PossibleAuthTypeBasicResourceCertificateDetailsValues returns an array of possible values for the AuthTypeBasicResourceCertificateDetails const type.
func PossibleAuthTypeBasicResourceCertificateDetailsValues() []AuthTypeBasicResourceCertificateDetails {
	return []AuthTypeBasicResourceCertificateDetails{AuthTypeAccessControlService, AuthTypeAzureActiveDirectory, AuthTypeResourceCertificateDetails}
}

// PrivateEndpointConnectionStatus enumerates the values for private endpoint connection status.
type PrivateEndpointConnectionStatus string

const (
	// Approved ...
	Approved PrivateEndpointConnectionStatus = "Approved"
	// Disconnected ...
	Disconnected PrivateEndpointConnectionStatus = "Disconnected"
	// Pending ...
	Pending PrivateEndpointConnectionStatus = "Pending"
	// Rejected ...
	Rejected PrivateEndpointConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointConnectionStatusValues returns an array of possible values for the PrivateEndpointConnectionStatus const type.
func PossiblePrivateEndpointConnectionStatusValues() []PrivateEndpointConnectionStatus {
	return []PrivateEndpointConnectionStatus{Approved, Disconnected, Pending, Rejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStatePending ...
	ProvisioningStatePending ProvisioningState = "Pending"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStatePending, ProvisioningStateSucceeded}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// None ...
	None ResourceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{None, SystemAssigned}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// RS0 ...
	RS0 SkuName = "RS0"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{RS0, Standard}
}

// TriggerType enumerates the values for trigger type.
type TriggerType string

const (
	// ForcedUpgrade ...
	ForcedUpgrade TriggerType = "ForcedUpgrade"
	// UserTriggered ...
	UserTriggered TriggerType = "UserTriggered"
)

// PossibleTriggerTypeValues returns an array of possible values for the TriggerType const type.
func PossibleTriggerTypeValues() []TriggerType {
	return []TriggerType{ForcedUpgrade, UserTriggered}
}

// UsagesUnit enumerates the values for usages unit.
type UsagesUnit string

const (
	// Bytes ...
	Bytes UsagesUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UsagesUnit = "BytesPerSecond"
	// Count ...
	Count UsagesUnit = "Count"
	// CountPerSecond ...
	CountPerSecond UsagesUnit = "CountPerSecond"
	// Percent ...
	Percent UsagesUnit = "Percent"
	// Seconds ...
	Seconds UsagesUnit = "Seconds"
)

// PossibleUsagesUnitValues returns an array of possible values for the UsagesUnit const type.
func PossibleUsagesUnitValues() []UsagesUnit {
	return []UsagesUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// VaultPrivateEndpointState enumerates the values for vault private endpoint state.
type VaultPrivateEndpointState string

const (
	// VaultPrivateEndpointStateEnabled ...
	VaultPrivateEndpointStateEnabled VaultPrivateEndpointState = "Enabled"
	// VaultPrivateEndpointStateNone ...
	VaultPrivateEndpointStateNone VaultPrivateEndpointState = "None"
)

// PossibleVaultPrivateEndpointStateValues returns an array of possible values for the VaultPrivateEndpointState const type.
func PossibleVaultPrivateEndpointStateValues() []VaultPrivateEndpointState {
	return []VaultPrivateEndpointState{VaultPrivateEndpointStateEnabled, VaultPrivateEndpointStateNone}
}

// VaultUpgradeState enumerates the values for vault upgrade state.
type VaultUpgradeState string

const (
	// Failed ...
	Failed VaultUpgradeState = "Failed"
	// InProgress ...
	InProgress VaultUpgradeState = "InProgress"
	// Unknown ...
	Unknown VaultUpgradeState = "Unknown"
	// Upgraded ...
	Upgraded VaultUpgradeState = "Upgraded"
)

// PossibleVaultUpgradeStateValues returns an array of possible values for the VaultUpgradeState const type.
func PossibleVaultUpgradeStateValues() []VaultUpgradeState {
	return []VaultUpgradeState{Failed, InProgress, Unknown, Upgraded}
}
