package insights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2022-06-01-preview/insights"

// ActionDetail the action detail
type ActionDetail struct {
	// MechanismType - The mechanism type
	MechanismType *string `json:"MechanismType,omitempty"`
	// Name - The name of the action
	Name *string `json:"Name,omitempty"`
	// Status - The status of the action
	Status *string `json:"Status,omitempty"`
	// SubState - The substatus of the action
	SubState *string `json:"SubState,omitempty"`
	// SendTime - The send time
	SendTime *string `json:"SendTime,omitempty"`
	// Detail - The detail of the friendly error message
	Detail *string `json:"Detail,omitempty"`
}

// ActionGroup an Azure action group.
type ActionGroup struct {
	// GroupShortName - The short name of the action group. This will be used in SMS messages.
	GroupShortName *string `json:"groupShortName,omitempty"`
	// Enabled - Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
	Enabled *bool `json:"enabled,omitempty"`
	// EmailReceivers - The list of email receivers that are part of this action group.
	EmailReceivers *[]EmailReceiver `json:"emailReceivers,omitempty"`
	// SmsReceivers - The list of SMS receivers that are part of this action group.
	SmsReceivers *[]SmsReceiver `json:"smsReceivers,omitempty"`
	// WebhookReceivers - The list of webhook receivers that are part of this action group.
	WebhookReceivers *[]WebhookReceiver `json:"webhookReceivers,omitempty"`
	// ItsmReceivers - The list of ITSM receivers that are part of this action group.
	ItsmReceivers *[]ItsmReceiver `json:"itsmReceivers,omitempty"`
	// AzureAppPushReceivers - The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers *[]AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`
	// AutomationRunbookReceivers - The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers *[]AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`
	// VoiceReceivers - The list of voice receivers that are part of this action group.
	VoiceReceivers *[]VoiceReceiver `json:"voiceReceivers,omitempty"`
	// LogicAppReceivers - The list of logic app receivers that are part of this action group.
	LogicAppReceivers *[]LogicAppReceiver `json:"logicAppReceivers,omitempty"`
	// AzureFunctionReceivers - The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers *[]AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`
	// ArmRoleReceivers - The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
	ArmRoleReceivers *[]ArmRoleReceiver `json:"armRoleReceivers,omitempty"`
	// EventHubReceivers - The list of event hub receivers that are part of this action group.
	EventHubReceivers *[]EventHubReceiver `json:"eventHubReceivers,omitempty"`
}

// ActionGroupForActivityLogAlerts a pointer to an Azure Action Group.
type ActionGroupForActivityLogAlerts struct {
	// ActionGroupID - The resource ID of the Action Group. This cannot be null or empty.
	ActionGroupID *string `json:"actionGroupId,omitempty"`
	// WebhookProperties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	WebhookProperties map[string]*string `json:"webhookProperties"`
}

// MarshalJSON is the custom marshaler for ActionGroupForActivityLogAlerts.
func (agfala ActionGroupForActivityLogAlerts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfala.ActionGroupID != nil {
		objectMap["actionGroupId"] = agfala.ActionGroupID
	}
	if agfala.WebhookProperties != nil {
		objectMap["webhookProperties"] = agfala.WebhookProperties
	}
	return json.Marshal(objectMap)
}

// ActionGroupList a list of action groups.
type ActionGroupList struct {
	autorest.Response `json:"-"`
	// Value - The list of action groups.
	Value *[]ActionGroupResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActionGroupPatch an Azure action group for patch operations.
type ActionGroupPatch struct {
	// Enabled - Indicates whether this action group is enabled. If an action group is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// ActionGroupPatchBody an action group object for the body of patch operations.
type ActionGroupPatchBody struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ActionGroupPatch - The action group settings for an update operation.
	*ActionGroupPatch `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionGroupPatchBody.
func (agpb ActionGroupPatchBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpb.Tags != nil {
		objectMap["tags"] = agpb.Tags
	}
	if agpb.ActionGroupPatch != nil {
		objectMap["properties"] = agpb.ActionGroupPatch
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionGroupPatchBody struct.
func (agpb *ActionGroupPatchBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agpb.Tags = tags
			}
		case "properties":
			if v != nil {
				var actionGroupPatch ActionGroupPatch
				err = json.Unmarshal(*v, &actionGroupPatch)
				if err != nil {
					return err
				}
				agpb.ActionGroupPatch = &actionGroupPatch
			}
		}
	}

	return nil
}

// ActionGroupResource an action group resource.
type ActionGroupResource struct {
	autorest.Response `json:"-"`
	// ActionGroup - The action groups properties of the resource.
	*ActionGroup `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ActionGroupResource.
func (agr ActionGroupResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agr.ActionGroup != nil {
		objectMap["properties"] = agr.ActionGroup
	}
	if agr.Location != nil {
		objectMap["location"] = agr.Location
	}
	if agr.Tags != nil {
		objectMap["tags"] = agr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionGroupResource struct.
func (agr *ActionGroupResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var actionGroup ActionGroup
				err = json.Unmarshal(*v, &actionGroup)
				if err != nil {
					return err
				}
				agr.ActionGroup = &actionGroup
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agr.Tags = tags
			}
		}
	}

	return nil
}

// ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ActionGroupsClient) (TestNotificationDetailsResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture.Result.
func (future *ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture) result(client ActionGroupsClient) (tndr TestNotificationDetailsResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tndr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tndr.Response.Response, err = future.GetResult(sender); err == nil && tndr.Response.Response.StatusCode != http.StatusNoContent {
		tndr, err = client.CreateNotificationsAtActionGroupResourceLevelResponder(tndr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "insights.ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture", "Result", tndr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ActionGroupsCreateNotificationsAtResourceGroupLevelFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ActionGroupsCreateNotificationsAtResourceGroupLevelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ActionGroupsClient) (TestNotificationDetailsResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ActionGroupsCreateNotificationsAtResourceGroupLevelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ActionGroupsCreateNotificationsAtResourceGroupLevelFuture.Result.
func (future *ActionGroupsCreateNotificationsAtResourceGroupLevelFuture) result(client ActionGroupsClient) (tndr TestNotificationDetailsResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.ActionGroupsCreateNotificationsAtResourceGroupLevelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tndr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.ActionGroupsCreateNotificationsAtResourceGroupLevelFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tndr.Response.Response, err = future.GetResult(sender); err == nil && tndr.Response.Response.StatusCode != http.StatusNoContent {
		tndr, err = client.CreateNotificationsAtResourceGroupLevelResponder(tndr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "insights.ActionGroupsCreateNotificationsAtResourceGroupLevelFuture", "Result", tndr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ActionGroupsPostTestNotificationsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ActionGroupsPostTestNotificationsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ActionGroupsClient) (TestNotificationDetailsResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ActionGroupsPostTestNotificationsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ActionGroupsPostTestNotificationsFuture.Result.
func (future *ActionGroupsPostTestNotificationsFuture) result(client ActionGroupsClient) (tndr TestNotificationDetailsResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.ActionGroupsPostTestNotificationsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tndr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.ActionGroupsPostTestNotificationsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tndr.Response.Response, err = future.GetResult(sender); err == nil && tndr.Response.Response.StatusCode != http.StatusNoContent {
		tndr, err = client.PostTestNotificationsResponder(tndr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "insights.ActionGroupsPostTestNotificationsFuture", "Result", tndr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ActionList a list of Activity Log Alert rule actions.
type ActionList struct {
	// ActionGroups - The list of the Action Groups.
	ActionGroups *[]ActionGroupForActivityLogAlerts `json:"actionGroups,omitempty"`
}

// Actions actions to invoke when the alert fires.
type Actions struct {
	// ActionGroups - Action Group resource Ids to invoke when the alert fires.
	ActionGroups *[]string `json:"actionGroups,omitempty"`
	// CustomProperties - The properties of an alert payload.
	CustomProperties map[string]*string `json:"customProperties"`
}

// MarshalJSON is the custom marshaler for Actions.
func (a Actions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ActionGroups != nil {
		objectMap["actionGroups"] = a.ActionGroups
	}
	if a.CustomProperties != nil {
		objectMap["customProperties"] = a.CustomProperties
	}
	return json.Marshal(objectMap)
}

// ActivityLogAlertResource an Activity Log Alert rule resource.
type ActivityLogAlertResource struct {
	autorest.Response `json:"-"`
	// AlertRuleProperties - The Activity Log Alert rule properties of the resource.
	*AlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ActivityLogAlertResource.
func (alar ActivityLogAlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alar.AlertRuleProperties != nil {
		objectMap["properties"] = alar.AlertRuleProperties
	}
	if alar.Location != nil {
		objectMap["location"] = alar.Location
	}
	if alar.Tags != nil {
		objectMap["tags"] = alar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityLogAlertResource struct.
func (alar *ActivityLogAlertResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertRuleProperties AlertRuleProperties
				err = json.Unmarshal(*v, &alertRuleProperties)
				if err != nil {
					return err
				}
				alar.AlertRuleProperties = &alertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				alar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				alar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				alar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				alar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				alar.Tags = tags
			}
		}
	}

	return nil
}

// AlertRule an alert rule.
type AlertRule struct {
	// Name - the name of the alert rule.
	Name *string `json:"name,omitempty"`
	// Description - the description of the alert rule that will be included in the alert email.
	Description *string `json:"description,omitempty"`
	// ProvisioningState - the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// IsEnabled - the flag that indicates whether the alert rule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Condition - the condition that results in the alert rule being activated.
	Condition BasicRuleCondition `json:"condition,omitempty"`
	// Action - action that is performed when the alert rule becomes active, and when an alert condition is resolved.
	Action BasicRuleAction `json:"action,omitempty"`
	// Actions - the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions *[]BasicRuleAction `json:"actions,omitempty"`
	// LastUpdatedTime - READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRule.
func (ar AlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Description != nil {
		objectMap["description"] = ar.Description
	}
	if ar.ProvisioningState != nil {
		objectMap["provisioningState"] = ar.ProvisioningState
	}
	if ar.IsEnabled != nil {
		objectMap["isEnabled"] = ar.IsEnabled
	}
	objectMap["condition"] = ar.Condition
	objectMap["action"] = ar.Action
	if ar.Actions != nil {
		objectMap["actions"] = ar.Actions
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRule struct.
func (ar *AlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ar.Description = &description
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ar.ProvisioningState = &provisioningState
			}
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				ar.IsEnabled = &isEnabled
			}
		case "condition":
			if v != nil {
				condition, err := unmarshalBasicRuleCondition(*v)
				if err != nil {
					return err
				}
				ar.Condition = condition
			}
		case "action":
			if v != nil {
				action, err := unmarshalBasicRuleAction(*v)
				if err != nil {
					return err
				}
				ar.Action = action
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicRuleActionArray(*v)
				if err != nil {
					return err
				}
				ar.Actions = &actions
			}
		case "lastUpdatedTime":
			if v != nil {
				var lastUpdatedTime date.Time
				err = json.Unmarshal(*v, &lastUpdatedTime)
				if err != nil {
					return err
				}
				ar.LastUpdatedTime = &lastUpdatedTime
			}
		}
	}

	return nil
}

// AlertRuleAllOfCondition an Activity Log Alert rule condition that is met when all its member conditions
// are met.
type AlertRuleAllOfCondition struct {
	// AllOf - The list of Activity Log Alert rule conditions.
	AllOf *[]AlertRuleAnyOfOrLeafCondition `json:"allOf,omitempty"`
}

// AlertRuleAnyOfOrLeafCondition an Activity Log Alert rule condition that is met when all its member
// conditions are met.
// Each condition can be of one of the following types:
// __Important__: Each type has its unique subset of properties. Properties from different types CANNOT
// exist in one condition.
// * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
// _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
// * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
// _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._
type AlertRuleAnyOfOrLeafCondition struct {
	// AnyOf - An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
	AnyOf *[]AlertRuleLeafCondition `json:"anyOf,omitempty"`
	// Field - The name of the Activity Log event's field that this condition will examine.
	// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
	// Equals - The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
	// ContainsAny - The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
	ContainsAny *[]string `json:"containsAny,omitempty"`
}

// AlertRuleLeafCondition an Activity Log Alert rule condition that is met by comparing the field and value
// of an Activity Log event.
// This condition must contain 'field' and either 'equals' or 'containsAny'.
type AlertRuleLeafCondition struct {
	// Field - The name of the Activity Log event's field that this condition will examine.
	// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
	// Equals - The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
	// ContainsAny - The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
	ContainsAny *[]string `json:"containsAny,omitempty"`
}

// AlertRuleList a list of Activity Log Alert rules.
type AlertRuleList struct {
	autorest.Response `json:"-"`
	// Value - The list of Activity Log Alert rules.
	Value *[]ActivityLogAlertResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertRuleListIterator provides access to a complete listing of ActivityLogAlertResource values.
type AlertRuleListIterator struct {
	i    int
	page AlertRuleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRuleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRuleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRuleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRuleListIterator) Response() AlertRuleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRuleListIterator) Value() ActivityLogAlertResource {
	if !iter.page.NotDone() {
		return ActivityLogAlertResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRuleListIterator type.
func NewAlertRuleListIterator(page AlertRuleListPage) AlertRuleListIterator {
	return AlertRuleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRuleList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AlertRuleList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// alertRuleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRuleList) alertRuleListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRuleListPage contains a page of ActivityLogAlertResource values.
type AlertRuleListPage struct {
	fn  func(context.Context, AlertRuleList) (AlertRuleList, error)
	arl AlertRuleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRuleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRuleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRuleListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRuleListPage) Response() AlertRuleList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRuleListPage) Values() []ActivityLogAlertResource {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRuleListPage type.
func NewAlertRuleListPage(cur AlertRuleList, getNextPage func(context.Context, AlertRuleList) (AlertRuleList, error)) AlertRuleListPage {
	return AlertRuleListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// AlertRulePatchObject an Activity Log Alert rule object for the body of patch operations.
type AlertRulePatchObject struct {
	// Tags - The resource tags
	Tags map[string]*string `json:"tags"`
	// AlertRulePatchProperties - The activity log alert settings for an update operation.
	*AlertRulePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRulePatchObject.
func (arpo AlertRulePatchObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arpo.Tags != nil {
		objectMap["tags"] = arpo.Tags
	}
	if arpo.AlertRulePatchProperties != nil {
		objectMap["properties"] = arpo.AlertRulePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRulePatchObject struct.
func (arpo *AlertRulePatchObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arpo.Tags = tags
			}
		case "properties":
			if v != nil {
				var alertRulePatchProperties AlertRulePatchProperties
				err = json.Unmarshal(*v, &alertRulePatchProperties)
				if err != nil {
					return err
				}
				arpo.AlertRulePatchProperties = &alertRulePatchProperties
			}
		}
	}

	return nil
}

// AlertRulePatchProperties an Activity Log Alert rule properties for patch operations.
type AlertRulePatchProperties struct {
	// Enabled - Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertRuleProperties an Azure Activity Log Alert rule.
type AlertRuleProperties struct {
	// Scopes - A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
	Scopes *[]string `json:"scopes,omitempty"`
	// Condition - The condition that will cause this alert to activate.
	Condition *AlertRuleAllOfCondition `json:"condition,omitempty"`
	// Actions - The actions that will activate when the condition is met.
	Actions *ActionList `json:"actions,omitempty"`
	// Enabled - Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
	// Description - A description of this Activity Log Alert rule.
	Description *string `json:"description,omitempty"`
}

// AlertRuleResource the alert rule resource.
type AlertRuleResource struct {
	autorest.Response `json:"-"`
	// AlertRule - The alert rule properties of the resource.
	*AlertRule `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AlertRuleResource.
func (arr AlertRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arr.AlertRule != nil {
		objectMap["properties"] = arr.AlertRule
	}
	if arr.Location != nil {
		objectMap["location"] = arr.Location
	}
	if arr.Tags != nil {
		objectMap["tags"] = arr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleResource struct.
func (arr *AlertRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertRule AlertRule
				err = json.Unmarshal(*v, &alertRule)
				if err != nil {
					return err
				}
				arr.AlertRule = &alertRule
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				arr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				arr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				arr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arr.Tags = tags
			}
		}
	}

	return nil
}

// AlertRuleResourceCollection represents a collection of alert rule resources.
type AlertRuleResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the alert rule resources.
	Value *[]AlertRuleResource `json:"value,omitempty"`
}

// AlertRuleResourcePatch the alert rule object for patch operations.
type AlertRuleResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AlertRule - The properties of an alert rule.
	*AlertRule `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRuleResourcePatch.
func (arrp AlertRuleResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arrp.Tags != nil {
		objectMap["tags"] = arrp.Tags
	}
	if arrp.AlertRule != nil {
		objectMap["properties"] = arrp.AlertRule
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleResourcePatch struct.
func (arrp *AlertRuleResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var alertRule AlertRule
				err = json.Unmarshal(*v, &alertRule)
				if err != nil {
					return err
				}
				arrp.AlertRule = &alertRule
			}
		}
	}

	return nil
}

// ArmRoleReceiver an arm role receiver.
type ArmRoleReceiver struct {
	// Name - The name of the arm role receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// RoleID - The arm role id.
	RoleID *string `json:"roleId,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutomationRunbookReceiver the Azure Automation Runbook notification receiver.
type AutomationRunbookReceiver struct {
	// AutomationAccountID - The Azure automation account Id which holds this runbook and authenticate to Azure resource.
	AutomationAccountID *string `json:"automationAccountId,omitempty"`
	// RunbookName - The name for this runbook.
	RunbookName *string `json:"runbookName,omitempty"`
	// WebhookResourceID - The resource id for webhook linked to this runbook.
	WebhookResourceID *string `json:"webhookResourceId,omitempty"`
	// IsGlobalRunbook - Indicates whether this instance is global runbook.
	IsGlobalRunbook *bool `json:"isGlobalRunbook,omitempty"`
	// Name - Indicates name of the webhook.
	Name *string `json:"name,omitempty"`
	// ServiceURI - The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutoscaleNotification autoscale notification.
type AutoscaleNotification struct {
	// Operation - the operation associated with the notification and its value must be "scale"
	Operation *string `json:"operation,omitempty"`
	// Email - the email notification.
	Email *EmailNotification `json:"email,omitempty"`
	// Webhooks - the collection of webhook notifications.
	Webhooks *[]WebhookNotification `json:"webhooks,omitempty"`
}

// AutoscaleProfile autoscale profile.
type AutoscaleProfile struct {
	// Name - the name of the profile.
	Name *string `json:"name,omitempty"`
	// Capacity - the number of instances that can be used during this profile.
	Capacity *ScaleCapacity `json:"capacity,omitempty"`
	// Rules - the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
	Rules *[]ScaleRule `json:"rules,omitempty"`
	// FixedDate - the specific date-time for the profile. This element is not used if the Recurrence element is used.
	FixedDate *TimeWindow `json:"fixedDate,omitempty"`
	// Recurrence - the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
	Recurrence *Recurrence `json:"recurrence,omitempty"`
}

// AutoscaleSetting a setting that contains all of the configuration for the automatic scaling of a
// resource.
type AutoscaleSetting struct {
	// Profiles - the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
	Profiles *[]AutoscaleProfile `json:"profiles,omitempty"`
	// Notifications - the collection of notifications.
	Notifications *[]AutoscaleNotification `json:"notifications,omitempty"`
	// Enabled - the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
	Enabled *bool `json:"enabled,omitempty"`
	// Name - the name of the autoscale setting.
	Name *string `json:"name,omitempty"`
	// TargetResourceURI - the resource identifier of the resource that the autoscale setting should be added to.
	TargetResourceURI *string `json:"targetResourceUri,omitempty"`
	// TargetResourceLocation - the location of the resource that the autoscale setting should be added to.
	TargetResourceLocation *string `json:"targetResourceLocation,omitempty"`
}

// AutoscaleSettingResource the autoscale setting resource.
type AutoscaleSettingResource struct {
	autorest.Response `json:"-"`
	// AutoscaleSetting - The autoscale setting of the resource.
	*AutoscaleSetting `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingResource.
func (asr AutoscaleSettingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.AutoscaleSetting != nil {
		objectMap["properties"] = asr.AutoscaleSetting
	}
	if asr.Location != nil {
		objectMap["location"] = asr.Location
	}
	if asr.Tags != nil {
		objectMap["tags"] = asr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoscaleSettingResource struct.
func (asr *AutoscaleSettingResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var autoscaleSetting AutoscaleSetting
				err = json.Unmarshal(*v, &autoscaleSetting)
				if err != nil {
					return err
				}
				asr.AutoscaleSetting = &autoscaleSetting
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asr.Tags = tags
			}
		}
	}

	return nil
}

// AutoscaleSettingResourceCollection represents a collection of autoscale setting resources.
type AutoscaleSettingResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the autoscale setting resources.
	Value *[]AutoscaleSettingResource `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutoscaleSettingResourceCollectionIterator provides access to a complete listing of
// AutoscaleSettingResource values.
type AutoscaleSettingResourceCollectionIterator struct {
	i    int
	page AutoscaleSettingResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoscaleSettingResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoscaleSettingResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoscaleSettingResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoscaleSettingResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoscaleSettingResourceCollectionIterator) Response() AutoscaleSettingResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoscaleSettingResourceCollectionIterator) Value() AutoscaleSettingResource {
	if !iter.page.NotDone() {
		return AutoscaleSettingResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoscaleSettingResourceCollectionIterator type.
func NewAutoscaleSettingResourceCollectionIterator(page AutoscaleSettingResourceCollectionPage) AutoscaleSettingResourceCollectionIterator {
	return AutoscaleSettingResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asrc AutoscaleSettingResourceCollection) IsEmpty() bool {
	return asrc.Value == nil || len(*asrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asrc AutoscaleSettingResourceCollection) hasNextLink() bool {
	return asrc.NextLink != nil && len(*asrc.NextLink) != 0
}

// autoscaleSettingResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asrc AutoscaleSettingResourceCollection) autoscaleSettingResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !asrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asrc.NextLink)))
}

// AutoscaleSettingResourceCollectionPage contains a page of AutoscaleSettingResource values.
type AutoscaleSettingResourceCollectionPage struct {
	fn   func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)
	asrc AutoscaleSettingResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoscaleSettingResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoscaleSettingResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asrc)
		if err != nil {
			return err
		}
		page.asrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoscaleSettingResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoscaleSettingResourceCollectionPage) NotDone() bool {
	return !page.asrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoscaleSettingResourceCollectionPage) Response() AutoscaleSettingResourceCollection {
	return page.asrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoscaleSettingResourceCollectionPage) Values() []AutoscaleSettingResource {
	if page.asrc.IsEmpty() {
		return nil
	}
	return *page.asrc.Value
}

// Creates a new instance of the AutoscaleSettingResourceCollectionPage type.
func NewAutoscaleSettingResourceCollectionPage(cur AutoscaleSettingResourceCollection, getNextPage func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)) AutoscaleSettingResourceCollectionPage {
	return AutoscaleSettingResourceCollectionPage{
		fn:   getNextPage,
		asrc: cur,
	}
}

// AutoscaleSettingResourcePatch the autoscale setting object for patch operations.
type AutoscaleSettingResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AutoscaleSetting - The autoscale setting properties of the update operation.
	*AutoscaleSetting `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingResourcePatch.
func (asrp AutoscaleSettingResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrp.Tags != nil {
		objectMap["tags"] = asrp.Tags
	}
	if asrp.AutoscaleSetting != nil {
		objectMap["properties"] = asrp.AutoscaleSetting
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoscaleSettingResourcePatch struct.
func (asrp *AutoscaleSettingResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var autoscaleSetting AutoscaleSetting
				err = json.Unmarshal(*v, &autoscaleSetting)
				if err != nil {
					return err
				}
				asrp.AutoscaleSetting = &autoscaleSetting
			}
		}
	}

	return nil
}

// AzureAppPushReceiver the Azure mobile App push notification receiver.
type AzureAppPushReceiver struct {
	// Name - The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EmailAddress - The email address registered for the Azure mobile app.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// AzureFunctionReceiver an azure function receiver.
type AzureFunctionReceiver struct {
	// Name - The name of the azure function receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// FunctionAppResourceID - The azure resource id of the function app.
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`
	// FunctionName - The function name in the function app.
	FunctionName *string `json:"functionName,omitempty"`
	// HTTPTriggerURL - The http trigger url where http request sent to.
	HTTPTriggerURL *string `json:"httpTriggerUrl,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AzureMonitorMetricsDestination azure Monitor Metrics destination.
type AzureMonitorMetricsDestination struct {
	// Name - A friendly name for the destination.
	// This name should be unique across all destinations (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// AzureMonitorPrivateLinkScope an Azure Monitor PrivateLinkScope definition.
type AzureMonitorPrivateLinkScope struct {
	autorest.Response `json:"-"`
	// AzureMonitorPrivateLinkScopeProperties - Properties that define a Azure Monitor PrivateLinkScope resource.
	*AzureMonitorPrivateLinkScopeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureMonitorPrivateLinkScope.
func (ampls AzureMonitorPrivateLinkScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ampls.AzureMonitorPrivateLinkScopeProperties != nil {
		objectMap["properties"] = ampls.AzureMonitorPrivateLinkScopeProperties
	}
	if ampls.Location != nil {
		objectMap["location"] = ampls.Location
	}
	if ampls.Tags != nil {
		objectMap["tags"] = ampls.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureMonitorPrivateLinkScope struct.
func (ampls *AzureMonitorPrivateLinkScope) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureMonitorPrivateLinkScopeProperties AzureMonitorPrivateLinkScopeProperties
				err = json.Unmarshal(*v, &azureMonitorPrivateLinkScopeProperties)
				if err != nil {
					return err
				}
				ampls.AzureMonitorPrivateLinkScopeProperties = &azureMonitorPrivateLinkScopeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ampls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ampls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ampls.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ampls.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ampls.Tags = tags
			}
		}
	}

	return nil
}

// AzureMonitorPrivateLinkScopeListResult describes the list of Azure Monitor PrivateLinkScope resources.
type AzureMonitorPrivateLinkScopeListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Monitor PrivateLinkScope definitions.
	Value *[]AzureMonitorPrivateLinkScope `json:"value,omitempty"`
	// NextLink - The URI to get the next set of Azure Monitor PrivateLinkScope definitions if too many PrivateLinkScopes where returned in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureMonitorPrivateLinkScopeListResultIterator provides access to a complete listing of
// AzureMonitorPrivateLinkScope values.
type AzureMonitorPrivateLinkScopeListResultIterator struct {
	i    int
	page AzureMonitorPrivateLinkScopeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureMonitorPrivateLinkScopeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureMonitorPrivateLinkScopeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureMonitorPrivateLinkScopeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureMonitorPrivateLinkScopeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureMonitorPrivateLinkScopeListResultIterator) Response() AzureMonitorPrivateLinkScopeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureMonitorPrivateLinkScopeListResultIterator) Value() AzureMonitorPrivateLinkScope {
	if !iter.page.NotDone() {
		return AzureMonitorPrivateLinkScope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureMonitorPrivateLinkScopeListResultIterator type.
func NewAzureMonitorPrivateLinkScopeListResultIterator(page AzureMonitorPrivateLinkScopeListResultPage) AzureMonitorPrivateLinkScopeListResultIterator {
	return AzureMonitorPrivateLinkScopeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (amplslr AzureMonitorPrivateLinkScopeListResult) IsEmpty() bool {
	return amplslr.Value == nil || len(*amplslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (amplslr AzureMonitorPrivateLinkScopeListResult) hasNextLink() bool {
	return amplslr.NextLink != nil && len(*amplslr.NextLink) != 0
}

// azureMonitorPrivateLinkScopeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (amplslr AzureMonitorPrivateLinkScopeListResult) azureMonitorPrivateLinkScopeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !amplslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(amplslr.NextLink)))
}

// AzureMonitorPrivateLinkScopeListResultPage contains a page of AzureMonitorPrivateLinkScope values.
type AzureMonitorPrivateLinkScopeListResultPage struct {
	fn      func(context.Context, AzureMonitorPrivateLinkScopeListResult) (AzureMonitorPrivateLinkScopeListResult, error)
	amplslr AzureMonitorPrivateLinkScopeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureMonitorPrivateLinkScopeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureMonitorPrivateLinkScopeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.amplslr)
		if err != nil {
			return err
		}
		page.amplslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureMonitorPrivateLinkScopeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureMonitorPrivateLinkScopeListResultPage) NotDone() bool {
	return !page.amplslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureMonitorPrivateLinkScopeListResultPage) Response() AzureMonitorPrivateLinkScopeListResult {
	return page.amplslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureMonitorPrivateLinkScopeListResultPage) Values() []AzureMonitorPrivateLinkScope {
	if page.amplslr.IsEmpty() {
		return nil
	}
	return *page.amplslr.Value
}

// Creates a new instance of the AzureMonitorPrivateLinkScopeListResultPage type.
func NewAzureMonitorPrivateLinkScopeListResultPage(cur AzureMonitorPrivateLinkScopeListResult, getNextPage func(context.Context, AzureMonitorPrivateLinkScopeListResult) (AzureMonitorPrivateLinkScopeListResult, error)) AzureMonitorPrivateLinkScopeListResultPage {
	return AzureMonitorPrivateLinkScopeListResultPage{
		fn:      getNextPage,
		amplslr: cur,
	}
}

// AzureMonitorPrivateLinkScopeProperties properties that define a Azure Monitor PrivateLinkScope resource.
type AzureMonitorPrivateLinkScopeProperties struct {
	// ProvisioningState - READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMonitorPrivateLinkScopeProperties.
func (amplsp AzureMonitorPrivateLinkScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureResource an azure resource object
type AzureResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureResource.
func (ar AzureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// BaselineMetadata represents a baseline metadata value.
type BaselineMetadata struct {
	// Name - Name of the baseline metadata.
	Name *string `json:"name,omitempty"`
	// Value - Value of the baseline metadata.
	Value *string `json:"value,omitempty"`
}

// ColumnDefinition definition of custom data column.
type ColumnDefinition struct {
	// Name - The name of the column.
	Name *string `json:"name,omitempty"`
	// Type - The type of the column data. Possible values include: 'String', 'Int', 'Long', 'Real', 'Boolean', 'Datetime', 'Dynamic'
	Type KnownColumnDefinitionType `json:"type,omitempty"`
}

// Condition a condition of the scheduled query rule.
type Condition struct {
	// Query - Log query alert
	Query *string `json:"query,omitempty"`
	// TimeAggregation - Aggregation type. Relevant and required only for rules of the kind LogAlert. Possible values include: 'TimeAggregationCount', 'TimeAggregationAverage', 'TimeAggregationMinimum', 'TimeAggregationMaximum', 'TimeAggregationTotal'
	TimeAggregation TimeAggregation `json:"timeAggregation,omitempty"`
	// MetricMeasureColumn - The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
	MetricMeasureColumn *string `json:"metricMeasureColumn,omitempty"`
	// ResourceIDColumn - The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
	ResourceIDColumn *string `json:"resourceIdColumn,omitempty"`
	// Dimensions - List of Dimensions conditions
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// Operator - The criteria operator. Relevant and required only for rules of the kind LogAlert. Possible values include: 'OperatorForConditionEquals', 'OperatorForConditionGreaterThan', 'OperatorForConditionGreaterThanOrEqual', 'OperatorForConditionLessThan', 'OperatorForConditionLessThanOrEqual'
	Operator OperatorForCondition `json:"operator,omitempty"`
	// Threshold - the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
	Threshold *float64 `json:"threshold,omitempty"`
	// FailingPeriods - The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
	FailingPeriods *ConditionFailingPeriods `json:"failingPeriods,omitempty"`
	// MetricName - The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
	MetricName *string `json:"metricName,omitempty"`
}

// ConditionFailingPeriods the minimum number of violations required within the selected lookback time
// window required to raise an alert. Relevant only for rules of the kind LogAlert.
type ConditionFailingPeriods struct {
	// NumberOfEvaluationPeriods - The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
	NumberOfEvaluationPeriods *int64 `json:"numberOfEvaluationPeriods,omitempty"`
	// MinFailingPeriodsToAlert - The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
	MinFailingPeriodsToAlert *int64 `json:"minFailingPeriodsToAlert,omitempty"`
}

// ConfigurationAccessEndpointSpec definition of the endpoint used for accessing configuration.
type ConfigurationAccessEndpointSpec struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationAccessEndpointSpec.
func (caes ConfigurationAccessEndpointSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Context the context info
type Context struct {
	// NotificationSource - The source of the notification request
	NotificationSource *string `json:"notificationSource,omitempty"`
	// ContextType - The context id type
	ContextType *string `json:"contextType,omitempty"`
}

// DataCollectionEndpoint definition of data collection endpoint.
type DataCollectionEndpoint struct {
	// Description - Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`
	// ImmutableID - The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// ConfigurationAccess - The endpoint used by clients to access their configuration.
	ConfigurationAccess *DataCollectionEndpointConfigurationAccess `json:"configurationAccess,omitempty"`
	// LogsIngestion - The endpoint used by clients to ingest logs.
	LogsIngestion *DataCollectionEndpointLogsIngestion `json:"logsIngestion,omitempty"`
	// NetworkAcls - Network access control rules for the endpoints.
	NetworkAcls *DataCollectionEndpointNetworkAcls `json:"networkAcls,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. This property is READ-ONLY. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed'
	ProvisioningState KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionEndpoint.
func (dce DataCollectionEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dce.Description != nil {
		objectMap["description"] = dce.Description
	}
	if dce.ImmutableID != nil {
		objectMap["immutableId"] = dce.ImmutableID
	}
	if dce.ConfigurationAccess != nil {
		objectMap["configurationAccess"] = dce.ConfigurationAccess
	}
	if dce.LogsIngestion != nil {
		objectMap["logsIngestion"] = dce.LogsIngestion
	}
	if dce.NetworkAcls != nil {
		objectMap["networkAcls"] = dce.NetworkAcls
	}
	return json.Marshal(objectMap)
}

// DataCollectionEndpointConfigurationAccess the endpoint used by clients to access their configuration.
type DataCollectionEndpointConfigurationAccess struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionEndpointConfigurationAccess.
func (dceA DataCollectionEndpointConfigurationAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataCollectionEndpointLogsIngestion the endpoint used by clients to ingest logs.
type DataCollectionEndpointLogsIngestion struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionEndpointLogsIngestion.
func (dceI DataCollectionEndpointLogsIngestion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataCollectionEndpointNetworkAcls network access control rules for the endpoints.
type DataCollectionEndpointNetworkAcls struct {
	// PublicNetworkAccess - The configuration to set whether network access from public internet to the endpoints are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// DataCollectionEndpointResource definition of ARM tracked top level resource.
type DataCollectionEndpointResource struct {
	autorest.Response `json:"-"`
	// DataCollectionEndpointResourceProperties - Resource properties.
	*DataCollectionEndpointResourceProperties `json:"properties,omitempty"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Kind - The kind of the resource. Possible values include: 'Linux', 'Windows'
	Kind KnownDataCollectionEndpointResourceKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionEndpointResourceSystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionEndpointResource.
func (dcer DataCollectionEndpointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcer.DataCollectionEndpointResourceProperties != nil {
		objectMap["properties"] = dcer.DataCollectionEndpointResourceProperties
	}
	if dcer.Location != nil {
		objectMap["location"] = dcer.Location
	}
	if dcer.Tags != nil {
		objectMap["tags"] = dcer.Tags
	}
	if dcer.Kind != "" {
		objectMap["kind"] = dcer.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataCollectionEndpointResource struct.
func (dcer *DataCollectionEndpointResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataCollectionEndpointResourceProperties DataCollectionEndpointResourceProperties
				err = json.Unmarshal(*v, &dataCollectionEndpointResourceProperties)
				if err != nil {
					return err
				}
				dcer.DataCollectionEndpointResourceProperties = &dataCollectionEndpointResourceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcer.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcer.Tags = tags
			}
		case "kind":
			if v != nil {
				var kind KnownDataCollectionEndpointResourceKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dcer.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcer.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcer.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcer.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dcer.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData DataCollectionEndpointResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dcer.SystemData = &systemData
			}
		}
	}

	return nil
}

// DataCollectionEndpointResourceListResult a pageable list of resources.
type DataCollectionEndpointResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of resources.
	Value *[]DataCollectionEndpointResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataCollectionEndpointResourceListResultIterator provides access to a complete listing of
// DataCollectionEndpointResource values.
type DataCollectionEndpointResourceListResultIterator struct {
	i    int
	page DataCollectionEndpointResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataCollectionEndpointResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataCollectionEndpointResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataCollectionEndpointResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataCollectionEndpointResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataCollectionEndpointResourceListResultIterator) Response() DataCollectionEndpointResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataCollectionEndpointResourceListResultIterator) Value() DataCollectionEndpointResource {
	if !iter.page.NotDone() {
		return DataCollectionEndpointResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataCollectionEndpointResourceListResultIterator type.
func NewDataCollectionEndpointResourceListResultIterator(page DataCollectionEndpointResourceListResultPage) DataCollectionEndpointResourceListResultIterator {
	return DataCollectionEndpointResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcerlr DataCollectionEndpointResourceListResult) IsEmpty() bool {
	return dcerlr.Value == nil || len(*dcerlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcerlr DataCollectionEndpointResourceListResult) hasNextLink() bool {
	return dcerlr.NextLink != nil && len(*dcerlr.NextLink) != 0
}

// dataCollectionEndpointResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcerlr DataCollectionEndpointResourceListResult) dataCollectionEndpointResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dcerlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcerlr.NextLink)))
}

// DataCollectionEndpointResourceListResultPage contains a page of DataCollectionEndpointResource values.
type DataCollectionEndpointResourceListResultPage struct {
	fn     func(context.Context, DataCollectionEndpointResourceListResult) (DataCollectionEndpointResourceListResult, error)
	dcerlr DataCollectionEndpointResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataCollectionEndpointResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataCollectionEndpointResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcerlr)
		if err != nil {
			return err
		}
		page.dcerlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataCollectionEndpointResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataCollectionEndpointResourceListResultPage) NotDone() bool {
	return !page.dcerlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataCollectionEndpointResourceListResultPage) Response() DataCollectionEndpointResourceListResult {
	return page.dcerlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataCollectionEndpointResourceListResultPage) Values() []DataCollectionEndpointResource {
	if page.dcerlr.IsEmpty() {
		return nil
	}
	return *page.dcerlr.Value
}

// Creates a new instance of the DataCollectionEndpointResourceListResultPage type.
func NewDataCollectionEndpointResourceListResultPage(cur DataCollectionEndpointResourceListResult, getNextPage func(context.Context, DataCollectionEndpointResourceListResult) (DataCollectionEndpointResourceListResult, error)) DataCollectionEndpointResourceListResultPage {
	return DataCollectionEndpointResourceListResultPage{
		fn:     getNextPage,
		dcerlr: cur,
	}
}

// DataCollectionEndpointResourceProperties resource properties.
type DataCollectionEndpointResourceProperties struct {
	// Description - Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`
	// ImmutableID - The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// ConfigurationAccess - The endpoint used by clients to access their configuration.
	ConfigurationAccess *DataCollectionEndpointConfigurationAccess `json:"configurationAccess,omitempty"`
	// LogsIngestion - The endpoint used by clients to ingest logs.
	LogsIngestion *DataCollectionEndpointLogsIngestion `json:"logsIngestion,omitempty"`
	// NetworkAcls - Network access control rules for the endpoints.
	NetworkAcls *DataCollectionEndpointNetworkAcls `json:"networkAcls,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. This property is READ-ONLY. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed'
	ProvisioningState KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionEndpointResourceProperties.
func (dcer DataCollectionEndpointResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcer.Description != nil {
		objectMap["description"] = dcer.Description
	}
	if dcer.ImmutableID != nil {
		objectMap["immutableId"] = dcer.ImmutableID
	}
	if dcer.ConfigurationAccess != nil {
		objectMap["configurationAccess"] = dcer.ConfigurationAccess
	}
	if dcer.LogsIngestion != nil {
		objectMap["logsIngestion"] = dcer.LogsIngestion
	}
	if dcer.NetworkAcls != nil {
		objectMap["networkAcls"] = dcer.NetworkAcls
	}
	return json.Marshal(objectMap)
}

// DataCollectionEndpointResourceSystemData metadata pertaining to creation and last modification of the
// resource.
type DataCollectionEndpointResourceSystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// DataCollectionRule definition of what monitoring data to collect and where that data should be sent.
type DataCollectionRule struct {
	// Description - Description of the data collection rule.
	Description *string `json:"description,omitempty"`
	// ImmutableID - READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that this rule can be used with.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleMetadata `json:"metadata,omitempty"`
	// StreamDeclarations - Declaration of custom streams used in this rule.
	StreamDeclarations map[string]*StreamDeclaration `json:"streamDeclarations"`
	// DataSources - The specification of data sources.
	// This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
	DataSources *DataCollectionRuleDataSources `json:"dataSources,omitempty"`
	// Destinations - The specification of destinations.
	Destinations *DataCollectionRuleDestinations `json:"destinations,omitempty"`
	// DataFlows - The specification of data flows.
	DataFlows *[]DataFlow `json:"dataFlows,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleProvisioningStateCreating', 'KnownDataCollectionRuleProvisioningStateUpdating', 'KnownDataCollectionRuleProvisioningStateDeleting', 'KnownDataCollectionRuleProvisioningStateSucceeded', 'KnownDataCollectionRuleProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRule.
func (dcr DataCollectionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcr.Description != nil {
		objectMap["description"] = dcr.Description
	}
	if dcr.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = dcr.DataCollectionEndpointID
	}
	if dcr.StreamDeclarations != nil {
		objectMap["streamDeclarations"] = dcr.StreamDeclarations
	}
	if dcr.DataSources != nil {
		objectMap["dataSources"] = dcr.DataSources
	}
	if dcr.Destinations != nil {
		objectMap["destinations"] = dcr.Destinations
	}
	if dcr.DataFlows != nil {
		objectMap["dataFlows"] = dcr.DataFlows
	}
	return json.Marshal(objectMap)
}

// DataCollectionRuleAssociation definition of association of a data collection rule with a monitored Azure
// resource.
type DataCollectionRuleAssociation struct {
	// Description - Description of the association.
	Description *string `json:"description,omitempty"`
	// DataCollectionRuleID - The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleAssociationProvisioningStateCreating', 'KnownDataCollectionRuleAssociationProvisioningStateUpdating', 'KnownDataCollectionRuleAssociationProvisioningStateDeleting', 'KnownDataCollectionRuleAssociationProvisioningStateSucceeded', 'KnownDataCollectionRuleAssociationProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleAssociationMetadata `json:"metadata,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleAssociation.
func (dcra DataCollectionRuleAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcra.Description != nil {
		objectMap["description"] = dcra.Description
	}
	if dcra.DataCollectionRuleID != nil {
		objectMap["dataCollectionRuleId"] = dcra.DataCollectionRuleID
	}
	if dcra.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = dcra.DataCollectionEndpointID
	}
	return json.Marshal(objectMap)
}

// DataCollectionRuleAssociationMetadata metadata about the resource
type DataCollectionRuleAssociationMetadata struct {
	// ProvisionedBy - READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleAssociationMetadata.
func (dcra DataCollectionRuleAssociationMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataCollectionRuleAssociationProxyOnlyResource definition of generic ARM proxy resource.
type DataCollectionRuleAssociationProxyOnlyResource struct {
	autorest.Response `json:"-"`
	// DataCollectionRuleAssociationProxyOnlyResourceProperties - Resource properties.
	*DataCollectionRuleAssociationProxyOnlyResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionRuleAssociationProxyOnlyResourceSystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleAssociationProxyOnlyResource.
func (dcrapor DataCollectionRuleAssociationProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcrapor.DataCollectionRuleAssociationProxyOnlyResourceProperties != nil {
		objectMap["properties"] = dcrapor.DataCollectionRuleAssociationProxyOnlyResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataCollectionRuleAssociationProxyOnlyResource struct.
func (dcrapor *DataCollectionRuleAssociationProxyOnlyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataCollectionRuleAssociationProxyOnlyResourceProperties DataCollectionRuleAssociationProxyOnlyResourceProperties
				err = json.Unmarshal(*v, &dataCollectionRuleAssociationProxyOnlyResourceProperties)
				if err != nil {
					return err
				}
				dcrapor.DataCollectionRuleAssociationProxyOnlyResourceProperties = &dataCollectionRuleAssociationProxyOnlyResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcrapor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcrapor.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcrapor.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dcrapor.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData DataCollectionRuleAssociationProxyOnlyResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dcrapor.SystemData = &systemData
			}
		}
	}

	return nil
}

// DataCollectionRuleAssociationProxyOnlyResourceListResult a pageable list of resources.
type DataCollectionRuleAssociationProxyOnlyResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of resources.
	Value *[]DataCollectionRuleAssociationProxyOnlyResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataCollectionRuleAssociationProxyOnlyResourceListResultIterator provides access to a complete listing
// of DataCollectionRuleAssociationProxyOnlyResource values.
type DataCollectionRuleAssociationProxyOnlyResourceListResultIterator struct {
	i    int
	page DataCollectionRuleAssociationProxyOnlyResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataCollectionRuleAssociationProxyOnlyResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataCollectionRuleAssociationProxyOnlyResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataCollectionRuleAssociationProxyOnlyResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataCollectionRuleAssociationProxyOnlyResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataCollectionRuleAssociationProxyOnlyResourceListResultIterator) Response() DataCollectionRuleAssociationProxyOnlyResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataCollectionRuleAssociationProxyOnlyResourceListResultIterator) Value() DataCollectionRuleAssociationProxyOnlyResource {
	if !iter.page.NotDone() {
		return DataCollectionRuleAssociationProxyOnlyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataCollectionRuleAssociationProxyOnlyResourceListResultIterator type.
func NewDataCollectionRuleAssociationProxyOnlyResourceListResultIterator(page DataCollectionRuleAssociationProxyOnlyResourceListResultPage) DataCollectionRuleAssociationProxyOnlyResourceListResultIterator {
	return DataCollectionRuleAssociationProxyOnlyResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcraporlr DataCollectionRuleAssociationProxyOnlyResourceListResult) IsEmpty() bool {
	return dcraporlr.Value == nil || len(*dcraporlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcraporlr DataCollectionRuleAssociationProxyOnlyResourceListResult) hasNextLink() bool {
	return dcraporlr.NextLink != nil && len(*dcraporlr.NextLink) != 0
}

// dataCollectionRuleAssociationProxyOnlyResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcraporlr DataCollectionRuleAssociationProxyOnlyResourceListResult) dataCollectionRuleAssociationProxyOnlyResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dcraporlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcraporlr.NextLink)))
}

// DataCollectionRuleAssociationProxyOnlyResourceListResultPage contains a page of
// DataCollectionRuleAssociationProxyOnlyResource values.
type DataCollectionRuleAssociationProxyOnlyResourceListResultPage struct {
	fn        func(context.Context, DataCollectionRuleAssociationProxyOnlyResourceListResult) (DataCollectionRuleAssociationProxyOnlyResourceListResult, error)
	dcraporlr DataCollectionRuleAssociationProxyOnlyResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataCollectionRuleAssociationProxyOnlyResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataCollectionRuleAssociationProxyOnlyResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcraporlr)
		if err != nil {
			return err
		}
		page.dcraporlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataCollectionRuleAssociationProxyOnlyResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataCollectionRuleAssociationProxyOnlyResourceListResultPage) NotDone() bool {
	return !page.dcraporlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataCollectionRuleAssociationProxyOnlyResourceListResultPage) Response() DataCollectionRuleAssociationProxyOnlyResourceListResult {
	return page.dcraporlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataCollectionRuleAssociationProxyOnlyResourceListResultPage) Values() []DataCollectionRuleAssociationProxyOnlyResource {
	if page.dcraporlr.IsEmpty() {
		return nil
	}
	return *page.dcraporlr.Value
}

// Creates a new instance of the DataCollectionRuleAssociationProxyOnlyResourceListResultPage type.
func NewDataCollectionRuleAssociationProxyOnlyResourceListResultPage(cur DataCollectionRuleAssociationProxyOnlyResourceListResult, getNextPage func(context.Context, DataCollectionRuleAssociationProxyOnlyResourceListResult) (DataCollectionRuleAssociationProxyOnlyResourceListResult, error)) DataCollectionRuleAssociationProxyOnlyResourceListResultPage {
	return DataCollectionRuleAssociationProxyOnlyResourceListResultPage{
		fn:        getNextPage,
		dcraporlr: cur,
	}
}

// DataCollectionRuleAssociationProxyOnlyResourceProperties resource properties.
type DataCollectionRuleAssociationProxyOnlyResourceProperties struct {
	// Description - Description of the association.
	Description *string `json:"description,omitempty"`
	// DataCollectionRuleID - The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleAssociationProvisioningStateCreating', 'KnownDataCollectionRuleAssociationProvisioningStateUpdating', 'KnownDataCollectionRuleAssociationProvisioningStateDeleting', 'KnownDataCollectionRuleAssociationProvisioningStateSucceeded', 'KnownDataCollectionRuleAssociationProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleAssociationMetadata `json:"metadata,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleAssociationProxyOnlyResourceProperties.
func (dcrapor DataCollectionRuleAssociationProxyOnlyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcrapor.Description != nil {
		objectMap["description"] = dcrapor.Description
	}
	if dcrapor.DataCollectionRuleID != nil {
		objectMap["dataCollectionRuleId"] = dcrapor.DataCollectionRuleID
	}
	if dcrapor.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = dcrapor.DataCollectionEndpointID
	}
	return json.Marshal(objectMap)
}

// DataCollectionRuleAssociationProxyOnlyResourceSystemData metadata pertaining to creation and last
// modification of the resource.
type DataCollectionRuleAssociationProxyOnlyResourceSystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// DataCollectionRuleDataSources the specification of data sources.
// This property is optional and can be omitted if the rule is meant to be used via direct calls to the
// provisioned endpoint.
type DataCollectionRuleDataSources struct {
	// PerformanceCounters - The list of performance counter data source configurations.
	PerformanceCounters *[]PerfCounterDataSource `json:"performanceCounters,omitempty"`
	// WindowsEventLogs - The list of Windows Event Log data source configurations.
	WindowsEventLogs *[]WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
	// Syslog - The list of Syslog data source configurations.
	Syslog *[]SyslogDataSource `json:"syslog,omitempty"`
	// Extensions - The list of Azure VM extension data source configurations.
	Extensions *[]ExtensionDataSource `json:"extensions,omitempty"`
	// LogFiles - The list of Log files source configurations.
	LogFiles *[]LogFilesDataSource `json:"logFiles,omitempty"`
	// IisLogs - The list of IIS logs source configurations.
	IisLogs *[]IisLogsDataSource `json:"iisLogs,omitempty"`
}

// DataCollectionRuleDestinations the specification of destinations.
type DataCollectionRuleDestinations struct {
	// LogAnalytics - List of Log Analytics destinations.
	LogAnalytics *[]LogAnalyticsDestination `json:"logAnalytics,omitempty"`
	// AzureMonitorMetrics - Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`
}

// DataCollectionRuleMetadata metadata about the resource
type DataCollectionRuleMetadata struct {
	// ProvisionedBy - READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleMetadata.
func (dcr DataCollectionRuleMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataCollectionRuleResource definition of ARM tracked top level resource.
type DataCollectionRuleResource struct {
	autorest.Response `json:"-"`
	// DataCollectionRuleResourceProperties - Resource properties.
	*DataCollectionRuleResourceProperties `json:"properties,omitempty"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Kind - The kind of the resource. Possible values include: 'KnownDataCollectionRuleResourceKindLinux', 'KnownDataCollectionRuleResourceKindWindows'
	Kind KnownDataCollectionRuleResourceKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionRuleResourceSystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleResource.
func (dcrr DataCollectionRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcrr.DataCollectionRuleResourceProperties != nil {
		objectMap["properties"] = dcrr.DataCollectionRuleResourceProperties
	}
	if dcrr.Location != nil {
		objectMap["location"] = dcrr.Location
	}
	if dcrr.Tags != nil {
		objectMap["tags"] = dcrr.Tags
	}
	if dcrr.Kind != "" {
		objectMap["kind"] = dcrr.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataCollectionRuleResource struct.
func (dcrr *DataCollectionRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataCollectionRuleResourceProperties DataCollectionRuleResourceProperties
				err = json.Unmarshal(*v, &dataCollectionRuleResourceProperties)
				if err != nil {
					return err
				}
				dcrr.DataCollectionRuleResourceProperties = &dataCollectionRuleResourceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcrr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcrr.Tags = tags
			}
		case "kind":
			if v != nil {
				var kind KnownDataCollectionRuleResourceKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dcrr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcrr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcrr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcrr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dcrr.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData DataCollectionRuleResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dcrr.SystemData = &systemData
			}
		}
	}

	return nil
}

// DataCollectionRuleResourceListResult a pageable list of resources.
type DataCollectionRuleResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of resources.
	Value *[]DataCollectionRuleResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataCollectionRuleResourceListResultIterator provides access to a complete listing of
// DataCollectionRuleResource values.
type DataCollectionRuleResourceListResultIterator struct {
	i    int
	page DataCollectionRuleResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataCollectionRuleResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataCollectionRuleResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataCollectionRuleResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataCollectionRuleResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataCollectionRuleResourceListResultIterator) Response() DataCollectionRuleResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataCollectionRuleResourceListResultIterator) Value() DataCollectionRuleResource {
	if !iter.page.NotDone() {
		return DataCollectionRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataCollectionRuleResourceListResultIterator type.
func NewDataCollectionRuleResourceListResultIterator(page DataCollectionRuleResourceListResultPage) DataCollectionRuleResourceListResultIterator {
	return DataCollectionRuleResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcrrlr DataCollectionRuleResourceListResult) IsEmpty() bool {
	return dcrrlr.Value == nil || len(*dcrrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcrrlr DataCollectionRuleResourceListResult) hasNextLink() bool {
	return dcrrlr.NextLink != nil && len(*dcrrlr.NextLink) != 0
}

// dataCollectionRuleResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcrrlr DataCollectionRuleResourceListResult) dataCollectionRuleResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dcrrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcrrlr.NextLink)))
}

// DataCollectionRuleResourceListResultPage contains a page of DataCollectionRuleResource values.
type DataCollectionRuleResourceListResultPage struct {
	fn     func(context.Context, DataCollectionRuleResourceListResult) (DataCollectionRuleResourceListResult, error)
	dcrrlr DataCollectionRuleResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataCollectionRuleResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataCollectionRuleResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcrrlr)
		if err != nil {
			return err
		}
		page.dcrrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataCollectionRuleResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataCollectionRuleResourceListResultPage) NotDone() bool {
	return !page.dcrrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataCollectionRuleResourceListResultPage) Response() DataCollectionRuleResourceListResult {
	return page.dcrrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataCollectionRuleResourceListResultPage) Values() []DataCollectionRuleResource {
	if page.dcrrlr.IsEmpty() {
		return nil
	}
	return *page.dcrrlr.Value
}

// Creates a new instance of the DataCollectionRuleResourceListResultPage type.
func NewDataCollectionRuleResourceListResultPage(cur DataCollectionRuleResourceListResult, getNextPage func(context.Context, DataCollectionRuleResourceListResult) (DataCollectionRuleResourceListResult, error)) DataCollectionRuleResourceListResultPage {
	return DataCollectionRuleResourceListResultPage{
		fn:     getNextPage,
		dcrrlr: cur,
	}
}

// DataCollectionRuleResourceProperties resource properties.
type DataCollectionRuleResourceProperties struct {
	// Description - Description of the data collection rule.
	Description *string `json:"description,omitempty"`
	// ImmutableID - READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that this rule can be used with.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleMetadata `json:"metadata,omitempty"`
	// StreamDeclarations - Declaration of custom streams used in this rule.
	StreamDeclarations map[string]*StreamDeclaration `json:"streamDeclarations"`
	// DataSources - The specification of data sources.
	// This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
	DataSources *DataCollectionRuleDataSources `json:"dataSources,omitempty"`
	// Destinations - The specification of destinations.
	Destinations *DataCollectionRuleDestinations `json:"destinations,omitempty"`
	// DataFlows - The specification of data flows.
	DataFlows *[]DataFlow `json:"dataFlows,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleProvisioningStateCreating', 'KnownDataCollectionRuleProvisioningStateUpdating', 'KnownDataCollectionRuleProvisioningStateDeleting', 'KnownDataCollectionRuleProvisioningStateSucceeded', 'KnownDataCollectionRuleProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DataCollectionRuleResourceProperties.
func (dcrr DataCollectionRuleResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcrr.Description != nil {
		objectMap["description"] = dcrr.Description
	}
	if dcrr.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = dcrr.DataCollectionEndpointID
	}
	if dcrr.StreamDeclarations != nil {
		objectMap["streamDeclarations"] = dcrr.StreamDeclarations
	}
	if dcrr.DataSources != nil {
		objectMap["dataSources"] = dcrr.DataSources
	}
	if dcrr.Destinations != nil {
		objectMap["destinations"] = dcrr.Destinations
	}
	if dcrr.DataFlows != nil {
		objectMap["dataFlows"] = dcrr.DataFlows
	}
	return json.Marshal(objectMap)
}

// DataCollectionRuleResourceSystemData metadata pertaining to creation and last modification of the
// resource.
type DataCollectionRuleResourceSystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// DataContainer information about a container with data for a given resource.
type DataContainer struct {
	// Workspace - Log Analytics workspace information.
	Workspace *WorkspaceInfo `json:"workspace,omitempty"`
}

// DataFlow definition of which streams are sent to which destinations.
type DataFlow struct {
	// Streams - List of streams for this data flow.
	Streams *[]KnownDataFlowStreams `json:"streams,omitempty"`
	// Destinations - List of destinations for this data flow.
	Destinations *[]string `json:"destinations,omitempty"`
	// TransformKql - The KQL query to transform stream data.
	TransformKql *string `json:"transformKql,omitempty"`
	// OutputStream - The output stream of the transform. Only required if the transform changes data to a different stream.
	OutputStream *string `json:"outputStream,omitempty"`
}

// DataSourcesSpec specification of data sources that will be collected.
type DataSourcesSpec struct {
	// PerformanceCounters - The list of performance counter data source configurations.
	PerformanceCounters *[]PerfCounterDataSource `json:"performanceCounters,omitempty"`
	// WindowsEventLogs - The list of Windows Event Log data source configurations.
	WindowsEventLogs *[]WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
	// Syslog - The list of Syslog data source configurations.
	Syslog *[]SyslogDataSource `json:"syslog,omitempty"`
	// Extensions - The list of Azure VM extension data source configurations.
	Extensions *[]ExtensionDataSource `json:"extensions,omitempty"`
	// LogFiles - The list of Log files source configurations.
	LogFiles *[]LogFilesDataSource `json:"logFiles,omitempty"`
	// IisLogs - The list of IIS logs source configurations.
	IisLogs *[]IisLogsDataSource `json:"iisLogs,omitempty"`
}

// DestinationsSpec specification of destinations that can be used in data flows.
type DestinationsSpec struct {
	// LogAnalytics - List of Log Analytics destinations.
	LogAnalytics *[]LogAnalyticsDestination `json:"logAnalytics,omitempty"`
	// AzureMonitorMetrics - Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`
}

// DestinationsSpecAzureMonitorMetrics azure Monitor Metrics destination.
type DestinationsSpecAzureMonitorMetrics struct {
	// Name - A friendly name for the destination.
	// This name should be unique across all destinations (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// DiagnosticSettings the diagnostic settings.
type DiagnosticSettings struct {
	// StorageAccountID - The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// EventHubAuthorizationRuleID - The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`
	// EventHubName - The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`
	// Metrics - The list of metric settings.
	Metrics *[]MetricSettings `json:"metrics,omitempty"`
	// Logs - The list of logs settings.
	Logs *[]LogSettings `json:"logs,omitempty"`
	// WorkspaceID - The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// LogAnalyticsDestinationType - A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: <normalized service identity>_<normalized category name>. Possible values are: Dedicated and null (null is default.)
	LogAnalyticsDestinationType *string `json:"logAnalyticsDestinationType,omitempty"`
}

// DiagnosticSettingsCategory the diagnostic settings Category.
type DiagnosticSettingsCategory struct {
	// CategoryType - The type of the diagnostic settings category. Possible values include: 'Metrics', 'Logs'
	CategoryType CategoryType `json:"categoryType,omitempty"`
}

// DiagnosticSettingsCategoryResource the diagnostic settings category resource.
type DiagnosticSettingsCategoryResource struct {
	autorest.Response `json:"-"`
	// DiagnosticSettingsCategory - The properties of a Diagnostic Settings Category.
	*DiagnosticSettingsCategory `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticSettingsCategoryResource.
func (dscr DiagnosticSettingsCategoryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dscr.DiagnosticSettingsCategory != nil {
		objectMap["properties"] = dscr.DiagnosticSettingsCategory
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticSettingsCategoryResource struct.
func (dscr *DiagnosticSettingsCategoryResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticSettingsCategory DiagnosticSettingsCategory
				err = json.Unmarshal(*v, &diagnosticSettingsCategory)
				if err != nil {
					return err
				}
				dscr.DiagnosticSettingsCategory = &diagnosticSettingsCategory
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dscr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dscr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dscr.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticSettingsCategoryResourceCollection represents a collection of diagnostic setting category
// resources.
type DiagnosticSettingsCategoryResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of diagnostic settings category resources.
	Value *[]DiagnosticSettingsCategoryResource `json:"value,omitempty"`
}

// DiagnosticSettingsResource the diagnostic setting resource.
type DiagnosticSettingsResource struct {
	autorest.Response `json:"-"`
	// DiagnosticSettings - Properties of a Diagnostic Settings Resource.
	*DiagnosticSettings `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticSettingsResource.
func (dsr DiagnosticSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsr.DiagnosticSettings != nil {
		objectMap["properties"] = dsr.DiagnosticSettings
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticSettingsResource struct.
func (dsr *DiagnosticSettingsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticSettings DiagnosticSettings
				err = json.Unmarshal(*v, &diagnosticSettings)
				if err != nil {
					return err
				}
				dsr.DiagnosticSettings = &diagnosticSettings
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsr.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticSettingsResourceCollection represents a collection of alert rule resources.
type DiagnosticSettingsResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of diagnostic settings resources;.
	Value *[]DiagnosticSettingsResource `json:"value,omitempty"`
}

// Dimension dimension splitting and filtering definition
type Dimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// Operator - Operator for dimension values. Possible values include: 'Include', 'Exclude'
	Operator DimensionOperator `json:"operator,omitempty"`
	// Values - List of dimension values
	Values *[]string `json:"values,omitempty"`
}

// DynamicMetricCriteria criterion for dynamic threshold.
type DynamicMetricCriteria struct {
	// Operator - The operator used to compare the metric value against the threshold. Possible values include: 'DynamicThresholdOperatorGreaterThan', 'DynamicThresholdOperatorLessThan', 'DynamicThresholdOperatorGreaterOrLessThan'
	Operator DynamicThresholdOperator `json:"operator,omitempty"`
	// AlertSensitivity - The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern. Possible values include: 'DynamicThresholdSensitivityLow', 'DynamicThresholdSensitivityMedium', 'DynamicThresholdSensitivityHigh'
	AlertSensitivity DynamicThresholdSensitivity `json:"alertSensitivity,omitempty"`
	// FailingPeriods - The minimum number of violations required within the selected lookback time window required to raise an alert.
	FailingPeriods *DynamicThresholdFailingPeriods `json:"failingPeriods,omitempty"`
	// IgnoreDataBefore - Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
	IgnoreDataBefore *date.Time `json:"ignoreDataBefore,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Name of the criteria.
	Name *string `json:"name,omitempty"`
	// MetricName - Name of the metric.
	MetricName *string `json:"metricName,omitempty"`
	// MetricNamespace - Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// TimeAggregation - the criteria time aggregation types. Possible values include: 'AggregationTypeEnumAverage', 'AggregationTypeEnumCount', 'AggregationTypeEnumMinimum', 'AggregationTypeEnumMaximum', 'AggregationTypeEnumTotal'
	TimeAggregation AggregationTypeEnum `json:"timeAggregation,omitempty"`
	// Dimensions - List of dimension conditions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// SkipMetricValidation - Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
	// CriterionType - Possible values include: 'CriterionTypeMultiMetricCriteria', 'CriterionTypeStaticThresholdCriterion', 'CriterionTypeDynamicThresholdCriterion'
	CriterionType CriterionType `json:"criterionType,omitempty"`
}

// MarshalJSON is the custom marshaler for DynamicMetricCriteria.
func (dmc DynamicMetricCriteria) MarshalJSON() ([]byte, error) {
	dmc.CriterionType = CriterionTypeDynamicThresholdCriterion
	objectMap := make(map[string]interface{})
	if dmc.Operator != "" {
		objectMap["operator"] = dmc.Operator
	}
	if dmc.AlertSensitivity != "" {
		objectMap["alertSensitivity"] = dmc.AlertSensitivity
	}
	if dmc.FailingPeriods != nil {
		objectMap["failingPeriods"] = dmc.FailingPeriods
	}
	if dmc.IgnoreDataBefore != nil {
		objectMap["ignoreDataBefore"] = dmc.IgnoreDataBefore
	}
	if dmc.Name != nil {
		objectMap["name"] = dmc.Name
	}
	if dmc.MetricName != nil {
		objectMap["metricName"] = dmc.MetricName
	}
	if dmc.MetricNamespace != nil {
		objectMap["metricNamespace"] = dmc.MetricNamespace
	}
	if dmc.TimeAggregation != "" {
		objectMap["timeAggregation"] = dmc.TimeAggregation
	}
	if dmc.Dimensions != nil {
		objectMap["dimensions"] = dmc.Dimensions
	}
	if dmc.SkipMetricValidation != nil {
		objectMap["skipMetricValidation"] = dmc.SkipMetricValidation
	}
	if dmc.CriterionType != "" {
		objectMap["criterionType"] = dmc.CriterionType
	}
	for k, v := range dmc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricCriteria is the BasicMultiMetricCriteria implementation for DynamicMetricCriteria.
func (dmc DynamicMetricCriteria) AsMetricCriteria() (*MetricCriteria, bool) {
	return nil, false
}

// AsDynamicMetricCriteria is the BasicMultiMetricCriteria implementation for DynamicMetricCriteria.
func (dmc DynamicMetricCriteria) AsDynamicMetricCriteria() (*DynamicMetricCriteria, bool) {
	return &dmc, true
}

// AsMultiMetricCriteria is the BasicMultiMetricCriteria implementation for DynamicMetricCriteria.
func (dmc DynamicMetricCriteria) AsMultiMetricCriteria() (*MultiMetricCriteria, bool) {
	return nil, false
}

// AsBasicMultiMetricCriteria is the BasicMultiMetricCriteria implementation for DynamicMetricCriteria.
func (dmc DynamicMetricCriteria) AsBasicMultiMetricCriteria() (BasicMultiMetricCriteria, bool) {
	return &dmc, true
}

// UnmarshalJSON is the custom unmarshaler for DynamicMetricCriteria struct.
func (dmc *DynamicMetricCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "operator":
			if v != nil {
				var operator DynamicThresholdOperator
				err = json.Unmarshal(*v, &operator)
				if err != nil {
					return err
				}
				dmc.Operator = operator
			}
		case "alertSensitivity":
			if v != nil {
				var alertSensitivity DynamicThresholdSensitivity
				err = json.Unmarshal(*v, &alertSensitivity)
				if err != nil {
					return err
				}
				dmc.AlertSensitivity = alertSensitivity
			}
		case "failingPeriods":
			if v != nil {
				var failingPeriods DynamicThresholdFailingPeriods
				err = json.Unmarshal(*v, &failingPeriods)
				if err != nil {
					return err
				}
				dmc.FailingPeriods = &failingPeriods
			}
		case "ignoreDataBefore":
			if v != nil {
				var ignoreDataBefore date.Time
				err = json.Unmarshal(*v, &ignoreDataBefore)
				if err != nil {
					return err
				}
				dmc.IgnoreDataBefore = &ignoreDataBefore
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if dmc.AdditionalProperties == nil {
					dmc.AdditionalProperties = make(map[string]interface{})
				}
				dmc.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmc.Name = &name
			}
		case "metricName":
			if v != nil {
				var metricName string
				err = json.Unmarshal(*v, &metricName)
				if err != nil {
					return err
				}
				dmc.MetricName = &metricName
			}
		case "metricNamespace":
			if v != nil {
				var metricNamespace string
				err = json.Unmarshal(*v, &metricNamespace)
				if err != nil {
					return err
				}
				dmc.MetricNamespace = &metricNamespace
			}
		case "timeAggregation":
			if v != nil {
				var timeAggregation AggregationTypeEnum
				err = json.Unmarshal(*v, &timeAggregation)
				if err != nil {
					return err
				}
				dmc.TimeAggregation = timeAggregation
			}
		case "dimensions":
			if v != nil {
				var dimensions []MetricDimension
				err = json.Unmarshal(*v, &dimensions)
				if err != nil {
					return err
				}
				dmc.Dimensions = &dimensions
			}
		case "skipMetricValidation":
			if v != nil {
				var skipMetricValidation bool
				err = json.Unmarshal(*v, &skipMetricValidation)
				if err != nil {
					return err
				}
				dmc.SkipMetricValidation = &skipMetricValidation
			}
		case "criterionType":
			if v != nil {
				var criterionType CriterionType
				err = json.Unmarshal(*v, &criterionType)
				if err != nil {
					return err
				}
				dmc.CriterionType = criterionType
			}
		}
	}

	return nil
}

// DynamicThresholdFailingPeriods the minimum number of violations required within the selected lookback
// time window required to raise an alert.
type DynamicThresholdFailingPeriods struct {
	// NumberOfEvaluationPeriods - The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
	NumberOfEvaluationPeriods *float64 `json:"numberOfEvaluationPeriods,omitempty"`
	// MinFailingPeriodsToAlert - The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
	MinFailingPeriodsToAlert *float64 `json:"minFailingPeriodsToAlert,omitempty"`
}

// EmailNotification email notification of an autoscale event.
type EmailNotification struct {
	// SendToSubscriptionAdministrator - a value indicating whether to send email to subscription administrator.
	SendToSubscriptionAdministrator *bool `json:"sendToSubscriptionAdministrator,omitempty"`
	// SendToSubscriptionCoAdministrators - a value indicating whether to send email to subscription co-administrators.
	SendToSubscriptionCoAdministrators *bool `json:"sendToSubscriptionCoAdministrators,omitempty"`
	// CustomEmails - the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
	CustomEmails *[]string `json:"customEmails,omitempty"`
}

// EmailReceiver an email receiver.
type EmailReceiver struct {
	// Name - The name of the email receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EmailAddress - The email address of this receiver.
	EmailAddress *string `json:"emailAddress,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
	// Status - READ-ONLY; The receiver status of the e-mail. Possible values include: 'ReceiverStatusNotSpecified', 'ReceiverStatusEnabled', 'ReceiverStatusDisabled'
	Status ReceiverStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailReceiver.
func (er EmailReceiver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.Name != nil {
		objectMap["name"] = er.Name
	}
	if er.EmailAddress != nil {
		objectMap["emailAddress"] = er.EmailAddress
	}
	if er.UseCommonAlertSchema != nil {
		objectMap["useCommonAlertSchema"] = er.UseCommonAlertSchema
	}
	return json.Marshal(objectMap)
}

// EnableRequest describes a receiver that should be resubscribed.
type EnableRequest struct {
	// ReceiverName - The name of the receiver to resubscribe.
	ReceiverName *string `json:"receiverName,omitempty"`
}

// Error error details.
type Error struct {
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - Error message in the caller's locale.
	Message *string `json:"message,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorContract describes the format of Error response.
type ErrorContract struct {
	// Error - The error details.
	Error *ErrorResponseDetails `json:"error,omitempty"`
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponseAdditionalInfo the resource management error additional info.
type ErrorResponseAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseAdditionalInfo.
func (erai ErrorResponseAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponseCommon the resource management error response.
type ErrorResponseCommon struct {
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponseCommon `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseCommon.
func (erc ErrorResponseCommon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Code != nil {
		objectMap["code"] = erc.Code
	}
	if erc.Message != nil {
		objectMap["message"] = erc.Message
	}
	return json.Marshal(objectMap)
}

// ErrorResponseCommonV2 common error response for all Azure Resource Manager APIs to return error details
// for failed operations. (This also follows the OData error response format.).
type ErrorResponseCommonV2 struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ErrorResponseDetails common error response for all Azure Resource Manager APIs to return error details
// for failed operations. (This also follows the OData error response format.)
type ErrorResponseDetails struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponseDetails `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorResponseAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseDetails.
func (erd ErrorResponseDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventCategoryCollection a collection of event categories. Currently possible values are: Administrative,
// Security, ServiceHealth, Alert, Recommendation, Policy.
type EventCategoryCollection struct {
	autorest.Response `json:"-"`
	// Value - the list that includes the Azure event categories.
	Value *[]LocalizableString `json:"value,omitempty"`
}

// EventData the Azure event log entries are of type EventData
type EventData struct {
	// Authorization - READ-ONLY; The sender authorization information.
	Authorization *SenderAuthorization `json:"authorization,omitempty"`
	// Claims - READ-ONLY; key value pairs to identify ARM permissions.
	Claims map[string]*string `json:"claims"`
	// Caller - READ-ONLY; the email address of the user who has performed the operation, the UPN claim or SPN claim based on availability.
	Caller *string `json:"caller,omitempty"`
	// Description - READ-ONLY; the description of the event.
	Description *string `json:"description,omitempty"`
	// ID - READ-ONLY; the Id of this event as required by ARM for RBAC. It contains the EventDataID and a timestamp information.
	ID *string `json:"id,omitempty"`
	// EventDataID - READ-ONLY; the event data Id. This is a unique identifier for an event.
	EventDataID *string `json:"eventDataId,omitempty"`
	// CorrelationID - READ-ONLY; the correlation Id, usually a GUID in the string format. The correlation Id is shared among the events that belong to the same uber operation.
	CorrelationID *string `json:"correlationId,omitempty"`
	// EventName - READ-ONLY; the event name. This value should not be confused with OperationName. For practical purposes, OperationName might be more appealing to end users.
	EventName *LocalizableString `json:"eventName,omitempty"`
	// Category - READ-ONLY; the event category.
	Category *LocalizableString `json:"category,omitempty"`
	// HTTPRequest - READ-ONLY; the HTTP request info. Usually includes the 'clientRequestId', 'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method e.g. PUT).
	HTTPRequest *HTTPRequestInfo `json:"httpRequest,omitempty"`
	// Level - READ-ONLY; the event level. Possible values include: 'EventLevelCritical', 'EventLevelError', 'EventLevelWarning', 'EventLevelInformational', 'EventLevelVerbose'
	Level EventLevel `json:"level,omitempty"`
	// ResourceGroupName - READ-ONLY; the resource group name of the impacted resource.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceProviderName - READ-ONLY; the resource provider name of the impacted resource.
	ResourceProviderName *LocalizableString `json:"resourceProviderName,omitempty"`
	// ResourceID - READ-ONLY; the resource uri that uniquely identifies the resource that caused this event.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceType - READ-ONLY; the resource type
	ResourceType *LocalizableString `json:"resourceType,omitempty"`
	// OperationID - READ-ONLY; It is usually a GUID shared among the events corresponding to single operation. This value should not be confused with EventName.
	OperationID *string `json:"operationId,omitempty"`
	// OperationName - READ-ONLY; the operation name.
	OperationName *LocalizableString `json:"operationName,omitempty"`
	// Properties - READ-ONLY; the set of <Key, Value> pairs (usually a Dictionary<String, String>) that includes details about the event.
	Properties map[string]*string `json:"properties"`
	// Status - READ-ONLY; a string describing the status of the operation. Some typical values are: Started, In progress, Succeeded, Failed, Resolved.
	Status *LocalizableString `json:"status,omitempty"`
	// SubStatus - READ-ONLY; the event sub status. Most of the time, when included, this captures the HTTP status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code: 409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504)
	SubStatus *LocalizableString `json:"subStatus,omitempty"`
	// EventTimestamp - READ-ONLY; the timestamp of when the event was generated by the Azure service processing the request corresponding the event. It in ISO 8601 format.
	EventTimestamp *date.Time `json:"eventTimestamp,omitempty"`
	// SubmissionTimestamp - READ-ONLY; the timestamp of when the event became available for querying via this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there might be a delay between the occurrence time of the event, and the time that the event is submitted to the Azure logging infrastructure.
	SubmissionTimestamp *date.Time `json:"submissionTimestamp,omitempty"`
	// SubscriptionID - READ-ONLY; the Azure subscription Id usually a GUID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// TenantID - READ-ONLY; the Azure tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for EventData.
func (ed EventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventDataCollection represents collection of events.
type EventDataCollection struct {
	autorest.Response `json:"-"`
	// Value - this list that includes the Azure audit logs.
	Value *[]EventData `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventDataCollectionIterator provides access to a complete listing of EventData values.
type EventDataCollectionIterator struct {
	i    int
	page EventDataCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventDataCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventDataCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventDataCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventDataCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventDataCollectionIterator) Response() EventDataCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventDataCollectionIterator) Value() EventData {
	if !iter.page.NotDone() {
		return EventData{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventDataCollectionIterator type.
func NewEventDataCollectionIterator(page EventDataCollectionPage) EventDataCollectionIterator {
	return EventDataCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (edc EventDataCollection) IsEmpty() bool {
	return edc.Value == nil || len(*edc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (edc EventDataCollection) hasNextLink() bool {
	return edc.NextLink != nil && len(*edc.NextLink) != 0
}

// eventDataCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (edc EventDataCollection) eventDataCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !edc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(edc.NextLink)))
}

// EventDataCollectionPage contains a page of EventData values.
type EventDataCollectionPage struct {
	fn  func(context.Context, EventDataCollection) (EventDataCollection, error)
	edc EventDataCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventDataCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventDataCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.edc)
		if err != nil {
			return err
		}
		page.edc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventDataCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventDataCollectionPage) NotDone() bool {
	return !page.edc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventDataCollectionPage) Response() EventDataCollection {
	return page.edc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventDataCollectionPage) Values() []EventData {
	if page.edc.IsEmpty() {
		return nil
	}
	return *page.edc.Value
}

// Creates a new instance of the EventDataCollectionPage type.
func NewEventDataCollectionPage(cur EventDataCollection, getNextPage func(context.Context, EventDataCollection) (EventDataCollection, error)) EventDataCollectionPage {
	return EventDataCollectionPage{
		fn:  getNextPage,
		edc: cur,
	}
}

// EventHubReceiver an Event hub receiver.
type EventHubReceiver struct {
	// Name - The name of the Event hub receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EventHubNameSpace - The Event Hub namespace
	EventHubNameSpace *string `json:"eventHubNameSpace,omitempty"`
	// EventHubName - The name of the specific Event Hub queue
	EventHubName *string `json:"eventHubName,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
	// TenantID - The tenant Id for the subscription containing this event hub
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The Id for the subscription containing this event hub
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// ExtensionDataSource definition of which data will be collected from a separate VM extension that
// integrates with the Azure Monitor Agent.
// Collected from either Windows and Linux machines, depending on which extension is defined.
type ExtensionDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownExtensionDataSourceStreams `json:"streams,omitempty"`
	// ExtensionName - The name of the VM extension.
	ExtensionName *string `json:"extensionName,omitempty"`
	// ExtensionSettings - The extension settings. The format is specific for particular extension.
	ExtensionSettings interface{} `json:"extensionSettings,omitempty"`
	// InputDataSources - The list of data sources this extension needs data from.
	InputDataSources *[]string `json:"inputDataSources,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// HTTPRequestInfo the Http request info.
type HTTPRequestInfo struct {
	// ClientRequestID - the client request id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// ClientIPAddress - the client Ip Address
	ClientIPAddress *string `json:"clientIpAddress,omitempty"`
	// Method - the Http request method.
	Method *string `json:"method,omitempty"`
	// URI - the Uri.
	URI *string `json:"uri,omitempty"`
}

// IisLogsDataSource enables IIS logs to be collected by this data collection rule.
type IisLogsDataSource struct {
	// Streams - IIS streams
	Streams *[]string `json:"streams,omitempty"`
	// LogDirectories - Absolute paths file location
	LogDirectories *[]string `json:"logDirectories,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// Incident an alert incident indicates the activation status of an alert rule.
type Incident struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Incident name.
	Name *string `json:"name,omitempty"`
	// RuleName - READ-ONLY; Rule name that is associated with the incident.
	RuleName *string `json:"ruleName,omitempty"`
	// IsActive - READ-ONLY; A boolean to indicate whether the incident is active or resolved.
	IsActive *bool `json:"isActive,omitempty"`
	// ActivatedTime - READ-ONLY; The time at which the incident was activated in ISO8601 format.
	ActivatedTime *date.Time `json:"activatedTime,omitempty"`
	// ResolvedTime - READ-ONLY; The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active.
	ResolvedTime *date.Time `json:"resolvedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IncidentListResult the List incidents operation response.
type IncidentListResult struct {
	autorest.Response `json:"-"`
	// Value - the incident collection.
	Value *[]Incident `json:"value,omitempty"`
}

// ItsmReceiver an Itsm receiver.
type ItsmReceiver struct {
	// Name - The name of the Itsm receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// WorkspaceID - OMS LA instance identifier.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// ConnectionID - Unique identification of ITSM connection among multiple defined in above workspace.
	ConnectionID *string `json:"connectionId,omitempty"`
	// TicketConfiguration - JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
	TicketConfiguration *string `json:"ticketConfiguration,omitempty"`
	// Region - Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
	Region *string `json:"region,omitempty"`
}

// LocalizableString the localizable string class.
type LocalizableString struct {
	// Value - the invariant value.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// LocationThresholdRuleCondition a rule condition based on a certain number of locations failing.
type LocationThresholdRuleCondition struct {
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
	// FailedLocationCount - the number of locations that must fail to activate the alert.
	FailedLocationCount *int32 `json:"failedLocationCount,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	ltrc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition
	objectMap := make(map[string]interface{})
	if ltrc.WindowSize != nil {
		objectMap["windowSize"] = ltrc.WindowSize
	}
	if ltrc.FailedLocationCount != nil {
		objectMap["failedLocationCount"] = ltrc.FailedLocationCount
	}
	objectMap["dataSource"] = ltrc.DataSource
	if ltrc.OdataType != "" {
		objectMap["odata.type"] = ltrc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return &ltrc, true
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &ltrc, true
}

// UnmarshalJSON is the custom unmarshaler for LocationThresholdRuleCondition struct.
func (ltrc *LocationThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				ltrc.WindowSize = &windowSize
			}
		case "failedLocationCount":
			if v != nil {
				var failedLocationCount int32
				err = json.Unmarshal(*v, &failedLocationCount)
				if err != nil {
					return err
				}
				ltrc.FailedLocationCount = &failedLocationCount
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				ltrc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ltrc.OdataType = odataType
			}
		}
	}

	return nil
}

// LogAnalyticsDestination log Analytics destination.
type LogAnalyticsDestination struct {
	// WorkspaceResourceID - The resource ID of the Log Analytics workspace.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
	// WorkspaceID - READ-ONLY; The Customer ID of the Log Analytics workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Name - A friendly name for the destination.
	// This name should be unique across all destinations (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsDestination.
func (lad LogAnalyticsDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lad.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = lad.WorkspaceResourceID
	}
	if lad.Name != nil {
		objectMap["name"] = lad.Name
	}
	return json.Marshal(objectMap)
}

// LogFilesDataSource definition of which custom log files will be collected by this data collection rule
type LogFilesDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data source
	Streams *[]string `json:"streams,omitempty"`
	// FilePatterns - File Patterns where the log files are located
	FilePatterns *[]string `json:"filePatterns,omitempty"`
	// Format - The data format of the log files
	Format *string `json:"format,omitempty"`
	// Settings - The log files specific settings.
	Settings *LogFilesDataSourceSettings `json:"settings,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// LogFilesDataSourceSettings the log files specific settings.
type LogFilesDataSourceSettings struct {
	// Text - Text settings
	Text *LogFileSettingsText `json:"text,omitempty"`
}

// LogFileSettings settings for different log file formats
type LogFileSettings struct {
	// Text - Text settings
	Text *LogFileSettingsText `json:"text,omitempty"`
}

// LogFileSettingsText text settings
type LogFileSettingsText struct {
	// RecordStartTimestampFormat - One of the supported timestamp formats. Possible values include: 'ISO8601', 'YYYYMMDDHHMMSS', 'MDYYYYHHMMSSAMPM', 'MonDDYYYYHHMMSS', 'YyMMddHHmmss', 'DdMMyyHHmmss', 'MMMdhhmmss', 'DdMMMyyyyHHmmsszzz', 'YyyyMMDdTHHmmssK'
	RecordStartTimestampFormat KnownLogFileTextSettingsRecordStartTimestampFormat `json:"recordStartTimestampFormat,omitempty"`
}

// LogFileTextSettings settings for text log files
type LogFileTextSettings struct {
	// RecordStartTimestampFormat - One of the supported timestamp formats. Possible values include: 'ISO8601', 'YYYYMMDDHHMMSS', 'MDYYYYHHMMSSAMPM', 'MonDDYYYYHHMMSS', 'YyMMddHHmmss', 'DdMMyyHHmmss', 'MMMdhhmmss', 'DdMMMyyyyHHmmsszzz', 'YyyyMMDdTHHmmssK'
	RecordStartTimestampFormat KnownLogFileTextSettingsRecordStartTimestampFormat `json:"recordStartTimestampFormat,omitempty"`
}

// LogicAppReceiver a logic app receiver.
type LogicAppReceiver struct {
	// Name - The name of the logic app receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// ResourceID - The azure resource id of the logic app receiver.
	ResourceID *string `json:"resourceId,omitempty"`
	// CallbackURL - The callback url where http request sent to.
	CallbackURL *string `json:"callbackUrl,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// LogProfileCollection represents a collection of log profiles.
type LogProfileCollection struct {
	autorest.Response `json:"-"`
	// Value - the values of the log profiles.
	Value *[]LogProfileResource `json:"value,omitempty"`
}

// LogProfileProperties the log profile properties.
type LogProfileProperties struct {
	// StorageAccountID - the resource id of the storage account to which you would like to send the Activity Log.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// Locations - List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
	Locations *[]string `json:"locations,omitempty"`
	// Categories - the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
	Categories *[]string `json:"categories,omitempty"`
	// RetentionPolicy - the retention policy for the events in the log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogProfileResource the log profile resource.
type LogProfileResource struct {
	autorest.Response `json:"-"`
	// LogProfileProperties - The log profile properties of the resource.
	*LogProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogProfileResource.
func (lpr LogProfileResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpr.LogProfileProperties != nil {
		objectMap["properties"] = lpr.LogProfileProperties
	}
	if lpr.Location != nil {
		objectMap["location"] = lpr.Location
	}
	if lpr.Tags != nil {
		objectMap["tags"] = lpr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogProfileResource struct.
func (lpr *LogProfileResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logProfileProperties LogProfileProperties
				err = json.Unmarshal(*v, &logProfileProperties)
				if err != nil {
					return err
				}
				lpr.LogProfileProperties = &logProfileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lpr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lpr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lpr.Tags = tags
			}
		}
	}

	return nil
}

// LogProfileResourcePatch the log profile resource for patch operations.
type LogProfileResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// LogProfileProperties - The log profile properties for an update operation.
	*LogProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LogProfileResourcePatch.
func (lprp LogProfileResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lprp.Tags != nil {
		objectMap["tags"] = lprp.Tags
	}
	if lprp.LogProfileProperties != nil {
		objectMap["properties"] = lprp.LogProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogProfileResourcePatch struct.
func (lprp *LogProfileResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lprp.Tags = tags
			}
		case "properties":
			if v != nil {
				var logProfileProperties LogProfileProperties
				err = json.Unmarshal(*v, &logProfileProperties)
				if err != nil {
					return err
				}
				lprp.LogProfileProperties = &logProfileProperties
			}
		}
	}

	return nil
}

// LogSettings part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	// Category - Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`
	// Enabled - a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - the retention policy for this log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogsIngestionEndpointSpec definition of the endpoint used for ingesting logs.
type LogsIngestionEndpointSpec struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for LogsIngestionEndpointSpec.
func (lies LogsIngestionEndpointSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagementEventAggregationCondition how the data that is collected should be combined over time.
type ManagementEventAggregationCondition struct {
	// Operator - the condition operator. Possible values include: 'ConditionOperatorGreaterThan', 'ConditionOperatorGreaterThanOrEqual', 'ConditionOperatorLessThan', 'ConditionOperatorLessThanOrEqual'
	Operator ConditionOperator `json:"operator,omitempty"`
	// Threshold - The threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// ManagementEventRuleCondition a management event rule condition.
type ManagementEventRuleCondition struct {
	// Aggregation - How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
	Aggregation *ManagementEventAggregationCondition `json:"aggregation,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) MarshalJSON() ([]byte, error) {
	merc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition
	objectMap := make(map[string]interface{})
	if merc.Aggregation != nil {
		objectMap["aggregation"] = merc.Aggregation
	}
	objectMap["dataSource"] = merc.DataSource
	if merc.OdataType != "" {
		objectMap["odata.type"] = merc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return &merc, true
}

// AsRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &merc, true
}

// UnmarshalJSON is the custom unmarshaler for ManagementEventRuleCondition struct.
func (merc *ManagementEventRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "aggregation":
			if v != nil {
				var aggregation ManagementEventAggregationCondition
				err = json.Unmarshal(*v, &aggregation)
				if err != nil {
					return err
				}
				merc.Aggregation = &aggregation
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				merc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				merc.OdataType = odataType
			}
		}
	}

	return nil
}

// Metadata metadata about the resource
type Metadata struct {
	// ProvisionedBy - READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for Metadata.
func (mVar Metadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetadataValue represents a metric metadata value.
type MetadataValue struct {
	// Name - the name of the metadata.
	Name *LocalizableString `json:"name,omitempty"`
	// Value - the value of the metadata.
	Value *string `json:"value,omitempty"`
}

// Metric the result data of a query.
type Metric struct {
	// ID - the metric Id.
	ID *string `json:"id,omitempty"`
	// Type - the resource type of the metric resource.
	Type *string `json:"type,omitempty"`
	// Name - the name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString `json:"name,omitempty"`
	// DisplayDescription - Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// ErrorCode - 'Success' or the error details on query failures for this metric.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Error message encountered querying this specific metric.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'MetricUnitCount', 'MetricUnitBytes', 'MetricUnitSeconds', 'MetricUnitCountPerSecond', 'MetricUnitBytesPerSecond', 'MetricUnitPercent', 'MetricUnitMilliSeconds', 'MetricUnitByteSeconds', 'MetricUnitUnspecified', 'MetricUnitCores', 'MetricUnitMilliCores', 'MetricUnitNanoCores', 'MetricUnitBitsPerSecond'
	Unit MetricUnit `json:"unit,omitempty"`
	// Timeseries - the time series returned when a data query is performed.
	Timeseries *[]TimeSeriesElement `json:"timeseries,omitempty"`
}

// MetricAlertAction an alert action.
type MetricAlertAction struct {
	// ActionGroupID - the id of the action group to use.
	ActionGroupID *string `json:"actionGroupId,omitempty"`
	// WebHookProperties - This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
	WebHookProperties map[string]*string `json:"webHookProperties"`
}

// MarshalJSON is the custom marshaler for MetricAlertAction.
func (maa MetricAlertAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if maa.ActionGroupID != nil {
		objectMap["actionGroupId"] = maa.ActionGroupID
	}
	if maa.WebHookProperties != nil {
		objectMap["webHookProperties"] = maa.WebHookProperties
	}
	return json.Marshal(objectMap)
}

// BasicMetricAlertCriteria the rule criteria that defines the conditions of the alert rule.
type BasicMetricAlertCriteria interface {
	AsMetricAlertSingleResourceMultipleMetricCriteria() (*MetricAlertSingleResourceMultipleMetricCriteria, bool)
	AsWebtestLocationAvailabilityCriteria() (*WebtestLocationAvailabilityCriteria, bool)
	AsMetricAlertMultipleResourceMultipleMetricCriteria() (*MetricAlertMultipleResourceMultipleMetricCriteria, bool)
	AsMetricAlertCriteria() (*MetricAlertCriteria, bool)
}

// MetricAlertCriteria the rule criteria that defines the conditions of the alert rule.
type MetricAlertCriteria struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// OdataType - Possible values include: 'OdataTypeMetricAlertCriteria', 'OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria', 'OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria', 'OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria'
	OdataType OdataTypeBasicMetricAlertCriteria `json:"odata.type,omitempty"`
}

func unmarshalBasicMetricAlertCriteria(body []byte) (BasicMetricAlertCriteria, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria):
		var masrmmc MetricAlertSingleResourceMultipleMetricCriteria
		err := json.Unmarshal(body, &masrmmc)
		return masrmmc, err
	case string(OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria):
		var wlac WebtestLocationAvailabilityCriteria
		err := json.Unmarshal(body, &wlac)
		return wlac, err
	case string(OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria):
		var mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria
		err := json.Unmarshal(body, &mamrmmc)
		return mamrmmc, err
	default:
		var mac MetricAlertCriteria
		err := json.Unmarshal(body, &mac)
		return mac, err
	}
}
func unmarshalBasicMetricAlertCriteriaArray(body []byte) ([]BasicMetricAlertCriteria, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	macArray := make([]BasicMetricAlertCriteria, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mac, err := unmarshalBasicMetricAlertCriteria(*rawMessage)
		if err != nil {
			return nil, err
		}
		macArray[index] = mac
	}
	return macArray, nil
}

// MarshalJSON is the custom marshaler for MetricAlertCriteria.
func (mac MetricAlertCriteria) MarshalJSON() ([]byte, error) {
	mac.OdataType = OdataTypeMetricAlertCriteria
	objectMap := make(map[string]interface{})
	if mac.OdataType != "" {
		objectMap["odata.type"] = mac.OdataType
	}
	for k, v := range mac.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricAlertSingleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for MetricAlertCriteria.
func (mac MetricAlertCriteria) AsMetricAlertSingleResourceMultipleMetricCriteria() (*MetricAlertSingleResourceMultipleMetricCriteria, bool) {
	return nil, false
}

// AsWebtestLocationAvailabilityCriteria is the BasicMetricAlertCriteria implementation for MetricAlertCriteria.
func (mac MetricAlertCriteria) AsWebtestLocationAvailabilityCriteria() (*WebtestLocationAvailabilityCriteria, bool) {
	return nil, false
}

// AsMetricAlertMultipleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for MetricAlertCriteria.
func (mac MetricAlertCriteria) AsMetricAlertMultipleResourceMultipleMetricCriteria() (*MetricAlertMultipleResourceMultipleMetricCriteria, bool) {
	return nil, false
}

// AsMetricAlertCriteria is the BasicMetricAlertCriteria implementation for MetricAlertCriteria.
func (mac MetricAlertCriteria) AsMetricAlertCriteria() (*MetricAlertCriteria, bool) {
	return &mac, true
}

// AsBasicMetricAlertCriteria is the BasicMetricAlertCriteria implementation for MetricAlertCriteria.
func (mac MetricAlertCriteria) AsBasicMetricAlertCriteria() (BasicMetricAlertCriteria, bool) {
	return &mac, true
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertCriteria struct.
func (mac *MetricAlertCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mac.AdditionalProperties == nil {
					mac.AdditionalProperties = make(map[string]interface{})
				}
				mac.AdditionalProperties[k] = additionalProperties
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicMetricAlertCriteria
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				mac.OdataType = odataType
			}
		}
	}

	return nil
}

// MetricAlertMultipleResourceMultipleMetricCriteria specifies the metric alert criteria for multiple
// resource that has multiple metric criteria.
type MetricAlertMultipleResourceMultipleMetricCriteria struct {
	// AllOf - the list of multiple metric criteria for this 'all of' operation.
	AllOf *[]BasicMultiMetricCriteria `json:"allOf,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// OdataType - Possible values include: 'OdataTypeMetricAlertCriteria', 'OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria', 'OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria', 'OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria'
	OdataType OdataTypeBasicMetricAlertCriteria `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAlertMultipleResourceMultipleMetricCriteria.
func (mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria) MarshalJSON() ([]byte, error) {
	mamrmmc.OdataType = OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria
	objectMap := make(map[string]interface{})
	if mamrmmc.AllOf != nil {
		objectMap["allOf"] = mamrmmc.AllOf
	}
	if mamrmmc.OdataType != "" {
		objectMap["odata.type"] = mamrmmc.OdataType
	}
	for k, v := range mamrmmc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricAlertSingleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for MetricAlertMultipleResourceMultipleMetricCriteria.
func (mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria) AsMetricAlertSingleResourceMultipleMetricCriteria() (*MetricAlertSingleResourceMultipleMetricCriteria, bool) {
	return nil, false
}

// AsWebtestLocationAvailabilityCriteria is the BasicMetricAlertCriteria implementation for MetricAlertMultipleResourceMultipleMetricCriteria.
func (mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria) AsWebtestLocationAvailabilityCriteria() (*WebtestLocationAvailabilityCriteria, bool) {
	return nil, false
}

// AsMetricAlertMultipleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for MetricAlertMultipleResourceMultipleMetricCriteria.
func (mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria) AsMetricAlertMultipleResourceMultipleMetricCriteria() (*MetricAlertMultipleResourceMultipleMetricCriteria, bool) {
	return &mamrmmc, true
}

// AsMetricAlertCriteria is the BasicMetricAlertCriteria implementation for MetricAlertMultipleResourceMultipleMetricCriteria.
func (mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria) AsMetricAlertCriteria() (*MetricAlertCriteria, bool) {
	return nil, false
}

// AsBasicMetricAlertCriteria is the BasicMetricAlertCriteria implementation for MetricAlertMultipleResourceMultipleMetricCriteria.
func (mamrmmc MetricAlertMultipleResourceMultipleMetricCriteria) AsBasicMetricAlertCriteria() (BasicMetricAlertCriteria, bool) {
	return &mamrmmc, true
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertMultipleResourceMultipleMetricCriteria struct.
func (mamrmmc *MetricAlertMultipleResourceMultipleMetricCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "allOf":
			if v != nil {
				allOf, err := unmarshalBasicMultiMetricCriteriaArray(*v)
				if err != nil {
					return err
				}
				mamrmmc.AllOf = &allOf
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mamrmmc.AdditionalProperties == nil {
					mamrmmc.AdditionalProperties = make(map[string]interface{})
				}
				mamrmmc.AdditionalProperties[k] = additionalProperties
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicMetricAlertCriteria
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				mamrmmc.OdataType = odataType
			}
		}
	}

	return nil
}

// MetricAlertProperties an alert rule.
type MetricAlertProperties struct {
	// Description - the description of the metric alert that will be included in the alert email.
	Description *string `json:"description,omitempty"`
	// Severity - Alert severity {0, 1, 2, 3, 4}
	Severity *int32 `json:"severity,omitempty"`
	// Enabled - the flag that indicates whether the metric alert is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Scopes - the list of resource id's that this metric alert is scoped to.
	Scopes *[]string `json:"scopes,omitempty"`
	// EvaluationFrequency - how often the metric alert is evaluated represented in ISO 8601 duration format.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
	WindowSize *string `json:"windowSize,omitempty"`
	// TargetResourceType - the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
	TargetResourceType *string `json:"targetResourceType,omitempty"`
	// TargetResourceRegion - the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
	TargetResourceRegion *string `json:"targetResourceRegion,omitempty"`
	// Criteria - defines the specific alert criteria information.
	Criteria BasicMetricAlertCriteria `json:"criteria,omitempty"`
	// AutoMitigate - the flag that indicates whether the alert should be auto resolved or not. The default is true.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`
	// Actions - the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions *[]MetricAlertAction `json:"actions,omitempty"`
	// LastUpdatedTime - READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// IsMigrated - READ-ONLY; the value indicating whether this alert rule is migrated.
	IsMigrated *bool `json:"isMigrated,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAlertProperties.
func (mapVar MetricAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mapVar.Description != nil {
		objectMap["description"] = mapVar.Description
	}
	if mapVar.Severity != nil {
		objectMap["severity"] = mapVar.Severity
	}
	if mapVar.Enabled != nil {
		objectMap["enabled"] = mapVar.Enabled
	}
	if mapVar.Scopes != nil {
		objectMap["scopes"] = mapVar.Scopes
	}
	if mapVar.EvaluationFrequency != nil {
		objectMap["evaluationFrequency"] = mapVar.EvaluationFrequency
	}
	if mapVar.WindowSize != nil {
		objectMap["windowSize"] = mapVar.WindowSize
	}
	if mapVar.TargetResourceType != nil {
		objectMap["targetResourceType"] = mapVar.TargetResourceType
	}
	if mapVar.TargetResourceRegion != nil {
		objectMap["targetResourceRegion"] = mapVar.TargetResourceRegion
	}
	objectMap["criteria"] = mapVar.Criteria
	if mapVar.AutoMitigate != nil {
		objectMap["autoMitigate"] = mapVar.AutoMitigate
	}
	if mapVar.Actions != nil {
		objectMap["actions"] = mapVar.Actions
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertProperties struct.
func (mapVar *MetricAlertProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mapVar.Description = &description
			}
		case "severity":
			if v != nil {
				var severity int32
				err = json.Unmarshal(*v, &severity)
				if err != nil {
					return err
				}
				mapVar.Severity = &severity
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				mapVar.Enabled = &enabled
			}
		case "scopes":
			if v != nil {
				var scopes []string
				err = json.Unmarshal(*v, &scopes)
				if err != nil {
					return err
				}
				mapVar.Scopes = &scopes
			}
		case "evaluationFrequency":
			if v != nil {
				var evaluationFrequency string
				err = json.Unmarshal(*v, &evaluationFrequency)
				if err != nil {
					return err
				}
				mapVar.EvaluationFrequency = &evaluationFrequency
			}
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				mapVar.WindowSize = &windowSize
			}
		case "targetResourceType":
			if v != nil {
				var targetResourceType string
				err = json.Unmarshal(*v, &targetResourceType)
				if err != nil {
					return err
				}
				mapVar.TargetResourceType = &targetResourceType
			}
		case "targetResourceRegion":
			if v != nil {
				var targetResourceRegion string
				err = json.Unmarshal(*v, &targetResourceRegion)
				if err != nil {
					return err
				}
				mapVar.TargetResourceRegion = &targetResourceRegion
			}
		case "criteria":
			if v != nil {
				criteria, err := unmarshalBasicMetricAlertCriteria(*v)
				if err != nil {
					return err
				}
				mapVar.Criteria = criteria
			}
		case "autoMitigate":
			if v != nil {
				var autoMitigate bool
				err = json.Unmarshal(*v, &autoMitigate)
				if err != nil {
					return err
				}
				mapVar.AutoMitigate = &autoMitigate
			}
		case "actions":
			if v != nil {
				var actions []MetricAlertAction
				err = json.Unmarshal(*v, &actions)
				if err != nil {
					return err
				}
				mapVar.Actions = &actions
			}
		case "lastUpdatedTime":
			if v != nil {
				var lastUpdatedTime date.Time
				err = json.Unmarshal(*v, &lastUpdatedTime)
				if err != nil {
					return err
				}
				mapVar.LastUpdatedTime = &lastUpdatedTime
			}
		case "isMigrated":
			if v != nil {
				var isMigrated bool
				err = json.Unmarshal(*v, &isMigrated)
				if err != nil {
					return err
				}
				mapVar.IsMigrated = &isMigrated
			}
		}
	}

	return nil
}

// MetricAlertPropertiesPatch an alert rule properties for patch.
type MetricAlertPropertiesPatch struct {
	// Description - the description of the metric alert that will be included in the alert email.
	Description *string `json:"description,omitempty"`
	// Severity - Alert severity {0, 1, 2, 3, 4}
	Severity *int32 `json:"severity,omitempty"`
	// Enabled - the flag that indicates whether the metric alert is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Scopes - the list of resource id's that this metric alert is scoped to.
	Scopes *[]string `json:"scopes,omitempty"`
	// EvaluationFrequency - how often the metric alert is evaluated represented in ISO 8601 duration format.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
	WindowSize *string `json:"windowSize,omitempty"`
	// TargetResourceType - the resource type of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
	TargetResourceType *string `json:"targetResourceType,omitempty"`
	// TargetResourceRegion - the region of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
	TargetResourceRegion *string `json:"targetResourceRegion,omitempty"`
	// Criteria - defines the specific alert criteria information.
	Criteria BasicMetricAlertCriteria `json:"criteria,omitempty"`
	// AutoMitigate - the flag that indicates whether the alert should be auto resolved or not. The default is true.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`
	// Actions - the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions *[]MetricAlertAction `json:"actions,omitempty"`
	// LastUpdatedTime - READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// IsMigrated - READ-ONLY; the value indicating whether this alert rule is migrated.
	IsMigrated *bool `json:"isMigrated,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAlertPropertiesPatch.
func (mapp MetricAlertPropertiesPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mapp.Description != nil {
		objectMap["description"] = mapp.Description
	}
	if mapp.Severity != nil {
		objectMap["severity"] = mapp.Severity
	}
	if mapp.Enabled != nil {
		objectMap["enabled"] = mapp.Enabled
	}
	if mapp.Scopes != nil {
		objectMap["scopes"] = mapp.Scopes
	}
	if mapp.EvaluationFrequency != nil {
		objectMap["evaluationFrequency"] = mapp.EvaluationFrequency
	}
	if mapp.WindowSize != nil {
		objectMap["windowSize"] = mapp.WindowSize
	}
	if mapp.TargetResourceType != nil {
		objectMap["targetResourceType"] = mapp.TargetResourceType
	}
	if mapp.TargetResourceRegion != nil {
		objectMap["targetResourceRegion"] = mapp.TargetResourceRegion
	}
	objectMap["criteria"] = mapp.Criteria
	if mapp.AutoMitigate != nil {
		objectMap["autoMitigate"] = mapp.AutoMitigate
	}
	if mapp.Actions != nil {
		objectMap["actions"] = mapp.Actions
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertPropertiesPatch struct.
func (mapp *MetricAlertPropertiesPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mapp.Description = &description
			}
		case "severity":
			if v != nil {
				var severity int32
				err = json.Unmarshal(*v, &severity)
				if err != nil {
					return err
				}
				mapp.Severity = &severity
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				mapp.Enabled = &enabled
			}
		case "scopes":
			if v != nil {
				var scopes []string
				err = json.Unmarshal(*v, &scopes)
				if err != nil {
					return err
				}
				mapp.Scopes = &scopes
			}
		case "evaluationFrequency":
			if v != nil {
				var evaluationFrequency string
				err = json.Unmarshal(*v, &evaluationFrequency)
				if err != nil {
					return err
				}
				mapp.EvaluationFrequency = &evaluationFrequency
			}
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				mapp.WindowSize = &windowSize
			}
		case "targetResourceType":
			if v != nil {
				var targetResourceType string
				err = json.Unmarshal(*v, &targetResourceType)
				if err != nil {
					return err
				}
				mapp.TargetResourceType = &targetResourceType
			}
		case "targetResourceRegion":
			if v != nil {
				var targetResourceRegion string
				err = json.Unmarshal(*v, &targetResourceRegion)
				if err != nil {
					return err
				}
				mapp.TargetResourceRegion = &targetResourceRegion
			}
		case "criteria":
			if v != nil {
				criteria, err := unmarshalBasicMetricAlertCriteria(*v)
				if err != nil {
					return err
				}
				mapp.Criteria = criteria
			}
		case "autoMitigate":
			if v != nil {
				var autoMitigate bool
				err = json.Unmarshal(*v, &autoMitigate)
				if err != nil {
					return err
				}
				mapp.AutoMitigate = &autoMitigate
			}
		case "actions":
			if v != nil {
				var actions []MetricAlertAction
				err = json.Unmarshal(*v, &actions)
				if err != nil {
					return err
				}
				mapp.Actions = &actions
			}
		case "lastUpdatedTime":
			if v != nil {
				var lastUpdatedTime date.Time
				err = json.Unmarshal(*v, &lastUpdatedTime)
				if err != nil {
					return err
				}
				mapp.LastUpdatedTime = &lastUpdatedTime
			}
		case "isMigrated":
			if v != nil {
				var isMigrated bool
				err = json.Unmarshal(*v, &isMigrated)
				if err != nil {
					return err
				}
				mapp.IsMigrated = &isMigrated
			}
		}
	}

	return nil
}

// MetricAlertResource the metric alert resource.
type MetricAlertResource struct {
	autorest.Response `json:"-"`
	// MetricAlertProperties - The alert rule properties of the resource.
	*MetricAlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MetricAlertResource.
func (mar MetricAlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mar.MetricAlertProperties != nil {
		objectMap["properties"] = mar.MetricAlertProperties
	}
	if mar.Location != nil {
		objectMap["location"] = mar.Location
	}
	if mar.Tags != nil {
		objectMap["tags"] = mar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertResource struct.
func (mar *MetricAlertResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var metricAlertProperties MetricAlertProperties
				err = json.Unmarshal(*v, &metricAlertProperties)
				if err != nil {
					return err
				}
				mar.MetricAlertProperties = &metricAlertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mar.Tags = tags
			}
		}
	}

	return nil
}

// MetricAlertResourceCollection represents a collection of alert rule resources.
type MetricAlertResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the alert rule resources.
	Value *[]MetricAlertResource `json:"value,omitempty"`
}

// MetricAlertResourcePatch the metric alert resource for patch operations.
type MetricAlertResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// MetricAlertPropertiesPatch - The alert rule properties of the resource.
	*MetricAlertPropertiesPatch `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAlertResourcePatch.
func (marp MetricAlertResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if marp.Tags != nil {
		objectMap["tags"] = marp.Tags
	}
	if marp.MetricAlertPropertiesPatch != nil {
		objectMap["properties"] = marp.MetricAlertPropertiesPatch
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertResourcePatch struct.
func (marp *MetricAlertResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				marp.Tags = tags
			}
		case "properties":
			if v != nil {
				var metricAlertPropertiesPatch MetricAlertPropertiesPatch
				err = json.Unmarshal(*v, &metricAlertPropertiesPatch)
				if err != nil {
					return err
				}
				marp.MetricAlertPropertiesPatch = &metricAlertPropertiesPatch
			}
		}
	}

	return nil
}

// MetricAlertSingleResourceMultipleMetricCriteria specifies the metric alert criteria for a single
// resource that has multiple metric criteria.
type MetricAlertSingleResourceMultipleMetricCriteria struct {
	// AllOf - The list of metric criteria for this 'all of' operation.
	AllOf *[]MetricCriteria `json:"allOf,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// OdataType - Possible values include: 'OdataTypeMetricAlertCriteria', 'OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria', 'OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria', 'OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria'
	OdataType OdataTypeBasicMetricAlertCriteria `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAlertSingleResourceMultipleMetricCriteria.
func (masrmmc MetricAlertSingleResourceMultipleMetricCriteria) MarshalJSON() ([]byte, error) {
	masrmmc.OdataType = OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria
	objectMap := make(map[string]interface{})
	if masrmmc.AllOf != nil {
		objectMap["allOf"] = masrmmc.AllOf
	}
	if masrmmc.OdataType != "" {
		objectMap["odata.type"] = masrmmc.OdataType
	}
	for k, v := range masrmmc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricAlertSingleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for MetricAlertSingleResourceMultipleMetricCriteria.
func (masrmmc MetricAlertSingleResourceMultipleMetricCriteria) AsMetricAlertSingleResourceMultipleMetricCriteria() (*MetricAlertSingleResourceMultipleMetricCriteria, bool) {
	return &masrmmc, true
}

// AsWebtestLocationAvailabilityCriteria is the BasicMetricAlertCriteria implementation for MetricAlertSingleResourceMultipleMetricCriteria.
func (masrmmc MetricAlertSingleResourceMultipleMetricCriteria) AsWebtestLocationAvailabilityCriteria() (*WebtestLocationAvailabilityCriteria, bool) {
	return nil, false
}

// AsMetricAlertMultipleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for MetricAlertSingleResourceMultipleMetricCriteria.
func (masrmmc MetricAlertSingleResourceMultipleMetricCriteria) AsMetricAlertMultipleResourceMultipleMetricCriteria() (*MetricAlertMultipleResourceMultipleMetricCriteria, bool) {
	return nil, false
}

// AsMetricAlertCriteria is the BasicMetricAlertCriteria implementation for MetricAlertSingleResourceMultipleMetricCriteria.
func (masrmmc MetricAlertSingleResourceMultipleMetricCriteria) AsMetricAlertCriteria() (*MetricAlertCriteria, bool) {
	return nil, false
}

// AsBasicMetricAlertCriteria is the BasicMetricAlertCriteria implementation for MetricAlertSingleResourceMultipleMetricCriteria.
func (masrmmc MetricAlertSingleResourceMultipleMetricCriteria) AsBasicMetricAlertCriteria() (BasicMetricAlertCriteria, bool) {
	return &masrmmc, true
}

// UnmarshalJSON is the custom unmarshaler for MetricAlertSingleResourceMultipleMetricCriteria struct.
func (masrmmc *MetricAlertSingleResourceMultipleMetricCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "allOf":
			if v != nil {
				var allOf []MetricCriteria
				err = json.Unmarshal(*v, &allOf)
				if err != nil {
					return err
				}
				masrmmc.AllOf = &allOf
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if masrmmc.AdditionalProperties == nil {
					masrmmc.AdditionalProperties = make(map[string]interface{})
				}
				masrmmc.AdditionalProperties[k] = additionalProperties
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicMetricAlertCriteria
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				masrmmc.OdataType = odataType
			}
		}
	}

	return nil
}

// MetricAlertStatus an alert status.
type MetricAlertStatus struct {
	// Name - The status name.
	Name *string `json:"name,omitempty"`
	// ID - The alert rule arm id.
	ID *string `json:"id,omitempty"`
	// Type - The extended resource type name.
	Type *string `json:"type,omitempty"`
	// Properties - The alert status properties of the metric alert status.
	Properties *MetricAlertStatusProperties `json:"properties,omitempty"`
}

// MetricAlertStatusCollection represents a collection of alert rule resources.
type MetricAlertStatusCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the alert rule resources.
	Value *[]MetricAlertStatus `json:"value,omitempty"`
}

// MetricAlertStatusProperties an alert status properties.
type MetricAlertStatusProperties struct {
	// Dimensions - An object describing the type of the dimensions.
	Dimensions map[string]*string `json:"dimensions"`
	// Status - status value
	Status *string `json:"status,omitempty"`
	// Timestamp - UTC time when the status was checked.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAlertStatusProperties.
func (masp MetricAlertStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if masp.Dimensions != nil {
		objectMap["dimensions"] = masp.Dimensions
	}
	if masp.Status != nil {
		objectMap["status"] = masp.Status
	}
	if masp.Timestamp != nil {
		objectMap["timestamp"] = masp.Timestamp
	}
	return json.Marshal(objectMap)
}

// MetricAvailability metric availability specifies the time grain (aggregation interval or frequency) and
// the retention period for that time grain.
type MetricAvailability struct {
	// TimeGrain - the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - the retention period for the metric at the specified timegrain.  Expressed as a duration 'PT1M', 'P1D', etc.
	Retention *string `json:"retention,omitempty"`
}

// MetricBaselinesProperties the response to a metric baselines query.
type MetricBaselinesProperties struct {
	// Timespan - The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
	Timespan *string `json:"timespan,omitempty"`
	// Interval - The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
	Interval *string `json:"interval,omitempty"`
	// Namespace - The namespace of the metrics been queried.
	Namespace *string `json:"namespace,omitempty"`
	// Baselines - The baseline for each time series that was queried.
	Baselines *[]TimeSeriesBaseline `json:"baselines,omitempty"`
}

// MetricBaselinesResponse a list of metric baselines.
type MetricBaselinesResponse struct {
	autorest.Response `json:"-"`
	// Value - The list of metric baselines.
	Value *[]SingleMetricBaseline `json:"value,omitempty"`
}

// MetricCriteria criterion to filter metrics.
type MetricCriteria struct {
	// Operator - the criteria operator. Possible values include: 'OperatorEquals', 'OperatorGreaterThan', 'OperatorGreaterThanOrEqual', 'OperatorLessThan', 'OperatorLessThanOrEqual'
	Operator Operator `json:"operator,omitempty"`
	// Threshold - the criteria threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Name of the criteria.
	Name *string `json:"name,omitempty"`
	// MetricName - Name of the metric.
	MetricName *string `json:"metricName,omitempty"`
	// MetricNamespace - Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// TimeAggregation - the criteria time aggregation types. Possible values include: 'AggregationTypeEnumAverage', 'AggregationTypeEnumCount', 'AggregationTypeEnumMinimum', 'AggregationTypeEnumMaximum', 'AggregationTypeEnumTotal'
	TimeAggregation AggregationTypeEnum `json:"timeAggregation,omitempty"`
	// Dimensions - List of dimension conditions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// SkipMetricValidation - Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
	// CriterionType - Possible values include: 'CriterionTypeMultiMetricCriteria', 'CriterionTypeStaticThresholdCriterion', 'CriterionTypeDynamicThresholdCriterion'
	CriterionType CriterionType `json:"criterionType,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricCriteria.
func (mc MetricCriteria) MarshalJSON() ([]byte, error) {
	mc.CriterionType = CriterionTypeStaticThresholdCriterion
	objectMap := make(map[string]interface{})
	if mc.Operator != "" {
		objectMap["operator"] = mc.Operator
	}
	if mc.Threshold != nil {
		objectMap["threshold"] = mc.Threshold
	}
	if mc.Name != nil {
		objectMap["name"] = mc.Name
	}
	if mc.MetricName != nil {
		objectMap["metricName"] = mc.MetricName
	}
	if mc.MetricNamespace != nil {
		objectMap["metricNamespace"] = mc.MetricNamespace
	}
	if mc.TimeAggregation != "" {
		objectMap["timeAggregation"] = mc.TimeAggregation
	}
	if mc.Dimensions != nil {
		objectMap["dimensions"] = mc.Dimensions
	}
	if mc.SkipMetricValidation != nil {
		objectMap["skipMetricValidation"] = mc.SkipMetricValidation
	}
	if mc.CriterionType != "" {
		objectMap["criterionType"] = mc.CriterionType
	}
	for k, v := range mc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricCriteria is the BasicMultiMetricCriteria implementation for MetricCriteria.
func (mc MetricCriteria) AsMetricCriteria() (*MetricCriteria, bool) {
	return &mc, true
}

// AsDynamicMetricCriteria is the BasicMultiMetricCriteria implementation for MetricCriteria.
func (mc MetricCriteria) AsDynamicMetricCriteria() (*DynamicMetricCriteria, bool) {
	return nil, false
}

// AsMultiMetricCriteria is the BasicMultiMetricCriteria implementation for MetricCriteria.
func (mc MetricCriteria) AsMultiMetricCriteria() (*MultiMetricCriteria, bool) {
	return nil, false
}

// AsBasicMultiMetricCriteria is the BasicMultiMetricCriteria implementation for MetricCriteria.
func (mc MetricCriteria) AsBasicMultiMetricCriteria() (BasicMultiMetricCriteria, bool) {
	return &mc, true
}

// UnmarshalJSON is the custom unmarshaler for MetricCriteria struct.
func (mc *MetricCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "operator":
			if v != nil {
				var operator Operator
				err = json.Unmarshal(*v, &operator)
				if err != nil {
					return err
				}
				mc.Operator = operator
			}
		case "threshold":
			if v != nil {
				var threshold float64
				err = json.Unmarshal(*v, &threshold)
				if err != nil {
					return err
				}
				mc.Threshold = &threshold
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mc.AdditionalProperties == nil {
					mc.AdditionalProperties = make(map[string]interface{})
				}
				mc.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mc.Name = &name
			}
		case "metricName":
			if v != nil {
				var metricName string
				err = json.Unmarshal(*v, &metricName)
				if err != nil {
					return err
				}
				mc.MetricName = &metricName
			}
		case "metricNamespace":
			if v != nil {
				var metricNamespace string
				err = json.Unmarshal(*v, &metricNamespace)
				if err != nil {
					return err
				}
				mc.MetricNamespace = &metricNamespace
			}
		case "timeAggregation":
			if v != nil {
				var timeAggregation AggregationTypeEnum
				err = json.Unmarshal(*v, &timeAggregation)
				if err != nil {
					return err
				}
				mc.TimeAggregation = timeAggregation
			}
		case "dimensions":
			if v != nil {
				var dimensions []MetricDimension
				err = json.Unmarshal(*v, &dimensions)
				if err != nil {
					return err
				}
				mc.Dimensions = &dimensions
			}
		case "skipMetricValidation":
			if v != nil {
				var skipMetricValidation bool
				err = json.Unmarshal(*v, &skipMetricValidation)
				if err != nil {
					return err
				}
				mc.SkipMetricValidation = &skipMetricValidation
			}
		case "criterionType":
			if v != nil {
				var criterionType CriterionType
				err = json.Unmarshal(*v, &criterionType)
				if err != nil {
					return err
				}
				mc.CriterionType = criterionType
			}
		}
	}

	return nil
}

// MetricDefinition metric definition class specifies the metadata for a metric.
type MetricDefinition struct {
	// IsDimensionRequired - Flag to indicate whether the dimension is required.
	IsDimensionRequired *bool `json:"isDimensionRequired,omitempty"`
	// ResourceID - the resource identifier of the resource that emitted the metric.
	ResourceID *string `json:"resourceId,omitempty"`
	// Namespace - the namespace the metric belongs to.
	Namespace *string `json:"namespace,omitempty"`
	// Name - the name and the display name of the metric, i.e. it is a localizable string.
	Name *LocalizableString `json:"name,omitempty"`
	// DisplayDescription - Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Category - Custom category name for this metric.
	Category *string `json:"category,omitempty"`
	// MetricClass - The class of the metric. Possible values include: 'Availability', 'Transactions', 'Errors', 'Latency', 'Saturation'
	MetricClass MetricClass `json:"metricClass,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'MetricUnitCount', 'MetricUnitBytes', 'MetricUnitSeconds', 'MetricUnitCountPerSecond', 'MetricUnitBytesPerSecond', 'MetricUnitPercent', 'MetricUnitMilliSeconds', 'MetricUnitByteSeconds', 'MetricUnitUnspecified', 'MetricUnitCores', 'MetricUnitMilliCores', 'MetricUnitNanoCores', 'MetricUnitBitsPerSecond'
	Unit MetricUnit `json:"unit,omitempty"`
	// PrimaryAggregationType - the primary aggregation type value defining how to use the values for display. Possible values include: 'None', 'Average', 'Count', 'Minimum', 'Maximum', 'Total'
	PrimaryAggregationType AggregationType `json:"primaryAggregationType,omitempty"`
	// SupportedAggregationTypes - the collection of what aggregation types are supported.
	SupportedAggregationTypes *[]AggregationType `json:"supportedAggregationTypes,omitempty"`
	// MetricAvailabilities - the collection of what aggregation intervals are available to be queried.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
	// ID - the resource identifier of the metric definition.
	ID *string `json:"id,omitempty"`
	// Dimensions - the name and the display name of the dimension, i.e. it is a localizable string.
	Dimensions *[]LocalizableString `json:"dimensions,omitempty"`
}

// MetricDefinitionCollection represents collection of metric definitions.
type MetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the metric definitions.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricDimension specifies a metric dimension.
type MetricDimension struct {
	// Name - Name of the dimension.
	Name *string `json:"name,omitempty"`
	// Operator - the dimension operator. Only 'Include' and 'Exclude' are supported
	Operator *string `json:"operator,omitempty"`
	// Values - list of dimension values.
	Values *[]string `json:"values,omitempty"`
}

// MetricNamespace metric namespace class specifies the metadata for a metric namespace.
type MetricNamespace struct {
	// ID - The ID of the metric namespace.
	ID *string `json:"id,omitempty"`
	// Type - The type of the namespace.
	Type *string `json:"type,omitempty"`
	// Name - The escaped name of the namespace.
	Name *string `json:"name,omitempty"`
	// Classification - Kind of namespace. Possible values include: 'Platform', 'Custom', 'Qos'
	Classification NamespaceClassification `json:"classification,omitempty"`
	// Properties - Properties which include the fully qualified namespace name.
	Properties *MetricNamespaceName `json:"properties,omitempty"`
}

// MetricNamespaceCollection represents collection of metric namespaces.
type MetricNamespaceCollection struct {
	autorest.Response `json:"-"`
	// Value - The values for the metric namespaces.
	Value *[]MetricNamespace `json:"value,omitempty"`
}

// MetricNamespaceName the fully qualified metric namespace name.
type MetricNamespaceName struct {
	// MetricNamespaceName - The metric namespace name.
	MetricNamespaceName *string `json:"metricNamespaceName,omitempty"`
}

// MetricSettings part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	// TimeGrain - the timegrain of the metric in ISO8601 format.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Category - Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`
	// Enabled - a value indicating whether this category is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - the retention policy for this category.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// MetricSingleDimension the metric dimension name and value.
type MetricSingleDimension struct {
	// Name - Name of the dimension.
	Name *string `json:"name,omitempty"`
	// Value - Value of the dimension.
	Value *string `json:"value,omitempty"`
}

// MetricTrigger the trigger that results in a scaling action.
type MetricTrigger struct {
	// MetricName - the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`
	// MetricNamespace - the namespace of the metric that defines what the rule monitors.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// MetricResourceURI - the resource identifier of the resource the rule monitors.
	MetricResourceURI *string `json:"metricResourceUri,omitempty"`
	// MetricResourceLocation - the location of the resource the rule monitors.
	MetricResourceLocation *string `json:"metricResourceLocation,omitempty"`
	// TimeGrain - the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Statistic - the metric statistic type. How the metrics from multiple instances are combined. Possible values include: 'MetricStatisticTypeAverage', 'MetricStatisticTypeMin', 'MetricStatisticTypeMax', 'MetricStatisticTypeSum', 'MetricStatisticTypeCount'
	Statistic MetricStatisticType `json:"statistic,omitempty"`
	// TimeWindow - the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
	TimeWindow *string `json:"timeWindow,omitempty"`
	// TimeAggregation - time aggregation type. How the data that is collected should be combined over time. The default value is Average. Possible values include: 'TimeAggregationTypeAverage', 'TimeAggregationTypeMinimum', 'TimeAggregationTypeMaximum', 'TimeAggregationTypeTotal', 'TimeAggregationTypeCount', 'TimeAggregationTypeLast'
	TimeAggregation TimeAggregationType `json:"timeAggregation,omitempty"`
	// Operator - the operator that is used to compare the metric data and the threshold. Possible values include: 'Equals', 'NotEquals', 'GreaterThan', 'GreaterThanOrEqual', 'LessThan', 'LessThanOrEqual'
	Operator ComparisonOperationType `json:"operator,omitempty"`
	// Threshold - the threshold of the metric that triggers the scale action.
	Threshold *float64 `json:"threshold,omitempty"`
	// Dimensions - List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
	Dimensions *[]ScaleRuleMetricDimension `json:"dimensions,omitempty"`
	// DividePerInstance - a value indicating whether metric should divide per instance.
	DividePerInstance *bool `json:"dividePerInstance,omitempty"`
}

// MetricValue represents a metric value.
type MetricValue struct {
	// TimeStamp - the timestamp for the metric value in ISO 8601 format.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Average - the average value in the time range.
	Average *float64 `json:"average,omitempty"`
	// Minimum - the least value in the time range.
	Minimum *float64 `json:"minimum,omitempty"`
	// Maximum - the greatest value in the time range.
	Maximum *float64 `json:"maximum,omitempty"`
	// Total - the sum of all of the values in the time range.
	Total *float64 `json:"total,omitempty"`
	// Count - the number of samples in the time range. Can be used to determine the number of values that contributed to the average value.
	Count *float64 `json:"count,omitempty"`
}

// BasicMultiMetricCriteria the types of conditions for a multi resource alert.
type BasicMultiMetricCriteria interface {
	AsMetricCriteria() (*MetricCriteria, bool)
	AsDynamicMetricCriteria() (*DynamicMetricCriteria, bool)
	AsMultiMetricCriteria() (*MultiMetricCriteria, bool)
}

// MultiMetricCriteria the types of conditions for a multi resource alert.
type MultiMetricCriteria struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Name of the criteria.
	Name *string `json:"name,omitempty"`
	// MetricName - Name of the metric.
	MetricName *string `json:"metricName,omitempty"`
	// MetricNamespace - Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// TimeAggregation - the criteria time aggregation types. Possible values include: 'AggregationTypeEnumAverage', 'AggregationTypeEnumCount', 'AggregationTypeEnumMinimum', 'AggregationTypeEnumMaximum', 'AggregationTypeEnumTotal'
	TimeAggregation AggregationTypeEnum `json:"timeAggregation,omitempty"`
	// Dimensions - List of dimension conditions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// SkipMetricValidation - Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
	// CriterionType - Possible values include: 'CriterionTypeMultiMetricCriteria', 'CriterionTypeStaticThresholdCriterion', 'CriterionTypeDynamicThresholdCriterion'
	CriterionType CriterionType `json:"criterionType,omitempty"`
}

func unmarshalBasicMultiMetricCriteria(body []byte) (BasicMultiMetricCriteria, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["criterionType"] {
	case string(CriterionTypeStaticThresholdCriterion):
		var mc MetricCriteria
		err := json.Unmarshal(body, &mc)
		return mc, err
	case string(CriterionTypeDynamicThresholdCriterion):
		var dmc DynamicMetricCriteria
		err := json.Unmarshal(body, &dmc)
		return dmc, err
	default:
		var mmc MultiMetricCriteria
		err := json.Unmarshal(body, &mmc)
		return mmc, err
	}
}
func unmarshalBasicMultiMetricCriteriaArray(body []byte) ([]BasicMultiMetricCriteria, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mmcArray := make([]BasicMultiMetricCriteria, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mmc, err := unmarshalBasicMultiMetricCriteria(*rawMessage)
		if err != nil {
			return nil, err
		}
		mmcArray[index] = mmc
	}
	return mmcArray, nil
}

// MarshalJSON is the custom marshaler for MultiMetricCriteria.
func (mmc MultiMetricCriteria) MarshalJSON() ([]byte, error) {
	mmc.CriterionType = CriterionTypeMultiMetricCriteria
	objectMap := make(map[string]interface{})
	if mmc.Name != nil {
		objectMap["name"] = mmc.Name
	}
	if mmc.MetricName != nil {
		objectMap["metricName"] = mmc.MetricName
	}
	if mmc.MetricNamespace != nil {
		objectMap["metricNamespace"] = mmc.MetricNamespace
	}
	if mmc.TimeAggregation != "" {
		objectMap["timeAggregation"] = mmc.TimeAggregation
	}
	if mmc.Dimensions != nil {
		objectMap["dimensions"] = mmc.Dimensions
	}
	if mmc.SkipMetricValidation != nil {
		objectMap["skipMetricValidation"] = mmc.SkipMetricValidation
	}
	if mmc.CriterionType != "" {
		objectMap["criterionType"] = mmc.CriterionType
	}
	for k, v := range mmc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricCriteria is the BasicMultiMetricCriteria implementation for MultiMetricCriteria.
func (mmc MultiMetricCriteria) AsMetricCriteria() (*MetricCriteria, bool) {
	return nil, false
}

// AsDynamicMetricCriteria is the BasicMultiMetricCriteria implementation for MultiMetricCriteria.
func (mmc MultiMetricCriteria) AsDynamicMetricCriteria() (*DynamicMetricCriteria, bool) {
	return nil, false
}

// AsMultiMetricCriteria is the BasicMultiMetricCriteria implementation for MultiMetricCriteria.
func (mmc MultiMetricCriteria) AsMultiMetricCriteria() (*MultiMetricCriteria, bool) {
	return &mmc, true
}

// AsBasicMultiMetricCriteria is the BasicMultiMetricCriteria implementation for MultiMetricCriteria.
func (mmc MultiMetricCriteria) AsBasicMultiMetricCriteria() (BasicMultiMetricCriteria, bool) {
	return &mmc, true
}

// UnmarshalJSON is the custom unmarshaler for MultiMetricCriteria struct.
func (mmc *MultiMetricCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mmc.AdditionalProperties == nil {
					mmc.AdditionalProperties = make(map[string]interface{})
				}
				mmc.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mmc.Name = &name
			}
		case "metricName":
			if v != nil {
				var metricName string
				err = json.Unmarshal(*v, &metricName)
				if err != nil {
					return err
				}
				mmc.MetricName = &metricName
			}
		case "metricNamespace":
			if v != nil {
				var metricNamespace string
				err = json.Unmarshal(*v, &metricNamespace)
				if err != nil {
					return err
				}
				mmc.MetricNamespace = &metricNamespace
			}
		case "timeAggregation":
			if v != nil {
				var timeAggregation AggregationTypeEnum
				err = json.Unmarshal(*v, &timeAggregation)
				if err != nil {
					return err
				}
				mmc.TimeAggregation = timeAggregation
			}
		case "dimensions":
			if v != nil {
				var dimensions []MetricDimension
				err = json.Unmarshal(*v, &dimensions)
				if err != nil {
					return err
				}
				mmc.Dimensions = &dimensions
			}
		case "skipMetricValidation":
			if v != nil {
				var skipMetricValidation bool
				err = json.Unmarshal(*v, &skipMetricValidation)
				if err != nil {
					return err
				}
				mmc.SkipMetricValidation = &skipMetricValidation
			}
		case "criterionType":
			if v != nil {
				var criterionType CriterionType
				err = json.Unmarshal(*v, &criterionType)
				if err != nil {
					return err
				}
				mmc.CriterionType = criterionType
			}
		}
	}

	return nil
}

// NetworkRuleSet definition of the network rules.
type NetworkRuleSet struct {
	// PublicNetworkAccess - The configuration to set whether network access from public internet to the endpoints are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// NotificationRequestBody the request body which contain contact detail metadata
type NotificationRequestBody struct {
	// AlertType - The name of the supported alert type.
	AlertType *string `json:"alertType,omitempty"`
	// EmailReceivers - The list of email receivers that are part of this action group.
	EmailReceivers *[]EmailReceiver `json:"emailReceivers,omitempty"`
	// SmsReceivers - The list of SMS receivers that are part of this action group.
	SmsReceivers *[]SmsReceiver `json:"smsReceivers,omitempty"`
	// WebhookReceivers - The list of webhook receivers that are part of this action group.
	WebhookReceivers *[]WebhookReceiver `json:"webhookReceivers,omitempty"`
	// ItsmReceivers - The list of ITSM receivers that are part of this action group.
	ItsmReceivers *[]ItsmReceiver `json:"itsmReceivers,omitempty"`
	// AzureAppPushReceivers - The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers *[]AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`
	// AutomationRunbookReceivers - The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers *[]AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`
	// VoiceReceivers - The list of voice receivers that are part of this action group.
	VoiceReceivers *[]VoiceReceiver `json:"voiceReceivers,omitempty"`
	// LogicAppReceivers - The list of logic app receivers that are part of this action group.
	LogicAppReceivers *[]LogicAppReceiver `json:"logicAppReceivers,omitempty"`
	// AzureFunctionReceivers - The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers *[]AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`
	// ArmRoleReceivers - The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
	ArmRoleReceivers *[]ArmRoleReceiver `json:"armRoleReceivers,omitempty"`
	// EventHubReceivers - The list of event hub receivers that are part of this action group.
	EventHubReceivers *[]EventHubReceiver `json:"eventHubReceivers,omitempty"`
}

// Operation microsoft Insights API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Insights
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: AlertRules, Autoscale, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Microsoft.Insights operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Insights provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationStatus the status of operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - The operation Id.
	ID *string `json:"id,omitempty"`
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// StartTime - Start time of the job in standard ISO8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the job in standard ISO8601 format.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Error - The error detail of the operation if any.
	Error *ErrorResponseCommon `json:"error,omitempty"`
}

// PerfCounterDataSource definition of which performance counters will be collected and how they will be
// collected by this data collection rule.
// Collected from both Windows and Linux machines where the counter is present.
type PerfCounterDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownPerfCounterDataSourceStreams `json:"streams,omitempty"`
	// SamplingFrequencyInSeconds - The number of seconds between consecutive counter measurements (samples).
	SamplingFrequencyInSeconds *int32 `json:"samplingFrequencyInSeconds,omitempty"`
	// CounterSpecifiers - A list of specifier names of the performance counters you want to collect.
	// Use a wildcard (*) to collect a counter for all instances.
	// To get a list of performance counters on Windows, run the command 'typeperf'.
	CounterSpecifiers *[]string `json:"counterSpecifiers,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionListResult.
func (peclr PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "insights.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointProperty private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceListResult.
func (plrlr PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkScopedResourcesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateLinkScopedResourcesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopedResourcesClient) (ScopedResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopedResourcesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopedResourcesCreateOrUpdateFuture.Result.
func (future *PrivateLinkScopedResourcesCreateOrUpdateFuture) result(client PrivateLinkScopedResourcesClient) (sr ScopedResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopedResourcesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.PrivateLinkScopedResourcesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopedResourcesCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkScopedResourcesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateLinkScopedResourcesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopedResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopedResourcesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopedResourcesDeleteFuture.Result.
func (future *PrivateLinkScopedResourcesDeleteFuture) result(client PrivateLinkScopedResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopedResourcesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.PrivateLinkScopedResourcesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkScopesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateLinkScopesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopesDeleteFuture.Result.
func (future *PrivateLinkScopesDeleteFuture) result(client PrivateLinkScopesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("insights.PrivateLinkScopesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkScopesResource an azure resource object
type PrivateLinkScopesResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateLinkScopesResource.
func (plsr PrivateLinkScopesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plsr.Location != nil {
		objectMap["location"] = plsr.Location
	}
	if plsr.Tags != nil {
		objectMap["tags"] = plsr.Tags
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionStateProperty state of the private endpoint connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status.
	Status *string `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionStateProperty.
func (plscsp PrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscsp.Status != nil {
		objectMap["status"] = plscsp.Status
	}
	if plscsp.Description != nil {
		objectMap["description"] = plscsp.Description
	}
	return json.Marshal(objectMap)
}

// ProxyOnlyResource a proxy only azure resource object
type ProxyOnlyResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyOnlyResource.
func (por ProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource an azure resource object
type ProxyResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Recurrence the repeating times at which this profile begins. This element is not used if the FixedDate
// element is used.
type Recurrence struct {
	// Frequency - the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly. Possible values include: 'RecurrenceFrequencyNone', 'RecurrenceFrequencySecond', 'RecurrenceFrequencyMinute', 'RecurrenceFrequencyHour', 'RecurrenceFrequencyDay', 'RecurrenceFrequencyWeek', 'RecurrenceFrequencyMonth', 'RecurrenceFrequencyYear'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// Schedule - the scheduling constraints for when the profile begins.
	Schedule *RecurrentSchedule `json:"schedule,omitempty"`
}

// RecurrentSchedule the scheduling constraints for when the profile begins.
type RecurrentSchedule struct {
	// TimeZone - the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// Days - the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
	Days *[]string `json:"days,omitempty"`
	// Hours - A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
	Hours *[]int32 `json:"hours,omitempty"`
	// Minutes - A collection of minutes at which the profile takes effect at.
	Minutes *[]int32 `json:"minutes,omitempty"`
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceForUpdate definition of ARM tracked top level resource properties for update operation.
type ResourceForUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceForUpdate.
func (rfu ResourceForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rfu.Tags != nil {
		objectMap["tags"] = rfu.Tags
	}
	return json.Marshal(objectMap)
}

// Response the response to a metrics query.
type Response struct {
	autorest.Response `json:"-"`
	// Cost - The integer value representing the relative cost of the query.
	Cost *float64 `json:"cost,omitempty"`
	// Timespan - The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
	Timespan *string `json:"timespan,omitempty"`
	// Interval - The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
	Interval *string `json:"interval,omitempty"`
	// Namespace - The namespace of the metrics being queried
	Namespace *string `json:"namespace,omitempty"`
	// Resourceregion - The region of the resource being queried for metrics.
	Resourceregion *string `json:"resourceregion,omitempty"`
	// Value - the value of the collection.
	Value *[]Metric `json:"value,omitempty"`
}

// ResponseWithError an error response from the API.
type ResponseWithError struct {
	// Error - Error information.
	Error *Error `json:"error,omitempty"`
}

// RetentionPolicy specifies the retention policy for the log.
type RetentionPolicy struct {
	// Enabled - a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`
}

// BasicRuleAction the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type BasicRuleAction interface {
	AsRuleEmailAction() (*RuleEmailAction, bool)
	AsRuleWebhookAction() (*RuleWebhookAction, bool)
	AsRuleAction() (*RuleAction, bool)
}

// RuleAction the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type RuleAction struct {
	// OdataType - Possible values include: 'OdataTypeRuleAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleAction(body []byte) (BasicRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction):
		var rea RuleEmailAction
		err := json.Unmarshal(body, &rea)
		return rea, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction):
		var rwa RuleWebhookAction
		err := json.Unmarshal(body, &rwa)
		return rwa, err
	default:
		var ra RuleAction
		err := json.Unmarshal(body, &ra)
		return ra, err
	}
}
func unmarshalBasicRuleActionArray(body []byte) ([]BasicRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	raArray := make([]BasicRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ra, err := unmarshalBasicRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		raArray[index] = ra
	}
	return raArray, nil
}

// MarshalJSON is the custom marshaler for RuleAction.
func (ra RuleAction) MarshalJSON() ([]byte, error) {
	ra.OdataType = OdataTypeRuleAction
	objectMap := make(map[string]interface{})
	if ra.OdataType != "" {
		objectMap["odata.type"] = ra.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// AsRuleAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleAction() (*RuleAction, bool) {
	return &ra, true
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &ra, true
}

// BasicRuleCondition the condition that results in the alert rule being activated.
type BasicRuleCondition interface {
	AsThresholdRuleCondition() (*ThresholdRuleCondition, bool)
	AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool)
	AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool)
	AsRuleCondition() (*RuleCondition, bool)
}

// RuleCondition the condition that results in the alert rule being activated.
type RuleCondition struct {
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleCondition(body []byte) (BasicRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition):
		var trc ThresholdRuleCondition
		err := json.Unmarshal(body, &trc)
		return trc, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition):
		var ltrc LocationThresholdRuleCondition
		err := json.Unmarshal(body, &ltrc)
		return ltrc, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition):
		var merc ManagementEventRuleCondition
		err := json.Unmarshal(body, &merc)
		return merc, err
	default:
		var rc RuleCondition
		err := json.Unmarshal(body, &rc)
		return rc, err
	}
}
func unmarshalBasicRuleConditionArray(body []byte) ([]BasicRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rcArray := make([]BasicRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rc, err := unmarshalBasicRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		rcArray[index] = rc
	}
	return rcArray, nil
}

// MarshalJSON is the custom marshaler for RuleCondition.
func (rc RuleCondition) MarshalJSON() ([]byte, error) {
	rc.OdataType = OdataTypeRuleCondition
	objectMap := make(map[string]interface{})
	objectMap["dataSource"] = rc.DataSource
	if rc.OdataType != "" {
		objectMap["odata.type"] = rc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return &rc, true
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &rc, true
}

// UnmarshalJSON is the custom unmarshaler for RuleCondition struct.
func (rc *RuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				rc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				rc.OdataType = odataType
			}
		}
	}

	return nil
}

// BasicRuleDataSource the resource from which the rule collects its data.
type BasicRuleDataSource interface {
	AsRuleMetricDataSource() (*RuleMetricDataSource, bool)
	AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool)
	AsRuleDataSource() (*RuleDataSource, bool)
}

// RuleDataSource the resource from which the rule collects its data.
type RuleDataSource struct {
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// LegacyResourceID - the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`
	// ResourceLocation - the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// MetricNamespace - the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleDataSource(body []byte) (BasicRuleDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource):
		var rmds RuleMetricDataSource
		err := json.Unmarshal(body, &rmds)
		return rmds, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource):
		var rmeds RuleManagementEventDataSource
		err := json.Unmarshal(body, &rmeds)
		return rmeds, err
	default:
		var rds RuleDataSource
		err := json.Unmarshal(body, &rds)
		return rds, err
	}
}
func unmarshalBasicRuleDataSourceArray(body []byte) ([]BasicRuleDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdsArray := make([]BasicRuleDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rds, err := unmarshalBasicRuleDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdsArray[index] = rds
	}
	return rdsArray, nil
}

// MarshalJSON is the custom marshaler for RuleDataSource.
func (rds RuleDataSource) MarshalJSON() ([]byte, error) {
	rds.OdataType = OdataTypeRuleDataSource
	objectMap := make(map[string]interface{})
	if rds.ResourceURI != nil {
		objectMap["resourceUri"] = rds.ResourceURI
	}
	if rds.LegacyResourceID != nil {
		objectMap["legacyResourceId"] = rds.LegacyResourceID
	}
	if rds.ResourceLocation != nil {
		objectMap["resourceLocation"] = rds.ResourceLocation
	}
	if rds.MetricNamespace != nil {
		objectMap["metricNamespace"] = rds.MetricNamespace
	}
	if rds.OdataType != "" {
		objectMap["odata.type"] = rds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return &rds, true
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rds, true
}

// RuleEmailAction specifies the action to send email when the rule condition is evaluated. The
// discriminator is always RuleEmailAction in this case.
type RuleEmailAction struct {
	// SendToServiceOwners - Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
	SendToServiceOwners *bool `json:"sendToServiceOwners,omitempty"`
	// CustomEmails - the list of administrator's custom email addresses to notify of the activation of the alert.
	CustomEmails *[]string `json:"customEmails,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleEmailAction.
func (rea RuleEmailAction) MarshalJSON() ([]byte, error) {
	rea.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction
	objectMap := make(map[string]interface{})
	if rea.SendToServiceOwners != nil {
		objectMap["sendToServiceOwners"] = rea.SendToServiceOwners
	}
	if rea.CustomEmails != nil {
		objectMap["customEmails"] = rea.CustomEmails
	}
	if rea.OdataType != "" {
		objectMap["odata.type"] = rea.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return &rea, true
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// AsRuleAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleAction() (*RuleAction, bool) {
	return nil, false
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &rea, true
}

// RuleManagementEventClaimsDataSource the claims for a rule management event data source.
type RuleManagementEventClaimsDataSource struct {
	// EmailAddress - the email address.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// RuleManagementEventDataSource a rule management event data source. The discriminator fields is always
// RuleManagementEventDataSource in this case.
type RuleManagementEventDataSource struct {
	// EventName - the event name.
	EventName *string `json:"eventName,omitempty"`
	// EventSource - the event source.
	EventSource *string `json:"eventSource,omitempty"`
	// Level - the level.
	Level *string `json:"level,omitempty"`
	// OperationName - The name of the operation that should be checked for. If no name is provided, any operation will match.
	OperationName *string `json:"operationName,omitempty"`
	// ResourceGroupName - the resource group name.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceProviderName - the resource provider name.
	ResourceProviderName *string `json:"resourceProviderName,omitempty"`
	// Status - The status of the operation that should be checked for. If no status is provided, any status will match.
	Status *string `json:"status,omitempty"`
	// SubStatus - the substatus.
	SubStatus *string `json:"subStatus,omitempty"`
	// Claims - the claims.
	Claims *RuleManagementEventClaimsDataSource `json:"claims,omitempty"`
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// LegacyResourceID - the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`
	// ResourceLocation - the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// MetricNamespace - the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) MarshalJSON() ([]byte, error) {
	rmeds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource
	objectMap := make(map[string]interface{})
	if rmeds.EventName != nil {
		objectMap["eventName"] = rmeds.EventName
	}
	if rmeds.EventSource != nil {
		objectMap["eventSource"] = rmeds.EventSource
	}
	if rmeds.Level != nil {
		objectMap["level"] = rmeds.Level
	}
	if rmeds.OperationName != nil {
		objectMap["operationName"] = rmeds.OperationName
	}
	if rmeds.ResourceGroupName != nil {
		objectMap["resourceGroupName"] = rmeds.ResourceGroupName
	}
	if rmeds.ResourceProviderName != nil {
		objectMap["resourceProviderName"] = rmeds.ResourceProviderName
	}
	if rmeds.Status != nil {
		objectMap["status"] = rmeds.Status
	}
	if rmeds.SubStatus != nil {
		objectMap["subStatus"] = rmeds.SubStatus
	}
	if rmeds.Claims != nil {
		objectMap["claims"] = rmeds.Claims
	}
	if rmeds.ResourceURI != nil {
		objectMap["resourceUri"] = rmeds.ResourceURI
	}
	if rmeds.LegacyResourceID != nil {
		objectMap["legacyResourceId"] = rmeds.LegacyResourceID
	}
	if rmeds.ResourceLocation != nil {
		objectMap["resourceLocation"] = rmeds.ResourceLocation
	}
	if rmeds.MetricNamespace != nil {
		objectMap["metricNamespace"] = rmeds.MetricNamespace
	}
	if rmeds.OdataType != "" {
		objectMap["odata.type"] = rmeds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return &rmeds, true
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return nil, false
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rmeds, true
}

// RuleMetricDataSource a rule metric data source. The discriminator value is always RuleMetricDataSource
// in this case.
type RuleMetricDataSource struct {
	// MetricName - the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// LegacyResourceID - the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`
	// ResourceLocation - the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// MetricNamespace - the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleMetricDataSource.
func (rmds RuleMetricDataSource) MarshalJSON() ([]byte, error) {
	rmds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource
	objectMap := make(map[string]interface{})
	if rmds.MetricName != nil {
		objectMap["metricName"] = rmds.MetricName
	}
	if rmds.ResourceURI != nil {
		objectMap["resourceUri"] = rmds.ResourceURI
	}
	if rmds.LegacyResourceID != nil {
		objectMap["legacyResourceId"] = rmds.LegacyResourceID
	}
	if rmds.ResourceLocation != nil {
		objectMap["resourceLocation"] = rmds.ResourceLocation
	}
	if rmds.MetricNamespace != nil {
		objectMap["metricNamespace"] = rmds.MetricNamespace
	}
	if rmds.OdataType != "" {
		objectMap["odata.type"] = rmds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return &rmds, true
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return nil, false
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rmds, true
}

// RuleWebhookAction specifies the action to post to service when the rule condition is evaluated. The
// discriminator is always RuleWebhookAction in this case.
type RuleWebhookAction struct {
	// ServiceURI - the service uri to Post the notification when the alert activates or resolves.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// Properties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	Properties map[string]*string `json:"properties"`
	// OdataType - Possible values include: 'OdataTypeRuleAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleWebhookAction.
func (rwa RuleWebhookAction) MarshalJSON() ([]byte, error) {
	rwa.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction
	objectMap := make(map[string]interface{})
	if rwa.ServiceURI != nil {
		objectMap["serviceUri"] = rwa.ServiceURI
	}
	if rwa.Properties != nil {
		objectMap["properties"] = rwa.Properties
	}
	if rwa.OdataType != "" {
		objectMap["odata.type"] = rwa.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return &rwa, true
}

// AsRuleAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleAction() (*RuleAction, bool) {
	return nil, false
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &rwa, true
}

// ScaleAction the parameters for the scaling action.
type ScaleAction struct {
	// Direction - the scale direction. Whether the scaling action increases or decreases the number of instances. Possible values include: 'ScaleDirectionNone', 'ScaleDirectionIncrease', 'ScaleDirectionDecrease'
	Direction ScaleDirection `json:"direction,omitempty"`
	// Type - the type of action that should occur when the scale rule fires. Possible values include: 'ChangeCount', 'PercentChangeCount', 'ExactCount', 'ServiceAllowedNextValue'
	Type ScaleType `json:"type,omitempty"`
	// Value - the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
	Value *string `json:"value,omitempty"`
	// Cooldown - the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
	Cooldown *string `json:"cooldown,omitempty"`
}

// ScaleCapacity the number of instances that can be used during this profile.
type ScaleCapacity struct {
	// Minimum - the minimum number of instances for the resource.
	Minimum *string `json:"minimum,omitempty"`
	// Maximum - the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
	Maximum *string `json:"maximum,omitempty"`
	// Default - the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
	Default *string `json:"default,omitempty"`
}

// ScaleRule a rule that provide the triggers and parameters for the scaling action.
type ScaleRule struct {
	// MetricTrigger - the trigger that results in a scaling action.
	MetricTrigger *MetricTrigger `json:"metricTrigger,omitempty"`
	// ScaleAction - the parameters for the scaling action.
	ScaleAction *ScaleAction `json:"scaleAction,omitempty"`
}

// ScaleRuleMetricDimension specifies an auto scale rule metric dimension.
type ScaleRuleMetricDimension struct {
	// DimensionName - Name of the dimension.
	DimensionName *string `json:"DimensionName,omitempty"`
	// Operator - the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values. Possible values include: 'ScaleRuleMetricDimensionOperationTypeEquals', 'ScaleRuleMetricDimensionOperationTypeNotEquals'
	Operator ScaleRuleMetricDimensionOperationType `json:"Operator,omitempty"`
	// Values - list of dimension values. For example: ["App1","App2"].
	Values *[]string `json:"Values,omitempty"`
}

// ScheduledQueryRuleCriteria the rule criteria that defines the conditions of the scheduled query rule.
type ScheduledQueryRuleCriteria struct {
	// AllOf - A list of conditions to evaluate against the specified scopes
	AllOf *[]Condition `json:"allOf,omitempty"`
}

// ScheduledQueryRuleProperties scheduled query rule Definition
type ScheduledQueryRuleProperties struct {
	// CreatedWithAPIVersion - READ-ONLY; The api-version used when creating this alert rule
	CreatedWithAPIVersion *string `json:"createdWithApiVersion,omitempty"`
	// IsLegacyLogAnalyticsRule - READ-ONLY; True if alert rule is legacy Log Analytic rule
	IsLegacyLogAnalyticsRule *bool `json:"isLegacyLogAnalyticsRule,omitempty"`
	// Description - The description of the scheduled query rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name of the alert rule
	DisplayName *string `json:"displayName,omitempty"`
	// Severity - Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert.
	Severity *int64 `json:"severity,omitempty"`
	// Enabled - The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
	Enabled *bool `json:"enabled,omitempty"`
	// Scopes - The list of resource id's that this scheduled query rule is scoped to.
	Scopes *[]string `json:"scopes,omitempty"`
	// EvaluationFrequency - How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`
	// WindowSize - The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
	WindowSize *string `json:"windowSize,omitempty"`
	// OverrideQueryTimeRange - If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
	OverrideQueryTimeRange *string `json:"overrideQueryTimeRange,omitempty"`
	// TargetResourceTypes - List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
	TargetResourceTypes *[]string `json:"targetResourceTypes,omitempty"`
	// Criteria - The rule criteria that defines the conditions of the scheduled query rule.
	Criteria *ScheduledQueryRuleCriteria `json:"criteria,omitempty"`
	// MuteActionsDuration - Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
	MuteActionsDuration *string `json:"muteActionsDuration,omitempty"`
	// Actions - Actions to invoke when the alert fires.
	Actions *Actions `json:"actions,omitempty"`
	// IsWorkspaceAlertsStorageConfigured - READ-ONLY; The flag which indicates whether this scheduled query rule has been configured to be stored in the customer's storage. The default is false.
	IsWorkspaceAlertsStorageConfigured *bool `json:"isWorkspaceAlertsStorageConfigured,omitempty"`
	// CheckWorkspaceAlertsStorageConfigured - The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert.
	CheckWorkspaceAlertsStorageConfigured *bool `json:"checkWorkspaceAlertsStorageConfigured,omitempty"`
	// SkipQueryValidation - The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert.
	SkipQueryValidation *bool `json:"skipQueryValidation,omitempty"`
	// AutoMitigate - The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledQueryRuleProperties.
func (sqrp ScheduledQueryRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sqrp.Description != nil {
		objectMap["description"] = sqrp.Description
	}
	if sqrp.DisplayName != nil {
		objectMap["displayName"] = sqrp.DisplayName
	}
	if sqrp.Severity != nil {
		objectMap["severity"] = sqrp.Severity
	}
	if sqrp.Enabled != nil {
		objectMap["enabled"] = sqrp.Enabled
	}
	if sqrp.Scopes != nil {
		objectMap["scopes"] = sqrp.Scopes
	}
	if sqrp.EvaluationFrequency != nil {
		objectMap["evaluationFrequency"] = sqrp.EvaluationFrequency
	}
	if sqrp.WindowSize != nil {
		objectMap["windowSize"] = sqrp.WindowSize
	}
	if sqrp.OverrideQueryTimeRange != nil {
		objectMap["overrideQueryTimeRange"] = sqrp.OverrideQueryTimeRange
	}
	if sqrp.TargetResourceTypes != nil {
		objectMap["targetResourceTypes"] = sqrp.TargetResourceTypes
	}
	if sqrp.Criteria != nil {
		objectMap["criteria"] = sqrp.Criteria
	}
	if sqrp.MuteActionsDuration != nil {
		objectMap["muteActionsDuration"] = sqrp.MuteActionsDuration
	}
	if sqrp.Actions != nil {
		objectMap["actions"] = sqrp.Actions
	}
	if sqrp.CheckWorkspaceAlertsStorageConfigured != nil {
		objectMap["checkWorkspaceAlertsStorageConfigured"] = sqrp.CheckWorkspaceAlertsStorageConfigured
	}
	if sqrp.SkipQueryValidation != nil {
		objectMap["skipQueryValidation"] = sqrp.SkipQueryValidation
	}
	if sqrp.AutoMitigate != nil {
		objectMap["autoMitigate"] = sqrp.AutoMitigate
	}
	return json.Marshal(objectMap)
}

// ScheduledQueryRuleResource the scheduled query rule resource.
type ScheduledQueryRuleResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Kind - Indicates the type of scheduled query rule. The default is LogAlert. Possible values include: 'LogAlert', 'LogToMetric'
	Kind Kind `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; SystemData of ScheduledQueryRule.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ScheduledQueryRuleProperties - The rule properties of the resource.
	*ScheduledQueryRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledQueryRuleResource.
func (sqrr ScheduledQueryRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sqrr.Tags != nil {
		objectMap["tags"] = sqrr.Tags
	}
	if sqrr.Location != nil {
		objectMap["location"] = sqrr.Location
	}
	if sqrr.Kind != "" {
		objectMap["kind"] = sqrr.Kind
	}
	if sqrr.ScheduledQueryRuleProperties != nil {
		objectMap["properties"] = sqrr.ScheduledQueryRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduledQueryRuleResource struct.
func (sqrr *ScheduledQueryRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sqrr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sqrr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sqrr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sqrr.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sqrr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sqrr.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sqrr.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sqrr.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var scheduledQueryRuleProperties ScheduledQueryRuleProperties
				err = json.Unmarshal(*v, &scheduledQueryRuleProperties)
				if err != nil {
					return err
				}
				sqrr.ScheduledQueryRuleProperties = &scheduledQueryRuleProperties
			}
		}
	}

	return nil
}

// ScheduledQueryRuleResourceCollection represents a collection of scheduled query rule resources.
type ScheduledQueryRuleResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The values for the scheduled query rule resources.
	Value *[]ScheduledQueryRuleResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledQueryRuleResourceCollection.
func (sqrrc ScheduledQueryRuleResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sqrrc.Value != nil {
		objectMap["value"] = sqrrc.Value
	}
	return json.Marshal(objectMap)
}

// ScheduledQueryRuleResourceCollectionIterator provides access to a complete listing of
// ScheduledQueryRuleResource values.
type ScheduledQueryRuleResourceCollectionIterator struct {
	i    int
	page ScheduledQueryRuleResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScheduledQueryRuleResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScheduledQueryRuleResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScheduledQueryRuleResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScheduledQueryRuleResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScheduledQueryRuleResourceCollectionIterator) Response() ScheduledQueryRuleResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScheduledQueryRuleResourceCollectionIterator) Value() ScheduledQueryRuleResource {
	if !iter.page.NotDone() {
		return ScheduledQueryRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScheduledQueryRuleResourceCollectionIterator type.
func NewScheduledQueryRuleResourceCollectionIterator(page ScheduledQueryRuleResourceCollectionPage) ScheduledQueryRuleResourceCollectionIterator {
	return ScheduledQueryRuleResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sqrrc ScheduledQueryRuleResourceCollection) IsEmpty() bool {
	return sqrrc.Value == nil || len(*sqrrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sqrrc ScheduledQueryRuleResourceCollection) hasNextLink() bool {
	return sqrrc.NextLink != nil && len(*sqrrc.NextLink) != 0
}

// scheduledQueryRuleResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sqrrc ScheduledQueryRuleResourceCollection) scheduledQueryRuleResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sqrrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sqrrc.NextLink)))
}

// ScheduledQueryRuleResourceCollectionPage contains a page of ScheduledQueryRuleResource values.
type ScheduledQueryRuleResourceCollectionPage struct {
	fn    func(context.Context, ScheduledQueryRuleResourceCollection) (ScheduledQueryRuleResourceCollection, error)
	sqrrc ScheduledQueryRuleResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScheduledQueryRuleResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScheduledQueryRuleResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sqrrc)
		if err != nil {
			return err
		}
		page.sqrrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScheduledQueryRuleResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScheduledQueryRuleResourceCollectionPage) NotDone() bool {
	return !page.sqrrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScheduledQueryRuleResourceCollectionPage) Response() ScheduledQueryRuleResourceCollection {
	return page.sqrrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScheduledQueryRuleResourceCollectionPage) Values() []ScheduledQueryRuleResource {
	if page.sqrrc.IsEmpty() {
		return nil
	}
	return *page.sqrrc.Value
}

// Creates a new instance of the ScheduledQueryRuleResourceCollectionPage type.
func NewScheduledQueryRuleResourceCollectionPage(cur ScheduledQueryRuleResourceCollection, getNextPage func(context.Context, ScheduledQueryRuleResourceCollection) (ScheduledQueryRuleResourceCollection, error)) ScheduledQueryRuleResourceCollectionPage {
	return ScheduledQueryRuleResourceCollectionPage{
		fn:    getNextPage,
		sqrrc: cur,
	}
}

// ScheduledQueryRuleResourcePatch the scheduled query rule resource for patch operations.
type ScheduledQueryRuleResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ScheduledQueryRuleProperties - The scheduled query rule properties of the resource.
	*ScheduledQueryRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledQueryRuleResourcePatch.
func (sqrrp ScheduledQueryRuleResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sqrrp.Tags != nil {
		objectMap["tags"] = sqrrp.Tags
	}
	if sqrrp.ScheduledQueryRuleProperties != nil {
		objectMap["properties"] = sqrrp.ScheduledQueryRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduledQueryRuleResourcePatch struct.
func (sqrrp *ScheduledQueryRuleResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sqrrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var scheduledQueryRuleProperties ScheduledQueryRuleProperties
				err = json.Unmarshal(*v, &scheduledQueryRuleProperties)
				if err != nil {
					return err
				}
				sqrrp.ScheduledQueryRuleProperties = &scheduledQueryRuleProperties
			}
		}
	}

	return nil
}

// ScopedResource a private link scoped resource
type ScopedResource struct {
	autorest.Response `json:"-"`
	// ScopedResourceProperties - Resource properties.
	*ScopedResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopedResource.
func (sr ScopedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.ScopedResourceProperties != nil {
		objectMap["properties"] = sr.ScopedResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopedResource struct.
func (sr *ScopedResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scopedResourceProperties ScopedResourceProperties
				err = json.Unmarshal(*v, &scopedResourceProperties)
				if err != nil {
					return err
				}
				sr.ScopedResourceProperties = &scopedResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		}
	}

	return nil
}

// ScopedResourceListResult a list of scoped resources in a private link scope.
type ScopedResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ScopedResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopedResourceListResult.
func (srlr ScopedResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScopedResourceListResultIterator provides access to a complete listing of ScopedResource values.
type ScopedResourceListResultIterator struct {
	i    int
	page ScopedResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScopedResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopedResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScopedResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScopedResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScopedResourceListResultIterator) Response() ScopedResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScopedResourceListResultIterator) Value() ScopedResource {
	if !iter.page.NotDone() {
		return ScopedResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScopedResourceListResultIterator type.
func NewScopedResourceListResultIterator(page ScopedResourceListResultPage) ScopedResourceListResultIterator {
	return ScopedResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srlr ScopedResourceListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srlr ScopedResourceListResult) hasNextLink() bool {
	return srlr.NextLink != nil && len(*srlr.NextLink) != 0
}

// scopedResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr ScopedResourceListResult) scopedResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !srlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// ScopedResourceListResultPage contains a page of ScopedResource values.
type ScopedResourceListResultPage struct {
	fn   func(context.Context, ScopedResourceListResult) (ScopedResourceListResult, error)
	srlr ScopedResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScopedResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopedResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srlr)
		if err != nil {
			return err
		}
		page.srlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScopedResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScopedResourceListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScopedResourceListResultPage) Response() ScopedResourceListResult {
	return page.srlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScopedResourceListResultPage) Values() []ScopedResource {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// Creates a new instance of the ScopedResourceListResultPage type.
func NewScopedResourceListResultPage(cur ScopedResourceListResult, getNextPage func(context.Context, ScopedResourceListResult) (ScopedResourceListResult, error)) ScopedResourceListResultPage {
	return ScopedResourceListResultPage{
		fn:   getNextPage,
		srlr: cur,
	}
}

// ScopedResourceProperties properties of a private link scoped resource.
type ScopedResourceProperties struct {
	// LinkedResourceID - The resource id of the scoped Azure monitor resource.
	LinkedResourceID *string `json:"linkedResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopedResourceProperties.
func (srp ScopedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srp.LinkedResourceID != nil {
		objectMap["linkedResourceId"] = srp.LinkedResourceID
	}
	return json.Marshal(objectMap)
}

// SenderAuthorization the authorization used by the user who has performed the operation that led to this
// event. This captures the RBAC properties of the event. These usually include the 'action', 'role' and
// the 'scope'
type SenderAuthorization struct {
	// Action - the permissible actions. For instance: microsoft.support/supporttickets/write
	Action *string `json:"action,omitempty"`
	// Role - the role of the user. For instance: Subscription Admin
	Role *string `json:"role,omitempty"`
	// Scope - the scope.
	Scope *string `json:"scope,omitempty"`
}

// SingleBaseline the baseline values for a single sensitivity value.
type SingleBaseline struct {
	// Sensitivity - the sensitivity of the baseline. Possible values include: 'Low', 'Medium', 'High'
	Sensitivity BaselineSensitivity `json:"sensitivity,omitempty"`
	// LowThresholds - The low thresholds of the baseline.
	LowThresholds *[]float64 `json:"lowThresholds,omitempty"`
	// HighThresholds - The high thresholds of the baseline.
	HighThresholds *[]float64 `json:"highThresholds,omitempty"`
}

// SingleMetricBaseline the baseline results of a single metric.
type SingleMetricBaseline struct {
	// ID - The metric baseline Id.
	ID *string `json:"id,omitempty"`
	// Type - The resource type of the metric baseline resource.
	Type *string `json:"type,omitempty"`
	// Name - The name of the metric for which the baselines were retrieved.
	Name *string `json:"name,omitempty"`
	// MetricBaselinesProperties - The metric baseline properties of the metric.
	*MetricBaselinesProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SingleMetricBaseline.
func (smb SingleMetricBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smb.ID != nil {
		objectMap["id"] = smb.ID
	}
	if smb.Type != nil {
		objectMap["type"] = smb.Type
	}
	if smb.Name != nil {
		objectMap["name"] = smb.Name
	}
	if smb.MetricBaselinesProperties != nil {
		objectMap["properties"] = smb.MetricBaselinesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SingleMetricBaseline struct.
func (smb *SingleMetricBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smb.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smb.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smb.Name = &name
			}
		case "properties":
			if v != nil {
				var metricBaselinesProperties MetricBaselinesProperties
				err = json.Unmarshal(*v, &metricBaselinesProperties)
				if err != nil {
					return err
				}
				smb.MetricBaselinesProperties = &metricBaselinesProperties
			}
		}
	}

	return nil
}

// SmsReceiver an SMS receiver.
type SmsReceiver struct {
	// Name - The name of the SMS receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// CountryCode - The country code of the SMS receiver.
	CountryCode *string `json:"countryCode,omitempty"`
	// PhoneNumber - The phone number of the SMS receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
	// Status - READ-ONLY; The status of the receiver. Possible values include: 'ReceiverStatusNotSpecified', 'ReceiverStatusEnabled', 'ReceiverStatusDisabled'
	Status ReceiverStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for SmsReceiver.
func (sr SmsReceiver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.CountryCode != nil {
		objectMap["countryCode"] = sr.CountryCode
	}
	if sr.PhoneNumber != nil {
		objectMap["phoneNumber"] = sr.PhoneNumber
	}
	return json.Marshal(objectMap)
}

// StreamDeclaration declaration of a custom stream.
type StreamDeclaration struct {
	// Columns - List of columns used by data in this stream.
	Columns *[]ColumnDefinition `json:"columns,omitempty"`
}

// SyslogDataSource definition of which syslog data will be collected and how it will be collected.
// Only collected from Linux machines.
type SyslogDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownSyslogDataSourceStreams `json:"streams,omitempty"`
	// FacilityNames - The list of facility names.
	FacilityNames *[]KnownSyslogDataSourceFacilityNames `json:"facilityNames,omitempty"`
	// LogLevels - The log levels to collect.
	LogLevels *[]KnownSyslogDataSourceLogLevels `json:"logLevels,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// PrivateLinkScope instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TestNotificationDetailsResponse the details of the test notification results.
type TestNotificationDetailsResponse struct {
	autorest.Response `json:"-"`
	Context           *Context `json:"context,omitempty"`
	// State - The overall state
	State *string `json:"state,omitempty"`
	// CompletedTime - The completed time
	CompletedTime *string `json:"completedTime,omitempty"`
	// CreatedTime - The created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// ActionDetails - The list of action detail
	ActionDetails *[]ActionDetail `json:"actionDetails,omitempty"`
}

// ThresholdRuleCondition a rule condition based on a metric crossing a threshold.
type ThresholdRuleCondition struct {
	// Operator - the operator used to compare the data and the threshold. Possible values include: 'ConditionOperatorGreaterThan', 'ConditionOperatorGreaterThanOrEqual', 'ConditionOperatorLessThan', 'ConditionOperatorLessThanOrEqual'
	Operator ConditionOperator `json:"operator,omitempty"`
	// Threshold - the threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
	// TimeAggregation - the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric. Possible values include: 'TimeAggregationOperatorAverage', 'TimeAggregationOperatorMinimum', 'TimeAggregationOperatorMaximum', 'TimeAggregationOperatorTotal', 'TimeAggregationOperatorLast'
	TimeAggregation TimeAggregationOperator `json:"timeAggregation,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	trc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition
	objectMap := make(map[string]interface{})
	if trc.Operator != "" {
		objectMap["operator"] = trc.Operator
	}
	if trc.Threshold != nil {
		objectMap["threshold"] = trc.Threshold
	}
	if trc.WindowSize != nil {
		objectMap["windowSize"] = trc.WindowSize
	}
	if trc.TimeAggregation != "" {
		objectMap["timeAggregation"] = trc.TimeAggregation
	}
	objectMap["dataSource"] = trc.DataSource
	if trc.OdataType != "" {
		objectMap["odata.type"] = trc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return &trc, true
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &trc, true
}

// UnmarshalJSON is the custom unmarshaler for ThresholdRuleCondition struct.
func (trc *ThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "operator":
			if v != nil {
				var operator ConditionOperator
				err = json.Unmarshal(*v, &operator)
				if err != nil {
					return err
				}
				trc.Operator = operator
			}
		case "threshold":
			if v != nil {
				var threshold float64
				err = json.Unmarshal(*v, &threshold)
				if err != nil {
					return err
				}
				trc.Threshold = &threshold
			}
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				trc.WindowSize = &windowSize
			}
		case "timeAggregation":
			if v != nil {
				var timeAggregation TimeAggregationOperator
				err = json.Unmarshal(*v, &timeAggregation)
				if err != nil {
					return err
				}
				trc.TimeAggregation = timeAggregation
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				trc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				trc.OdataType = odataType
			}
		}
	}

	return nil
}

// TimeSeriesBaseline the baseline values for a single time series.
type TimeSeriesBaseline struct {
	// Aggregation - The aggregation type of the metric.
	Aggregation *string `json:"aggregation,omitempty"`
	// Dimensions - The dimensions of this time series.
	Dimensions *[]MetricSingleDimension `json:"dimensions,omitempty"`
	// Timestamps - The list of timestamps of the baselines.
	Timestamps *[]date.Time `json:"timestamps,omitempty"`
	// Data - The baseline values for each sensitivity.
	Data *[]SingleBaseline `json:"data,omitempty"`
	// MetadataValues - The baseline metadata values.
	MetadataValues *[]BaselineMetadata `json:"metadataValues,omitempty"`
}

// TimeSeriesElement a time series result type. The discriminator value is always TimeSeries in this case.
type TimeSeriesElement struct {
	// Metadatavalues - the metadata values returned if $filter was specified in the call.
	Metadatavalues *[]MetadataValue `json:"metadatavalues,omitempty"`
	// Data - An array of data points representing the metric values.  This is only returned if a result type of data is specified.
	Data *[]MetricValue `json:"data,omitempty"`
}

// TimeWindow a specific date-time for the profile.
type TimeWindow struct {
	// TimeZone - the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// Start - the start time for the profile in ISO 8601 format.
	Start *date.Time `json:"start,omitempty"`
	// End - the end time for the profile in ISO 8601 format.
	End *date.Time `json:"end,omitempty"`
}

// VMInsightsOnboardingStatus VM Insights onboarding status for a resource.
type VMInsightsOnboardingStatus struct {
	autorest.Response `json:"-"`
	// VMInsightsOnboardingStatusProperties - Resource properties.
	*VMInsightsOnboardingStatusProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VMInsightsOnboardingStatus.
func (vios VMInsightsOnboardingStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vios.VMInsightsOnboardingStatusProperties != nil {
		objectMap["properties"] = vios.VMInsightsOnboardingStatusProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VMInsightsOnboardingStatus struct.
func (vios *VMInsightsOnboardingStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var VMInsightsOnboardingStatusProperties VMInsightsOnboardingStatusProperties
				err = json.Unmarshal(*v, &VMInsightsOnboardingStatusProperties)
				if err != nil {
					return err
				}
				vios.VMInsightsOnboardingStatusProperties = &VMInsightsOnboardingStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vios.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vios.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vios.Type = &typeVar
			}
		}
	}

	return nil
}

// VMInsightsOnboardingStatusProperties resource properties.
type VMInsightsOnboardingStatusProperties struct {
	// ResourceID - Azure Resource Manager identifier of the resource whose onboarding status is being represented.
	ResourceID *string `json:"resourceId,omitempty"`
	// OnboardingStatus - The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription, is considered onboarded if at least one resource under it is onboarded. Possible values include: 'Onboarded', 'NotOnboarded', 'Unknown'
	OnboardingStatus OnboardingStatus `json:"onboardingStatus,omitempty"`
	// DataStatus - The status of VM Insights data from the resource. When reported as `present` the data array will contain information about the data containers to which data for the specified resource is being routed. Possible values include: 'Present', 'NotPresent'
	DataStatus DataStatus `json:"dataStatus,omitempty"`
	// Data - Containers that currently store VM Insights data for the specified resource.
	Data *[]DataContainer `json:"data,omitempty"`
}

// VoiceReceiver a voice receiver.
type VoiceReceiver struct {
	// Name - The name of the voice receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// CountryCode - The country code of the voice receiver.
	CountryCode *string `json:"countryCode,omitempty"`
	// PhoneNumber - The phone number of the voice receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// WebhookNotification webhook notification of an autoscale event.
type WebhookNotification struct {
	// ServiceURI - the service address to receive the notification.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// Properties - a property bag of settings. This value can be empty.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for WebhookNotification.
func (wn WebhookNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wn.ServiceURI != nil {
		objectMap["serviceUri"] = wn.ServiceURI
	}
	if wn.Properties != nil {
		objectMap["properties"] = wn.Properties
	}
	return json.Marshal(objectMap)
}

// WebhookReceiver a webhook receiver.
type WebhookReceiver struct {
	// Name - The name of the webhook receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// ServiceURI - The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
	// UseAadAuth - Indicates whether or not use AAD authentication.
	UseAadAuth *bool `json:"useAadAuth,omitempty"`
	// ObjectID - Indicates the webhook app object Id for aad auth.
	ObjectID *string `json:"objectId,omitempty"`
	// IdentifierURI - Indicates the identifier uri for aad auth.
	IdentifierURI *string `json:"identifierUri,omitempty"`
	// TenantID - Indicates the tenant id for aad auth.
	TenantID *string `json:"tenantId,omitempty"`
}

// WebtestLocationAvailabilityCriteria specifies the metric alert rule criteria for a web test resource.
type WebtestLocationAvailabilityCriteria struct {
	// WebTestID - The Application Insights web test Id.
	WebTestID *string `json:"webTestId,omitempty"`
	// ComponentID - The Application Insights resource Id.
	ComponentID *string `json:"componentId,omitempty"`
	// FailedLocationCount - The number of failed locations.
	FailedLocationCount *float64 `json:"failedLocationCount,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// OdataType - Possible values include: 'OdataTypeMetricAlertCriteria', 'OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria', 'OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria', 'OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria'
	OdataType OdataTypeBasicMetricAlertCriteria `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for WebtestLocationAvailabilityCriteria.
func (wlac WebtestLocationAvailabilityCriteria) MarshalJSON() ([]byte, error) {
	wlac.OdataType = OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria
	objectMap := make(map[string]interface{})
	if wlac.WebTestID != nil {
		objectMap["webTestId"] = wlac.WebTestID
	}
	if wlac.ComponentID != nil {
		objectMap["componentId"] = wlac.ComponentID
	}
	if wlac.FailedLocationCount != nil {
		objectMap["failedLocationCount"] = wlac.FailedLocationCount
	}
	if wlac.OdataType != "" {
		objectMap["odata.type"] = wlac.OdataType
	}
	for k, v := range wlac.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsMetricAlertSingleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for WebtestLocationAvailabilityCriteria.
func (wlac WebtestLocationAvailabilityCriteria) AsMetricAlertSingleResourceMultipleMetricCriteria() (*MetricAlertSingleResourceMultipleMetricCriteria, bool) {
	return nil, false
}

// AsWebtestLocationAvailabilityCriteria is the BasicMetricAlertCriteria implementation for WebtestLocationAvailabilityCriteria.
func (wlac WebtestLocationAvailabilityCriteria) AsWebtestLocationAvailabilityCriteria() (*WebtestLocationAvailabilityCriteria, bool) {
	return &wlac, true
}

// AsMetricAlertMultipleResourceMultipleMetricCriteria is the BasicMetricAlertCriteria implementation for WebtestLocationAvailabilityCriteria.
func (wlac WebtestLocationAvailabilityCriteria) AsMetricAlertMultipleResourceMultipleMetricCriteria() (*MetricAlertMultipleResourceMultipleMetricCriteria, bool) {
	return nil, false
}

// AsMetricAlertCriteria is the BasicMetricAlertCriteria implementation for WebtestLocationAvailabilityCriteria.
func (wlac WebtestLocationAvailabilityCriteria) AsMetricAlertCriteria() (*MetricAlertCriteria, bool) {
	return nil, false
}

// AsBasicMetricAlertCriteria is the BasicMetricAlertCriteria implementation for WebtestLocationAvailabilityCriteria.
func (wlac WebtestLocationAvailabilityCriteria) AsBasicMetricAlertCriteria() (BasicMetricAlertCriteria, bool) {
	return &wlac, true
}

// UnmarshalJSON is the custom unmarshaler for WebtestLocationAvailabilityCriteria struct.
func (wlac *WebtestLocationAvailabilityCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "webTestId":
			if v != nil {
				var webTestID string
				err = json.Unmarshal(*v, &webTestID)
				if err != nil {
					return err
				}
				wlac.WebTestID = &webTestID
			}
		case "componentId":
			if v != nil {
				var componentID string
				err = json.Unmarshal(*v, &componentID)
				if err != nil {
					return err
				}
				wlac.ComponentID = &componentID
			}
		case "failedLocationCount":
			if v != nil {
				var failedLocationCount float64
				err = json.Unmarshal(*v, &failedLocationCount)
				if err != nil {
					return err
				}
				wlac.FailedLocationCount = &failedLocationCount
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if wlac.AdditionalProperties == nil {
					wlac.AdditionalProperties = make(map[string]interface{})
				}
				wlac.AdditionalProperties[k] = additionalProperties
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicMetricAlertCriteria
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				wlac.OdataType = odataType
			}
		}
	}

	return nil
}

// WindowsEventLogDataSource definition of which Windows Event Log events will be collected and how they
// will be collected.
// Only collected from Windows machines.
type WindowsEventLogDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownWindowsEventLogDataSourceStreams `json:"streams,omitempty"`
	// XPathQueries - A list of Windows Event Log queries in XPATH format.
	XPathQueries *[]string `json:"xPathQueries,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// WorkspaceInfo information about a Log Analytics Workspace.
type WorkspaceInfo struct {
	// ID - Azure Resource Manager identifier of the Log Analytics Workspace.
	ID *string `json:"id,omitempty"`
	// Location - Location of the Log Analytics workspace.
	Location *string `json:"location,omitempty"`
	// WorkspaceInfoProperties - Resource properties.
	*WorkspaceInfoProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceInfo.
func (wi WorkspaceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wi.ID != nil {
		objectMap["id"] = wi.ID
	}
	if wi.Location != nil {
		objectMap["location"] = wi.Location
	}
	if wi.WorkspaceInfoProperties != nil {
		objectMap["properties"] = wi.WorkspaceInfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceInfo struct.
func (wi *WorkspaceInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wi.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wi.Location = &location
			}
		case "properties":
			if v != nil {
				var workspaceInfoProperties WorkspaceInfoProperties
				err = json.Unmarshal(*v, &workspaceInfoProperties)
				if err != nil {
					return err
				}
				wi.WorkspaceInfoProperties = &workspaceInfoProperties
			}
		}
	}

	return nil
}

// WorkspaceInfoProperties resource properties.
type WorkspaceInfoProperties struct {
	// CustomerID - Log Analytics workspace identifier.
	CustomerID *string `json:"customerId,omitempty"`
}
