package datamigration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ActiveDirectoryIntegrated ...
	ActiveDirectoryIntegrated AuthenticationType = "ActiveDirectoryIntegrated"
	// ActiveDirectoryPassword ...
	ActiveDirectoryPassword AuthenticationType = "ActiveDirectoryPassword"
	// None ...
	None AuthenticationType = "None"
	// SQLAuthentication ...
	SQLAuthentication AuthenticationType = "SqlAuthentication"
	// WindowsAuthentication ...
	WindowsAuthentication AuthenticationType = "WindowsAuthentication"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ActiveDirectoryIntegrated, ActiveDirectoryPassword, None, SQLAuthentication, WindowsAuthentication}
}

// BackupFileStatus enumerates the values for backup file status.
type BackupFileStatus string

const (
	// Arrived ...
	Arrived BackupFileStatus = "Arrived"
	// Cancelled ...
	Cancelled BackupFileStatus = "Cancelled"
	// Queued ...
	Queued BackupFileStatus = "Queued"
	// Restored ...
	Restored BackupFileStatus = "Restored"
	// Restoring ...
	Restoring BackupFileStatus = "Restoring"
	// Uploaded ...
	Uploaded BackupFileStatus = "Uploaded"
	// Uploading ...
	Uploading BackupFileStatus = "Uploading"
)

// PossibleBackupFileStatusValues returns an array of possible values for the BackupFileStatus const type.
func PossibleBackupFileStatusValues() []BackupFileStatus {
	return []BackupFileStatus{Arrived, Cancelled, Queued, Restored, Restoring, Uploaded, Uploading}
}

// BackupMode enumerates the values for backup mode.
type BackupMode string

const (
	// CreateBackup ...
	CreateBackup BackupMode = "CreateBackup"
	// ExistingBackup ...
	ExistingBackup BackupMode = "ExistingBackup"
)

// PossibleBackupModeValues returns an array of possible values for the BackupMode const type.
func PossibleBackupModeValues() []BackupMode {
	return []BackupMode{CreateBackup, ExistingBackup}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// BackupTypeDatabase ...
	BackupTypeDatabase BackupType = "Database"
	// BackupTypeDifferentialDatabase ...
	BackupTypeDifferentialDatabase BackupType = "DifferentialDatabase"
	// BackupTypeDifferentialFile ...
	BackupTypeDifferentialFile BackupType = "DifferentialFile"
	// BackupTypeDifferentialPartial ...
	BackupTypeDifferentialPartial BackupType = "DifferentialPartial"
	// BackupTypeFile ...
	BackupTypeFile BackupType = "File"
	// BackupTypePartial ...
	BackupTypePartial BackupType = "Partial"
	// BackupTypeTransactionLog ...
	BackupTypeTransactionLog BackupType = "TransactionLog"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{BackupTypeDatabase, BackupTypeDifferentialDatabase, BackupTypeDifferentialFile, BackupTypeDifferentialPartial, BackupTypeFile, BackupTypePartial, BackupTypeTransactionLog}
}

// CommandState enumerates the values for command state.
type CommandState string

const (
	// Accepted ...
	Accepted CommandState = "Accepted"
	// Failed ...
	Failed CommandState = "Failed"
	// Running ...
	Running CommandState = "Running"
	// Succeeded ...
	Succeeded CommandState = "Succeeded"
	// Unknown ...
	Unknown CommandState = "Unknown"
)

// PossibleCommandStateValues returns an array of possible values for the CommandState const type.
func PossibleCommandStateValues() []CommandState {
	return []CommandState{Accepted, Failed, Running, Succeeded, Unknown}
}

// CommandType enumerates the values for command type.
type CommandType string

const (
	// CommandTypeCancel ...
	CommandTypeCancel CommandType = "cancel"
	// CommandTypeCommandProperties ...
	CommandTypeCommandProperties CommandType = "CommandProperties"
	// CommandTypeFinish ...
	CommandTypeFinish CommandType = "finish"
	// CommandTypeMigrateSQLServerAzureDbSQLMiComplete ...
	CommandTypeMigrateSQLServerAzureDbSQLMiComplete CommandType = "Migrate.SqlServer.AzureDbSqlMi.Complete"
	// CommandTypeMigrateSyncCompleteDatabase ...
	CommandTypeMigrateSyncCompleteDatabase CommandType = "Migrate.Sync.Complete.Database"
	// CommandTypeRestart ...
	CommandTypeRestart CommandType = "restart"
)

// PossibleCommandTypeValues returns an array of possible values for the CommandType const type.
func PossibleCommandTypeValues() []CommandType {
	return []CommandType{CommandTypeCancel, CommandTypeCommandProperties, CommandTypeFinish, CommandTypeMigrateSQLServerAzureDbSQLMiComplete, CommandTypeMigrateSyncCompleteDatabase, CommandTypeRestart}
}

// DatabaseCompatLevel enumerates the values for database compat level.
type DatabaseCompatLevel string

const (
	// CompatLevel100 ...
	CompatLevel100 DatabaseCompatLevel = "CompatLevel100"
	// CompatLevel110 ...
	CompatLevel110 DatabaseCompatLevel = "CompatLevel110"
	// CompatLevel120 ...
	CompatLevel120 DatabaseCompatLevel = "CompatLevel120"
	// CompatLevel130 ...
	CompatLevel130 DatabaseCompatLevel = "CompatLevel130"
	// CompatLevel140 ...
	CompatLevel140 DatabaseCompatLevel = "CompatLevel140"
	// CompatLevel80 ...
	CompatLevel80 DatabaseCompatLevel = "CompatLevel80"
	// CompatLevel90 ...
	CompatLevel90 DatabaseCompatLevel = "CompatLevel90"
)

// PossibleDatabaseCompatLevelValues returns an array of possible values for the DatabaseCompatLevel const type.
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return []DatabaseCompatLevel{CompatLevel100, CompatLevel110, CompatLevel120, CompatLevel130, CompatLevel140, CompatLevel80, CompatLevel90}
}

// DatabaseFileType enumerates the values for database file type.
type DatabaseFileType string

const (
	// Filestream ...
	Filestream DatabaseFileType = "Filestream"
	// Fulltext ...
	Fulltext DatabaseFileType = "Fulltext"
	// Log ...
	Log DatabaseFileType = "Log"
	// NotSupported ...
	NotSupported DatabaseFileType = "NotSupported"
	// Rows ...
	Rows DatabaseFileType = "Rows"
)

// PossibleDatabaseFileTypeValues returns an array of possible values for the DatabaseFileType const type.
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return []DatabaseFileType{Filestream, Fulltext, Log, NotSupported, Rows}
}

// DatabaseMigrationStage enumerates the values for database migration stage.
type DatabaseMigrationStage string

const (
	// DatabaseMigrationStageBackup ...
	DatabaseMigrationStageBackup DatabaseMigrationStage = "Backup"
	// DatabaseMigrationStageCompleted ...
	DatabaseMigrationStageCompleted DatabaseMigrationStage = "Completed"
	// DatabaseMigrationStageFileCopy ...
	DatabaseMigrationStageFileCopy DatabaseMigrationStage = "FileCopy"
	// DatabaseMigrationStageInitialize ...
	DatabaseMigrationStageInitialize DatabaseMigrationStage = "Initialize"
	// DatabaseMigrationStageNone ...
	DatabaseMigrationStageNone DatabaseMigrationStage = "None"
	// DatabaseMigrationStageRestore ...
	DatabaseMigrationStageRestore DatabaseMigrationStage = "Restore"
)

// PossibleDatabaseMigrationStageValues returns an array of possible values for the DatabaseMigrationStage const type.
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return []DatabaseMigrationStage{DatabaseMigrationStageBackup, DatabaseMigrationStageCompleted, DatabaseMigrationStageFileCopy, DatabaseMigrationStageInitialize, DatabaseMigrationStageNone, DatabaseMigrationStageRestore}
}

// DatabaseMigrationState enumerates the values for database migration state.
type DatabaseMigrationState string

const (
	// CANCELLED ...
	CANCELLED DatabaseMigrationState = "CANCELLED"
	// COMPLETED ...
	COMPLETED DatabaseMigrationState = "COMPLETED"
	// CUTOVERSTART ...
	CUTOVERSTART DatabaseMigrationState = "CUTOVER_START"
	// FAILED ...
	FAILED DatabaseMigrationState = "FAILED"
	// FULLBACKUPUPLOADSTART ...
	FULLBACKUPUPLOADSTART DatabaseMigrationState = "FULL_BACKUP_UPLOAD_START"
	// INITIAL ...
	INITIAL DatabaseMigrationState = "INITIAL"
	// LOGSHIPPINGSTART ...
	LOGSHIPPINGSTART DatabaseMigrationState = "LOG_SHIPPING_START"
	// POSTCUTOVERCOMPLETE ...
	POSTCUTOVERCOMPLETE DatabaseMigrationState = "POST_CUTOVER_COMPLETE"
	// UNDEFINED ...
	UNDEFINED DatabaseMigrationState = "UNDEFINED"
	// UPLOADLOGFILESSTART ...
	UPLOADLOGFILESSTART DatabaseMigrationState = "UPLOAD_LOG_FILES_START"
)

// PossibleDatabaseMigrationStateValues returns an array of possible values for the DatabaseMigrationState const type.
func PossibleDatabaseMigrationStateValues() []DatabaseMigrationState {
	return []DatabaseMigrationState{CANCELLED, COMPLETED, CUTOVERSTART, FAILED, FULLBACKUPUPLOADSTART, INITIAL, LOGSHIPPINGSTART, POSTCUTOVERCOMPLETE, UNDEFINED, UPLOADLOGFILESSTART}
}

// DatabaseState enumerates the values for database state.
type DatabaseState string

const (
	// DatabaseStateCopying ...
	DatabaseStateCopying DatabaseState = "Copying"
	// DatabaseStateEmergency ...
	DatabaseStateEmergency DatabaseState = "Emergency"
	// DatabaseStateOffline ...
	DatabaseStateOffline DatabaseState = "Offline"
	// DatabaseStateOfflineSecondary ...
	DatabaseStateOfflineSecondary DatabaseState = "OfflineSecondary"
	// DatabaseStateOnline ...
	DatabaseStateOnline DatabaseState = "Online"
	// DatabaseStateRecovering ...
	DatabaseStateRecovering DatabaseState = "Recovering"
	// DatabaseStateRecoveryPending ...
	DatabaseStateRecoveryPending DatabaseState = "RecoveryPending"
	// DatabaseStateRestoring ...
	DatabaseStateRestoring DatabaseState = "Restoring"
	// DatabaseStateSuspect ...
	DatabaseStateSuspect DatabaseState = "Suspect"
)

// PossibleDatabaseStateValues returns an array of possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{DatabaseStateCopying, DatabaseStateEmergency, DatabaseStateOffline, DatabaseStateOfflineSecondary, DatabaseStateOnline, DatabaseStateRecovering, DatabaseStateRecoveryPending, DatabaseStateRestoring, DatabaseStateSuspect}
}

// ErrorType enumerates the values for error type.
type ErrorType string

const (
	// ErrorTypeDefault ...
	ErrorTypeDefault ErrorType = "Default"
	// ErrorTypeError ...
	ErrorTypeError ErrorType = "Error"
	// ErrorTypeWarning ...
	ErrorTypeWarning ErrorType = "Warning"
)

// PossibleErrorTypeValues returns an array of possible values for the ErrorType const type.
func PossibleErrorTypeValues() []ErrorType {
	return []ErrorType{ErrorTypeDefault, ErrorTypeError, ErrorTypeWarning}
}

// LoginMigrationStage enumerates the values for login migration stage.
type LoginMigrationStage string

const (
	// LoginMigrationStageAssignRoleMembership ...
	LoginMigrationStageAssignRoleMembership LoginMigrationStage = "AssignRoleMembership"
	// LoginMigrationStageAssignRoleOwnership ...
	LoginMigrationStageAssignRoleOwnership LoginMigrationStage = "AssignRoleOwnership"
	// LoginMigrationStageCompleted ...
	LoginMigrationStageCompleted LoginMigrationStage = "Completed"
	// LoginMigrationStageEstablishObjectPermissions ...
	LoginMigrationStageEstablishObjectPermissions LoginMigrationStage = "EstablishObjectPermissions"
	// LoginMigrationStageEstablishServerPermissions ...
	LoginMigrationStageEstablishServerPermissions LoginMigrationStage = "EstablishServerPermissions"
	// LoginMigrationStageEstablishUserMapping ...
	LoginMigrationStageEstablishUserMapping LoginMigrationStage = "EstablishUserMapping"
	// LoginMigrationStageInitialize ...
	LoginMigrationStageInitialize LoginMigrationStage = "Initialize"
	// LoginMigrationStageLoginMigration ...
	LoginMigrationStageLoginMigration LoginMigrationStage = "LoginMigration"
	// LoginMigrationStageNone ...
	LoginMigrationStageNone LoginMigrationStage = "None"
)

// PossibleLoginMigrationStageValues returns an array of possible values for the LoginMigrationStage const type.
func PossibleLoginMigrationStageValues() []LoginMigrationStage {
	return []LoginMigrationStage{LoginMigrationStageAssignRoleMembership, LoginMigrationStageAssignRoleOwnership, LoginMigrationStageCompleted, LoginMigrationStageEstablishObjectPermissions, LoginMigrationStageEstablishServerPermissions, LoginMigrationStageEstablishUserMapping, LoginMigrationStageInitialize, LoginMigrationStageLoginMigration, LoginMigrationStageNone}
}

// LoginType enumerates the values for login type.
type LoginType string

const (
	// AsymmetricKey ...
	AsymmetricKey LoginType = "AsymmetricKey"
	// Certificate ...
	Certificate LoginType = "Certificate"
	// ExternalGroup ...
	ExternalGroup LoginType = "ExternalGroup"
	// ExternalUser ...
	ExternalUser LoginType = "ExternalUser"
	// SQLLogin ...
	SQLLogin LoginType = "SqlLogin"
	// WindowsGroup ...
	WindowsGroup LoginType = "WindowsGroup"
	// WindowsUser ...
	WindowsUser LoginType = "WindowsUser"
)

// PossibleLoginTypeValues returns an array of possible values for the LoginType const type.
func PossibleLoginTypeValues() []LoginType {
	return []LoginType{AsymmetricKey, Certificate, ExternalGroup, ExternalUser, SQLLogin, WindowsGroup, WindowsUser}
}

// MigrationState enumerates the values for migration state.
type MigrationState string

const (
	// MigrationStateCompleted ...
	MigrationStateCompleted MigrationState = "Completed"
	// MigrationStateFailed ...
	MigrationStateFailed MigrationState = "Failed"
	// MigrationStateInProgress ...
	MigrationStateInProgress MigrationState = "InProgress"
	// MigrationStateNone ...
	MigrationStateNone MigrationState = "None"
	// MigrationStateSkipped ...
	MigrationStateSkipped MigrationState = "Skipped"
	// MigrationStateStopped ...
	MigrationStateStopped MigrationState = "Stopped"
	// MigrationStateWarning ...
	MigrationStateWarning MigrationState = "Warning"
)

// PossibleMigrationStateValues returns an array of possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{MigrationStateCompleted, MigrationStateFailed, MigrationStateInProgress, MigrationStateNone, MigrationStateSkipped, MigrationStateStopped, MigrationStateWarning}
}

// MigrationStatus enumerates the values for migration status.
type MigrationStatus string

const (
	// MigrationStatusCompleted ...
	MigrationStatusCompleted MigrationStatus = "Completed"
	// MigrationStatusCompletedWithWarnings ...
	MigrationStatusCompletedWithWarnings MigrationStatus = "CompletedWithWarnings"
	// MigrationStatusConfigured ...
	MigrationStatusConfigured MigrationStatus = "Configured"
	// MigrationStatusConnecting ...
	MigrationStatusConnecting MigrationStatus = "Connecting"
	// MigrationStatusDefault ...
	MigrationStatusDefault MigrationStatus = "Default"
	// MigrationStatusError ...
	MigrationStatusError MigrationStatus = "Error"
	// MigrationStatusRunning ...
	MigrationStatusRunning MigrationStatus = "Running"
	// MigrationStatusSelectLogins ...
	MigrationStatusSelectLogins MigrationStatus = "SelectLogins"
	// MigrationStatusSourceAndTargetSelected ...
	MigrationStatusSourceAndTargetSelected MigrationStatus = "SourceAndTargetSelected"
	// MigrationStatusStopped ...
	MigrationStatusStopped MigrationStatus = "Stopped"
)

// PossibleMigrationStatusValues returns an array of possible values for the MigrationStatus const type.
func PossibleMigrationStatusValues() []MigrationStatus {
	return []MigrationStatus{MigrationStatusCompleted, MigrationStatusCompletedWithWarnings, MigrationStatusConfigured, MigrationStatusConnecting, MigrationStatusDefault, MigrationStatusError, MigrationStatusRunning, MigrationStatusSelectLogins, MigrationStatusSourceAndTargetSelected, MigrationStatusStopped}
}

// MongoDbClusterType enumerates the values for mongo db cluster type.
type MongoDbClusterType string

const (
	// BlobContainer ...
	BlobContainer MongoDbClusterType = "BlobContainer"
	// CosmosDb ...
	CosmosDb MongoDbClusterType = "CosmosDb"
	// MongoDb ...
	MongoDb MongoDbClusterType = "MongoDb"
)

// PossibleMongoDbClusterTypeValues returns an array of possible values for the MongoDbClusterType const type.
func PossibleMongoDbClusterTypeValues() []MongoDbClusterType {
	return []MongoDbClusterType{BlobContainer, CosmosDb, MongoDb}
}

// MongoDbErrorType enumerates the values for mongo db error type.
type MongoDbErrorType string

const (
	// MongoDbErrorTypeError ...
	MongoDbErrorTypeError MongoDbErrorType = "Error"
	// MongoDbErrorTypeValidationError ...
	MongoDbErrorTypeValidationError MongoDbErrorType = "ValidationError"
	// MongoDbErrorTypeWarning ...
	MongoDbErrorTypeWarning MongoDbErrorType = "Warning"
)

// PossibleMongoDbErrorTypeValues returns an array of possible values for the MongoDbErrorType const type.
func PossibleMongoDbErrorTypeValues() []MongoDbErrorType {
	return []MongoDbErrorType{MongoDbErrorTypeError, MongoDbErrorTypeValidationError, MongoDbErrorTypeWarning}
}

// MongoDbMigrationState enumerates the values for mongo db migration state.
type MongoDbMigrationState string

const (
	// MongoDbMigrationStateCanceled ...
	MongoDbMigrationStateCanceled MongoDbMigrationState = "Canceled"
	// MongoDbMigrationStateComplete ...
	MongoDbMigrationStateComplete MongoDbMigrationState = "Complete"
	// MongoDbMigrationStateCopying ...
	MongoDbMigrationStateCopying MongoDbMigrationState = "Copying"
	// MongoDbMigrationStateFailed ...
	MongoDbMigrationStateFailed MongoDbMigrationState = "Failed"
	// MongoDbMigrationStateFinalizing ...
	MongoDbMigrationStateFinalizing MongoDbMigrationState = "Finalizing"
	// MongoDbMigrationStateInitializing ...
	MongoDbMigrationStateInitializing MongoDbMigrationState = "Initializing"
	// MongoDbMigrationStateInitialReplay ...
	MongoDbMigrationStateInitialReplay MongoDbMigrationState = "InitialReplay"
	// MongoDbMigrationStateNotStarted ...
	MongoDbMigrationStateNotStarted MongoDbMigrationState = "NotStarted"
	// MongoDbMigrationStateReplaying ...
	MongoDbMigrationStateReplaying MongoDbMigrationState = "Replaying"
	// MongoDbMigrationStateRestarting ...
	MongoDbMigrationStateRestarting MongoDbMigrationState = "Restarting"
	// MongoDbMigrationStateValidatingInput ...
	MongoDbMigrationStateValidatingInput MongoDbMigrationState = "ValidatingInput"
)

// PossibleMongoDbMigrationStateValues returns an array of possible values for the MongoDbMigrationState const type.
func PossibleMongoDbMigrationStateValues() []MongoDbMigrationState {
	return []MongoDbMigrationState{MongoDbMigrationStateCanceled, MongoDbMigrationStateComplete, MongoDbMigrationStateCopying, MongoDbMigrationStateFailed, MongoDbMigrationStateFinalizing, MongoDbMigrationStateInitializing, MongoDbMigrationStateInitialReplay, MongoDbMigrationStateNotStarted, MongoDbMigrationStateReplaying, MongoDbMigrationStateRestarting, MongoDbMigrationStateValidatingInput}
}

// MongoDbReplication enumerates the values for mongo db replication.
type MongoDbReplication string

const (
	// Continuous ...
	Continuous MongoDbReplication = "Continuous"
	// Disabled ...
	Disabled MongoDbReplication = "Disabled"
	// OneTime ...
	OneTime MongoDbReplication = "OneTime"
)

// PossibleMongoDbReplicationValues returns an array of possible values for the MongoDbReplication const type.
func PossibleMongoDbReplicationValues() []MongoDbReplication {
	return []MongoDbReplication{Continuous, Disabled, OneTime}
}

// MongoDbShardKeyOrder enumerates the values for mongo db shard key order.
type MongoDbShardKeyOrder string

const (
	// Forward ...
	Forward MongoDbShardKeyOrder = "Forward"
	// Hashed ...
	Hashed MongoDbShardKeyOrder = "Hashed"
	// Reverse ...
	Reverse MongoDbShardKeyOrder = "Reverse"
)

// PossibleMongoDbShardKeyOrderValues returns an array of possible values for the MongoDbShardKeyOrder const type.
func PossibleMongoDbShardKeyOrderValues() []MongoDbShardKeyOrder {
	return []MongoDbShardKeyOrder{Forward, Hashed, Reverse}
}

// MySQLTargetPlatformType enumerates the values for my sql target platform type.
type MySQLTargetPlatformType string

const (
	// AzureDbForMySQL ...
	AzureDbForMySQL MySQLTargetPlatformType = "AzureDbForMySQL"
	// SQLServer ...
	SQLServer MySQLTargetPlatformType = "SqlServer"
)

// PossibleMySQLTargetPlatformTypeValues returns an array of possible values for the MySQLTargetPlatformType const type.
func PossibleMySQLTargetPlatformTypeValues() []MySQLTargetPlatformType {
	return []MySQLTargetPlatformType{AzureDbForMySQL, SQLServer}
}

// NameCheckFailureReason enumerates the values for name check failure reason.
type NameCheckFailureReason string

const (
	// AlreadyExists ...
	AlreadyExists NameCheckFailureReason = "AlreadyExists"
	// Invalid ...
	Invalid NameCheckFailureReason = "Invalid"
)

// PossibleNameCheckFailureReasonValues returns an array of possible values for the NameCheckFailureReason const type.
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return []NameCheckFailureReason{AlreadyExists, Invalid}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// Function ...
	Function ObjectType = "Function"
	// StoredProcedures ...
	StoredProcedures ObjectType = "StoredProcedures"
	// Table ...
	Table ObjectType = "Table"
	// User ...
	User ObjectType = "User"
	// View ...
	View ObjectType = "View"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{Function, StoredProcedures, Table, User, View}
}

// ProjectProvisioningState enumerates the values for project provisioning state.
type ProjectProvisioningState string

const (
	// ProjectProvisioningStateDeleting ...
	ProjectProvisioningStateDeleting ProjectProvisioningState = "Deleting"
	// ProjectProvisioningStateSucceeded ...
	ProjectProvisioningStateSucceeded ProjectProvisioningState = "Succeeded"
)

// PossibleProjectProvisioningStateValues returns an array of possible values for the ProjectProvisioningState const type.
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return []ProjectProvisioningState{ProjectProvisioningStateDeleting, ProjectProvisioningStateSucceeded}
}

// ProjectSourcePlatform enumerates the values for project source platform.
type ProjectSourcePlatform string

const (
	// ProjectSourcePlatformMongoDb ...
	ProjectSourcePlatformMongoDb ProjectSourcePlatform = "MongoDb"
	// ProjectSourcePlatformMySQL ...
	ProjectSourcePlatformMySQL ProjectSourcePlatform = "MySQL"
	// ProjectSourcePlatformPostgreSQL ...
	ProjectSourcePlatformPostgreSQL ProjectSourcePlatform = "PostgreSql"
	// ProjectSourcePlatformSQL ...
	ProjectSourcePlatformSQL ProjectSourcePlatform = "SQL"
	// ProjectSourcePlatformUnknown ...
	ProjectSourcePlatformUnknown ProjectSourcePlatform = "Unknown"
)

// PossibleProjectSourcePlatformValues returns an array of possible values for the ProjectSourcePlatform const type.
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return []ProjectSourcePlatform{ProjectSourcePlatformMongoDb, ProjectSourcePlatformMySQL, ProjectSourcePlatformPostgreSQL, ProjectSourcePlatformSQL, ProjectSourcePlatformUnknown}
}

// ProjectTargetPlatform enumerates the values for project target platform.
type ProjectTargetPlatform string

const (
	// ProjectTargetPlatformAzureDbForMySQL ...
	ProjectTargetPlatformAzureDbForMySQL ProjectTargetPlatform = "AzureDbForMySql"
	// ProjectTargetPlatformAzureDbForPostgreSQL ...
	ProjectTargetPlatformAzureDbForPostgreSQL ProjectTargetPlatform = "AzureDbForPostgreSql"
	// ProjectTargetPlatformMongoDb ...
	ProjectTargetPlatformMongoDb ProjectTargetPlatform = "MongoDb"
	// ProjectTargetPlatformSQLDB ...
	ProjectTargetPlatformSQLDB ProjectTargetPlatform = "SQLDB"
	// ProjectTargetPlatformSQLMI ...
	ProjectTargetPlatformSQLMI ProjectTargetPlatform = "SQLMI"
	// ProjectTargetPlatformUnknown ...
	ProjectTargetPlatformUnknown ProjectTargetPlatform = "Unknown"
)

// PossibleProjectTargetPlatformValues returns an array of possible values for the ProjectTargetPlatform const type.
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return []ProjectTargetPlatform{ProjectTargetPlatformAzureDbForMySQL, ProjectTargetPlatformAzureDbForPostgreSQL, ProjectTargetPlatformMongoDb, ProjectTargetPlatformSQLDB, ProjectTargetPlatformSQLMI, ProjectTargetPlatformUnknown}
}

// ReplicateMigrationState enumerates the values for replicate migration state.
type ReplicateMigrationState string

const (
	// ReplicateMigrationStateACTIONREQUIRED ...
	ReplicateMigrationStateACTIONREQUIRED ReplicateMigrationState = "ACTION_REQUIRED"
	// ReplicateMigrationStateCOMPLETE ...
	ReplicateMigrationStateCOMPLETE ReplicateMigrationState = "COMPLETE"
	// ReplicateMigrationStateFAILED ...
	ReplicateMigrationStateFAILED ReplicateMigrationState = "FAILED"
	// ReplicateMigrationStatePENDING ...
	ReplicateMigrationStatePENDING ReplicateMigrationState = "PENDING"
	// ReplicateMigrationStateUNDEFINED ...
	ReplicateMigrationStateUNDEFINED ReplicateMigrationState = "UNDEFINED"
	// ReplicateMigrationStateVALIDATING ...
	ReplicateMigrationStateVALIDATING ReplicateMigrationState = "VALIDATING"
)

// PossibleReplicateMigrationStateValues returns an array of possible values for the ReplicateMigrationState const type.
func PossibleReplicateMigrationStateValues() []ReplicateMigrationState {
	return []ReplicateMigrationState{ReplicateMigrationStateACTIONREQUIRED, ReplicateMigrationStateCOMPLETE, ReplicateMigrationStateFAILED, ReplicateMigrationStatePENDING, ReplicateMigrationStateUNDEFINED, ReplicateMigrationStateVALIDATING}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "location"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location}
}

// ResultCode enumerates the values for result code.
type ResultCode string

const (
	// Completed ...
	Completed ResultCode = "Completed"
	// FatalError ...
	FatalError ResultCode = "FatalError"
	// Initial ...
	Initial ResultCode = "Initial"
	// ObjectNotExistsInSource ...
	ObjectNotExistsInSource ResultCode = "ObjectNotExistsInSource"
	// ObjectNotExistsInTarget ...
	ObjectNotExistsInTarget ResultCode = "ObjectNotExistsInTarget"
	// TargetObjectIsInaccessible ...
	TargetObjectIsInaccessible ResultCode = "TargetObjectIsInaccessible"
)

// PossibleResultCodeValues returns an array of possible values for the ResultCode const type.
func PossibleResultCodeValues() []ResultCode {
	return []ResultCode{Completed, FatalError, Initial, ObjectNotExistsInSource, ObjectNotExistsInTarget, TargetObjectIsInaccessible}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeMigrateSsisTaskOutput ...
	ResultTypeMigrateSsisTaskOutput ResultType = "MigrateSsisTaskOutput"
	// ResultTypeMigrationLevelOutput ...
	ResultTypeMigrationLevelOutput ResultType = "MigrationLevelOutput"
	// ResultTypeSsisProjectLevelOutput ...
	ResultTypeSsisProjectLevelOutput ResultType = "SsisProjectLevelOutput"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeMigrateSsisTaskOutput, ResultTypeMigrationLevelOutput, ResultTypeSsisProjectLevelOutput}
}

// ResultTypeBasicConnectToSourceSQLServerTaskOutput enumerates the values for result type basic connect to
// source sql server task output.
type ResultTypeBasicConnectToSourceSQLServerTaskOutput string

const (
	// ResultTypeAgentJobLevelOutput ...
	ResultTypeAgentJobLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "AgentJobLevelOutput"
	// ResultTypeConnectToSourceSQLServerTaskOutput ...
	ResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "ConnectToSourceSqlServerTaskOutput"
	// ResultTypeDatabaseLevelOutput ...
	ResultTypeDatabaseLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "DatabaseLevelOutput"
	// ResultTypeLoginLevelOutput ...
	ResultTypeLoginLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "LoginLevelOutput"
	// ResultTypeTaskLevelOutput ...
	ResultTypeTaskLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "TaskLevelOutput"
)

// PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues returns an array of possible values for the ResultTypeBasicConnectToSourceSQLServerTaskOutput const type.
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return []ResultTypeBasicConnectToSourceSQLServerTaskOutput{ResultTypeAgentJobLevelOutput, ResultTypeConnectToSourceSQLServerTaskOutput, ResultTypeDatabaseLevelOutput, ResultTypeLoginLevelOutput, ResultTypeTaskLevelOutput}
}

// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput enumerates the values for result type basic migrate
// my sql azure db for my sql sync task output.
type ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput string

const (
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "MigrateMySqlAzureDbForMySqlSyncTaskOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues() []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput{ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput enumerates the values for result type basic
// migrate oracle azure db postgre sql sync task output.
type ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput string

const (
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "MigrateOracleAzureDbPostgreSqlSyncTaskOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputValues() []ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return []ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput{ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput enumerates the values for result type
// basic migrate postgre sql azure db for postgre sql sync task output.
type ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput string

const (
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputValues() []ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return []ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput enumerates the values for result type basic migrate
// schema sql server sql db task output.
type ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput string

const (
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "MigrateSchemaSqlServerSqlDbTaskOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "SchemaErrorOutput"
)

// PossibleResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput const type.
func PossibleResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput {
	return []ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput{ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput}
}

// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput enumerates the values for result type basic migrate sql
// server sql db sync task output.
type ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "MigrateSqlServerSqlDbSyncTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput{ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLDbTaskOutput enumerates the values for result type basic migrate sql
// server sql db task output.
type ResultTypeBasicMigrateSQLServerSQLDbTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrateSqlServerSqlDbTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLDbTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput{ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput enumerates the values for result type basic migrate sql
// server sqlmi sync task output.
type ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "MigrateSqlServerSqlMISyncTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "MigrationLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput{ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLMITaskOutput enumerates the values for result type basic migrate sql
// server sqlmi task output.
type ResultTypeBasicMigrateSQLServerSQLMITaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "AgentJobLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "LoginLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "MigrateSqlServerSqlMITaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "MigrationLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLMITaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMITaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLMITaskOutput{ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput}
}

// ResultTypeBasicMongoDbProgress enumerates the values for result type basic mongo db progress.
type ResultTypeBasicMongoDbProgress string

const (
	// ResultTypeCollection ...
	ResultTypeCollection ResultTypeBasicMongoDbProgress = "Collection"
	// ResultTypeDatabase ...
	ResultTypeDatabase ResultTypeBasicMongoDbProgress = "Database"
	// ResultTypeMigration ...
	ResultTypeMigration ResultTypeBasicMongoDbProgress = "Migration"
	// ResultTypeMongoDbProgress ...
	ResultTypeMongoDbProgress ResultTypeBasicMongoDbProgress = "MongoDbProgress"
)

// PossibleResultTypeBasicMongoDbProgressValues returns an array of possible values for the ResultTypeBasicMongoDbProgress const type.
func PossibleResultTypeBasicMongoDbProgressValues() []ResultTypeBasicMongoDbProgress {
	return []ResultTypeBasicMongoDbProgress{ResultTypeCollection, ResultTypeDatabase, ResultTypeMigration, ResultTypeMongoDbProgress}
}

// ScenarioSource enumerates the values for scenario source.
type ScenarioSource string

const (
	// Access ...
	Access ScenarioSource = "Access"
	// DB2 ...
	DB2 ScenarioSource = "DB2"
	// MongoDB ...
	MongoDB ScenarioSource = "MongoDB"
	// MySQL ...
	MySQL ScenarioSource = "MySQL"
	// MySQLRDS ...
	MySQLRDS ScenarioSource = "MySQLRDS"
	// Oracle ...
	Oracle ScenarioSource = "Oracle"
	// PostgreSQL ...
	PostgreSQL ScenarioSource = "PostgreSQL"
	// PostgreSQLRDS ...
	PostgreSQLRDS ScenarioSource = "PostgreSQLRDS"
	// SQL ...
	SQL ScenarioSource = "SQL"
	// SQLRDS ...
	SQLRDS ScenarioSource = "SQLRDS"
	// Sybase ...
	Sybase ScenarioSource = "Sybase"
)

// PossibleScenarioSourceValues returns an array of possible values for the ScenarioSource const type.
func PossibleScenarioSourceValues() []ScenarioSource {
	return []ScenarioSource{Access, DB2, MongoDB, MySQL, MySQLRDS, Oracle, PostgreSQL, PostgreSQLRDS, SQL, SQLRDS, Sybase}
}

// ScenarioTarget enumerates the values for scenario target.
type ScenarioTarget string

const (
	// ScenarioTargetAzureDBForMySQL ...
	ScenarioTargetAzureDBForMySQL ScenarioTarget = "AzureDBForMySql"
	// ScenarioTargetAzureDBForPostgresSQL ...
	ScenarioTargetAzureDBForPostgresSQL ScenarioTarget = "AzureDBForPostgresSQL"
	// ScenarioTargetMongoDB ...
	ScenarioTargetMongoDB ScenarioTarget = "MongoDB"
	// ScenarioTargetSQLDB ...
	ScenarioTargetSQLDB ScenarioTarget = "SQLDB"
	// ScenarioTargetSQLDW ...
	ScenarioTargetSQLDW ScenarioTarget = "SQLDW"
	// ScenarioTargetSQLMI ...
	ScenarioTargetSQLMI ScenarioTarget = "SQLMI"
	// ScenarioTargetSQLServer ...
	ScenarioTargetSQLServer ScenarioTarget = "SQLServer"
)

// PossibleScenarioTargetValues returns an array of possible values for the ScenarioTarget const type.
func PossibleScenarioTargetValues() []ScenarioTarget {
	return []ScenarioTarget{ScenarioTargetAzureDBForMySQL, ScenarioTargetAzureDBForPostgresSQL, ScenarioTargetMongoDB, ScenarioTargetSQLDB, ScenarioTargetSQLDW, ScenarioTargetSQLMI, ScenarioTargetSQLServer}
}

// SchemaMigrationOption enumerates the values for schema migration option.
type SchemaMigrationOption string

const (
	// SchemaMigrationOptionExtractFromSource ...
	SchemaMigrationOptionExtractFromSource SchemaMigrationOption = "ExtractFromSource"
	// SchemaMigrationOptionNone ...
	SchemaMigrationOptionNone SchemaMigrationOption = "None"
	// SchemaMigrationOptionUseStorageFile ...
	SchemaMigrationOptionUseStorageFile SchemaMigrationOption = "UseStorageFile"
)

// PossibleSchemaMigrationOptionValues returns an array of possible values for the SchemaMigrationOption const type.
func PossibleSchemaMigrationOptionValues() []SchemaMigrationOption {
	return []SchemaMigrationOption{SchemaMigrationOptionExtractFromSource, SchemaMigrationOptionNone, SchemaMigrationOptionUseStorageFile}
}

// SchemaMigrationStage enumerates the values for schema migration stage.
type SchemaMigrationStage string

const (
	// SchemaMigrationStageCollectingObjects ...
	SchemaMigrationStageCollectingObjects SchemaMigrationStage = "CollectingObjects"
	// SchemaMigrationStageCompleted ...
	SchemaMigrationStageCompleted SchemaMigrationStage = "Completed"
	// SchemaMigrationStageCompletedWithWarnings ...
	SchemaMigrationStageCompletedWithWarnings SchemaMigrationStage = "CompletedWithWarnings"
	// SchemaMigrationStageDeployingSchema ...
	SchemaMigrationStageDeployingSchema SchemaMigrationStage = "DeployingSchema"
	// SchemaMigrationStageDownloadingScript ...
	SchemaMigrationStageDownloadingScript SchemaMigrationStage = "DownloadingScript"
	// SchemaMigrationStageFailed ...
	SchemaMigrationStageFailed SchemaMigrationStage = "Failed"
	// SchemaMigrationStageGeneratingScript ...
	SchemaMigrationStageGeneratingScript SchemaMigrationStage = "GeneratingScript"
	// SchemaMigrationStageNotStarted ...
	SchemaMigrationStageNotStarted SchemaMigrationStage = "NotStarted"
	// SchemaMigrationStageUploadingScript ...
	SchemaMigrationStageUploadingScript SchemaMigrationStage = "UploadingScript"
	// SchemaMigrationStageValidatingInputs ...
	SchemaMigrationStageValidatingInputs SchemaMigrationStage = "ValidatingInputs"
)

// PossibleSchemaMigrationStageValues returns an array of possible values for the SchemaMigrationStage const type.
func PossibleSchemaMigrationStageValues() []SchemaMigrationStage {
	return []SchemaMigrationStage{SchemaMigrationStageCollectingObjects, SchemaMigrationStageCompleted, SchemaMigrationStageCompletedWithWarnings, SchemaMigrationStageDeployingSchema, SchemaMigrationStageDownloadingScript, SchemaMigrationStageFailed, SchemaMigrationStageGeneratingScript, SchemaMigrationStageNotStarted, SchemaMigrationStageUploadingScript, SchemaMigrationStageValidatingInputs}
}

// ServerLevelPermissionsGroup enumerates the values for server level permissions group.
type ServerLevelPermissionsGroup string

const (
	// Default ...
	Default ServerLevelPermissionsGroup = "Default"
	// MigrationFromMySQLToAzureDBForMySQL ...
	MigrationFromMySQLToAzureDBForMySQL ServerLevelPermissionsGroup = "MigrationFromMySQLToAzureDBForMySQL"
	// MigrationFromSQLServerToAzureDB ...
	MigrationFromSQLServerToAzureDB ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureDB"
	// MigrationFromSQLServerToAzureMI ...
	MigrationFromSQLServerToAzureMI ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureMI"
)

// PossibleServerLevelPermissionsGroupValues returns an array of possible values for the ServerLevelPermissionsGroup const type.
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return []ServerLevelPermissionsGroup{Default, MigrationFromMySQLToAzureDBForMySQL, MigrationFromSQLServerToAzureDB, MigrationFromSQLServerToAzureMI}
}

// ServiceProvisioningState enumerates the values for service provisioning state.
type ServiceProvisioningState string

const (
	// ServiceProvisioningStateAccepted ...
	ServiceProvisioningStateAccepted ServiceProvisioningState = "Accepted"
	// ServiceProvisioningStateDeleting ...
	ServiceProvisioningStateDeleting ServiceProvisioningState = "Deleting"
	// ServiceProvisioningStateDeploying ...
	ServiceProvisioningStateDeploying ServiceProvisioningState = "Deploying"
	// ServiceProvisioningStateFailed ...
	ServiceProvisioningStateFailed ServiceProvisioningState = "Failed"
	// ServiceProvisioningStateFailedToStart ...
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = "FailedToStart"
	// ServiceProvisioningStateFailedToStop ...
	ServiceProvisioningStateFailedToStop ServiceProvisioningState = "FailedToStop"
	// ServiceProvisioningStateStarting ...
	ServiceProvisioningStateStarting ServiceProvisioningState = "Starting"
	// ServiceProvisioningStateStopped ...
	ServiceProvisioningStateStopped ServiceProvisioningState = "Stopped"
	// ServiceProvisioningStateStopping ...
	ServiceProvisioningStateStopping ServiceProvisioningState = "Stopping"
	// ServiceProvisioningStateSucceeded ...
	ServiceProvisioningStateSucceeded ServiceProvisioningState = "Succeeded"
)

// PossibleServiceProvisioningStateValues returns an array of possible values for the ServiceProvisioningState const type.
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return []ServiceProvisioningState{ServiceProvisioningStateAccepted, ServiceProvisioningStateDeleting, ServiceProvisioningStateDeploying, ServiceProvisioningStateFailed, ServiceProvisioningStateFailedToStart, ServiceProvisioningStateFailedToStop, ServiceProvisioningStateStarting, ServiceProvisioningStateStopped, ServiceProvisioningStateStopping, ServiceProvisioningStateSucceeded}
}

// ServiceScalability enumerates the values for service scalability.
type ServiceScalability string

const (
	// ServiceScalabilityAutomatic ...
	ServiceScalabilityAutomatic ServiceScalability = "automatic"
	// ServiceScalabilityManual ...
	ServiceScalabilityManual ServiceScalability = "manual"
	// ServiceScalabilityNone ...
	ServiceScalabilityNone ServiceScalability = "none"
)

// PossibleServiceScalabilityValues returns an array of possible values for the ServiceScalability const type.
func PossibleServiceScalabilityValues() []ServiceScalability {
	return []ServiceScalability{ServiceScalabilityAutomatic, ServiceScalabilityManual, ServiceScalabilityNone}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityMessage ...
	SeverityMessage Severity = "Message"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityMessage, SeverityWarning}
}

// SQLSourcePlatform enumerates the values for sql source platform.
type SQLSourcePlatform string

const (
	// SQLOnPrem ...
	SQLOnPrem SQLSourcePlatform = "SqlOnPrem"
)

// PossibleSQLSourcePlatformValues returns an array of possible values for the SQLSourcePlatform const type.
func PossibleSQLSourcePlatformValues() []SQLSourcePlatform {
	return []SQLSourcePlatform{SQLOnPrem}
}

// SsisMigrationOverwriteOption enumerates the values for ssis migration overwrite option.
type SsisMigrationOverwriteOption string

const (
	// Ignore ...
	Ignore SsisMigrationOverwriteOption = "Ignore"
	// Overwrite ...
	Overwrite SsisMigrationOverwriteOption = "Overwrite"
)

// PossibleSsisMigrationOverwriteOptionValues returns an array of possible values for the SsisMigrationOverwriteOption const type.
func PossibleSsisMigrationOverwriteOptionValues() []SsisMigrationOverwriteOption {
	return []SsisMigrationOverwriteOption{Ignore, Overwrite}
}

// SsisMigrationStage enumerates the values for ssis migration stage.
type SsisMigrationStage string

const (
	// SsisMigrationStageCompleted ...
	SsisMigrationStageCompleted SsisMigrationStage = "Completed"
	// SsisMigrationStageInitialize ...
	SsisMigrationStageInitialize SsisMigrationStage = "Initialize"
	// SsisMigrationStageInProgress ...
	SsisMigrationStageInProgress SsisMigrationStage = "InProgress"
	// SsisMigrationStageNone ...
	SsisMigrationStageNone SsisMigrationStage = "None"
)

// PossibleSsisMigrationStageValues returns an array of possible values for the SsisMigrationStage const type.
func PossibleSsisMigrationStageValues() []SsisMigrationStage {
	return []SsisMigrationStage{SsisMigrationStageCompleted, SsisMigrationStageInitialize, SsisMigrationStageInProgress, SsisMigrationStageNone}
}

// SsisStoreType enumerates the values for ssis store type.
type SsisStoreType string

const (
	// SsisCatalog ...
	SsisCatalog SsisStoreType = "SsisCatalog"
)

// PossibleSsisStoreTypeValues returns an array of possible values for the SsisStoreType const type.
func PossibleSsisStoreTypeValues() []SsisStoreType {
	return []SsisStoreType{SsisCatalog}
}

// SyncDatabaseMigrationReportingState enumerates the values for sync database migration reporting state.
type SyncDatabaseMigrationReportingState string

const (
	// SyncDatabaseMigrationReportingStateBACKUPCOMPLETED ...
	SyncDatabaseMigrationReportingStateBACKUPCOMPLETED SyncDatabaseMigrationReportingState = "BACKUP_COMPLETED"
	// SyncDatabaseMigrationReportingStateBACKUPINPROGRESS ...
	SyncDatabaseMigrationReportingStateBACKUPINPROGRESS SyncDatabaseMigrationReportingState = "BACKUP_IN_PROGRESS"
	// SyncDatabaseMigrationReportingStateCANCELLED ...
	SyncDatabaseMigrationReportingStateCANCELLED SyncDatabaseMigrationReportingState = "CANCELLED"
	// SyncDatabaseMigrationReportingStateCANCELLING ...
	SyncDatabaseMigrationReportingStateCANCELLING SyncDatabaseMigrationReportingState = "CANCELLING"
	// SyncDatabaseMigrationReportingStateCOMPLETE ...
	SyncDatabaseMigrationReportingStateCOMPLETE SyncDatabaseMigrationReportingState = "COMPLETE"
	// SyncDatabaseMigrationReportingStateCOMPLETING ...
	SyncDatabaseMigrationReportingStateCOMPLETING SyncDatabaseMigrationReportingState = "COMPLETING"
	// SyncDatabaseMigrationReportingStateCONFIGURING ...
	SyncDatabaseMigrationReportingStateCONFIGURING SyncDatabaseMigrationReportingState = "CONFIGURING"
	// SyncDatabaseMigrationReportingStateFAILED ...
	SyncDatabaseMigrationReportingStateFAILED SyncDatabaseMigrationReportingState = "FAILED"
	// SyncDatabaseMigrationReportingStateINITIALIAZING ...
	SyncDatabaseMigrationReportingStateINITIALIAZING SyncDatabaseMigrationReportingState = "INITIALIAZING"
	// SyncDatabaseMigrationReportingStateREADYTOCOMPLETE ...
	SyncDatabaseMigrationReportingStateREADYTOCOMPLETE SyncDatabaseMigrationReportingState = "READY_TO_COMPLETE"
	// SyncDatabaseMigrationReportingStateRESTORECOMPLETED ...
	SyncDatabaseMigrationReportingStateRESTORECOMPLETED SyncDatabaseMigrationReportingState = "RESTORE_COMPLETED"
	// SyncDatabaseMigrationReportingStateRESTOREINPROGRESS ...
	SyncDatabaseMigrationReportingStateRESTOREINPROGRESS SyncDatabaseMigrationReportingState = "RESTORE_IN_PROGRESS"
	// SyncDatabaseMigrationReportingStateRUNNING ...
	SyncDatabaseMigrationReportingStateRUNNING SyncDatabaseMigrationReportingState = "RUNNING"
	// SyncDatabaseMigrationReportingStateSTARTING ...
	SyncDatabaseMigrationReportingStateSTARTING SyncDatabaseMigrationReportingState = "STARTING"
	// SyncDatabaseMigrationReportingStateUNDEFINED ...
	SyncDatabaseMigrationReportingStateUNDEFINED SyncDatabaseMigrationReportingState = "UNDEFINED"
	// SyncDatabaseMigrationReportingStateVALIDATING ...
	SyncDatabaseMigrationReportingStateVALIDATING SyncDatabaseMigrationReportingState = "VALIDATING"
	// SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE ...
	SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE SyncDatabaseMigrationReportingState = "VALIDATION_COMPLETE"
	// SyncDatabaseMigrationReportingStateVALIDATIONFAILED ...
	SyncDatabaseMigrationReportingStateVALIDATIONFAILED SyncDatabaseMigrationReportingState = "VALIDATION_FAILED"
)

// PossibleSyncDatabaseMigrationReportingStateValues returns an array of possible values for the SyncDatabaseMigrationReportingState const type.
func PossibleSyncDatabaseMigrationReportingStateValues() []SyncDatabaseMigrationReportingState {
	return []SyncDatabaseMigrationReportingState{SyncDatabaseMigrationReportingStateBACKUPCOMPLETED, SyncDatabaseMigrationReportingStateBACKUPINPROGRESS, SyncDatabaseMigrationReportingStateCANCELLED, SyncDatabaseMigrationReportingStateCANCELLING, SyncDatabaseMigrationReportingStateCOMPLETE, SyncDatabaseMigrationReportingStateCOMPLETING, SyncDatabaseMigrationReportingStateCONFIGURING, SyncDatabaseMigrationReportingStateFAILED, SyncDatabaseMigrationReportingStateINITIALIAZING, SyncDatabaseMigrationReportingStateREADYTOCOMPLETE, SyncDatabaseMigrationReportingStateRESTORECOMPLETED, SyncDatabaseMigrationReportingStateRESTOREINPROGRESS, SyncDatabaseMigrationReportingStateRUNNING, SyncDatabaseMigrationReportingStateSTARTING, SyncDatabaseMigrationReportingStateUNDEFINED, SyncDatabaseMigrationReportingStateVALIDATING, SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE, SyncDatabaseMigrationReportingStateVALIDATIONFAILED}
}

// SyncTableMigrationState enumerates the values for sync table migration state.
type SyncTableMigrationState string

const (
	// SyncTableMigrationStateBEFORELOAD ...
	SyncTableMigrationStateBEFORELOAD SyncTableMigrationState = "BEFORE_LOAD"
	// SyncTableMigrationStateCANCELED ...
	SyncTableMigrationStateCANCELED SyncTableMigrationState = "CANCELED"
	// SyncTableMigrationStateCOMPLETED ...
	SyncTableMigrationStateCOMPLETED SyncTableMigrationState = "COMPLETED"
	// SyncTableMigrationStateERROR ...
	SyncTableMigrationStateERROR SyncTableMigrationState = "ERROR"
	// SyncTableMigrationStateFAILED ...
	SyncTableMigrationStateFAILED SyncTableMigrationState = "FAILED"
	// SyncTableMigrationStateFULLLOAD ...
	SyncTableMigrationStateFULLLOAD SyncTableMigrationState = "FULL_LOAD"
)

// PossibleSyncTableMigrationStateValues returns an array of possible values for the SyncTableMigrationState const type.
func PossibleSyncTableMigrationStateValues() []SyncTableMigrationState {
	return []SyncTableMigrationState{SyncTableMigrationStateBEFORELOAD, SyncTableMigrationStateCANCELED, SyncTableMigrationStateCOMPLETED, SyncTableMigrationStateERROR, SyncTableMigrationStateFAILED, SyncTableMigrationStateFULLLOAD}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateCanceled ...
	TaskStateCanceled TaskState = "Canceled"
	// TaskStateFailed ...
	TaskStateFailed TaskState = "Failed"
	// TaskStateFailedInputValidation ...
	TaskStateFailedInputValidation TaskState = "FailedInputValidation"
	// TaskStateFaulted ...
	TaskStateFaulted TaskState = "Faulted"
	// TaskStateQueued ...
	TaskStateQueued TaskState = "Queued"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "Running"
	// TaskStateSucceeded ...
	TaskStateSucceeded TaskState = "Succeeded"
	// TaskStateUnknown ...
	TaskStateUnknown TaskState = "Unknown"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateCanceled, TaskStateFailed, TaskStateFailedInputValidation, TaskStateFaulted, TaskStateQueued, TaskStateRunning, TaskStateSucceeded, TaskStateUnknown}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// TaskTypeConnectMongoDb ...
	TaskTypeConnectMongoDb TaskType = "Connect.MongoDb"
	// TaskTypeConnectToSourceMySQL ...
	TaskTypeConnectToSourceMySQL TaskType = "ConnectToSource.MySql"
	// TaskTypeConnectToSourceOracleSync ...
	TaskTypeConnectToSourceOracleSync TaskType = "ConnectToSource.Oracle.Sync"
	// TaskTypeConnectToSourcePostgreSQLSync ...
	TaskTypeConnectToSourcePostgreSQLSync TaskType = "ConnectToSource.PostgreSql.Sync"
	// TaskTypeConnectToSourceSQLServer ...
	TaskTypeConnectToSourceSQLServer TaskType = "ConnectToSource.SqlServer"
	// TaskTypeConnectToSourceSQLServerSync ...
	TaskTypeConnectToSourceSQLServerSync TaskType = "ConnectToSource.SqlServer.Sync"
	// TaskTypeConnectToTargetAzureDbForMySQL ...
	TaskTypeConnectToTargetAzureDbForMySQL TaskType = "ConnectToTarget.AzureDbForMySql"
	// TaskTypeConnectToTargetAzureDbForPostgreSQLSync ...
	TaskTypeConnectToTargetAzureDbForPostgreSQLSync TaskType = "ConnectToTarget.AzureDbForPostgreSql.Sync"
	// TaskTypeConnectToTargetAzureSQLDbMI ...
	TaskTypeConnectToTargetAzureSQLDbMI TaskType = "ConnectToTarget.AzureSqlDbMI"
	// TaskTypeConnectToTargetAzureSQLDbMISyncLRS ...
	TaskTypeConnectToTargetAzureSQLDbMISyncLRS TaskType = "ConnectToTarget.AzureSqlDbMI.Sync.LRS"
	// TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync ...
	TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync TaskType = "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync"
	// TaskTypeConnectToTargetSQLDb ...
	TaskTypeConnectToTargetSQLDb TaskType = "ConnectToTarget.SqlDb"
	// TaskTypeConnectToTargetSQLDbSync ...
	TaskTypeConnectToTargetSQLDbSync TaskType = "ConnectToTarget.SqlDb.Sync"
	// TaskTypeGetTDECertificatesSQL ...
	TaskTypeGetTDECertificatesSQL TaskType = "GetTDECertificates.Sql"
	// TaskTypeGetUserTablesAzureSQLDbSync ...
	TaskTypeGetUserTablesAzureSQLDbSync TaskType = "GetUserTables.AzureSqlDb.Sync"
	// TaskTypeGetUserTablesOracle ...
	TaskTypeGetUserTablesOracle TaskType = "GetUserTablesOracle"
	// TaskTypeGetUserTablesPostgreSQL ...
	TaskTypeGetUserTablesPostgreSQL TaskType = "GetUserTablesPostgreSql"
	// TaskTypeGetUserTablesSQL ...
	TaskTypeGetUserTablesSQL TaskType = "GetUserTables.Sql"
	// TaskTypeMigrateMongoDb ...
	TaskTypeMigrateMongoDb TaskType = "Migrate.MongoDb"
	// TaskTypeMigrateMySQLAzureDbForMySQLSync ...
	TaskTypeMigrateMySQLAzureDbForMySQLSync TaskType = "Migrate.MySql.AzureDbForMySql.Sync"
	// TaskTypeMigrateOracleAzureDbForPostgreSQLSync ...
	TaskTypeMigrateOracleAzureDbForPostgreSQLSync TaskType = "Migrate.Oracle.AzureDbForPostgreSql.Sync"
	// TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSyncV2 ...
	TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSyncV2 TaskType = "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2"
	// TaskTypeMigrateSchemaSQLServerSQLDb ...
	TaskTypeMigrateSchemaSQLServerSQLDb TaskType = "MigrateSchemaSqlServerSqlDb"
	// TaskTypeMigrateSQLServerAzureSQLDbMI ...
	TaskTypeMigrateSQLServerAzureSQLDbMI TaskType = "Migrate.SqlServer.AzureSqlDbMI"
	// TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS ...
	TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS TaskType = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS"
	// TaskTypeMigrateSQLServerAzureSQLDbSync ...
	TaskTypeMigrateSQLServerAzureSQLDbSync TaskType = "Migrate.SqlServer.AzureSqlDb.Sync"
	// TaskTypeMigrateSQLServerSQLDb ...
	TaskTypeMigrateSQLServerSQLDb TaskType = "Migrate.SqlServer.SqlDb"
	// TaskTypeMigrateSsis ...
	TaskTypeMigrateSsis TaskType = "Migrate.Ssis"
	// TaskTypeProjectTaskProperties ...
	TaskTypeProjectTaskProperties TaskType = "ProjectTaskProperties"
	// TaskTypeServiceCheckOCI ...
	TaskTypeServiceCheckOCI TaskType = "Service.Check.OCI"
	// TaskTypeServiceInstallOCI ...
	TaskTypeServiceInstallOCI TaskType = "Service.Install.OCI"
	// TaskTypeServiceUploadOCI ...
	TaskTypeServiceUploadOCI TaskType = "Service.Upload.OCI"
	// TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI ...
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI TaskType = "ValidateMigrationInput.SqlServer.AzureSqlDbMI"
	// TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS ...
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS TaskType = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS"
	// TaskTypeValidateMigrationInputSQLServerSQLDbSync ...
	TaskTypeValidateMigrationInputSQLServerSQLDbSync TaskType = "ValidateMigrationInput.SqlServer.SqlDb.Sync"
	// TaskTypeValidateMongoDb ...
	TaskTypeValidateMongoDb TaskType = "Validate.MongoDb"
	// TaskTypeValidateOracleAzureDbPostgreSQLSync ...
	TaskTypeValidateOracleAzureDbPostgreSQLSync TaskType = "Validate.Oracle.AzureDbPostgreSql.Sync"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{TaskTypeConnectMongoDb, TaskTypeConnectToSourceMySQL, TaskTypeConnectToSourceOracleSync, TaskTypeConnectToSourcePostgreSQLSync, TaskTypeConnectToSourceSQLServer, TaskTypeConnectToSourceSQLServerSync, TaskTypeConnectToTargetAzureDbForMySQL, TaskTypeConnectToTargetAzureDbForPostgreSQLSync, TaskTypeConnectToTargetAzureSQLDbMI, TaskTypeConnectToTargetAzureSQLDbMISyncLRS, TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync, TaskTypeConnectToTargetSQLDb, TaskTypeConnectToTargetSQLDbSync, TaskTypeGetTDECertificatesSQL, TaskTypeGetUserTablesAzureSQLDbSync, TaskTypeGetUserTablesOracle, TaskTypeGetUserTablesPostgreSQL, TaskTypeGetUserTablesSQL, TaskTypeMigrateMongoDb, TaskTypeMigrateMySQLAzureDbForMySQLSync, TaskTypeMigrateOracleAzureDbForPostgreSQLSync, TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSyncV2, TaskTypeMigrateSchemaSQLServerSQLDb, TaskTypeMigrateSQLServerAzureSQLDbMI, TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS, TaskTypeMigrateSQLServerAzureSQLDbSync, TaskTypeMigrateSQLServerSQLDb, TaskTypeMigrateSsis, TaskTypeProjectTaskProperties, TaskTypeServiceCheckOCI, TaskTypeServiceInstallOCI, TaskTypeServiceUploadOCI, TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI, TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS, TaskTypeValidateMigrationInputSQLServerSQLDbSync, TaskTypeValidateMongoDb, TaskTypeValidateOracleAzureDbPostgreSQLSync}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeConnectionInfo ...
	TypeConnectionInfo Type = "ConnectionInfo"
	// TypeMiSQLConnectionInfo ...
	TypeMiSQLConnectionInfo Type = "MiSqlConnectionInfo"
	// TypeMongoDbConnectionInfo ...
	TypeMongoDbConnectionInfo Type = "MongoDbConnectionInfo"
	// TypeMySQLConnectionInfo ...
	TypeMySQLConnectionInfo Type = "MySqlConnectionInfo"
	// TypeOracleConnectionInfo ...
	TypeOracleConnectionInfo Type = "OracleConnectionInfo"
	// TypePostgreSQLConnectionInfo ...
	TypePostgreSQLConnectionInfo Type = "PostgreSqlConnectionInfo"
	// TypeSQLConnectionInfo ...
	TypeSQLConnectionInfo Type = "SqlConnectionInfo"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeConnectionInfo, TypeMiSQLConnectionInfo, TypeMongoDbConnectionInfo, TypeMySQLConnectionInfo, TypeOracleConnectionInfo, TypePostgreSQLConnectionInfo, TypeSQLConnectionInfo}
}

// UpdateActionType enumerates the values for update action type.
type UpdateActionType string

const (
	// AddedOnTarget ...
	AddedOnTarget UpdateActionType = "AddedOnTarget"
	// ChangedOnTarget ...
	ChangedOnTarget UpdateActionType = "ChangedOnTarget"
	// DeletedOnTarget ...
	DeletedOnTarget UpdateActionType = "DeletedOnTarget"
)

// PossibleUpdateActionTypeValues returns an array of possible values for the UpdateActionType const type.
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return []UpdateActionType{AddedOnTarget, ChangedOnTarget, DeletedOnTarget}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusCompleted ...
	ValidationStatusCompleted ValidationStatus = "Completed"
	// ValidationStatusCompletedWithIssues ...
	ValidationStatusCompletedWithIssues ValidationStatus = "CompletedWithIssues"
	// ValidationStatusDefault ...
	ValidationStatusDefault ValidationStatus = "Default"
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInitialized ...
	ValidationStatusInitialized ValidationStatus = "Initialized"
	// ValidationStatusInProgress ...
	ValidationStatusInProgress ValidationStatus = "InProgress"
	// ValidationStatusNotStarted ...
	ValidationStatusNotStarted ValidationStatus = "NotStarted"
	// ValidationStatusStopped ...
	ValidationStatusStopped ValidationStatus = "Stopped"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusCompleted, ValidationStatusCompletedWithIssues, ValidationStatusDefault, ValidationStatusFailed, ValidationStatusInitialized, ValidationStatusInProgress, ValidationStatusNotStarted, ValidationStatusStopped}
}
