//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package web

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/web/mgmt/2021-03-01/web"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActiveRevisionsMode = original.ActiveRevisionsMode

const (
	ActiveRevisionsModeMultiple ActiveRevisionsMode = original.ActiveRevisionsModeMultiple
	ActiveRevisionsModeSingle   ActiveRevisionsMode = original.ActiveRevisionsModeSingle
)

type AppServicePlanRestrictions = original.AppServicePlanRestrictions

const (
	AppServicePlanRestrictionsBasic    AppServicePlanRestrictions = original.AppServicePlanRestrictionsBasic
	AppServicePlanRestrictionsFree     AppServicePlanRestrictions = original.AppServicePlanRestrictionsFree
	AppServicePlanRestrictionsNone     AppServicePlanRestrictions = original.AppServicePlanRestrictionsNone
	AppServicePlanRestrictionsPremium  AppServicePlanRestrictions = original.AppServicePlanRestrictionsPremium
	AppServicePlanRestrictionsShared   AppServicePlanRestrictions = original.AppServicePlanRestrictionsShared
	AppServicePlanRestrictionsStandard AppServicePlanRestrictions = original.AppServicePlanRestrictionsStandard
)

type AutoHealActionType = original.AutoHealActionType

const (
	AutoHealActionTypeCustomAction AutoHealActionType = original.AutoHealActionTypeCustomAction
	AutoHealActionTypeLogEvent     AutoHealActionType = original.AutoHealActionTypeLogEvent
	AutoHealActionTypeRecycle      AutoHealActionType = original.AutoHealActionTypeRecycle
)

type AzureResourceType = original.AzureResourceType

const (
	AzureResourceTypeTrafficManager AzureResourceType = original.AzureResourceTypeTrafficManager
	AzureResourceTypeWebsite        AzureResourceType = original.AzureResourceTypeWebsite
)

type AzureStorageState = original.AzureStorageState

const (
	AzureStorageStateInvalidCredentials AzureStorageState = original.AzureStorageStateInvalidCredentials
	AzureStorageStateInvalidShare       AzureStorageState = original.AzureStorageStateInvalidShare
	AzureStorageStateNotValidated       AzureStorageState = original.AzureStorageStateNotValidated
	AzureStorageStateOk                 AzureStorageState = original.AzureStorageStateOk
)

type AzureStorageType = original.AzureStorageType

const (
	AzureStorageTypeAzureBlob  AzureStorageType = original.AzureStorageTypeAzureBlob
	AzureStorageTypeAzureFiles AzureStorageType = original.AzureStorageTypeAzureFiles
)

type BackupItemStatus = original.BackupItemStatus

const (
	BackupItemStatusCreated            BackupItemStatus = original.BackupItemStatusCreated
	BackupItemStatusDeleted            BackupItemStatus = original.BackupItemStatusDeleted
	BackupItemStatusDeleteFailed       BackupItemStatus = original.BackupItemStatusDeleteFailed
	BackupItemStatusDeleteInProgress   BackupItemStatus = original.BackupItemStatusDeleteInProgress
	BackupItemStatusFailed             BackupItemStatus = original.BackupItemStatusFailed
	BackupItemStatusInProgress         BackupItemStatus = original.BackupItemStatusInProgress
	BackupItemStatusPartiallySucceeded BackupItemStatus = original.BackupItemStatusPartiallySucceeded
	BackupItemStatusSkipped            BackupItemStatus = original.BackupItemStatusSkipped
	BackupItemStatusSucceeded          BackupItemStatus = original.BackupItemStatusSucceeded
	BackupItemStatusTimedOut           BackupItemStatus = original.BackupItemStatusTimedOut
)

type BackupRestoreOperationType = original.BackupRestoreOperationType

const (
	BackupRestoreOperationTypeClone      BackupRestoreOperationType = original.BackupRestoreOperationTypeClone
	BackupRestoreOperationTypeCloudFS    BackupRestoreOperationType = original.BackupRestoreOperationTypeCloudFS
	BackupRestoreOperationTypeDefault    BackupRestoreOperationType = original.BackupRestoreOperationTypeDefault
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = original.BackupRestoreOperationTypeRelocation
	BackupRestoreOperationTypeSnapshot   BackupRestoreOperationType = original.BackupRestoreOperationTypeSnapshot
)

type BuildStatus = original.BuildStatus

const (
	BuildStatusDeleting             BuildStatus = original.BuildStatusDeleting
	BuildStatusDeploying            BuildStatus = original.BuildStatusDeploying
	BuildStatusDetached             BuildStatus = original.BuildStatusDetached
	BuildStatusFailed               BuildStatus = original.BuildStatusFailed
	BuildStatusReady                BuildStatus = original.BuildStatusReady
	BuildStatusUploading            BuildStatus = original.BuildStatusUploading
	BuildStatusWaitingForDeployment BuildStatus = original.BuildStatusWaitingForDeployment
)

type BuiltInAuthenticationProvider = original.BuiltInAuthenticationProvider

const (
	BuiltInAuthenticationProviderAzureActiveDirectory BuiltInAuthenticationProvider = original.BuiltInAuthenticationProviderAzureActiveDirectory
	BuiltInAuthenticationProviderFacebook             BuiltInAuthenticationProvider = original.BuiltInAuthenticationProviderFacebook
	BuiltInAuthenticationProviderGithub               BuiltInAuthenticationProvider = original.BuiltInAuthenticationProviderGithub
	BuiltInAuthenticationProviderGoogle               BuiltInAuthenticationProvider = original.BuiltInAuthenticationProviderGoogle
	BuiltInAuthenticationProviderMicrosoftAccount     BuiltInAuthenticationProvider = original.BuiltInAuthenticationProviderMicrosoftAccount
	BuiltInAuthenticationProviderTwitter              BuiltInAuthenticationProvider = original.BuiltInAuthenticationProviderTwitter
)

type CertificateOrderActionType = original.CertificateOrderActionType

const (
	CertificateOrderActionTypeCertificateExpirationWarning CertificateOrderActionType = original.CertificateOrderActionTypeCertificateExpirationWarning
	CertificateOrderActionTypeCertificateExpired           CertificateOrderActionType = original.CertificateOrderActionTypeCertificateExpired
	CertificateOrderActionTypeCertificateIssued            CertificateOrderActionType = original.CertificateOrderActionTypeCertificateIssued
	CertificateOrderActionTypeCertificateOrderCanceled     CertificateOrderActionType = original.CertificateOrderActionTypeCertificateOrderCanceled
	CertificateOrderActionTypeCertificateOrderCreated      CertificateOrderActionType = original.CertificateOrderActionTypeCertificateOrderCreated
	CertificateOrderActionTypeCertificateRevoked           CertificateOrderActionType = original.CertificateOrderActionTypeCertificateRevoked
	CertificateOrderActionTypeDomainValidationComplete     CertificateOrderActionType = original.CertificateOrderActionTypeDomainValidationComplete
	CertificateOrderActionTypeFraudCleared                 CertificateOrderActionType = original.CertificateOrderActionTypeFraudCleared
	CertificateOrderActionTypeFraudDetected                CertificateOrderActionType = original.CertificateOrderActionTypeFraudDetected
	CertificateOrderActionTypeFraudDocumentationRequired   CertificateOrderActionType = original.CertificateOrderActionTypeFraudDocumentationRequired
	CertificateOrderActionTypeOrgNameChange                CertificateOrderActionType = original.CertificateOrderActionTypeOrgNameChange
	CertificateOrderActionTypeOrgValidationComplete        CertificateOrderActionType = original.CertificateOrderActionTypeOrgValidationComplete
	CertificateOrderActionTypeSanDrop                      CertificateOrderActionType = original.CertificateOrderActionTypeSanDrop
	CertificateOrderActionTypeUnknown                      CertificateOrderActionType = original.CertificateOrderActionTypeUnknown
)

type CertificateOrderStatus = original.CertificateOrderStatus

const (
	CertificateOrderStatusCanceled          CertificateOrderStatus = original.CertificateOrderStatusCanceled
	CertificateOrderStatusDenied            CertificateOrderStatus = original.CertificateOrderStatusDenied
	CertificateOrderStatusExpired           CertificateOrderStatus = original.CertificateOrderStatusExpired
	CertificateOrderStatusIssued            CertificateOrderStatus = original.CertificateOrderStatusIssued
	CertificateOrderStatusNotSubmitted      CertificateOrderStatus = original.CertificateOrderStatusNotSubmitted
	CertificateOrderStatusPendingissuance   CertificateOrderStatus = original.CertificateOrderStatusPendingissuance
	CertificateOrderStatusPendingRekey      CertificateOrderStatus = original.CertificateOrderStatusPendingRekey
	CertificateOrderStatusPendingrevocation CertificateOrderStatus = original.CertificateOrderStatusPendingrevocation
	CertificateOrderStatusRevoked           CertificateOrderStatus = original.CertificateOrderStatusRevoked
	CertificateOrderStatusUnused            CertificateOrderStatus = original.CertificateOrderStatusUnused
)

type CertificateProductType = original.CertificateProductType

const (
	CertificateProductTypeStandardDomainValidatedSsl         CertificateProductType = original.CertificateProductTypeStandardDomainValidatedSsl
	CertificateProductTypeStandardDomainValidatedWildCardSsl CertificateProductType = original.CertificateProductTypeStandardDomainValidatedWildCardSsl
)

type Channels = original.Channels

const (
	ChannelsAll          Channels = original.ChannelsAll
	ChannelsAPI          Channels = original.ChannelsAPI
	ChannelsEmail        Channels = original.ChannelsEmail
	ChannelsNotification Channels = original.ChannelsNotification
	ChannelsWebhook      Channels = original.ChannelsWebhook
)

type CheckNameResourceTypes = original.CheckNameResourceTypes

const (
	CheckNameResourceTypesHostingEnvironment              CheckNameResourceTypes = original.CheckNameResourceTypesHostingEnvironment
	CheckNameResourceTypesMicrosoftWebhostingEnvironments CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebhostingEnvironments
	CheckNameResourceTypesMicrosoftWebpublishingUsers     CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebpublishingUsers
	CheckNameResourceTypesMicrosoftWebsites               CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebsites
	CheckNameResourceTypesMicrosoftWebsitesslots          CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebsitesslots
	CheckNameResourceTypesPublishingUser                  CheckNameResourceTypes = original.CheckNameResourceTypesPublishingUser
	CheckNameResourceTypesSite                            CheckNameResourceTypes = original.CheckNameResourceTypesSite
	CheckNameResourceTypesSlot                            CheckNameResourceTypes = original.CheckNameResourceTypesSlot
)

type ClientCertMode = original.ClientCertMode

const (
	ClientCertModeOptional                ClientCertMode = original.ClientCertModeOptional
	ClientCertModeOptionalInteractiveUser ClientCertMode = original.ClientCertModeOptionalInteractiveUser
	ClientCertModeRequired                ClientCertMode = original.ClientCertModeRequired
)

type ClientCredentialMethod = original.ClientCredentialMethod

const (
	ClientCredentialMethodClientSecretPost ClientCredentialMethod = original.ClientCredentialMethodClientSecretPost
)

type CloneAbilityResult = original.CloneAbilityResult

const (
	CloneAbilityResultCloneable          CloneAbilityResult = original.CloneAbilityResultCloneable
	CloneAbilityResultNotCloneable       CloneAbilityResult = original.CloneAbilityResultNotCloneable
	CloneAbilityResultPartiallyCloneable CloneAbilityResult = original.CloneAbilityResultPartiallyCloneable
)

type ComputeModeOptions = original.ComputeModeOptions

const (
	ComputeModeOptionsDedicated ComputeModeOptions = original.ComputeModeOptionsDedicated
	ComputeModeOptionsDynamic   ComputeModeOptions = original.ComputeModeOptionsDynamic
	ComputeModeOptionsShared    ComputeModeOptions = original.ComputeModeOptionsShared
)

type ConfigReferenceSource = original.ConfigReferenceSource

const (
	ConfigReferenceSourceKeyVault ConfigReferenceSource = original.ConfigReferenceSourceKeyVault
)

type ConnectionStringType = original.ConnectionStringType

const (
	ConnectionStringTypeAPIHub          ConnectionStringType = original.ConnectionStringTypeAPIHub
	ConnectionStringTypeCustom          ConnectionStringType = original.ConnectionStringTypeCustom
	ConnectionStringTypeDocDb           ConnectionStringType = original.ConnectionStringTypeDocDb
	ConnectionStringTypeEventHub        ConnectionStringType = original.ConnectionStringTypeEventHub
	ConnectionStringTypeMySQL           ConnectionStringType = original.ConnectionStringTypeMySQL
	ConnectionStringTypeNotificationHub ConnectionStringType = original.ConnectionStringTypeNotificationHub
	ConnectionStringTypePostgreSQL      ConnectionStringType = original.ConnectionStringTypePostgreSQL
	ConnectionStringTypeRedisCache      ConnectionStringType = original.ConnectionStringTypeRedisCache
	ConnectionStringTypeServiceBus      ConnectionStringType = original.ConnectionStringTypeServiceBus
	ConnectionStringTypeSQLAzure        ConnectionStringType = original.ConnectionStringTypeSQLAzure
	ConnectionStringTypeSQLServer       ConnectionStringType = original.ConnectionStringTypeSQLServer
)

type ContainerAppProvisioningState = original.ContainerAppProvisioningState

const (
	ContainerAppProvisioningStateCanceled   ContainerAppProvisioningState = original.ContainerAppProvisioningStateCanceled
	ContainerAppProvisioningStateFailed     ContainerAppProvisioningState = original.ContainerAppProvisioningStateFailed
	ContainerAppProvisioningStateInProgress ContainerAppProvisioningState = original.ContainerAppProvisioningStateInProgress
	ContainerAppProvisioningStateSucceeded  ContainerAppProvisioningState = original.ContainerAppProvisioningStateSucceeded
)

type ContinuousWebJobStatus = original.ContinuousWebJobStatus

const (
	ContinuousWebJobStatusInitializing   ContinuousWebJobStatus = original.ContinuousWebJobStatusInitializing
	ContinuousWebJobStatusPendingRestart ContinuousWebJobStatus = original.ContinuousWebJobStatusPendingRestart
	ContinuousWebJobStatusRunning        ContinuousWebJobStatus = original.ContinuousWebJobStatusRunning
	ContinuousWebJobStatusStarting       ContinuousWebJobStatus = original.ContinuousWebJobStatusStarting
	ContinuousWebJobStatusStopped        ContinuousWebJobStatus = original.ContinuousWebJobStatusStopped
)

type CookieExpirationConvention = original.CookieExpirationConvention

const (
	CookieExpirationConventionFixedTime               CookieExpirationConvention = original.CookieExpirationConventionFixedTime
	CookieExpirationConventionIdentityProviderDerived CookieExpirationConvention = original.CookieExpirationConventionIdentityProviderDerived
)

type CustomDomainStatus = original.CustomDomainStatus

const (
	CustomDomainStatusAdding                    CustomDomainStatus = original.CustomDomainStatusAdding
	CustomDomainStatusDeleting                  CustomDomainStatus = original.CustomDomainStatusDeleting
	CustomDomainStatusFailed                    CustomDomainStatus = original.CustomDomainStatusFailed
	CustomDomainStatusReady                     CustomDomainStatus = original.CustomDomainStatusReady
	CustomDomainStatusRetrievingValidationToken CustomDomainStatus = original.CustomDomainStatusRetrievingValidationToken
	CustomDomainStatusValidating                CustomDomainStatus = original.CustomDomainStatusValidating
)

type CustomHostNameDNSRecordType = original.CustomHostNameDNSRecordType

const (
	CustomHostNameDNSRecordTypeA     CustomHostNameDNSRecordType = original.CustomHostNameDNSRecordTypeA
	CustomHostNameDNSRecordTypeCName CustomHostNameDNSRecordType = original.CustomHostNameDNSRecordTypeCName
)

type DNSType = original.DNSType

const (
	DNSTypeAzureDNS                  DNSType = original.DNSTypeAzureDNS
	DNSTypeDefaultDomainRegistrarDNS DNSType = original.DNSTypeDefaultDomainRegistrarDNS
)

type DNSVerificationTestResult = original.DNSVerificationTestResult

const (
	DNSVerificationTestResultFailed  DNSVerificationTestResult = original.DNSVerificationTestResultFailed
	DNSVerificationTestResultPassed  DNSVerificationTestResult = original.DNSVerificationTestResultPassed
	DNSVerificationTestResultSkipped DNSVerificationTestResult = original.DNSVerificationTestResultSkipped
)

type DatabaseType = original.DatabaseType

const (
	DatabaseTypeLocalMySQL DatabaseType = original.DatabaseTypeLocalMySQL
	DatabaseTypeMySQL      DatabaseType = original.DatabaseTypeMySQL
	DatabaseTypePostgreSQL DatabaseType = original.DatabaseTypePostgreSQL
	DatabaseTypeSQLAzure   DatabaseType = original.DatabaseTypeSQLAzure
)

type DetectorType = original.DetectorType

const (
	DetectorTypeAnalysis         DetectorType = original.DetectorTypeAnalysis
	DetectorTypeCategoryOverview DetectorType = original.DetectorTypeCategoryOverview
	DetectorTypeDetector         DetectorType = original.DetectorTypeDetector
)

type DomainStatus = original.DomainStatus

const (
	DomainStatusActive              DomainStatus = original.DomainStatusActive
	DomainStatusAwaiting            DomainStatus = original.DomainStatusAwaiting
	DomainStatusCancelled           DomainStatus = original.DomainStatusCancelled
	DomainStatusConfiscated         DomainStatus = original.DomainStatusConfiscated
	DomainStatusDisabled            DomainStatus = original.DomainStatusDisabled
	DomainStatusExcluded            DomainStatus = original.DomainStatusExcluded
	DomainStatusExpired             DomainStatus = original.DomainStatusExpired
	DomainStatusFailed              DomainStatus = original.DomainStatusFailed
	DomainStatusHeld                DomainStatus = original.DomainStatusHeld
	DomainStatusJSONConverterFailed DomainStatus = original.DomainStatusJSONConverterFailed
	DomainStatusLocked              DomainStatus = original.DomainStatusLocked
	DomainStatusParked              DomainStatus = original.DomainStatusParked
	DomainStatusPending             DomainStatus = original.DomainStatusPending
	DomainStatusReserved            DomainStatus = original.DomainStatusReserved
	DomainStatusReverted            DomainStatus = original.DomainStatusReverted
	DomainStatusSuspended           DomainStatus = original.DomainStatusSuspended
	DomainStatusTransferred         DomainStatus = original.DomainStatusTransferred
	DomainStatusUnknown             DomainStatus = original.DomainStatusUnknown
	DomainStatusUnlocked            DomainStatus = original.DomainStatusUnlocked
	DomainStatusUnparked            DomainStatus = original.DomainStatusUnparked
	DomainStatusUpdated             DomainStatus = original.DomainStatusUpdated
)

type DomainType = original.DomainType

const (
	DomainTypeRegular     DomainType = original.DomainTypeRegular
	DomainTypeSoftDeleted DomainType = original.DomainTypeSoftDeleted
)

type EnterpriseGradeCdnStatus = original.EnterpriseGradeCdnStatus

const (
	EnterpriseGradeCdnStatusDisabled  EnterpriseGradeCdnStatus = original.EnterpriseGradeCdnStatusDisabled
	EnterpriseGradeCdnStatusDisabling EnterpriseGradeCdnStatus = original.EnterpriseGradeCdnStatusDisabling
	EnterpriseGradeCdnStatusEnabled   EnterpriseGradeCdnStatus = original.EnterpriseGradeCdnStatusEnabled
	EnterpriseGradeCdnStatusEnabling  EnterpriseGradeCdnStatus = original.EnterpriseGradeCdnStatusEnabling
)

type ForwardProxyConvention = original.ForwardProxyConvention

const (
	ForwardProxyConventionCustom   ForwardProxyConvention = original.ForwardProxyConventionCustom
	ForwardProxyConventionNoProxy  ForwardProxyConvention = original.ForwardProxyConventionNoProxy
	ForwardProxyConventionStandard ForwardProxyConvention = original.ForwardProxyConventionStandard
)

type FrequencyUnit = original.FrequencyUnit

const (
	FrequencyUnitDay  FrequencyUnit = original.FrequencyUnitDay
	FrequencyUnitHour FrequencyUnit = original.FrequencyUnitHour
)

type FrontEndServiceType = original.FrontEndServiceType

const (
	FrontEndServiceTypeLoadBalancer FrontEndServiceType = original.FrontEndServiceTypeLoadBalancer
	FrontEndServiceTypeNodePort     FrontEndServiceType = original.FrontEndServiceTypeNodePort
)

type FtpsState = original.FtpsState

const (
	FtpsStateAllAllowed FtpsState = original.FtpsStateAllAllowed
	FtpsStateDisabled   FtpsState = original.FtpsStateDisabled
	FtpsStateFtpsOnly   FtpsState = original.FtpsStateFtpsOnly
)

type HostNameType = original.HostNameType

const (
	HostNameTypeManaged  HostNameType = original.HostNameTypeManaged
	HostNameTypeVerified HostNameType = original.HostNameTypeVerified
)

type HostType = original.HostType

const (
	HostTypeRepository HostType = original.HostTypeRepository
	HostTypeStandard   HostType = original.HostTypeStandard
)

type HostingEnvironmentStatus = original.HostingEnvironmentStatus

const (
	HostingEnvironmentStatusDeleting  HostingEnvironmentStatus = original.HostingEnvironmentStatusDeleting
	HostingEnvironmentStatusPreparing HostingEnvironmentStatus = original.HostingEnvironmentStatusPreparing
	HostingEnvironmentStatusReady     HostingEnvironmentStatus = original.HostingEnvironmentStatusReady
	HostingEnvironmentStatusScaling   HostingEnvironmentStatus = original.HostingEnvironmentStatusScaling
)

type IPFilterTag = original.IPFilterTag

const (
	IPFilterTagDefault    IPFilterTag = original.IPFilterTagDefault
	IPFilterTagServiceTag IPFilterTag = original.IPFilterTagServiceTag
	IPFilterTagXffProxy   IPFilterTag = original.IPFilterTagXffProxy
)

type InAvailabilityReasonType = original.InAvailabilityReasonType

const (
	InAvailabilityReasonTypeAlreadyExists InAvailabilityReasonType = original.InAvailabilityReasonTypeAlreadyExists
	InAvailabilityReasonTypeInvalid       InAvailabilityReasonType = original.InAvailabilityReasonTypeInvalid
)

type IngressTransportMethod = original.IngressTransportMethod

const (
	IngressTransportMethodAuto  IngressTransportMethod = original.IngressTransportMethodAuto
	IngressTransportMethodHTTP  IngressTransportMethod = original.IngressTransportMethodHTTP
	IngressTransportMethodHTTP2 IngressTransportMethod = original.IngressTransportMethodHTTP2
)

type InsightStatus = original.InsightStatus

const (
	InsightStatusCritical InsightStatus = original.InsightStatusCritical
	InsightStatusInfo     InsightStatus = original.InsightStatusInfo
	InsightStatusNone     InsightStatus = original.InsightStatusNone
	InsightStatusSuccess  InsightStatus = original.InsightStatusSuccess
	InsightStatusWarning  InsightStatus = original.InsightStatusWarning
)

type IssueType = original.IssueType

const (
	IssueTypeAppCrash             IssueType = original.IssueTypeAppCrash
	IssueTypeAppDeployment        IssueType = original.IssueTypeAppDeployment
	IssueTypeAseDeployment        IssueType = original.IssueTypeAseDeployment
	IssueTypeOther                IssueType = original.IssueTypeOther
	IssueTypePlatformIssue        IssueType = original.IssueTypePlatformIssue
	IssueTypeRuntimeIssueDetected IssueType = original.IssueTypeRuntimeIssueDetected
	IssueTypeServiceIncident      IssueType = original.IssueTypeServiceIncident
	IssueTypeUserIssue            IssueType = original.IssueTypeUserIssue
)

type JobType = original.JobType

const (
	JobTypeContinuous JobType = original.JobTypeContinuous
	JobTypeTriggered  JobType = original.JobTypeTriggered
)

type KeyVaultSecretStatus = original.KeyVaultSecretStatus

const (
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = original.KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault
	KeyVaultSecretStatusCertificateOrderFailed                   KeyVaultSecretStatus = original.KeyVaultSecretStatusCertificateOrderFailed
	KeyVaultSecretStatusExternalPrivateKey                       KeyVaultSecretStatus = original.KeyVaultSecretStatusExternalPrivateKey
	KeyVaultSecretStatusInitialized                              KeyVaultSecretStatus = original.KeyVaultSecretStatusInitialized
	KeyVaultSecretStatusKeyVaultDoesNotExist                     KeyVaultSecretStatus = original.KeyVaultSecretStatusKeyVaultDoesNotExist
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist               KeyVaultSecretStatus = original.KeyVaultSecretStatusKeyVaultSecretDoesNotExist
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault          KeyVaultSecretStatus = original.KeyVaultSecretStatusOperationNotPermittedOnKeyVault
	KeyVaultSecretStatusSucceeded                                KeyVaultSecretStatus = original.KeyVaultSecretStatusSucceeded
	KeyVaultSecretStatusUnknown                                  KeyVaultSecretStatus = original.KeyVaultSecretStatusUnknown
	KeyVaultSecretStatusUnknownError                             KeyVaultSecretStatus = original.KeyVaultSecretStatusUnknownError
	KeyVaultSecretStatusWaitingOnCertificateOrder                KeyVaultSecretStatus = original.KeyVaultSecretStatusWaitingOnCertificateOrder
)

type KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningState

const (
	KubeEnvironmentProvisioningStateCanceled                      KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateCanceled
	KubeEnvironmentProvisioningStateFailed                        KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateFailed
	KubeEnvironmentProvisioningStateInfrastructureSetupComplete   KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateInfrastructureSetupComplete
	KubeEnvironmentProvisioningStateInfrastructureSetupInProgress KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateInfrastructureSetupInProgress
	KubeEnvironmentProvisioningStateInitializationInProgress      KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateInitializationInProgress
	KubeEnvironmentProvisioningStateScheduledForDelete            KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateScheduledForDelete
	KubeEnvironmentProvisioningStateSucceeded                     KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateSucceeded
	KubeEnvironmentProvisioningStateUpgradeFailed                 KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateUpgradeFailed
	KubeEnvironmentProvisioningStateUpgradeRequested              KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateUpgradeRequested
	KubeEnvironmentProvisioningStateWaiting                       KubeEnvironmentProvisioningState = original.KubeEnvironmentProvisioningStateWaiting
)

type LoadBalancingMode = original.LoadBalancingMode

const (
	LoadBalancingModeNone          LoadBalancingMode = original.LoadBalancingModeNone
	LoadBalancingModePublishing    LoadBalancingMode = original.LoadBalancingModePublishing
	LoadBalancingModeWeb           LoadBalancingMode = original.LoadBalancingModeWeb
	LoadBalancingModeWebPublishing LoadBalancingMode = original.LoadBalancingModeWebPublishing
)

type LogLevel = original.LogLevel

const (
	LogLevelError       LogLevel = original.LogLevelError
	LogLevelInformation LogLevel = original.LogLevelInformation
	LogLevelOff         LogLevel = original.LogLevelOff
	LogLevelVerbose     LogLevel = original.LogLevelVerbose
	LogLevelWarning     LogLevel = original.LogLevelWarning
)

type MSDeployLogEntryType = original.MSDeployLogEntryType

const (
	MSDeployLogEntryTypeError   MSDeployLogEntryType = original.MSDeployLogEntryTypeError
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = original.MSDeployLogEntryTypeMessage
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = original.MSDeployLogEntryTypeWarning
)

type MSDeployProvisioningState = original.MSDeployProvisioningState

const (
	MSDeployProvisioningStateAccepted  MSDeployProvisioningState = original.MSDeployProvisioningStateAccepted
	MSDeployProvisioningStateCanceled  MSDeployProvisioningState = original.MSDeployProvisioningStateCanceled
	MSDeployProvisioningStateFailed    MSDeployProvisioningState = original.MSDeployProvisioningStateFailed
	MSDeployProvisioningStateRunning   MSDeployProvisioningState = original.MSDeployProvisioningStateRunning
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = original.MSDeployProvisioningStateSucceeded
)

type ManagedPipelineMode = original.ManagedPipelineMode

const (
	ManagedPipelineModeClassic    ManagedPipelineMode = original.ManagedPipelineModeClassic
	ManagedPipelineModeIntegrated ManagedPipelineMode = original.ManagedPipelineModeIntegrated
)

type ManagedServiceIdentityType = original.ManagedServiceIdentityType

const (
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = original.ManagedServiceIdentityTypeNone
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = original.ManagedServiceIdentityTypeSystemAssigned
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = original.ManagedServiceIdentityTypeSystemAssignedUserAssigned
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = original.ManagedServiceIdentityTypeUserAssigned
)

type MySQLMigrationType = original.MySQLMigrationType

const (
	MySQLMigrationTypeLocalToRemote MySQLMigrationType = original.MySQLMigrationTypeLocalToRemote
	MySQLMigrationTypeRemoteToLocal MySQLMigrationType = original.MySQLMigrationTypeRemoteToLocal
)

type NotificationLevel = original.NotificationLevel

const (
	NotificationLevelCritical            NotificationLevel = original.NotificationLevelCritical
	NotificationLevelInformation         NotificationLevel = original.NotificationLevelInformation
	NotificationLevelNonUrgentSuggestion NotificationLevel = original.NotificationLevelNonUrgentSuggestion
	NotificationLevelWarning             NotificationLevel = original.NotificationLevelWarning
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusCreated    OperationStatus = original.OperationStatusCreated
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
	OperationStatusTimedOut   OperationStatus = original.OperationStatusTimedOut
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCanceled   ProvisioningState = original.ProvisioningStateCanceled
	ProvisioningStateDeleting   ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed     ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateInProgress ProvisioningState = original.ProvisioningStateInProgress
	ProvisioningStateSucceeded  ProvisioningState = original.ProvisioningStateSucceeded
)

type PublicCertificateLocation = original.PublicCertificateLocation

const (
	PublicCertificateLocationCurrentUserMy  PublicCertificateLocation = original.PublicCertificateLocationCurrentUserMy
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = original.PublicCertificateLocationLocalMachineMy
	PublicCertificateLocationUnknown        PublicCertificateLocation = original.PublicCertificateLocationUnknown
)

type PublishingProfileFormat = original.PublishingProfileFormat

const (
	PublishingProfileFormatFileZilla3 PublishingProfileFormat = original.PublishingProfileFormatFileZilla3
	PublishingProfileFormatFtp        PublishingProfileFormat = original.PublishingProfileFormatFtp
	PublishingProfileFormatWebDeploy  PublishingProfileFormat = original.PublishingProfileFormatWebDeploy
)

type RedundancyMode = original.RedundancyMode

const (
	RedundancyModeActiveActive RedundancyMode = original.RedundancyModeActiveActive
	RedundancyModeFailover     RedundancyMode = original.RedundancyModeFailover
	RedundancyModeGeoRedundant RedundancyMode = original.RedundancyModeGeoRedundant
	RedundancyModeManual       RedundancyMode = original.RedundancyModeManual
	RedundancyModeNone         RedundancyMode = original.RedundancyModeNone
)

type RenderingType = original.RenderingType

const (
	RenderingTypeAppInsight               RenderingType = original.RenderingTypeAppInsight
	RenderingTypeAppInsightEnablement     RenderingType = original.RenderingTypeAppInsightEnablement
	RenderingTypeCard                     RenderingType = original.RenderingTypeCard
	RenderingTypeChangeAnalysisOnboarding RenderingType = original.RenderingTypeChangeAnalysisOnboarding
	RenderingTypeChangeSets               RenderingType = original.RenderingTypeChangeSets
	RenderingTypeChangesView              RenderingType = original.RenderingTypeChangesView
	RenderingTypeDataSummary              RenderingType = original.RenderingTypeDataSummary
	RenderingTypeDependencyGraph          RenderingType = original.RenderingTypeDependencyGraph
	RenderingTypeDetector                 RenderingType = original.RenderingTypeDetector
	RenderingTypeDownTime                 RenderingType = original.RenderingTypeDownTime
	RenderingTypeDropDown                 RenderingType = original.RenderingTypeDropDown
	RenderingTypeDynamicInsight           RenderingType = original.RenderingTypeDynamicInsight
	RenderingTypeEmail                    RenderingType = original.RenderingTypeEmail
	RenderingTypeForm                     RenderingType = original.RenderingTypeForm
	RenderingTypeGuage                    RenderingType = original.RenderingTypeGuage
	RenderingTypeInsights                 RenderingType = original.RenderingTypeInsights
	RenderingTypeMarkdown                 RenderingType = original.RenderingTypeMarkdown
	RenderingTypeNoGraph                  RenderingType = original.RenderingTypeNoGraph
	RenderingTypePieChart                 RenderingType = original.RenderingTypePieChart
	RenderingTypeSearchComponent          RenderingType = original.RenderingTypeSearchComponent
	RenderingTypeSolution                 RenderingType = original.RenderingTypeSolution
	RenderingTypeSummaryCard              RenderingType = original.RenderingTypeSummaryCard
	RenderingTypeTable                    RenderingType = original.RenderingTypeTable
	RenderingTypeTimeSeries               RenderingType = original.RenderingTypeTimeSeries
	RenderingTypeTimeSeriesPerInstance    RenderingType = original.RenderingTypeTimeSeriesPerInstance
)

type ResolveStatus = original.ResolveStatus

const (
	ResolveStatusAccessToKeyVaultDenied ResolveStatus = original.ResolveStatusAccessToKeyVaultDenied
	ResolveStatusFetchTimedOut          ResolveStatus = original.ResolveStatusFetchTimedOut
	ResolveStatusInitialized            ResolveStatus = original.ResolveStatusInitialized
	ResolveStatusInvalidSyntax          ResolveStatus = original.ResolveStatusInvalidSyntax
	ResolveStatusMSINotEnabled          ResolveStatus = original.ResolveStatusMSINotEnabled
	ResolveStatusOtherReasons           ResolveStatus = original.ResolveStatusOtherReasons
	ResolveStatusResolved               ResolveStatus = original.ResolveStatusResolved
	ResolveStatusSecretNotFound         ResolveStatus = original.ResolveStatusSecretNotFound
	ResolveStatusSecretVersionNotFound  ResolveStatus = original.ResolveStatusSecretVersionNotFound
	ResolveStatusUnauthorizedClient     ResolveStatus = original.ResolveStatusUnauthorizedClient
	ResolveStatusVaultNotFound          ResolveStatus = original.ResolveStatusVaultNotFound
)

type ResourceScopeType = original.ResourceScopeType

const (
	ResourceScopeTypeServerFarm   ResourceScopeType = original.ResourceScopeTypeServerFarm
	ResourceScopeTypeSubscription ResourceScopeType = original.ResourceScopeTypeSubscription
	ResourceScopeTypeWebSite      ResourceScopeType = original.ResourceScopeTypeWebSite
)

type RevisionHealthState = original.RevisionHealthState

const (
	RevisionHealthStateHealthy   RevisionHealthState = original.RevisionHealthStateHealthy
	RevisionHealthStateNone      RevisionHealthState = original.RevisionHealthStateNone
	RevisionHealthStateUnhealthy RevisionHealthState = original.RevisionHealthStateUnhealthy
)

type RevisionProvisioningState = original.RevisionProvisioningState

const (
	RevisionProvisioningStateDeprovisioned  RevisionProvisioningState = original.RevisionProvisioningStateDeprovisioned
	RevisionProvisioningStateDeprovisioning RevisionProvisioningState = original.RevisionProvisioningStateDeprovisioning
	RevisionProvisioningStateFailed         RevisionProvisioningState = original.RevisionProvisioningStateFailed
	RevisionProvisioningStateProvisioned    RevisionProvisioningState = original.RevisionProvisioningStateProvisioned
	RevisionProvisioningStateProvisioning   RevisionProvisioningState = original.RevisionProvisioningStateProvisioning
)

type RouteType = original.RouteType

const (
	RouteTypeDEFAULT   RouteType = original.RouteTypeDEFAULT
	RouteTypeINHERITED RouteType = original.RouteTypeINHERITED
	RouteTypeSTATIC    RouteType = original.RouteTypeSTATIC
)

type ScmType = original.ScmType

const (
	ScmTypeBitbucketGit ScmType = original.ScmTypeBitbucketGit
	ScmTypeBitbucketHg  ScmType = original.ScmTypeBitbucketHg
	ScmTypeCodePlexGit  ScmType = original.ScmTypeCodePlexGit
	ScmTypeCodePlexHg   ScmType = original.ScmTypeCodePlexHg
	ScmTypeDropbox      ScmType = original.ScmTypeDropbox
	ScmTypeExternalGit  ScmType = original.ScmTypeExternalGit
	ScmTypeExternalHg   ScmType = original.ScmTypeExternalHg
	ScmTypeGitHub       ScmType = original.ScmTypeGitHub
	ScmTypeLocalGit     ScmType = original.ScmTypeLocalGit
	ScmTypeNone         ScmType = original.ScmTypeNone
	ScmTypeOneDrive     ScmType = original.ScmTypeOneDrive
	ScmTypeTfs          ScmType = original.ScmTypeTfs
	ScmTypeVSO          ScmType = original.ScmTypeVSO
	ScmTypeVSTSRM       ScmType = original.ScmTypeVSTSRM
)

type SiteAvailabilityState = original.SiteAvailabilityState

const (
	SiteAvailabilityStateDisasterRecoveryMode SiteAvailabilityState = original.SiteAvailabilityStateDisasterRecoveryMode
	SiteAvailabilityStateLimited              SiteAvailabilityState = original.SiteAvailabilityStateLimited
	SiteAvailabilityStateNormal               SiteAvailabilityState = original.SiteAvailabilityStateNormal
)

type SiteExtensionType = original.SiteExtensionType

const (
	SiteExtensionTypeGallery SiteExtensionType = original.SiteExtensionTypeGallery
	SiteExtensionTypeWebRoot SiteExtensionType = original.SiteExtensionTypeWebRoot
)

type SiteLoadBalancing = original.SiteLoadBalancing

const (
	SiteLoadBalancingLeastRequests        SiteLoadBalancing = original.SiteLoadBalancingLeastRequests
	SiteLoadBalancingLeastResponseTime    SiteLoadBalancing = original.SiteLoadBalancingLeastResponseTime
	SiteLoadBalancingPerSiteRoundRobin    SiteLoadBalancing = original.SiteLoadBalancingPerSiteRoundRobin
	SiteLoadBalancingRequestHash          SiteLoadBalancing = original.SiteLoadBalancingRequestHash
	SiteLoadBalancingWeightedRoundRobin   SiteLoadBalancing = original.SiteLoadBalancingWeightedRoundRobin
	SiteLoadBalancingWeightedTotalTraffic SiteLoadBalancing = original.SiteLoadBalancingWeightedTotalTraffic
)

type SiteRuntimeState = original.SiteRuntimeState

const (
	SiteRuntimeStateREADY   SiteRuntimeState = original.SiteRuntimeStateREADY
	SiteRuntimeStateSTOPPED SiteRuntimeState = original.SiteRuntimeStateSTOPPED
	SiteRuntimeStateUNKNOWN SiteRuntimeState = original.SiteRuntimeStateUNKNOWN
)

type SkuName = original.SkuName

const (
	SkuNameBasic            SkuName = original.SkuNameBasic
	SkuNameDynamic          SkuName = original.SkuNameDynamic
	SkuNameElasticIsolated  SkuName = original.SkuNameElasticIsolated
	SkuNameElasticPremium   SkuName = original.SkuNameElasticPremium
	SkuNameFree             SkuName = original.SkuNameFree
	SkuNameIsolated         SkuName = original.SkuNameIsolated
	SkuNameIsolatedV2       SkuName = original.SkuNameIsolatedV2
	SkuNamePremium          SkuName = original.SkuNamePremium
	SkuNamePremiumContainer SkuName = original.SkuNamePremiumContainer
	SkuNamePremiumV2        SkuName = original.SkuNamePremiumV2
	SkuNamePremiumV3        SkuName = original.SkuNamePremiumV3
	SkuNameShared           SkuName = original.SkuNameShared
	SkuNameStandard         SkuName = original.SkuNameStandard
)

type SolutionType = original.SolutionType

const (
	SolutionTypeBestPractices     SolutionType = original.SolutionTypeBestPractices
	SolutionTypeDeepInvestigation SolutionType = original.SolutionTypeDeepInvestigation
	SolutionTypeQuickSolution     SolutionType = original.SolutionTypeQuickSolution
)

type SslState = original.SslState

const (
	SslStateDisabled       SslState = original.SslStateDisabled
	SslStateIPBasedEnabled SslState = original.SslStateIPBasedEnabled
	SslStateSniEnabled     SslState = original.SslStateSniEnabled
)

type StackPreferredOs = original.StackPreferredOs

const (
	StackPreferredOsLinux   StackPreferredOs = original.StackPreferredOsLinux
	StackPreferredOsWindows StackPreferredOs = original.StackPreferredOsWindows
)

type StagingEnvironmentPolicy = original.StagingEnvironmentPolicy

const (
	StagingEnvironmentPolicyDisabled StagingEnvironmentPolicy = original.StagingEnvironmentPolicyDisabled
	StagingEnvironmentPolicyEnabled  StagingEnvironmentPolicy = original.StagingEnvironmentPolicyEnabled
)

type StatusOptions = original.StatusOptions

const (
	StatusOptionsCreating StatusOptions = original.StatusOptionsCreating
	StatusOptionsPending  StatusOptions = original.StatusOptionsPending
	StatusOptionsReady    StatusOptions = original.StatusOptionsReady
)

type StorageType = original.StorageType

const (
	StorageTypeLocalNode         StorageType = original.StorageTypeLocalNode
	StorageTypeNetworkFileSystem StorageType = original.StorageTypeNetworkFileSystem
)

type SupportedTLSVersions = original.SupportedTLSVersions

const (
	SupportedTLSVersionsOneFullStopOne  SupportedTLSVersions = original.SupportedTLSVersionsOneFullStopOne
	SupportedTLSVersionsOneFullStopTwo  SupportedTLSVersions = original.SupportedTLSVersionsOneFullStopTwo
	SupportedTLSVersionsOneFullStopZero SupportedTLSVersions = original.SupportedTLSVersionsOneFullStopZero
)

type TriggerTypes = original.TriggerTypes

const (
	TriggerTypesHTTPTrigger TriggerTypes = original.TriggerTypesHTTPTrigger
	TriggerTypesUnknown     TriggerTypes = original.TriggerTypesUnknown
)

type TriggeredWebJobStatus = original.TriggeredWebJobStatus

const (
	TriggeredWebJobStatusError   TriggeredWebJobStatus = original.TriggeredWebJobStatusError
	TriggeredWebJobStatusFailed  TriggeredWebJobStatus = original.TriggeredWebJobStatusFailed
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = original.TriggeredWebJobStatusSuccess
)

type UnauthenticatedClientAction = original.UnauthenticatedClientAction

const (
	UnauthenticatedClientActionAllowAnonymous      UnauthenticatedClientAction = original.UnauthenticatedClientActionAllowAnonymous
	UnauthenticatedClientActionRedirectToLoginPage UnauthenticatedClientAction = original.UnauthenticatedClientActionRedirectToLoginPage
)

type UnauthenticatedClientActionV2 = original.UnauthenticatedClientActionV2

const (
	UnauthenticatedClientActionV2AllowAnonymous      UnauthenticatedClientActionV2 = original.UnauthenticatedClientActionV2AllowAnonymous
	UnauthenticatedClientActionV2RedirectToLoginPage UnauthenticatedClientActionV2 = original.UnauthenticatedClientActionV2RedirectToLoginPage
	UnauthenticatedClientActionV2Return401           UnauthenticatedClientActionV2 = original.UnauthenticatedClientActionV2Return401
	UnauthenticatedClientActionV2Return403           UnauthenticatedClientActionV2 = original.UnauthenticatedClientActionV2Return403
)

type UsageState = original.UsageState

const (
	UsageStateExceeded UsageState = original.UsageStateExceeded
	UsageStateNormal   UsageState = original.UsageStateNormal
)

type ValidateResourceTypes = original.ValidateResourceTypes

const (
	ValidateResourceTypesMicrosoftWebhostingEnvironments ValidateResourceTypes = original.ValidateResourceTypesMicrosoftWebhostingEnvironments
	ValidateResourceTypesServerFarm                      ValidateResourceTypes = original.ValidateResourceTypesServerFarm
	ValidateResourceTypesSite                            ValidateResourceTypes = original.ValidateResourceTypesSite
)

type WorkerSizeOptions = original.WorkerSizeOptions

const (
	WorkerSizeOptionsD1               WorkerSizeOptions = original.WorkerSizeOptionsD1
	WorkerSizeOptionsD2               WorkerSizeOptions = original.WorkerSizeOptionsD2
	WorkerSizeOptionsD3               WorkerSizeOptions = original.WorkerSizeOptionsD3
	WorkerSizeOptionsDefault          WorkerSizeOptions = original.WorkerSizeOptionsDefault
	WorkerSizeOptionsLarge            WorkerSizeOptions = original.WorkerSizeOptionsLarge
	WorkerSizeOptionsLargeV3          WorkerSizeOptions = original.WorkerSizeOptionsLargeV3
	WorkerSizeOptionsMedium           WorkerSizeOptions = original.WorkerSizeOptionsMedium
	WorkerSizeOptionsMediumV3         WorkerSizeOptions = original.WorkerSizeOptionsMediumV3
	WorkerSizeOptionsNestedSmall      WorkerSizeOptions = original.WorkerSizeOptionsNestedSmall
	WorkerSizeOptionsNestedSmallLinux WorkerSizeOptions = original.WorkerSizeOptionsNestedSmallLinux
	WorkerSizeOptionsSmall            WorkerSizeOptions = original.WorkerSizeOptionsSmall
	WorkerSizeOptionsSmallV3          WorkerSizeOptions = original.WorkerSizeOptionsSmallV3
)

type APIDefinitionInfo = original.APIDefinitionInfo
type APIKVReference = original.APIKVReference
type APIKVReferenceCollection = original.APIKVReferenceCollection
type APIKVReferenceCollectionIterator = original.APIKVReferenceCollectionIterator
type APIKVReferenceCollectionPage = original.APIKVReferenceCollectionPage
type APIKVReferenceProperties = original.APIKVReferenceProperties
type APIManagementConfig = original.APIManagementConfig
type AbnormalTimePeriod = original.AbnormalTimePeriod
type Address = original.Address
type AddressResponse = original.AddressResponse
type AddressResponseProperties = original.AddressResponseProperties
type AllowedAudiencesValidation = original.AllowedAudiencesValidation
type AllowedPrincipals = original.AllowedPrincipals
type AnalysisData = original.AnalysisData
type AnalysisDefinition = original.AnalysisDefinition
type AnalysisDefinitionProperties = original.AnalysisDefinitionProperties
type AppCollection = original.AppCollection
type AppCollectionIterator = original.AppCollectionIterator
type AppCollectionPage = original.AppCollectionPage
type AppInsightsWebAppStackSettings = original.AppInsightsWebAppStackSettings
type AppInstanceStatusCollection = original.AppInstanceStatusCollection
type AppInstanceStatusCollectionIterator = original.AppInstanceStatusCollectionIterator
type AppInstanceStatusCollectionPage = original.AppInstanceStatusCollectionPage
type AppLogsConfiguration = original.AppLogsConfiguration
type AppMajorVersion = original.AppMajorVersion
type AppMinorVersion = original.AppMinorVersion
type AppRegistration = original.AppRegistration
type AppRuntimeSettings = original.AppRuntimeSettings
type AppRuntimes = original.AppRuntimes
type AppServiceCertificate = original.AppServiceCertificate
type AppServiceCertificateCollection = original.AppServiceCertificateCollection
type AppServiceCertificateCollectionIterator = original.AppServiceCertificateCollectionIterator
type AppServiceCertificateCollectionPage = original.AppServiceCertificateCollectionPage
type AppServiceCertificateOrder = original.AppServiceCertificateOrder
type AppServiceCertificateOrderCollection = original.AppServiceCertificateOrderCollection
type AppServiceCertificateOrderCollectionIterator = original.AppServiceCertificateOrderCollectionIterator
type AppServiceCertificateOrderCollectionPage = original.AppServiceCertificateOrderCollectionPage
type AppServiceCertificateOrderPatchResource = original.AppServiceCertificateOrderPatchResource
type AppServiceCertificateOrderPatchResourceProperties = original.AppServiceCertificateOrderPatchResourceProperties
type AppServiceCertificateOrderProperties = original.AppServiceCertificateOrderProperties
type AppServiceCertificateOrdersClient = original.AppServiceCertificateOrdersClient
type AppServiceCertificateOrdersCreateOrUpdateCertificateFuture = original.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture
type AppServiceCertificateOrdersCreateOrUpdateFuture = original.AppServiceCertificateOrdersCreateOrUpdateFuture
type AppServiceCertificatePatchResource = original.AppServiceCertificatePatchResource
type AppServiceCertificateResource = original.AppServiceCertificateResource
type AppServiceEnvironment = original.AppServiceEnvironment
type AppServiceEnvironmentCollection = original.AppServiceEnvironmentCollection
type AppServiceEnvironmentCollectionIterator = original.AppServiceEnvironmentCollectionIterator
type AppServiceEnvironmentCollectionPage = original.AppServiceEnvironmentCollectionPage
type AppServiceEnvironmentPatchResource = original.AppServiceEnvironmentPatchResource
type AppServiceEnvironmentResource = original.AppServiceEnvironmentResource
type AppServiceEnvironmentsApproveOrRejectPrivateEndpointConnectionFuture = original.AppServiceEnvironmentsApproveOrRejectPrivateEndpointConnectionFuture
type AppServiceEnvironmentsChangeVnetAllFuture = original.AppServiceEnvironmentsChangeVnetAllFuture
type AppServiceEnvironmentsChangeVnetFuture = original.AppServiceEnvironmentsChangeVnetFuture
type AppServiceEnvironmentsClient = original.AppServiceEnvironmentsClient
type AppServiceEnvironmentsCreateOrUpdateFuture = original.AppServiceEnvironmentsCreateOrUpdateFuture
type AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture = original.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture
type AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture = original.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture
type AppServiceEnvironmentsDeleteFuture = original.AppServiceEnvironmentsDeleteFuture
type AppServiceEnvironmentsDeletePrivateEndpointConnectionFuture = original.AppServiceEnvironmentsDeletePrivateEndpointConnectionFuture
type AppServiceEnvironmentsResumeAllFuture = original.AppServiceEnvironmentsResumeAllFuture
type AppServiceEnvironmentsResumeFuture = original.AppServiceEnvironmentsResumeFuture
type AppServiceEnvironmentsSuspendAllFuture = original.AppServiceEnvironmentsSuspendAllFuture
type AppServiceEnvironmentsSuspendFuture = original.AppServiceEnvironmentsSuspendFuture
type AppServicePlan = original.AppServicePlan
type AppServicePlanCollection = original.AppServicePlanCollection
type AppServicePlanCollectionIterator = original.AppServicePlanCollectionIterator
type AppServicePlanCollectionPage = original.AppServicePlanCollectionPage
type AppServicePlanPatchResource = original.AppServicePlanPatchResource
type AppServicePlanPatchResourceProperties = original.AppServicePlanPatchResourceProperties
type AppServicePlanProperties = original.AppServicePlanProperties
type AppServicePlansClient = original.AppServicePlansClient
type AppServicePlansCreateOrUpdateFuture = original.AppServicePlansCreateOrUpdateFuture
type AppStack = original.AppStack
type AppStackCollection = original.AppStackCollection
type AppStackCollectionIterator = original.AppStackCollectionIterator
type AppStackCollectionPage = original.AppStackCollectionPage
type AppStackProperties = original.AppStackProperties
type Apple = original.Apple
type AppleRegistration = original.AppleRegistration
type ApplicationLogsConfig = original.ApplicationLogsConfig
type ApplicationStack = original.ApplicationStack
type ApplicationStackCollection = original.ApplicationStackCollection
type ApplicationStackCollectionIterator = original.ApplicationStackCollectionIterator
type ApplicationStackCollectionPage = original.ApplicationStackCollectionPage
type ApplicationStackResource = original.ApplicationStackResource
type AppsApproveOrRejectPrivateEndpointConnectionFuture = original.AppsApproveOrRejectPrivateEndpointConnectionFuture
type AppsApproveOrRejectPrivateEndpointConnectionSlotFuture = original.AppsApproveOrRejectPrivateEndpointConnectionSlotFuture
type AppsClient = original.AppsClient
type AppsCreateFunctionFuture = original.AppsCreateFunctionFuture
type AppsCreateInstanceFunctionSlotFuture = original.AppsCreateInstanceFunctionSlotFuture
type AppsCreateInstanceMSDeployOperationFuture = original.AppsCreateInstanceMSDeployOperationFuture
type AppsCreateInstanceMSDeployOperationSlotFuture = original.AppsCreateInstanceMSDeployOperationSlotFuture
type AppsCreateMSDeployOperationFuture = original.AppsCreateMSDeployOperationFuture
type AppsCreateMSDeployOperationSlotFuture = original.AppsCreateMSDeployOperationSlotFuture
type AppsCreateOrUpdateFuture = original.AppsCreateOrUpdateFuture
type AppsCreateOrUpdateSlotFuture = original.AppsCreateOrUpdateSlotFuture
type AppsCreateOrUpdateSourceControlFuture = original.AppsCreateOrUpdateSourceControlFuture
type AppsCreateOrUpdateSourceControlSlotFuture = original.AppsCreateOrUpdateSourceControlSlotFuture
type AppsDeletePrivateEndpointConnectionFuture = original.AppsDeletePrivateEndpointConnectionFuture
type AppsDeletePrivateEndpointConnectionSlotFuture = original.AppsDeletePrivateEndpointConnectionSlotFuture
type AppsInstallSiteExtensionFuture = original.AppsInstallSiteExtensionFuture
type AppsInstallSiteExtensionSlotFuture = original.AppsInstallSiteExtensionSlotFuture
type AppsListPublishingCredentialsFuture = original.AppsListPublishingCredentialsFuture
type AppsListPublishingCredentialsSlotFuture = original.AppsListPublishingCredentialsSlotFuture
type AppsMigrateMySQLFuture = original.AppsMigrateMySQLFuture
type AppsMigrateStorageFuture = original.AppsMigrateStorageFuture
type AppsRestoreFromBackupBlobFuture = original.AppsRestoreFromBackupBlobFuture
type AppsRestoreFromBackupBlobSlotFuture = original.AppsRestoreFromBackupBlobSlotFuture
type AppsRestoreFromDeletedAppFuture = original.AppsRestoreFromDeletedAppFuture
type AppsRestoreFromDeletedAppSlotFuture = original.AppsRestoreFromDeletedAppSlotFuture
type AppsRestoreFuture = original.AppsRestoreFuture
type AppsRestoreSlotFuture = original.AppsRestoreSlotFuture
type AppsRestoreSnapshotFuture = original.AppsRestoreSnapshotFuture
type AppsRestoreSnapshotSlotFuture = original.AppsRestoreSnapshotSlotFuture
type AppsStartNetworkTraceFuture = original.AppsStartNetworkTraceFuture
type AppsStartNetworkTraceSlotFuture = original.AppsStartNetworkTraceSlotFuture
type AppsStartWebSiteNetworkTraceOperationFuture = original.AppsStartWebSiteNetworkTraceOperationFuture
type AppsStartWebSiteNetworkTraceOperationSlotFuture = original.AppsStartWebSiteNetworkTraceOperationSlotFuture
type AppsSwapSlotSlotFuture = original.AppsSwapSlotSlotFuture
type AppsSwapSlotWithProductionFuture = original.AppsSwapSlotWithProductionFuture
type AppserviceGithubToken = original.AppserviceGithubToken
type AppserviceGithubTokenRequest = original.AppserviceGithubTokenRequest
type ArcConfiguration = original.ArcConfiguration
type ArmIDWrapper = original.ArmIDWrapper
type ArmPlan = original.ArmPlan
type AseV3NetworkingConfiguration = original.AseV3NetworkingConfiguration
type AseV3NetworkingConfigurationProperties = original.AseV3NetworkingConfigurationProperties
type AuthPlatform = original.AuthPlatform
type AutoHealActions = original.AutoHealActions
type AutoHealCustomAction = original.AutoHealCustomAction
type AutoHealRules = original.AutoHealRules
type AutoHealTriggers = original.AutoHealTriggers
type AzureActiveDirectory = original.AzureActiveDirectory
type AzureActiveDirectoryLogin = original.AzureActiveDirectoryLogin
type AzureActiveDirectoryRegistration = original.AzureActiveDirectoryRegistration
type AzureActiveDirectoryValidation = original.AzureActiveDirectoryValidation
type AzureBlobStorageApplicationLogsConfig = original.AzureBlobStorageApplicationLogsConfig
type AzureBlobStorageHTTPLogsConfig = original.AzureBlobStorageHTTPLogsConfig
type AzureStaticWebApps = original.AzureStaticWebApps
type AzureStaticWebAppsRegistration = original.AzureStaticWebAppsRegistration
type AzureStorageInfoValue = original.AzureStorageInfoValue
type AzureStoragePropertyDictionaryResource = original.AzureStoragePropertyDictionaryResource
type AzureTableStorageApplicationLogsConfig = original.AzureTableStorageApplicationLogsConfig
type BackupItem = original.BackupItem
type BackupItemCollection = original.BackupItemCollection
type BackupItemCollectionIterator = original.BackupItemCollectionIterator
type BackupItemCollectionPage = original.BackupItemCollectionPage
type BackupItemProperties = original.BackupItemProperties
type BackupRequest = original.BackupRequest
type BackupRequestProperties = original.BackupRequestProperties
type BackupSchedule = original.BackupSchedule
type BaseClient = original.BaseClient
type BillingMeter = original.BillingMeter
type BillingMeterCollection = original.BillingMeterCollection
type BillingMeterCollectionIterator = original.BillingMeterCollectionIterator
type BillingMeterCollectionPage = original.BillingMeterCollectionPage
type BillingMeterProperties = original.BillingMeterProperties
type BlobStorageTokenStore = original.BlobStorageTokenStore
type Capability = original.Capability
type Certificate = original.Certificate
type CertificateCollection = original.CertificateCollection
type CertificateCollectionIterator = original.CertificateCollectionIterator
type CertificateCollectionPage = original.CertificateCollectionPage
type CertificateDetails = original.CertificateDetails
type CertificateEmail = original.CertificateEmail
type CertificateEmailProperties = original.CertificateEmailProperties
type CertificateOrderAction = original.CertificateOrderAction
type CertificateOrderActionProperties = original.CertificateOrderActionProperties
type CertificateOrderContact = original.CertificateOrderContact
type CertificateOrdersDiagnosticsClient = original.CertificateOrdersDiagnosticsClient
type CertificatePatchResource = original.CertificatePatchResource
type CertificatePatchResourceProperties = original.CertificatePatchResourceProperties
type CertificateProperties = original.CertificateProperties
type CertificateRegistrationProviderClient = original.CertificateRegistrationProviderClient
type CertificatesClient = original.CertificatesClient
type ClientRegistration = original.ClientRegistration
type CloningInfo = original.CloningInfo
type Configuration = original.Configuration
type ConnStringInfo = original.ConnStringInfo
type ConnStringValueTypePair = original.ConnStringValueTypePair
type ConnectionStringDictionary = original.ConnectionStringDictionary
type Contact = original.Contact
type Container = original.Container
type ContainerApp = original.ContainerApp
type ContainerAppCollection = original.ContainerAppCollection
type ContainerAppCollectionIterator = original.ContainerAppCollectionIterator
type ContainerAppCollectionPage = original.ContainerAppCollectionPage
type ContainerAppProperties = original.ContainerAppProperties
type ContainerAppSecret = original.ContainerAppSecret
type ContainerAppsClient = original.ContainerAppsClient
type ContainerAppsConfiguration = original.ContainerAppsConfiguration
type ContainerAppsCreateOrUpdateFuture = original.ContainerAppsCreateOrUpdateFuture
type ContainerAppsDeleteFuture = original.ContainerAppsDeleteFuture
type ContainerAppsRevisionsClient = original.ContainerAppsRevisionsClient
type ContainerCPUStatistics = original.ContainerCPUStatistics
type ContainerCPUUsage = original.ContainerCPUUsage
type ContainerInfo = original.ContainerInfo
type ContainerMemoryStatistics = original.ContainerMemoryStatistics
type ContainerNetworkInterfaceStatistics = original.ContainerNetworkInterfaceStatistics
type ContainerResources = original.ContainerResources
type ContainerThrottlingData = original.ContainerThrottlingData
type ContinuousWebJob = original.ContinuousWebJob
type ContinuousWebJobCollection = original.ContinuousWebJobCollection
type ContinuousWebJobCollectionIterator = original.ContinuousWebJobCollectionIterator
type ContinuousWebJobCollectionPage = original.ContinuousWebJobCollectionPage
type ContinuousWebJobProperties = original.ContinuousWebJobProperties
type CookieExpiration = original.CookieExpiration
type CorsSettings = original.CorsSettings
type CsmMoveResourceEnvelope = original.CsmMoveResourceEnvelope
type CsmOperationCollection = original.CsmOperationCollection
type CsmOperationCollectionIterator = original.CsmOperationCollectionIterator
type CsmOperationCollectionPage = original.CsmOperationCollectionPage
type CsmOperationDescription = original.CsmOperationDescription
type CsmOperationDescriptionProperties = original.CsmOperationDescriptionProperties
type CsmOperationDisplay = original.CsmOperationDisplay
type CsmPublishingCredentialsPoliciesEntity = original.CsmPublishingCredentialsPoliciesEntity
type CsmPublishingCredentialsPoliciesEntityProperties = original.CsmPublishingCredentialsPoliciesEntityProperties
type CsmPublishingProfileOptions = original.CsmPublishingProfileOptions
type CsmSlotEntity = original.CsmSlotEntity
type CsmUsageQuota = original.CsmUsageQuota
type CsmUsageQuotaCollection = original.CsmUsageQuotaCollection
type CsmUsageQuotaCollectionIterator = original.CsmUsageQuotaCollectionIterator
type CsmUsageQuotaCollectionPage = original.CsmUsageQuotaCollectionPage
type CustomHostnameAnalysisResult = original.CustomHostnameAnalysisResult
type CustomHostnameAnalysisResultProperties = original.CustomHostnameAnalysisResultProperties
type CustomHostnameSites = original.CustomHostnameSites
type CustomHostnameSitesCollection = original.CustomHostnameSitesCollection
type CustomHostnameSitesCollectionIterator = original.CustomHostnameSitesCollectionIterator
type CustomHostnameSitesCollectionPage = original.CustomHostnameSitesCollectionPage
type CustomHostnameSitesProperties = original.CustomHostnameSitesProperties
type CustomOpenIDConnectProvider = original.CustomOpenIDConnectProvider
type CustomScaleRule = original.CustomScaleRule
type Dapr = original.Dapr
type DaprComponent = original.DaprComponent
type DaprMetadata = original.DaprMetadata
type DataProviderMetadata = original.DataProviderMetadata
type DataSource = original.DataSource
type DataTableResponseColumn = original.DataTableResponseColumn
type DataTableResponseObject = original.DataTableResponseObject
type DatabaseBackupSetting = original.DatabaseBackupSetting
type DefaultAuthorizationPolicy = original.DefaultAuthorizationPolicy
type DefaultErrorResponse = original.DefaultErrorResponse
type DefaultErrorResponseError = original.DefaultErrorResponseError
type DefaultErrorResponseErrorDetailsItem = original.DefaultErrorResponseErrorDetailsItem
type DeletedAppRestoreRequest = original.DeletedAppRestoreRequest
type DeletedAppRestoreRequestProperties = original.DeletedAppRestoreRequestProperties
type DeletedSite = original.DeletedSite
type DeletedSiteProperties = original.DeletedSiteProperties
type DeletedWebAppCollection = original.DeletedWebAppCollection
type DeletedWebAppCollectionIterator = original.DeletedWebAppCollectionIterator
type DeletedWebAppCollectionPage = original.DeletedWebAppCollectionPage
type DeletedWebAppsClient = original.DeletedWebAppsClient
type Deployment = original.Deployment
type DeploymentCollection = original.DeploymentCollection
type DeploymentCollectionIterator = original.DeploymentCollectionIterator
type DeploymentCollectionPage = original.DeploymentCollectionPage
type DeploymentLocations = original.DeploymentLocations
type DeploymentProperties = original.DeploymentProperties
type DetectorAbnormalTimePeriod = original.DetectorAbnormalTimePeriod
type DetectorDefinition = original.DetectorDefinition
type DetectorDefinitionResource = original.DetectorDefinitionResource
type DetectorInfo = original.DetectorInfo
type DetectorResponse = original.DetectorResponse
type DetectorResponseCollection = original.DetectorResponseCollection
type DetectorResponseCollectionIterator = original.DetectorResponseCollectionIterator
type DetectorResponseCollectionPage = original.DetectorResponseCollectionPage
type DetectorResponseProperties = original.DetectorResponseProperties
type DiagnosticAnalysis = original.DiagnosticAnalysis
type DiagnosticAnalysisCollection = original.DiagnosticAnalysisCollection
type DiagnosticAnalysisCollectionIterator = original.DiagnosticAnalysisCollectionIterator
type DiagnosticAnalysisCollectionPage = original.DiagnosticAnalysisCollectionPage
type DiagnosticAnalysisProperties = original.DiagnosticAnalysisProperties
type DiagnosticCategory = original.DiagnosticCategory
type DiagnosticCategoryCollection = original.DiagnosticCategoryCollection
type DiagnosticCategoryCollectionIterator = original.DiagnosticCategoryCollectionIterator
type DiagnosticCategoryCollectionPage = original.DiagnosticCategoryCollectionPage
type DiagnosticCategoryProperties = original.DiagnosticCategoryProperties
type DiagnosticData = original.DiagnosticData
type DiagnosticDetectorCollection = original.DiagnosticDetectorCollection
type DiagnosticDetectorCollectionIterator = original.DiagnosticDetectorCollectionIterator
type DiagnosticDetectorCollectionPage = original.DiagnosticDetectorCollectionPage
type DiagnosticDetectorResponse = original.DiagnosticDetectorResponse
type DiagnosticDetectorResponseProperties = original.DiagnosticDetectorResponseProperties
type DiagnosticMetricSample = original.DiagnosticMetricSample
type DiagnosticMetricSet = original.DiagnosticMetricSet
type DiagnosticsClient = original.DiagnosticsClient
type Dimension = original.Dimension
type Domain = original.Domain
type DomainAvailabilityCheckResult = original.DomainAvailabilityCheckResult
type DomainCollection = original.DomainCollection
type DomainCollectionIterator = original.DomainCollectionIterator
type DomainCollectionPage = original.DomainCollectionPage
type DomainControlCenterSsoRequest = original.DomainControlCenterSsoRequest
type DomainOwnershipIdentifier = original.DomainOwnershipIdentifier
type DomainOwnershipIdentifierCollection = original.DomainOwnershipIdentifierCollection
type DomainOwnershipIdentifierCollectionIterator = original.DomainOwnershipIdentifierCollectionIterator
type DomainOwnershipIdentifierCollectionPage = original.DomainOwnershipIdentifierCollectionPage
type DomainOwnershipIdentifierProperties = original.DomainOwnershipIdentifierProperties
type DomainPatchResource = original.DomainPatchResource
type DomainPatchResourceProperties = original.DomainPatchResourceProperties
type DomainProperties = original.DomainProperties
type DomainPurchaseConsent = original.DomainPurchaseConsent
type DomainRecommendationSearchParameters = original.DomainRecommendationSearchParameters
type DomainRegistrationProviderClient = original.DomainRegistrationProviderClient
type DomainsClient = original.DomainsClient
type DomainsCreateOrUpdateFuture = original.DomainsCreateOrUpdateFuture
type EnabledConfig = original.EnabledConfig
type EndpointDependency = original.EndpointDependency
type EndpointDetail = original.EndpointDetail
type EnvironmentVar = original.EnvironmentVar
type ErrorEntity = original.ErrorEntity
type Experiments = original.Experiments
type ExtendedLocation = original.ExtendedLocation
type Facebook = original.Facebook
type FileSystemApplicationLogsConfig = original.FileSystemApplicationLogsConfig
type FileSystemHTTPLogsConfig = original.FileSystemHTTPLogsConfig
type FileSystemTokenStore = original.FileSystemTokenStore
type ForwardProxy = original.ForwardProxy
type FrontEndConfiguration = original.FrontEndConfiguration
type FunctionAppMajorVersion = original.FunctionAppMajorVersion
type FunctionAppMinorVersion = original.FunctionAppMinorVersion
type FunctionAppRuntimeSettings = original.FunctionAppRuntimeSettings
type FunctionAppRuntimes = original.FunctionAppRuntimes
type FunctionAppStack = original.FunctionAppStack
type FunctionAppStackCollection = original.FunctionAppStackCollection
type FunctionAppStackCollectionIterator = original.FunctionAppStackCollectionIterator
type FunctionAppStackCollectionPage = original.FunctionAppStackCollectionPage
type FunctionAppStackProperties = original.FunctionAppStackProperties
type FunctionEnvelope = original.FunctionEnvelope
type FunctionEnvelopeCollection = original.FunctionEnvelopeCollection
type FunctionEnvelopeCollectionIterator = original.FunctionEnvelopeCollectionIterator
type FunctionEnvelopeCollectionPage = original.FunctionEnvelopeCollectionPage
type FunctionEnvelopeProperties = original.FunctionEnvelopeProperties
type FunctionSecrets = original.FunctionSecrets
type GeoRegion = original.GeoRegion
type GeoRegionCollection = original.GeoRegionCollection
type GeoRegionCollectionIterator = original.GeoRegionCollectionIterator
type GeoRegionCollectionPage = original.GeoRegionCollectionPage
type GeoRegionProperties = original.GeoRegionProperties
type GitHub = original.GitHub
type GitHubActionCodeConfiguration = original.GitHubActionCodeConfiguration
type GitHubActionConfiguration = original.GitHubActionConfiguration
type GitHubActionContainerConfiguration = original.GitHubActionContainerConfiguration
type GitHubActionWebAppStackSettings = original.GitHubActionWebAppStackSettings
type GlobalClient = original.GlobalClient
type GlobalCsmSkuDescription = original.GlobalCsmSkuDescription
type GlobalValidation = original.GlobalValidation
type Google = original.Google
type HTTPLogsConfig = original.HTTPLogsConfig
type HTTPScaleRule = original.HTTPScaleRule
type HTTPSettings = original.HTTPSettings
type HTTPSettingsRoutes = original.HTTPSettingsRoutes
type HandlerMapping = original.HandlerMapping
type HostKeys = original.HostKeys
type HostName = original.HostName
type HostNameBinding = original.HostNameBinding
type HostNameBindingCollection = original.HostNameBindingCollection
type HostNameBindingCollectionIterator = original.HostNameBindingCollectionIterator
type HostNameBindingCollectionPage = original.HostNameBindingCollectionPage
type HostNameBindingProperties = original.HostNameBindingProperties
type HostNameSslState = original.HostNameSslState
type HostingEnvironmentDeploymentInfo = original.HostingEnvironmentDeploymentInfo
type HostingEnvironmentDiagnostics = original.HostingEnvironmentDiagnostics
type HostingEnvironmentProfile = original.HostingEnvironmentProfile
type HybridConnection = original.HybridConnection
type HybridConnectionCollection = original.HybridConnectionCollection
type HybridConnectionCollectionIterator = original.HybridConnectionCollectionIterator
type HybridConnectionCollectionPage = original.HybridConnectionCollectionPage
type HybridConnectionKey = original.HybridConnectionKey
type HybridConnectionKeyProperties = original.HybridConnectionKeyProperties
type HybridConnectionLimits = original.HybridConnectionLimits
type HybridConnectionLimitsProperties = original.HybridConnectionLimitsProperties
type HybridConnectionProperties = original.HybridConnectionProperties
type IPSecurityRestriction = original.IPSecurityRestriction
type Identifier = original.Identifier
type IdentifierCollection = original.IdentifierCollection
type IdentifierCollectionIterator = original.IdentifierCollectionIterator
type IdentifierCollectionPage = original.IdentifierCollectionPage
type IdentifierProperties = original.IdentifierProperties
type IdentityProviders = original.IdentityProviders
type InboundEnvironmentEndpoint = original.InboundEnvironmentEndpoint
type InboundEnvironmentEndpointCollection = original.InboundEnvironmentEndpointCollection
type InboundEnvironmentEndpointCollectionIterator = original.InboundEnvironmentEndpointCollectionIterator
type InboundEnvironmentEndpointCollectionPage = original.InboundEnvironmentEndpointCollectionPage
type Ingress = original.Ingress
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type JobProperties = original.JobProperties
type JwtClaimChecks = original.JwtClaimChecks
type KeyInfo = original.KeyInfo
type KeyValuePairStringObject = original.KeyValuePairStringObject
type KubeEnvironment = original.KubeEnvironment
type KubeEnvironmentCollection = original.KubeEnvironmentCollection
type KubeEnvironmentCollectionIterator = original.KubeEnvironmentCollectionIterator
type KubeEnvironmentCollectionPage = original.KubeEnvironmentCollectionPage
type KubeEnvironmentPatchResource = original.KubeEnvironmentPatchResource
type KubeEnvironmentPatchResourceProperties = original.KubeEnvironmentPatchResourceProperties
type KubeEnvironmentProfile = original.KubeEnvironmentProfile
type KubeEnvironmentProperties = original.KubeEnvironmentProperties
type KubeEnvironmentsClient = original.KubeEnvironmentsClient
type KubeEnvironmentsCreateOrUpdateFuture = original.KubeEnvironmentsCreateOrUpdateFuture
type KubeEnvironmentsDeleteFuture = original.KubeEnvironmentsDeleteFuture
type LegacyMicrosoftAccount = original.LegacyMicrosoftAccount
type LinuxJavaContainerSettings = original.LinuxJavaContainerSettings
type ListCapability = original.ListCapability
type ListCertificateEmail = original.ListCertificateEmail
type ListCertificateOrderAction = original.ListCertificateOrderAction
type ListHostingEnvironmentDiagnostics = original.ListHostingEnvironmentDiagnostics
type ListNetworkTrace = original.ListNetworkTrace
type ListOperation = original.ListOperation
type ListSnapshot = original.ListSnapshot
type ListVnetInfoResource = original.ListVnetInfoResource
type ListVnetRoute = original.ListVnetRoute
type LocalizableString = original.LocalizableString
type LogAnalyticsConfiguration = original.LogAnalyticsConfiguration
type LogSpecification = original.LogSpecification
type Login = original.Login
type LoginRoutes = original.LoginRoutes
type LoginScopes = original.LoginScopes
type MSDeploy = original.MSDeploy
type MSDeployCore = original.MSDeployCore
type MSDeployLog = original.MSDeployLog
type MSDeployLogEntry = original.MSDeployLogEntry
type MSDeployLogProperties = original.MSDeployLogProperties
type MSDeployStatus = original.MSDeployStatus
type MSDeployStatusProperties = original.MSDeployStatusProperties
type ManagedServiceIdentity = original.ManagedServiceIdentity
type MetricAvailability = original.MetricAvailability
type MetricSpecification = original.MetricSpecification
type MigrateMySQLRequest = original.MigrateMySQLRequest
type MigrateMySQLRequestProperties = original.MigrateMySQLRequestProperties
type MigrateMySQLStatus = original.MigrateMySQLStatus
type MigrateMySQLStatusProperties = original.MigrateMySQLStatusProperties
type NameIdentifier = original.NameIdentifier
type NameIdentifierCollection = original.NameIdentifierCollection
type NameIdentifierCollectionIterator = original.NameIdentifierCollectionIterator
type NameIdentifierCollectionPage = original.NameIdentifierCollectionPage
type NameValuePair = original.NameValuePair
type NetworkFeatures = original.NetworkFeatures
type NetworkFeaturesProperties = original.NetworkFeaturesProperties
type NetworkTrace = original.NetworkTrace
type Nonce = original.Nonce
type OpenIDConnectClientCredential = original.OpenIDConnectClientCredential
type OpenIDConnectConfig = original.OpenIDConnectConfig
type OpenIDConnectLogin = original.OpenIDConnectLogin
type OpenIDConnectRegistration = original.OpenIDConnectRegistration
type Operation = original.Operation
type OutboundEnvironmentEndpoint = original.OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection = original.OutboundEnvironmentEndpointCollection
type OutboundEnvironmentEndpointCollectionIterator = original.OutboundEnvironmentEndpointCollectionIterator
type OutboundEnvironmentEndpointCollectionPage = original.OutboundEnvironmentEndpointCollectionPage
type PerfMonCounterCollection = original.PerfMonCounterCollection
type PerfMonCounterCollectionIterator = original.PerfMonCounterCollectionIterator
type PerfMonCounterCollectionPage = original.PerfMonCounterCollectionPage
type PerfMonResponse = original.PerfMonResponse
type PerfMonSample = original.PerfMonSample
type PerfMonSet = original.PerfMonSet
type PremierAddOn = original.PremierAddOn
type PremierAddOnOffer = original.PremierAddOnOffer
type PremierAddOnOfferCollection = original.PremierAddOnOfferCollection
type PremierAddOnOfferCollectionIterator = original.PremierAddOnOfferCollectionIterator
type PremierAddOnOfferCollectionPage = original.PremierAddOnOfferCollectionPage
type PremierAddOnOfferProperties = original.PremierAddOnOfferProperties
type PremierAddOnPatchResource = original.PremierAddOnPatchResource
type PremierAddOnPatchResourceProperties = original.PremierAddOnPatchResourceProperties
type PremierAddOnProperties = original.PremierAddOnProperties
type PrivateAccess = original.PrivateAccess
type PrivateAccessProperties = original.PrivateAccessProperties
type PrivateAccessSubnet = original.PrivateAccessSubnet
type PrivateAccessVirtualNetwork = original.PrivateAccessVirtualNetwork
type PrivateEndpointConnectionCollection = original.PrivateEndpointConnectionCollection
type PrivateEndpointConnectionCollectionIterator = original.PrivateEndpointConnectionCollectionIterator
type PrivateEndpointConnectionCollectionPage = original.PrivateEndpointConnectionCollectionPage
type PrivateLinkConnectionApprovalRequest = original.PrivateLinkConnectionApprovalRequest
type PrivateLinkConnectionApprovalRequestResource = original.PrivateLinkConnectionApprovalRequestResource
type PrivateLinkConnectionState = original.PrivateLinkConnectionState
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesWrapper = original.PrivateLinkResourcesWrapper
type ProcessInfo = original.ProcessInfo
type ProcessInfoCollection = original.ProcessInfoCollection
type ProcessInfoCollectionIterator = original.ProcessInfoCollectionIterator
type ProcessInfoCollectionPage = original.ProcessInfoCollectionPage
type ProcessInfoProperties = original.ProcessInfoProperties
type ProcessModuleInfo = original.ProcessModuleInfo
type ProcessModuleInfoCollection = original.ProcessModuleInfoCollection
type ProcessModuleInfoCollectionIterator = original.ProcessModuleInfoCollectionIterator
type ProcessModuleInfoCollectionPage = original.ProcessModuleInfoCollectionPage
type ProcessModuleInfoProperties = original.ProcessModuleInfoProperties
type ProcessThreadInfo = original.ProcessThreadInfo
type ProcessThreadInfoCollection = original.ProcessThreadInfoCollection
type ProcessThreadInfoCollectionIterator = original.ProcessThreadInfoCollectionIterator
type ProcessThreadInfoCollectionPage = original.ProcessThreadInfoCollectionPage
type ProcessThreadInfoProperties = original.ProcessThreadInfoProperties
type ProviderClient = original.ProviderClient
type ProxyOnlyResource = original.ProxyOnlyResource
type PublicCertificate = original.PublicCertificate
type PublicCertificateCollection = original.PublicCertificateCollection
type PublicCertificateCollectionIterator = original.PublicCertificateCollectionIterator
type PublicCertificateCollectionPage = original.PublicCertificateCollectionPage
type PublicCertificateProperties = original.PublicCertificateProperties
type PublishingCredentialsPoliciesCollection = original.PublishingCredentialsPoliciesCollection
type PublishingCredentialsPoliciesCollectionIterator = original.PublishingCredentialsPoliciesCollectionIterator
type PublishingCredentialsPoliciesCollectionPage = original.PublishingCredentialsPoliciesCollectionPage
type PushSettings = original.PushSettings
type PushSettingsProperties = original.PushSettingsProperties
type QueryUtterancesResult = original.QueryUtterancesResult
type QueryUtterancesResults = original.QueryUtterancesResults
type QueueScaleRule = original.QueueScaleRule
type RampUpRule = original.RampUpRule
type ReadCloser = original.ReadCloser
type Recommendation = original.Recommendation
type RecommendationCollection = original.RecommendationCollection
type RecommendationCollectionIterator = original.RecommendationCollectionIterator
type RecommendationCollectionPage = original.RecommendationCollectionPage
type RecommendationProperties = original.RecommendationProperties
type RecommendationRule = original.RecommendationRule
type RecommendationRuleProperties = original.RecommendationRuleProperties
type RecommendationsClient = original.RecommendationsClient
type RegistryCredentials = original.RegistryCredentials
type ReissueCertificateOrderRequest = original.ReissueCertificateOrderRequest
type ReissueCertificateOrderRequestProperties = original.ReissueCertificateOrderRequestProperties
type RelayServiceConnectionEntity = original.RelayServiceConnectionEntity
type RelayServiceConnectionEntityProperties = original.RelayServiceConnectionEntityProperties
type RemotePrivateEndpointConnection = original.RemotePrivateEndpointConnection
type RemotePrivateEndpointConnectionARMResource = original.RemotePrivateEndpointConnectionARMResource
type RemotePrivateEndpointConnectionARMResourceProperties = original.RemotePrivateEndpointConnectionARMResourceProperties
type RemotePrivateEndpointConnectionProperties = original.RemotePrivateEndpointConnectionProperties
type Rendering = original.Rendering
type RenewCertificateOrderRequest = original.RenewCertificateOrderRequest
type RenewCertificateOrderRequestProperties = original.RenewCertificateOrderRequestProperties
type RequestsBasedTrigger = original.RequestsBasedTrigger
type Resource = original.Resource
type ResourceCollection = original.ResourceCollection
type ResourceCollectionIterator = original.ResourceCollectionIterator
type ResourceCollectionPage = original.ResourceCollectionPage
type ResourceHealthMetadata = original.ResourceHealthMetadata
type ResourceHealthMetadataClient = original.ResourceHealthMetadataClient
type ResourceHealthMetadataCollection = original.ResourceHealthMetadataCollection
type ResourceHealthMetadataCollectionIterator = original.ResourceHealthMetadataCollectionIterator
type ResourceHealthMetadataCollectionPage = original.ResourceHealthMetadataCollectionPage
type ResourceHealthMetadataProperties = original.ResourceHealthMetadataProperties
type ResourceMetricAvailability = original.ResourceMetricAvailability
type ResourceMetricDefinition = original.ResourceMetricDefinition
type ResourceMetricDefinitionCollection = original.ResourceMetricDefinitionCollection
type ResourceMetricDefinitionCollectionIterator = original.ResourceMetricDefinitionCollectionIterator
type ResourceMetricDefinitionCollectionPage = original.ResourceMetricDefinitionCollectionPage
type ResourceMetricDefinitionProperties = original.ResourceMetricDefinitionProperties
type ResourceNameAvailability = original.ResourceNameAvailability
type ResourceNameAvailabilityRequest = original.ResourceNameAvailabilityRequest
type ResponseMessageEnvelopeRemotePrivateEndpointConnection = original.ResponseMessageEnvelopeRemotePrivateEndpointConnection
type ResponseMetaData = original.ResponseMetaData
type RestoreRequest = original.RestoreRequest
type RestoreRequestProperties = original.RestoreRequestProperties
type Revision = original.Revision
type RevisionCollection = original.RevisionCollection
type RevisionCollectionIterator = original.RevisionCollectionIterator
type RevisionCollectionPage = original.RevisionCollectionPage
type RevisionProperties = original.RevisionProperties
type SampleUtterance = original.SampleUtterance
type Scale = original.Scale
type ScaleRule = original.ScaleRule
type ScaleRuleAuth = original.ScaleRuleAuth
type Secret = original.Secret
type SecretsCollection = original.SecretsCollection
type ServiceSpecification = original.ServiceSpecification
type SetObject = original.SetObject
type Site = original.Site
type SiteAuthSettings = original.SiteAuthSettings
type SiteAuthSettingsProperties = original.SiteAuthSettingsProperties
type SiteAuthSettingsV2 = original.SiteAuthSettingsV2
type SiteAuthSettingsV2Properties = original.SiteAuthSettingsV2Properties
type SiteCloneability = original.SiteCloneability
type SiteCloneabilityCriterion = original.SiteCloneabilityCriterion
type SiteConfig = original.SiteConfig
type SiteConfigPropertiesDictionary = original.SiteConfigPropertiesDictionary
type SiteConfigResource = original.SiteConfigResource
type SiteConfigResourceCollection = original.SiteConfigResourceCollection
type SiteConfigResourceCollectionIterator = original.SiteConfigResourceCollectionIterator
type SiteConfigResourceCollectionPage = original.SiteConfigResourceCollectionPage
type SiteConfigurationSnapshotInfo = original.SiteConfigurationSnapshotInfo
type SiteConfigurationSnapshotInfoCollection = original.SiteConfigurationSnapshotInfoCollection
type SiteConfigurationSnapshotInfoCollectionIterator = original.SiteConfigurationSnapshotInfoCollectionIterator
type SiteConfigurationSnapshotInfoCollectionPage = original.SiteConfigurationSnapshotInfoCollectionPage
type SiteConfigurationSnapshotInfoProperties = original.SiteConfigurationSnapshotInfoProperties
type SiteExtensionInfo = original.SiteExtensionInfo
type SiteExtensionInfoCollection = original.SiteExtensionInfoCollection
type SiteExtensionInfoCollectionIterator = original.SiteExtensionInfoCollectionIterator
type SiteExtensionInfoCollectionPage = original.SiteExtensionInfoCollectionPage
type SiteExtensionInfoProperties = original.SiteExtensionInfoProperties
type SiteInstanceStatus = original.SiteInstanceStatus
type SiteInstanceStatusProperties = original.SiteInstanceStatusProperties
type SiteLimits = original.SiteLimits
type SiteLogsConfig = original.SiteLogsConfig
type SiteLogsConfigProperties = original.SiteLogsConfigProperties
type SiteMachineKey = original.SiteMachineKey
type SitePatchResource = original.SitePatchResource
type SitePatchResourceProperties = original.SitePatchResourceProperties
type SitePhpErrorLogFlag = original.SitePhpErrorLogFlag
type SitePhpErrorLogFlagProperties = original.SitePhpErrorLogFlagProperties
type SiteProperties = original.SiteProperties
type SiteSeal = original.SiteSeal
type SiteSealRequest = original.SiteSealRequest
type SiteSourceControl = original.SiteSourceControl
type SiteSourceControlProperties = original.SiteSourceControlProperties
type SkuCapacity = original.SkuCapacity
type SkuDescription = original.SkuDescription
type SkuInfo = original.SkuInfo
type SkuInfoCollection = original.SkuInfoCollection
type SkuInfoCollectionIterator = original.SkuInfoCollectionIterator
type SkuInfoCollectionPage = original.SkuInfoCollectionPage
type SkuInfos = original.SkuInfos
type SlotConfigNames = original.SlotConfigNames
type SlotConfigNamesResource = original.SlotConfigNamesResource
type SlotDifference = original.SlotDifference
type SlotDifferenceCollection = original.SlotDifferenceCollection
type SlotDifferenceCollectionIterator = original.SlotDifferenceCollectionIterator
type SlotDifferenceCollectionPage = original.SlotDifferenceCollectionPage
type SlotDifferenceProperties = original.SlotDifferenceProperties
type SlotSwapStatus = original.SlotSwapStatus
type SlowRequestsBasedTrigger = original.SlowRequestsBasedTrigger
type Snapshot = original.Snapshot
type SnapshotCollection = original.SnapshotCollection
type SnapshotCollectionIterator = original.SnapshotCollectionIterator
type SnapshotCollectionPage = original.SnapshotCollectionPage
type SnapshotProperties = original.SnapshotProperties
type SnapshotRecoverySource = original.SnapshotRecoverySource
type SnapshotRestoreRequest = original.SnapshotRestoreRequest
type SnapshotRestoreRequestProperties = original.SnapshotRestoreRequestProperties
type Solution = original.Solution
type SourceControl = original.SourceControl
type SourceControlCollection = original.SourceControlCollection
type SourceControlCollectionIterator = original.SourceControlCollectionIterator
type SourceControlCollectionPage = original.SourceControlCollectionPage
type SourceControlProperties = original.SourceControlProperties
type StackMajorVersion = original.StackMajorVersion
type StackMinorVersion = original.StackMinorVersion
type StampCapacity = original.StampCapacity
type StampCapacityCollection = original.StampCapacityCollection
type StampCapacityCollectionIterator = original.StampCapacityCollectionIterator
type StampCapacityCollectionPage = original.StampCapacityCollectionPage
type StaticSite = original.StaticSite
type StaticSiteARMResource = original.StaticSiteARMResource
type StaticSiteBuildARMResource = original.StaticSiteBuildARMResource
type StaticSiteBuildARMResourceProperties = original.StaticSiteBuildARMResourceProperties
type StaticSiteBuildCollection = original.StaticSiteBuildCollection
type StaticSiteBuildCollectionIterator = original.StaticSiteBuildCollectionIterator
type StaticSiteBuildCollectionPage = original.StaticSiteBuildCollectionPage
type StaticSiteBuildProperties = original.StaticSiteBuildProperties
type StaticSiteCollection = original.StaticSiteCollection
type StaticSiteCollectionIterator = original.StaticSiteCollectionIterator
type StaticSiteCollectionPage = original.StaticSiteCollectionPage
type StaticSiteCustomDomainOverviewARMResource = original.StaticSiteCustomDomainOverviewARMResource
type StaticSiteCustomDomainOverviewARMResourceProperties = original.StaticSiteCustomDomainOverviewARMResourceProperties
type StaticSiteCustomDomainOverviewCollection = original.StaticSiteCustomDomainOverviewCollection
type StaticSiteCustomDomainOverviewCollectionIterator = original.StaticSiteCustomDomainOverviewCollectionIterator
type StaticSiteCustomDomainOverviewCollectionPage = original.StaticSiteCustomDomainOverviewCollectionPage
type StaticSiteCustomDomainRequestPropertiesARMResource = original.StaticSiteCustomDomainRequestPropertiesARMResource
type StaticSiteCustomDomainRequestPropertiesARMResourceProperties = original.StaticSiteCustomDomainRequestPropertiesARMResourceProperties
type StaticSiteFunctionOverviewARMResource = original.StaticSiteFunctionOverviewARMResource
type StaticSiteFunctionOverviewARMResourceProperties = original.StaticSiteFunctionOverviewARMResourceProperties
type StaticSiteFunctionOverviewCollection = original.StaticSiteFunctionOverviewCollection
type StaticSiteFunctionOverviewCollectionIterator = original.StaticSiteFunctionOverviewCollectionIterator
type StaticSiteFunctionOverviewCollectionPage = original.StaticSiteFunctionOverviewCollectionPage
type StaticSitePatchResource = original.StaticSitePatchResource
type StaticSiteResetPropertiesARMResource = original.StaticSiteResetPropertiesARMResource
type StaticSiteResetPropertiesARMResourceProperties = original.StaticSiteResetPropertiesARMResourceProperties
type StaticSiteTemplateOptions = original.StaticSiteTemplateOptions
type StaticSiteUserARMResource = original.StaticSiteUserARMResource
type StaticSiteUserARMResourceProperties = original.StaticSiteUserARMResourceProperties
type StaticSiteUserCollection = original.StaticSiteUserCollection
type StaticSiteUserCollectionIterator = original.StaticSiteUserCollectionIterator
type StaticSiteUserCollectionPage = original.StaticSiteUserCollectionPage
type StaticSiteUserInvitationRequestResource = original.StaticSiteUserInvitationRequestResource
type StaticSiteUserInvitationRequestResourceProperties = original.StaticSiteUserInvitationRequestResourceProperties
type StaticSiteUserInvitationResponseResource = original.StaticSiteUserInvitationResponseResource
type StaticSiteUserInvitationResponseResourceProperties = original.StaticSiteUserInvitationResponseResourceProperties
type StaticSiteUserProvidedFunctionApp = original.StaticSiteUserProvidedFunctionApp
type StaticSiteUserProvidedFunctionAppARMResource = original.StaticSiteUserProvidedFunctionAppARMResource
type StaticSiteUserProvidedFunctionAppARMResourceProperties = original.StaticSiteUserProvidedFunctionAppARMResourceProperties
type StaticSiteUserProvidedFunctionAppProperties = original.StaticSiteUserProvidedFunctionAppProperties
type StaticSiteUserProvidedFunctionAppsCollection = original.StaticSiteUserProvidedFunctionAppsCollection
type StaticSiteUserProvidedFunctionAppsCollectionIterator = original.StaticSiteUserProvidedFunctionAppsCollectionIterator
type StaticSiteUserProvidedFunctionAppsCollectionPage = original.StaticSiteUserProvidedFunctionAppsCollectionPage
type StaticSiteZipDeployment = original.StaticSiteZipDeployment
type StaticSiteZipDeploymentARMResource = original.StaticSiteZipDeploymentARMResource
type StaticSitesApproveOrRejectPrivateEndpointConnectionFuture = original.StaticSitesApproveOrRejectPrivateEndpointConnectionFuture
type StaticSitesClient = original.StaticSitesClient
type StaticSitesCreateOrUpdateStaticSiteCustomDomainFuture = original.StaticSitesCreateOrUpdateStaticSiteCustomDomainFuture
type StaticSitesCreateOrUpdateStaticSiteFuture = original.StaticSitesCreateOrUpdateStaticSiteFuture
type StaticSitesCreateZipDeploymentForStaticSiteBuildFuture = original.StaticSitesCreateZipDeploymentForStaticSiteBuildFuture
type StaticSitesCreateZipDeploymentForStaticSiteFuture = original.StaticSitesCreateZipDeploymentForStaticSiteFuture
type StaticSitesDeletePrivateEndpointConnectionFuture = original.StaticSitesDeletePrivateEndpointConnectionFuture
type StaticSitesDeleteStaticSiteBuildFuture = original.StaticSitesDeleteStaticSiteBuildFuture
type StaticSitesDeleteStaticSiteCustomDomainFuture = original.StaticSitesDeleteStaticSiteCustomDomainFuture
type StaticSitesDeleteStaticSiteFuture = original.StaticSitesDeleteStaticSiteFuture
type StaticSitesDetachStaticSiteFuture = original.StaticSitesDetachStaticSiteFuture
type StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteBuildFuture = original.StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteBuildFuture
type StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteFuture = original.StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteFuture
type StaticSitesValidateCustomDomainCanBeAddedToStaticSiteFuture = original.StaticSitesValidateCustomDomainCanBeAddedToStaticSiteFuture
type StaticSitesWorkflowPreview = original.StaticSitesWorkflowPreview
type StaticSitesWorkflowPreviewProperties = original.StaticSitesWorkflowPreviewProperties
type StaticSitesWorkflowPreviewRequest = original.StaticSitesWorkflowPreviewRequest
type StaticSitesWorkflowPreviewRequestProperties = original.StaticSitesWorkflowPreviewRequestProperties
type Status = original.Status
type StatusCodesBasedTrigger = original.StatusCodesBasedTrigger
type StatusCodesRangeBasedTrigger = original.StatusCodesRangeBasedTrigger
type StorageMigrationOptions = original.StorageMigrationOptions
type StorageMigrationOptionsProperties = original.StorageMigrationOptionsProperties
type StorageMigrationResponse = original.StorageMigrationResponse
type StorageMigrationResponseProperties = original.StorageMigrationResponseProperties
type String = original.String
type StringDictionary = original.StringDictionary
type StringList = original.StringList
type SupportTopic = original.SupportTopic
type SwiftVirtualNetwork = original.SwiftVirtualNetwork
type SwiftVirtualNetworkProperties = original.SwiftVirtualNetworkProperties
type Template = original.Template
type TldLegalAgreement = original.TldLegalAgreement
type TldLegalAgreementCollection = original.TldLegalAgreementCollection
type TldLegalAgreementCollectionIterator = original.TldLegalAgreementCollectionIterator
type TldLegalAgreementCollectionPage = original.TldLegalAgreementCollectionPage
type TokenStore = original.TokenStore
type TopLevelDomain = original.TopLevelDomain
type TopLevelDomainAgreementOption = original.TopLevelDomainAgreementOption
type TopLevelDomainCollection = original.TopLevelDomainCollection
type TopLevelDomainCollectionIterator = original.TopLevelDomainCollectionIterator
type TopLevelDomainCollectionPage = original.TopLevelDomainCollectionPage
type TopLevelDomainProperties = original.TopLevelDomainProperties
type TopLevelDomainsClient = original.TopLevelDomainsClient
type TrafficWeight = original.TrafficWeight
type TriggeredJobHistory = original.TriggeredJobHistory
type TriggeredJobHistoryCollection = original.TriggeredJobHistoryCollection
type TriggeredJobHistoryCollectionIterator = original.TriggeredJobHistoryCollectionIterator
type TriggeredJobHistoryCollectionPage = original.TriggeredJobHistoryCollectionPage
type TriggeredJobHistoryProperties = original.TriggeredJobHistoryProperties
type TriggeredJobRun = original.TriggeredJobRun
type TriggeredWebJob = original.TriggeredWebJob
type TriggeredWebJobCollection = original.TriggeredWebJobCollection
type TriggeredWebJobCollectionIterator = original.TriggeredWebJobCollectionIterator
type TriggeredWebJobCollectionPage = original.TriggeredWebJobCollectionPage
type TriggeredWebJobProperties = original.TriggeredWebJobProperties
type Twitter = original.Twitter
type TwitterRegistration = original.TwitterRegistration
type Usage = original.Usage
type UsageCollection = original.UsageCollection
type UsageCollectionIterator = original.UsageCollectionIterator
type UsageCollectionPage = original.UsageCollectionPage
type UsageProperties = original.UsageProperties
type User = original.User
type UserAssignedIdentity = original.UserAssignedIdentity
type UserProperties = original.UserProperties
type ValidateProperties = original.ValidateProperties
type ValidateRequest = original.ValidateRequest
type ValidateResponse = original.ValidateResponse
type ValidateResponseError = original.ValidateResponseError
type VirtualApplication = original.VirtualApplication
type VirtualDirectory = original.VirtualDirectory
type VirtualIPMapping = original.VirtualIPMapping
type VirtualNetworkProfile = original.VirtualNetworkProfile
type VnetGateway = original.VnetGateway
type VnetGatewayProperties = original.VnetGatewayProperties
type VnetInfo = original.VnetInfo
type VnetInfoResource = original.VnetInfoResource
type VnetParameters = original.VnetParameters
type VnetParametersProperties = original.VnetParametersProperties
type VnetRoute = original.VnetRoute
type VnetRouteProperties = original.VnetRouteProperties
type VnetValidationFailureDetails = original.VnetValidationFailureDetails
type VnetValidationFailureDetailsProperties = original.VnetValidationFailureDetailsProperties
type VnetValidationTestFailure = original.VnetValidationTestFailure
type VnetValidationTestFailureProperties = original.VnetValidationTestFailureProperties
type WindowsJavaContainerSettings = original.WindowsJavaContainerSettings
type WorkerPool = original.WorkerPool
type WorkerPoolCollection = original.WorkerPoolCollection
type WorkerPoolCollectionIterator = original.WorkerPoolCollectionIterator
type WorkerPoolCollectionPage = original.WorkerPoolCollectionPage
type WorkerPoolResource = original.WorkerPoolResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAPIKVReferenceCollectionIterator(page APIKVReferenceCollectionPage) APIKVReferenceCollectionIterator {
	return original.NewAPIKVReferenceCollectionIterator(page)
}
func NewAPIKVReferenceCollectionPage(cur APIKVReferenceCollection, getNextPage func(context.Context, APIKVReferenceCollection) (APIKVReferenceCollection, error)) APIKVReferenceCollectionPage {
	return original.NewAPIKVReferenceCollectionPage(cur, getNextPage)
}
func NewAppCollectionIterator(page AppCollectionPage) AppCollectionIterator {
	return original.NewAppCollectionIterator(page)
}
func NewAppCollectionPage(cur AppCollection, getNextPage func(context.Context, AppCollection) (AppCollection, error)) AppCollectionPage {
	return original.NewAppCollectionPage(cur, getNextPage)
}
func NewAppInstanceStatusCollectionIterator(page AppInstanceStatusCollectionPage) AppInstanceStatusCollectionIterator {
	return original.NewAppInstanceStatusCollectionIterator(page)
}
func NewAppInstanceStatusCollectionPage(cur AppInstanceStatusCollection, getNextPage func(context.Context, AppInstanceStatusCollection) (AppInstanceStatusCollection, error)) AppInstanceStatusCollectionPage {
	return original.NewAppInstanceStatusCollectionPage(cur, getNextPage)
}
func NewAppServiceCertificateCollectionIterator(page AppServiceCertificateCollectionPage) AppServiceCertificateCollectionIterator {
	return original.NewAppServiceCertificateCollectionIterator(page)
}
func NewAppServiceCertificateCollectionPage(cur AppServiceCertificateCollection, getNextPage func(context.Context, AppServiceCertificateCollection) (AppServiceCertificateCollection, error)) AppServiceCertificateCollectionPage {
	return original.NewAppServiceCertificateCollectionPage(cur, getNextPage)
}
func NewAppServiceCertificateOrderCollectionIterator(page AppServiceCertificateOrderCollectionPage) AppServiceCertificateOrderCollectionIterator {
	return original.NewAppServiceCertificateOrderCollectionIterator(page)
}
func NewAppServiceCertificateOrderCollectionPage(cur AppServiceCertificateOrderCollection, getNextPage func(context.Context, AppServiceCertificateOrderCollection) (AppServiceCertificateOrderCollection, error)) AppServiceCertificateOrderCollectionPage {
	return original.NewAppServiceCertificateOrderCollectionPage(cur, getNextPage)
}
func NewAppServiceCertificateOrdersClient(subscriptionID string) AppServiceCertificateOrdersClient {
	return original.NewAppServiceCertificateOrdersClient(subscriptionID)
}
func NewAppServiceCertificateOrdersClientWithBaseURI(baseURI string, subscriptionID string) AppServiceCertificateOrdersClient {
	return original.NewAppServiceCertificateOrdersClientWithBaseURI(baseURI, subscriptionID)
}
func NewAppServiceEnvironmentCollectionIterator(page AppServiceEnvironmentCollectionPage) AppServiceEnvironmentCollectionIterator {
	return original.NewAppServiceEnvironmentCollectionIterator(page)
}
func NewAppServiceEnvironmentCollectionPage(cur AppServiceEnvironmentCollection, getNextPage func(context.Context, AppServiceEnvironmentCollection) (AppServiceEnvironmentCollection, error)) AppServiceEnvironmentCollectionPage {
	return original.NewAppServiceEnvironmentCollectionPage(cur, getNextPage)
}
func NewAppServiceEnvironmentsClient(subscriptionID string) AppServiceEnvironmentsClient {
	return original.NewAppServiceEnvironmentsClient(subscriptionID)
}
func NewAppServiceEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) AppServiceEnvironmentsClient {
	return original.NewAppServiceEnvironmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAppServicePlanCollectionIterator(page AppServicePlanCollectionPage) AppServicePlanCollectionIterator {
	return original.NewAppServicePlanCollectionIterator(page)
}
func NewAppServicePlanCollectionPage(cur AppServicePlanCollection, getNextPage func(context.Context, AppServicePlanCollection) (AppServicePlanCollection, error)) AppServicePlanCollectionPage {
	return original.NewAppServicePlanCollectionPage(cur, getNextPage)
}
func NewAppServicePlansClient(subscriptionID string) AppServicePlansClient {
	return original.NewAppServicePlansClient(subscriptionID)
}
func NewAppServicePlansClientWithBaseURI(baseURI string, subscriptionID string) AppServicePlansClient {
	return original.NewAppServicePlansClientWithBaseURI(baseURI, subscriptionID)
}
func NewAppStackCollectionIterator(page AppStackCollectionPage) AppStackCollectionIterator {
	return original.NewAppStackCollectionIterator(page)
}
func NewAppStackCollectionPage(cur AppStackCollection, getNextPage func(context.Context, AppStackCollection) (AppStackCollection, error)) AppStackCollectionPage {
	return original.NewAppStackCollectionPage(cur, getNextPage)
}
func NewApplicationStackCollectionIterator(page ApplicationStackCollectionPage) ApplicationStackCollectionIterator {
	return original.NewApplicationStackCollectionIterator(page)
}
func NewApplicationStackCollectionPage(cur ApplicationStackCollection, getNextPage func(context.Context, ApplicationStackCollection) (ApplicationStackCollection, error)) ApplicationStackCollectionPage {
	return original.NewApplicationStackCollectionPage(cur, getNextPage)
}
func NewAppsClient(subscriptionID string) AppsClient {
	return original.NewAppsClient(subscriptionID)
}
func NewAppsClientWithBaseURI(baseURI string, subscriptionID string) AppsClient {
	return original.NewAppsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBackupItemCollectionIterator(page BackupItemCollectionPage) BackupItemCollectionIterator {
	return original.NewBackupItemCollectionIterator(page)
}
func NewBackupItemCollectionPage(cur BackupItemCollection, getNextPage func(context.Context, BackupItemCollection) (BackupItemCollection, error)) BackupItemCollectionPage {
	return original.NewBackupItemCollectionPage(cur, getNextPage)
}
func NewBillingMeterCollectionIterator(page BillingMeterCollectionPage) BillingMeterCollectionIterator {
	return original.NewBillingMeterCollectionIterator(page)
}
func NewBillingMeterCollectionPage(cur BillingMeterCollection, getNextPage func(context.Context, BillingMeterCollection) (BillingMeterCollection, error)) BillingMeterCollectionPage {
	return original.NewBillingMeterCollectionPage(cur, getNextPage)
}
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return original.NewCertificateCollectionIterator(page)
}
func NewCertificateCollectionPage(cur CertificateCollection, getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return original.NewCertificateCollectionPage(cur, getNextPage)
}
func NewCertificateOrdersDiagnosticsClient(subscriptionID string) CertificateOrdersDiagnosticsClient {
	return original.NewCertificateOrdersDiagnosticsClient(subscriptionID)
}
func NewCertificateOrdersDiagnosticsClientWithBaseURI(baseURI string, subscriptionID string) CertificateOrdersDiagnosticsClient {
	return original.NewCertificateOrdersDiagnosticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificateRegistrationProviderClient(subscriptionID string) CertificateRegistrationProviderClient {
	return original.NewCertificateRegistrationProviderClient(subscriptionID)
}
func NewCertificateRegistrationProviderClientWithBaseURI(baseURI string, subscriptionID string) CertificateRegistrationProviderClient {
	return original.NewCertificateRegistrationProviderClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificatesClient(subscriptionID string) CertificatesClient {
	return original.NewCertificatesClient(subscriptionID)
}
func NewCertificatesClientWithBaseURI(baseURI string, subscriptionID string) CertificatesClient {
	return original.NewCertificatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewContainerAppCollectionIterator(page ContainerAppCollectionPage) ContainerAppCollectionIterator {
	return original.NewContainerAppCollectionIterator(page)
}
func NewContainerAppCollectionPage(cur ContainerAppCollection, getNextPage func(context.Context, ContainerAppCollection) (ContainerAppCollection, error)) ContainerAppCollectionPage {
	return original.NewContainerAppCollectionPage(cur, getNextPage)
}
func NewContainerAppsClient(subscriptionID string) ContainerAppsClient {
	return original.NewContainerAppsClient(subscriptionID)
}
func NewContainerAppsClientWithBaseURI(baseURI string, subscriptionID string) ContainerAppsClient {
	return original.NewContainerAppsClientWithBaseURI(baseURI, subscriptionID)
}
func NewContainerAppsRevisionsClient(subscriptionID string) ContainerAppsRevisionsClient {
	return original.NewContainerAppsRevisionsClient(subscriptionID)
}
func NewContainerAppsRevisionsClientWithBaseURI(baseURI string, subscriptionID string) ContainerAppsRevisionsClient {
	return original.NewContainerAppsRevisionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewContinuousWebJobCollectionIterator(page ContinuousWebJobCollectionPage) ContinuousWebJobCollectionIterator {
	return original.NewContinuousWebJobCollectionIterator(page)
}
func NewContinuousWebJobCollectionPage(cur ContinuousWebJobCollection, getNextPage func(context.Context, ContinuousWebJobCollection) (ContinuousWebJobCollection, error)) ContinuousWebJobCollectionPage {
	return original.NewContinuousWebJobCollectionPage(cur, getNextPage)
}
func NewCsmOperationCollectionIterator(page CsmOperationCollectionPage) CsmOperationCollectionIterator {
	return original.NewCsmOperationCollectionIterator(page)
}
func NewCsmOperationCollectionPage(cur CsmOperationCollection, getNextPage func(context.Context, CsmOperationCollection) (CsmOperationCollection, error)) CsmOperationCollectionPage {
	return original.NewCsmOperationCollectionPage(cur, getNextPage)
}
func NewCsmUsageQuotaCollectionIterator(page CsmUsageQuotaCollectionPage) CsmUsageQuotaCollectionIterator {
	return original.NewCsmUsageQuotaCollectionIterator(page)
}
func NewCsmUsageQuotaCollectionPage(cur CsmUsageQuotaCollection, getNextPage func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)) CsmUsageQuotaCollectionPage {
	return original.NewCsmUsageQuotaCollectionPage(cur, getNextPage)
}
func NewCustomHostnameSitesCollectionIterator(page CustomHostnameSitesCollectionPage) CustomHostnameSitesCollectionIterator {
	return original.NewCustomHostnameSitesCollectionIterator(page)
}
func NewCustomHostnameSitesCollectionPage(cur CustomHostnameSitesCollection, getNextPage func(context.Context, CustomHostnameSitesCollection) (CustomHostnameSitesCollection, error)) CustomHostnameSitesCollectionPage {
	return original.NewCustomHostnameSitesCollectionPage(cur, getNextPage)
}
func NewDeletedWebAppCollectionIterator(page DeletedWebAppCollectionPage) DeletedWebAppCollectionIterator {
	return original.NewDeletedWebAppCollectionIterator(page)
}
func NewDeletedWebAppCollectionPage(cur DeletedWebAppCollection, getNextPage func(context.Context, DeletedWebAppCollection) (DeletedWebAppCollection, error)) DeletedWebAppCollectionPage {
	return original.NewDeletedWebAppCollectionPage(cur, getNextPage)
}
func NewDeletedWebAppsClient(subscriptionID string) DeletedWebAppsClient {
	return original.NewDeletedWebAppsClient(subscriptionID)
}
func NewDeletedWebAppsClientWithBaseURI(baseURI string, subscriptionID string) DeletedWebAppsClient {
	return original.NewDeletedWebAppsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDeploymentCollectionIterator(page DeploymentCollectionPage) DeploymentCollectionIterator {
	return original.NewDeploymentCollectionIterator(page)
}
func NewDeploymentCollectionPage(cur DeploymentCollection, getNextPage func(context.Context, DeploymentCollection) (DeploymentCollection, error)) DeploymentCollectionPage {
	return original.NewDeploymentCollectionPage(cur, getNextPage)
}
func NewDetectorResponseCollectionIterator(page DetectorResponseCollectionPage) DetectorResponseCollectionIterator {
	return original.NewDetectorResponseCollectionIterator(page)
}
func NewDetectorResponseCollectionPage(cur DetectorResponseCollection, getNextPage func(context.Context, DetectorResponseCollection) (DetectorResponseCollection, error)) DetectorResponseCollectionPage {
	return original.NewDetectorResponseCollectionPage(cur, getNextPage)
}
func NewDiagnosticAnalysisCollectionIterator(page DiagnosticAnalysisCollectionPage) DiagnosticAnalysisCollectionIterator {
	return original.NewDiagnosticAnalysisCollectionIterator(page)
}
func NewDiagnosticAnalysisCollectionPage(cur DiagnosticAnalysisCollection, getNextPage func(context.Context, DiagnosticAnalysisCollection) (DiagnosticAnalysisCollection, error)) DiagnosticAnalysisCollectionPage {
	return original.NewDiagnosticAnalysisCollectionPage(cur, getNextPage)
}
func NewDiagnosticCategoryCollectionIterator(page DiagnosticCategoryCollectionPage) DiagnosticCategoryCollectionIterator {
	return original.NewDiagnosticCategoryCollectionIterator(page)
}
func NewDiagnosticCategoryCollectionPage(cur DiagnosticCategoryCollection, getNextPage func(context.Context, DiagnosticCategoryCollection) (DiagnosticCategoryCollection, error)) DiagnosticCategoryCollectionPage {
	return original.NewDiagnosticCategoryCollectionPage(cur, getNextPage)
}
func NewDiagnosticDetectorCollectionIterator(page DiagnosticDetectorCollectionPage) DiagnosticDetectorCollectionIterator {
	return original.NewDiagnosticDetectorCollectionIterator(page)
}
func NewDiagnosticDetectorCollectionPage(cur DiagnosticDetectorCollection, getNextPage func(context.Context, DiagnosticDetectorCollection) (DiagnosticDetectorCollection, error)) DiagnosticDetectorCollectionPage {
	return original.NewDiagnosticDetectorCollectionPage(cur, getNextPage)
}
func NewDiagnosticsClient(subscriptionID string) DiagnosticsClient {
	return original.NewDiagnosticsClient(subscriptionID)
}
func NewDiagnosticsClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticsClient {
	return original.NewDiagnosticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainCollectionIterator(page DomainCollectionPage) DomainCollectionIterator {
	return original.NewDomainCollectionIterator(page)
}
func NewDomainCollectionPage(cur DomainCollection, getNextPage func(context.Context, DomainCollection) (DomainCollection, error)) DomainCollectionPage {
	return original.NewDomainCollectionPage(cur, getNextPage)
}
func NewDomainOwnershipIdentifierCollectionIterator(page DomainOwnershipIdentifierCollectionPage) DomainOwnershipIdentifierCollectionIterator {
	return original.NewDomainOwnershipIdentifierCollectionIterator(page)
}
func NewDomainOwnershipIdentifierCollectionPage(cur DomainOwnershipIdentifierCollection, getNextPage func(context.Context, DomainOwnershipIdentifierCollection) (DomainOwnershipIdentifierCollection, error)) DomainOwnershipIdentifierCollectionPage {
	return original.NewDomainOwnershipIdentifierCollectionPage(cur, getNextPage)
}
func NewDomainRegistrationProviderClient(subscriptionID string) DomainRegistrationProviderClient {
	return original.NewDomainRegistrationProviderClient(subscriptionID)
}
func NewDomainRegistrationProviderClientWithBaseURI(baseURI string, subscriptionID string) DomainRegistrationProviderClient {
	return original.NewDomainRegistrationProviderClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainsClient(subscriptionID string) DomainsClient {
	return original.NewDomainsClient(subscriptionID)
}
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return original.NewDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewFunctionAppStackCollectionIterator(page FunctionAppStackCollectionPage) FunctionAppStackCollectionIterator {
	return original.NewFunctionAppStackCollectionIterator(page)
}
func NewFunctionAppStackCollectionPage(cur FunctionAppStackCollection, getNextPage func(context.Context, FunctionAppStackCollection) (FunctionAppStackCollection, error)) FunctionAppStackCollectionPage {
	return original.NewFunctionAppStackCollectionPage(cur, getNextPage)
}
func NewFunctionEnvelopeCollectionIterator(page FunctionEnvelopeCollectionPage) FunctionEnvelopeCollectionIterator {
	return original.NewFunctionEnvelopeCollectionIterator(page)
}
func NewFunctionEnvelopeCollectionPage(cur FunctionEnvelopeCollection, getNextPage func(context.Context, FunctionEnvelopeCollection) (FunctionEnvelopeCollection, error)) FunctionEnvelopeCollectionPage {
	return original.NewFunctionEnvelopeCollectionPage(cur, getNextPage)
}
func NewGeoRegionCollectionIterator(page GeoRegionCollectionPage) GeoRegionCollectionIterator {
	return original.NewGeoRegionCollectionIterator(page)
}
func NewGeoRegionCollectionPage(cur GeoRegionCollection, getNextPage func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)) GeoRegionCollectionPage {
	return original.NewGeoRegionCollectionPage(cur, getNextPage)
}
func NewGlobalClient(subscriptionID string) GlobalClient {
	return original.NewGlobalClient(subscriptionID)
}
func NewGlobalClientWithBaseURI(baseURI string, subscriptionID string) GlobalClient {
	return original.NewGlobalClientWithBaseURI(baseURI, subscriptionID)
}
func NewHostNameBindingCollectionIterator(page HostNameBindingCollectionPage) HostNameBindingCollectionIterator {
	return original.NewHostNameBindingCollectionIterator(page)
}
func NewHostNameBindingCollectionPage(cur HostNameBindingCollection, getNextPage func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)) HostNameBindingCollectionPage {
	return original.NewHostNameBindingCollectionPage(cur, getNextPage)
}
func NewHybridConnectionCollectionIterator(page HybridConnectionCollectionPage) HybridConnectionCollectionIterator {
	return original.NewHybridConnectionCollectionIterator(page)
}
func NewHybridConnectionCollectionPage(cur HybridConnectionCollection, getNextPage func(context.Context, HybridConnectionCollection) (HybridConnectionCollection, error)) HybridConnectionCollectionPage {
	return original.NewHybridConnectionCollectionPage(cur, getNextPage)
}
func NewIdentifierCollectionIterator(page IdentifierCollectionPage) IdentifierCollectionIterator {
	return original.NewIdentifierCollectionIterator(page)
}
func NewIdentifierCollectionPage(cur IdentifierCollection, getNextPage func(context.Context, IdentifierCollection) (IdentifierCollection, error)) IdentifierCollectionPage {
	return original.NewIdentifierCollectionPage(cur, getNextPage)
}
func NewInboundEnvironmentEndpointCollectionIterator(page InboundEnvironmentEndpointCollectionPage) InboundEnvironmentEndpointCollectionIterator {
	return original.NewInboundEnvironmentEndpointCollectionIterator(page)
}
func NewInboundEnvironmentEndpointCollectionPage(cur InboundEnvironmentEndpointCollection, getNextPage func(context.Context, InboundEnvironmentEndpointCollection) (InboundEnvironmentEndpointCollection, error)) InboundEnvironmentEndpointCollectionPage {
	return original.NewInboundEnvironmentEndpointCollectionPage(cur, getNextPage)
}
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return original.NewJobCollectionIterator(page)
}
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return original.NewJobCollectionPage(cur, getNextPage)
}
func NewKubeEnvironmentCollectionIterator(page KubeEnvironmentCollectionPage) KubeEnvironmentCollectionIterator {
	return original.NewKubeEnvironmentCollectionIterator(page)
}
func NewKubeEnvironmentCollectionPage(cur KubeEnvironmentCollection, getNextPage func(context.Context, KubeEnvironmentCollection) (KubeEnvironmentCollection, error)) KubeEnvironmentCollectionPage {
	return original.NewKubeEnvironmentCollectionPage(cur, getNextPage)
}
func NewKubeEnvironmentsClient(subscriptionID string) KubeEnvironmentsClient {
	return original.NewKubeEnvironmentsClient(subscriptionID)
}
func NewKubeEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) KubeEnvironmentsClient {
	return original.NewKubeEnvironmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewNameIdentifierCollectionIterator(page NameIdentifierCollectionPage) NameIdentifierCollectionIterator {
	return original.NewNameIdentifierCollectionIterator(page)
}
func NewNameIdentifierCollectionPage(cur NameIdentifierCollection, getNextPage func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)) NameIdentifierCollectionPage {
	return original.NewNameIdentifierCollectionPage(cur, getNextPage)
}
func NewOutboundEnvironmentEndpointCollectionIterator(page OutboundEnvironmentEndpointCollectionPage) OutboundEnvironmentEndpointCollectionIterator {
	return original.NewOutboundEnvironmentEndpointCollectionIterator(page)
}
func NewOutboundEnvironmentEndpointCollectionPage(cur OutboundEnvironmentEndpointCollection, getNextPage func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)) OutboundEnvironmentEndpointCollectionPage {
	return original.NewOutboundEnvironmentEndpointCollectionPage(cur, getNextPage)
}
func NewPerfMonCounterCollectionIterator(page PerfMonCounterCollectionPage) PerfMonCounterCollectionIterator {
	return original.NewPerfMonCounterCollectionIterator(page)
}
func NewPerfMonCounterCollectionPage(cur PerfMonCounterCollection, getNextPage func(context.Context, PerfMonCounterCollection) (PerfMonCounterCollection, error)) PerfMonCounterCollectionPage {
	return original.NewPerfMonCounterCollectionPage(cur, getNextPage)
}
func NewPremierAddOnOfferCollectionIterator(page PremierAddOnOfferCollectionPage) PremierAddOnOfferCollectionIterator {
	return original.NewPremierAddOnOfferCollectionIterator(page)
}
func NewPremierAddOnOfferCollectionPage(cur PremierAddOnOfferCollection, getNextPage func(context.Context, PremierAddOnOfferCollection) (PremierAddOnOfferCollection, error)) PremierAddOnOfferCollectionPage {
	return original.NewPremierAddOnOfferCollectionPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionCollectionIterator(page PrivateEndpointConnectionCollectionPage) PrivateEndpointConnectionCollectionIterator {
	return original.NewPrivateEndpointConnectionCollectionIterator(page)
}
func NewPrivateEndpointConnectionCollectionPage(cur PrivateEndpointConnectionCollection, getNextPage func(context.Context, PrivateEndpointConnectionCollection) (PrivateEndpointConnectionCollection, error)) PrivateEndpointConnectionCollectionPage {
	return original.NewPrivateEndpointConnectionCollectionPage(cur, getNextPage)
}
func NewProcessInfoCollectionIterator(page ProcessInfoCollectionPage) ProcessInfoCollectionIterator {
	return original.NewProcessInfoCollectionIterator(page)
}
func NewProcessInfoCollectionPage(cur ProcessInfoCollection, getNextPage func(context.Context, ProcessInfoCollection) (ProcessInfoCollection, error)) ProcessInfoCollectionPage {
	return original.NewProcessInfoCollectionPage(cur, getNextPage)
}
func NewProcessModuleInfoCollectionIterator(page ProcessModuleInfoCollectionPage) ProcessModuleInfoCollectionIterator {
	return original.NewProcessModuleInfoCollectionIterator(page)
}
func NewProcessModuleInfoCollectionPage(cur ProcessModuleInfoCollection, getNextPage func(context.Context, ProcessModuleInfoCollection) (ProcessModuleInfoCollection, error)) ProcessModuleInfoCollectionPage {
	return original.NewProcessModuleInfoCollectionPage(cur, getNextPage)
}
func NewProcessThreadInfoCollectionIterator(page ProcessThreadInfoCollectionPage) ProcessThreadInfoCollectionIterator {
	return original.NewProcessThreadInfoCollectionIterator(page)
}
func NewProcessThreadInfoCollectionPage(cur ProcessThreadInfoCollection, getNextPage func(context.Context, ProcessThreadInfoCollection) (ProcessThreadInfoCollection, error)) ProcessThreadInfoCollectionPage {
	return original.NewProcessThreadInfoCollectionPage(cur, getNextPage)
}
func NewProviderClient(subscriptionID string) ProviderClient {
	return original.NewProviderClient(subscriptionID)
}
func NewProviderClientWithBaseURI(baseURI string, subscriptionID string) ProviderClient {
	return original.NewProviderClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicCertificateCollectionIterator(page PublicCertificateCollectionPage) PublicCertificateCollectionIterator {
	return original.NewPublicCertificateCollectionIterator(page)
}
func NewPublicCertificateCollectionPage(cur PublicCertificateCollection, getNextPage func(context.Context, PublicCertificateCollection) (PublicCertificateCollection, error)) PublicCertificateCollectionPage {
	return original.NewPublicCertificateCollectionPage(cur, getNextPage)
}
func NewPublishingCredentialsPoliciesCollectionIterator(page PublishingCredentialsPoliciesCollectionPage) PublishingCredentialsPoliciesCollectionIterator {
	return original.NewPublishingCredentialsPoliciesCollectionIterator(page)
}
func NewPublishingCredentialsPoliciesCollectionPage(cur PublishingCredentialsPoliciesCollection, getNextPage func(context.Context, PublishingCredentialsPoliciesCollection) (PublishingCredentialsPoliciesCollection, error)) PublishingCredentialsPoliciesCollectionPage {
	return original.NewPublishingCredentialsPoliciesCollectionPage(cur, getNextPage)
}
func NewRecommendationCollectionIterator(page RecommendationCollectionPage) RecommendationCollectionIterator {
	return original.NewRecommendationCollectionIterator(page)
}
func NewRecommendationCollectionPage(cur RecommendationCollection, getNextPage func(context.Context, RecommendationCollection) (RecommendationCollection, error)) RecommendationCollectionPage {
	return original.NewRecommendationCollectionPage(cur, getNextPage)
}
func NewRecommendationsClient(subscriptionID string) RecommendationsClient {
	return original.NewRecommendationsClient(subscriptionID)
}
func NewRecommendationsClientWithBaseURI(baseURI string, subscriptionID string) RecommendationsClient {
	return original.NewRecommendationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceCollectionIterator(page ResourceCollectionPage) ResourceCollectionIterator {
	return original.NewResourceCollectionIterator(page)
}
func NewResourceCollectionPage(cur ResourceCollection, getNextPage func(context.Context, ResourceCollection) (ResourceCollection, error)) ResourceCollectionPage {
	return original.NewResourceCollectionPage(cur, getNextPage)
}
func NewResourceHealthMetadataClient(subscriptionID string) ResourceHealthMetadataClient {
	return original.NewResourceHealthMetadataClient(subscriptionID)
}
func NewResourceHealthMetadataClientWithBaseURI(baseURI string, subscriptionID string) ResourceHealthMetadataClient {
	return original.NewResourceHealthMetadataClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceHealthMetadataCollectionIterator(page ResourceHealthMetadataCollectionPage) ResourceHealthMetadataCollectionIterator {
	return original.NewResourceHealthMetadataCollectionIterator(page)
}
func NewResourceHealthMetadataCollectionPage(cur ResourceHealthMetadataCollection, getNextPage func(context.Context, ResourceHealthMetadataCollection) (ResourceHealthMetadataCollection, error)) ResourceHealthMetadataCollectionPage {
	return original.NewResourceHealthMetadataCollectionPage(cur, getNextPage)
}
func NewResourceMetricDefinitionCollectionIterator(page ResourceMetricDefinitionCollectionPage) ResourceMetricDefinitionCollectionIterator {
	return original.NewResourceMetricDefinitionCollectionIterator(page)
}
func NewResourceMetricDefinitionCollectionPage(cur ResourceMetricDefinitionCollection, getNextPage func(context.Context, ResourceMetricDefinitionCollection) (ResourceMetricDefinitionCollection, error)) ResourceMetricDefinitionCollectionPage {
	return original.NewResourceMetricDefinitionCollectionPage(cur, getNextPage)
}
func NewRevisionCollectionIterator(page RevisionCollectionPage) RevisionCollectionIterator {
	return original.NewRevisionCollectionIterator(page)
}
func NewRevisionCollectionPage(cur RevisionCollection, getNextPage func(context.Context, RevisionCollection) (RevisionCollection, error)) RevisionCollectionPage {
	return original.NewRevisionCollectionPage(cur, getNextPage)
}
func NewSiteConfigResourceCollectionIterator(page SiteConfigResourceCollectionPage) SiteConfigResourceCollectionIterator {
	return original.NewSiteConfigResourceCollectionIterator(page)
}
func NewSiteConfigResourceCollectionPage(cur SiteConfigResourceCollection, getNextPage func(context.Context, SiteConfigResourceCollection) (SiteConfigResourceCollection, error)) SiteConfigResourceCollectionPage {
	return original.NewSiteConfigResourceCollectionPage(cur, getNextPage)
}
func NewSiteConfigurationSnapshotInfoCollectionIterator(page SiteConfigurationSnapshotInfoCollectionPage) SiteConfigurationSnapshotInfoCollectionIterator {
	return original.NewSiteConfigurationSnapshotInfoCollectionIterator(page)
}
func NewSiteConfigurationSnapshotInfoCollectionPage(cur SiteConfigurationSnapshotInfoCollection, getNextPage func(context.Context, SiteConfigurationSnapshotInfoCollection) (SiteConfigurationSnapshotInfoCollection, error)) SiteConfigurationSnapshotInfoCollectionPage {
	return original.NewSiteConfigurationSnapshotInfoCollectionPage(cur, getNextPage)
}
func NewSiteExtensionInfoCollectionIterator(page SiteExtensionInfoCollectionPage) SiteExtensionInfoCollectionIterator {
	return original.NewSiteExtensionInfoCollectionIterator(page)
}
func NewSiteExtensionInfoCollectionPage(cur SiteExtensionInfoCollection, getNextPage func(context.Context, SiteExtensionInfoCollection) (SiteExtensionInfoCollection, error)) SiteExtensionInfoCollectionPage {
	return original.NewSiteExtensionInfoCollectionPage(cur, getNextPage)
}
func NewSkuInfoCollectionIterator(page SkuInfoCollectionPage) SkuInfoCollectionIterator {
	return original.NewSkuInfoCollectionIterator(page)
}
func NewSkuInfoCollectionPage(cur SkuInfoCollection, getNextPage func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)) SkuInfoCollectionPage {
	return original.NewSkuInfoCollectionPage(cur, getNextPage)
}
func NewSlotDifferenceCollectionIterator(page SlotDifferenceCollectionPage) SlotDifferenceCollectionIterator {
	return original.NewSlotDifferenceCollectionIterator(page)
}
func NewSlotDifferenceCollectionPage(cur SlotDifferenceCollection, getNextPage func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)) SlotDifferenceCollectionPage {
	return original.NewSlotDifferenceCollectionPage(cur, getNextPage)
}
func NewSnapshotCollectionIterator(page SnapshotCollectionPage) SnapshotCollectionIterator {
	return original.NewSnapshotCollectionIterator(page)
}
func NewSnapshotCollectionPage(cur SnapshotCollection, getNextPage func(context.Context, SnapshotCollection) (SnapshotCollection, error)) SnapshotCollectionPage {
	return original.NewSnapshotCollectionPage(cur, getNextPage)
}
func NewSourceControlCollectionIterator(page SourceControlCollectionPage) SourceControlCollectionIterator {
	return original.NewSourceControlCollectionIterator(page)
}
func NewSourceControlCollectionPage(cur SourceControlCollection, getNextPage func(context.Context, SourceControlCollection) (SourceControlCollection, error)) SourceControlCollectionPage {
	return original.NewSourceControlCollectionPage(cur, getNextPage)
}
func NewStampCapacityCollectionIterator(page StampCapacityCollectionPage) StampCapacityCollectionIterator {
	return original.NewStampCapacityCollectionIterator(page)
}
func NewStampCapacityCollectionPage(cur StampCapacityCollection, getNextPage func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)) StampCapacityCollectionPage {
	return original.NewStampCapacityCollectionPage(cur, getNextPage)
}
func NewStaticSiteBuildCollectionIterator(page StaticSiteBuildCollectionPage) StaticSiteBuildCollectionIterator {
	return original.NewStaticSiteBuildCollectionIterator(page)
}
func NewStaticSiteBuildCollectionPage(cur StaticSiteBuildCollection, getNextPage func(context.Context, StaticSiteBuildCollection) (StaticSiteBuildCollection, error)) StaticSiteBuildCollectionPage {
	return original.NewStaticSiteBuildCollectionPage(cur, getNextPage)
}
func NewStaticSiteCollectionIterator(page StaticSiteCollectionPage) StaticSiteCollectionIterator {
	return original.NewStaticSiteCollectionIterator(page)
}
func NewStaticSiteCollectionPage(cur StaticSiteCollection, getNextPage func(context.Context, StaticSiteCollection) (StaticSiteCollection, error)) StaticSiteCollectionPage {
	return original.NewStaticSiteCollectionPage(cur, getNextPage)
}
func NewStaticSiteCustomDomainOverviewCollectionIterator(page StaticSiteCustomDomainOverviewCollectionPage) StaticSiteCustomDomainOverviewCollectionIterator {
	return original.NewStaticSiteCustomDomainOverviewCollectionIterator(page)
}
func NewStaticSiteCustomDomainOverviewCollectionPage(cur StaticSiteCustomDomainOverviewCollection, getNextPage func(context.Context, StaticSiteCustomDomainOverviewCollection) (StaticSiteCustomDomainOverviewCollection, error)) StaticSiteCustomDomainOverviewCollectionPage {
	return original.NewStaticSiteCustomDomainOverviewCollectionPage(cur, getNextPage)
}
func NewStaticSiteFunctionOverviewCollectionIterator(page StaticSiteFunctionOverviewCollectionPage) StaticSiteFunctionOverviewCollectionIterator {
	return original.NewStaticSiteFunctionOverviewCollectionIterator(page)
}
func NewStaticSiteFunctionOverviewCollectionPage(cur StaticSiteFunctionOverviewCollection, getNextPage func(context.Context, StaticSiteFunctionOverviewCollection) (StaticSiteFunctionOverviewCollection, error)) StaticSiteFunctionOverviewCollectionPage {
	return original.NewStaticSiteFunctionOverviewCollectionPage(cur, getNextPage)
}
func NewStaticSiteUserCollectionIterator(page StaticSiteUserCollectionPage) StaticSiteUserCollectionIterator {
	return original.NewStaticSiteUserCollectionIterator(page)
}
func NewStaticSiteUserCollectionPage(cur StaticSiteUserCollection, getNextPage func(context.Context, StaticSiteUserCollection) (StaticSiteUserCollection, error)) StaticSiteUserCollectionPage {
	return original.NewStaticSiteUserCollectionPage(cur, getNextPage)
}
func NewStaticSiteUserProvidedFunctionAppsCollectionIterator(page StaticSiteUserProvidedFunctionAppsCollectionPage) StaticSiteUserProvidedFunctionAppsCollectionIterator {
	return original.NewStaticSiteUserProvidedFunctionAppsCollectionIterator(page)
}
func NewStaticSiteUserProvidedFunctionAppsCollectionPage(cur StaticSiteUserProvidedFunctionAppsCollection, getNextPage func(context.Context, StaticSiteUserProvidedFunctionAppsCollection) (StaticSiteUserProvidedFunctionAppsCollection, error)) StaticSiteUserProvidedFunctionAppsCollectionPage {
	return original.NewStaticSiteUserProvidedFunctionAppsCollectionPage(cur, getNextPage)
}
func NewStaticSitesClient(subscriptionID string) StaticSitesClient {
	return original.NewStaticSitesClient(subscriptionID)
}
func NewStaticSitesClientWithBaseURI(baseURI string, subscriptionID string) StaticSitesClient {
	return original.NewStaticSitesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTldLegalAgreementCollectionIterator(page TldLegalAgreementCollectionPage) TldLegalAgreementCollectionIterator {
	return original.NewTldLegalAgreementCollectionIterator(page)
}
func NewTldLegalAgreementCollectionPage(cur TldLegalAgreementCollection, getNextPage func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)) TldLegalAgreementCollectionPage {
	return original.NewTldLegalAgreementCollectionPage(cur, getNextPage)
}
func NewTopLevelDomainCollectionIterator(page TopLevelDomainCollectionPage) TopLevelDomainCollectionIterator {
	return original.NewTopLevelDomainCollectionIterator(page)
}
func NewTopLevelDomainCollectionPage(cur TopLevelDomainCollection, getNextPage func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)) TopLevelDomainCollectionPage {
	return original.NewTopLevelDomainCollectionPage(cur, getNextPage)
}
func NewTopLevelDomainsClient(subscriptionID string) TopLevelDomainsClient {
	return original.NewTopLevelDomainsClient(subscriptionID)
}
func NewTopLevelDomainsClientWithBaseURI(baseURI string, subscriptionID string) TopLevelDomainsClient {
	return original.NewTopLevelDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTriggeredJobHistoryCollectionIterator(page TriggeredJobHistoryCollectionPage) TriggeredJobHistoryCollectionIterator {
	return original.NewTriggeredJobHistoryCollectionIterator(page)
}
func NewTriggeredJobHistoryCollectionPage(cur TriggeredJobHistoryCollection, getNextPage func(context.Context, TriggeredJobHistoryCollection) (TriggeredJobHistoryCollection, error)) TriggeredJobHistoryCollectionPage {
	return original.NewTriggeredJobHistoryCollectionPage(cur, getNextPage)
}
func NewTriggeredWebJobCollectionIterator(page TriggeredWebJobCollectionPage) TriggeredWebJobCollectionIterator {
	return original.NewTriggeredWebJobCollectionIterator(page)
}
func NewTriggeredWebJobCollectionPage(cur TriggeredWebJobCollection, getNextPage func(context.Context, TriggeredWebJobCollection) (TriggeredWebJobCollection, error)) TriggeredWebJobCollectionPage {
	return original.NewTriggeredWebJobCollectionPage(cur, getNextPage)
}
func NewUsageCollectionIterator(page UsageCollectionPage) UsageCollectionIterator {
	return original.NewUsageCollectionIterator(page)
}
func NewUsageCollectionPage(cur UsageCollection, getNextPage func(context.Context, UsageCollection) (UsageCollection, error)) UsageCollectionPage {
	return original.NewUsageCollectionPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkerPoolCollectionIterator(page WorkerPoolCollectionPage) WorkerPoolCollectionIterator {
	return original.NewWorkerPoolCollectionIterator(page)
}
func NewWorkerPoolCollectionPage(cur WorkerPoolCollection, getNextPage func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)) WorkerPoolCollectionPage {
	return original.NewWorkerPoolCollectionPage(cur, getNextPage)
}
func PossibleActiveRevisionsModeValues() []ActiveRevisionsMode {
	return original.PossibleActiveRevisionsModeValues()
}
func PossibleAppServicePlanRestrictionsValues() []AppServicePlanRestrictions {
	return original.PossibleAppServicePlanRestrictionsValues()
}
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return original.PossibleAutoHealActionTypeValues()
}
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return original.PossibleAzureResourceTypeValues()
}
func PossibleAzureStorageStateValues() []AzureStorageState {
	return original.PossibleAzureStorageStateValues()
}
func PossibleAzureStorageTypeValues() []AzureStorageType {
	return original.PossibleAzureStorageTypeValues()
}
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return original.PossibleBackupItemStatusValues()
}
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return original.PossibleBackupRestoreOperationTypeValues()
}
func PossibleBuildStatusValues() []BuildStatus {
	return original.PossibleBuildStatusValues()
}
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return original.PossibleBuiltInAuthenticationProviderValues()
}
func PossibleCertificateOrderActionTypeValues() []CertificateOrderActionType {
	return original.PossibleCertificateOrderActionTypeValues()
}
func PossibleCertificateOrderStatusValues() []CertificateOrderStatus {
	return original.PossibleCertificateOrderStatusValues()
}
func PossibleCertificateProductTypeValues() []CertificateProductType {
	return original.PossibleCertificateProductTypeValues()
}
func PossibleChannelsValues() []Channels {
	return original.PossibleChannelsValues()
}
func PossibleCheckNameResourceTypesValues() []CheckNameResourceTypes {
	return original.PossibleCheckNameResourceTypesValues()
}
func PossibleClientCertModeValues() []ClientCertMode {
	return original.PossibleClientCertModeValues()
}
func PossibleClientCredentialMethodValues() []ClientCredentialMethod {
	return original.PossibleClientCredentialMethodValues()
}
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return original.PossibleCloneAbilityResultValues()
}
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return original.PossibleComputeModeOptionsValues()
}
func PossibleConfigReferenceSourceValues() []ConfigReferenceSource {
	return original.PossibleConfigReferenceSourceValues()
}
func PossibleConnectionStringTypeValues() []ConnectionStringType {
	return original.PossibleConnectionStringTypeValues()
}
func PossibleContainerAppProvisioningStateValues() []ContainerAppProvisioningState {
	return original.PossibleContainerAppProvisioningStateValues()
}
func PossibleContinuousWebJobStatusValues() []ContinuousWebJobStatus {
	return original.PossibleContinuousWebJobStatusValues()
}
func PossibleCookieExpirationConventionValues() []CookieExpirationConvention {
	return original.PossibleCookieExpirationConventionValues()
}
func PossibleCustomDomainStatusValues() []CustomDomainStatus {
	return original.PossibleCustomDomainStatusValues()
}
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return original.PossibleCustomHostNameDNSRecordTypeValues()
}
func PossibleDNSTypeValues() []DNSType {
	return original.PossibleDNSTypeValues()
}
func PossibleDNSVerificationTestResultValues() []DNSVerificationTestResult {
	return original.PossibleDNSVerificationTestResultValues()
}
func PossibleDatabaseTypeValues() []DatabaseType {
	return original.PossibleDatabaseTypeValues()
}
func PossibleDetectorTypeValues() []DetectorType {
	return original.PossibleDetectorTypeValues()
}
func PossibleDomainStatusValues() []DomainStatus {
	return original.PossibleDomainStatusValues()
}
func PossibleDomainTypeValues() []DomainType {
	return original.PossibleDomainTypeValues()
}
func PossibleEnterpriseGradeCdnStatusValues() []EnterpriseGradeCdnStatus {
	return original.PossibleEnterpriseGradeCdnStatusValues()
}
func PossibleForwardProxyConventionValues() []ForwardProxyConvention {
	return original.PossibleForwardProxyConventionValues()
}
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return original.PossibleFrequencyUnitValues()
}
func PossibleFrontEndServiceTypeValues() []FrontEndServiceType {
	return original.PossibleFrontEndServiceTypeValues()
}
func PossibleFtpsStateValues() []FtpsState {
	return original.PossibleFtpsStateValues()
}
func PossibleHostNameTypeValues() []HostNameType {
	return original.PossibleHostNameTypeValues()
}
func PossibleHostTypeValues() []HostType {
	return original.PossibleHostTypeValues()
}
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return original.PossibleHostingEnvironmentStatusValues()
}
func PossibleIPFilterTagValues() []IPFilterTag {
	return original.PossibleIPFilterTagValues()
}
func PossibleInAvailabilityReasonTypeValues() []InAvailabilityReasonType {
	return original.PossibleInAvailabilityReasonTypeValues()
}
func PossibleIngressTransportMethodValues() []IngressTransportMethod {
	return original.PossibleIngressTransportMethodValues()
}
func PossibleInsightStatusValues() []InsightStatus {
	return original.PossibleInsightStatusValues()
}
func PossibleIssueTypeValues() []IssueType {
	return original.PossibleIssueTypeValues()
}
func PossibleJobTypeValues() []JobType {
	return original.PossibleJobTypeValues()
}
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return original.PossibleKeyVaultSecretStatusValues()
}
func PossibleKubeEnvironmentProvisioningStateValues() []KubeEnvironmentProvisioningState {
	return original.PossibleKubeEnvironmentProvisioningStateValues()
}
func PossibleLoadBalancingModeValues() []LoadBalancingMode {
	return original.PossibleLoadBalancingModeValues()
}
func PossibleLogLevelValues() []LogLevel {
	return original.PossibleLogLevelValues()
}
func PossibleMSDeployLogEntryTypeValues() []MSDeployLogEntryType {
	return original.PossibleMSDeployLogEntryTypeValues()
}
func PossibleMSDeployProvisioningStateValues() []MSDeployProvisioningState {
	return original.PossibleMSDeployProvisioningStateValues()
}
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return original.PossibleManagedPipelineModeValues()
}
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return original.PossibleManagedServiceIdentityTypeValues()
}
func PossibleMySQLMigrationTypeValues() []MySQLMigrationType {
	return original.PossibleMySQLMigrationTypeValues()
}
func PossibleNotificationLevelValues() []NotificationLevel {
	return original.PossibleNotificationLevelValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicCertificateLocationValues() []PublicCertificateLocation {
	return original.PossiblePublicCertificateLocationValues()
}
func PossiblePublishingProfileFormatValues() []PublishingProfileFormat {
	return original.PossiblePublishingProfileFormatValues()
}
func PossibleRedundancyModeValues() []RedundancyMode {
	return original.PossibleRedundancyModeValues()
}
func PossibleRenderingTypeValues() []RenderingType {
	return original.PossibleRenderingTypeValues()
}
func PossibleResolveStatusValues() []ResolveStatus {
	return original.PossibleResolveStatusValues()
}
func PossibleResourceScopeTypeValues() []ResourceScopeType {
	return original.PossibleResourceScopeTypeValues()
}
func PossibleRevisionHealthStateValues() []RevisionHealthState {
	return original.PossibleRevisionHealthStateValues()
}
func PossibleRevisionProvisioningStateValues() []RevisionProvisioningState {
	return original.PossibleRevisionProvisioningStateValues()
}
func PossibleRouteTypeValues() []RouteType {
	return original.PossibleRouteTypeValues()
}
func PossibleScmTypeValues() []ScmType {
	return original.PossibleScmTypeValues()
}
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return original.PossibleSiteAvailabilityStateValues()
}
func PossibleSiteExtensionTypeValues() []SiteExtensionType {
	return original.PossibleSiteExtensionTypeValues()
}
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return original.PossibleSiteLoadBalancingValues()
}
func PossibleSiteRuntimeStateValues() []SiteRuntimeState {
	return original.PossibleSiteRuntimeStateValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleSolutionTypeValues() []SolutionType {
	return original.PossibleSolutionTypeValues()
}
func PossibleSslStateValues() []SslState {
	return original.PossibleSslStateValues()
}
func PossibleStackPreferredOsValues() []StackPreferredOs {
	return original.PossibleStackPreferredOsValues()
}
func PossibleStagingEnvironmentPolicyValues() []StagingEnvironmentPolicy {
	return original.PossibleStagingEnvironmentPolicyValues()
}
func PossibleStatusOptionsValues() []StatusOptions {
	return original.PossibleStatusOptionsValues()
}
func PossibleStorageTypeValues() []StorageType {
	return original.PossibleStorageTypeValues()
}
func PossibleSupportedTLSVersionsValues() []SupportedTLSVersions {
	return original.PossibleSupportedTLSVersionsValues()
}
func PossibleTriggerTypesValues() []TriggerTypes {
	return original.PossibleTriggerTypesValues()
}
func PossibleTriggeredWebJobStatusValues() []TriggeredWebJobStatus {
	return original.PossibleTriggeredWebJobStatusValues()
}
func PossibleUnauthenticatedClientActionV2Values() []UnauthenticatedClientActionV2 {
	return original.PossibleUnauthenticatedClientActionV2Values()
}
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return original.PossibleUnauthenticatedClientActionValues()
}
func PossibleUsageStateValues() []UsageState {
	return original.PossibleUsageStateValues()
}
func PossibleValidateResourceTypesValues() []ValidateResourceTypes {
	return original.PossibleValidateResourceTypesValues()
}
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return original.PossibleWorkerSizeOptionsValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
