// Copyright 2011 Dmitry Chestnykh. All rights reserved.
// Use of this source code is governed by a MIT-style
// license that can be found in the LICENSE file.

// capgen is an utility to test captcha generation.
//
//nolint:forbidigo
package main

import (
	"flag"
	"fmt"
	"os"

	"code.forgejo.org/go-chi/captcha"
)

var (
	flagLen  = flag.Int("len", captcha.DefaultLen, "length of captcha")
	flagImgW = flag.Int("width", captcha.StdWidth, "image captcha width")
	flagImgH = flag.Int("height", captcha.StdHeight, "image captcha height")
)

func usage() {
	fmt.Fprintf(os.Stderr, "usage: capgen [flags] filename\n")
	flag.PrintDefaults()
}

func main() {
	flag.Parse()
	fname := flag.Arg(0)
	if fname == "" {
		usage()
		os.Exit(1)
	}
	f, err := os.Create(fname)
	if err != nil {
		panic(err)
	}
	defer f.Close()
	d := captcha.RandomDigits(*flagLen)
	if _, err := captcha.NewImage("", d, *flagImgW, *flagImgH).WriteTo(f); err != nil {
		panic(err)
	}
	for _, digit := range d {
		fmt.Print(string(digit + 48))
	}
	fmt.Println()
}
