// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationshipinfo"
	"entgo.io/ent/schema/field"
)

// RelationshipInfoDelete is the builder for deleting a RelationshipInfo entity.
type RelationshipInfoDelete struct {
	config
	hooks    []Hook
	mutation *RelationshipInfoMutation
}

// Where appends a list predicates to the RelationshipInfoDelete builder.
func (rid *RelationshipInfoDelete) Where(ps ...predicate.RelationshipInfo) *RelationshipInfoDelete {
	rid.mutation.Where(ps...)
	return rid
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (rid *RelationshipInfoDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(rid.hooks) == 0 {
		affected, err = rid.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*RelationshipInfoMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			rid.mutation = mutation
			affected, err = rid.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(rid.hooks) - 1; i >= 0; i-- {
			if rid.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = rid.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, rid.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (rid *RelationshipInfoDelete) ExecX(ctx context.Context) int {
	n, err := rid.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (rid *RelationshipInfoDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: relationshipinfo.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: relationshipinfo.FieldID,
			},
		},
	}
	if ps := rid.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, rid.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// RelationshipInfoDeleteOne is the builder for deleting a single RelationshipInfo entity.
type RelationshipInfoDeleteOne struct {
	rid *RelationshipInfoDelete
}

// Exec executes the deletion query.
func (rido *RelationshipInfoDeleteOne) Exec(ctx context.Context) error {
	n, err := rido.rid.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{relationshipinfo.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (rido *RelationshipInfoDeleteOne) ExecX(ctx context.Context) {
	rido.rid.ExecX(ctx)
}
