package main

import (
	"bytes"
	"compress/gzip"
	"io"
	"log"
)

func bindata_read(data []byte, name string) []byte {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		log.Fatalf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	gz.Close()

	if err != nil {
		log.Fatalf("Read %q: %v", name, err)
	}

	return buf.Bytes()
}

func in_b_test_asset() []byte {
	return bindata_read([]byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x00, 0xff, 0xd2, 0xd7,
		0x57, 0x28, 0x4e, 0xcc, 0x2d, 0xc8, 0x49, 0x55, 0x48, 0xcb, 0xcc, 0x49,
		0xe5, 0x02, 0x04, 0x00, 0x00, 0xff, 0xff, 0x8a, 0x82, 0x8c, 0x85, 0x0f,
		0x00, 0x00, 0x00,
	},
		"in/b/test.asset",
	)
}

func in_test_asset() []byte {
	return bindata_read([]byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x00, 0xff, 0xd2, 0xd7,
		0x57, 0x28, 0x4e, 0xcc, 0x2d, 0xc8, 0x49, 0x55, 0x48, 0xcb, 0xcc, 0x49,
		0xe5, 0x02, 0x04, 0x00, 0x00, 0xff, 0xff, 0x8a, 0x82, 0x8c, 0x85, 0x0f,
		0x00, 0x00, 0x00,
	},
		"in/test.asset",
	)
}

func in_a_test_asset() []byte {
	return bindata_read([]byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x00, 0xff, 0xd2, 0xd7,
		0x57, 0x28, 0x4e, 0xcc, 0x2d, 0xc8, 0x49, 0x55, 0x48, 0xcb, 0xcc, 0x49,
		0xe5, 0x02, 0x04, 0x00, 0x00, 0xff, 0xff, 0x8a, 0x82, 0x8c, 0x85, 0x0f,
		0x00, 0x00, 0x00,
	},
		"in/a/test.asset",
	)
}

func in_c_test_asset() []byte {
	return bindata_read([]byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x00, 0xff, 0xd2, 0xd7,
		0x57, 0x28, 0x4e, 0xcc, 0x2d, 0xc8, 0x49, 0x55, 0x48, 0xcb, 0xcc, 0x49,
		0xe5, 0x02, 0x04, 0x00, 0x00, 0xff, 0xff, 0x8a, 0x82, 0x8c, 0x85, 0x0f,
		0x00, 0x00, 0x00,
	},
		"in/c/test.asset",
	)
}

// Asset loads and returns the asset for the given name.
// This returns nil of the asset could not be found.
func Asset(name string) []byte {
	if f, ok := _bindata[name]; ok {
		return f()
	}
	return nil
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() []byte{
	"in/b/test.asset": in_b_test_asset,
	"in/test.asset":   in_test_asset,
	"in/a/test.asset": in_a_test_asset,
	"in/c/test.asset": in_c_test_asset,
}
