-----------------------------------------------------------------------
--                               G P S                               --
--                                                                   --
--                  Copyright (C) 2002-2009, AdaCore                 --
--                                                                   --
-- GPS is free  software; you can  redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this library; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with GNAT.OS_Lib;             use GNAT.OS_Lib;
with GNATCOLL.VFS;            use GNATCOLL.VFS;
with Gtkada.File_Selector;    use Gtkada.File_Selector;

with Case_Handling;           use Case_Handling;
with GPS.Intl;                use GPS.Intl;

with AUnit_Templates;         use AUnit_Templates;
with Templates_Parser;        use Templates_Parser;

with GPS.Kernel.Project;      use GPS.Kernel.Project;

package body Make_Test_Window_Pkg.Callbacks is
   --  Handle callbacks from "AUnit_Make_Test" main window.  Template
   --  generated by Glade

   --------------------
   -- Check_Validity --
   --------------------

   procedure Check_Validity
     (Object : access Gtk_Widget_Record'Class)
   is
      Win   : constant Make_Test_Window_Access :=
                Make_Test_Window_Access (Get_Toplevel (Object));
      Valid : Boolean;
   begin
      Valid := True;

      if not Is_Directory (Get_Text (Win.Directory_Entry)) then
         Valid := False;
         Set_Text (Win.Label, -"Invalid or non existing directory selected");
         Grab_Focus (Win.Description_Entry);
      end if;

      if Valid and then Get_Text (Win.Name_Entry) = "" then
         Valid := False;
         Set_Text (Win.Label, -"Missing test case name");
         Grab_Focus (Win.Name_Entry);
      end if;

      if Valid and then Get_Text (Win.Description_Entry) = "" then
         Valid := False;
         Set_Text (Win.Label, -"Missing test case description");
      end if;

      if Valid then
         Set_Text
           (Win.Label,
            -"Ready to create new test case " & Get_Text (Win.Name_Entry));
      end if;

      Set_Response_Sensitive (Win, Gtk_Response_OK, Valid);
   end Check_Validity;

   ---------------------------------
   -- On_Browse_Directory_Clicked --
   ---------------------------------

   procedure On_Browse_Directory_Clicked
     (Object : access Gtk_Button_Record'Class)
   is
      --  Open explorer window to select suite
      Test_Window : constant Make_Test_Window_Access :=
        Make_Test_Window_Access (Get_Toplevel (Object));
   begin
      Browse_Location (Test_Window.Directory_Entry);
      Check_Validity (Test_Window);
   end On_Browse_Directory_Clicked;

   -------------------
   -- On_Ok_Clicked --
   -------------------

   procedure On_Ok_Clicked (Window : Make_Test_Window_Access) is

      Directory_Name : constant Virtual_File :=
                         Create_From_UTF8 (Get_Text (Window.Directory_Entry));
      Name           : String := Get_Text (Window.Name_Entry);
      Description    : constant String := Get_Text (Window.Description_Entry);
      Translation    : Translate_Set;
      Success        : Boolean;

   begin
      --  Correct the case for Name, if needed.
      Mixed_Case (Name);

      Insert (Translation,
              Assoc ("TEST_CASE_PACKAGE", Name));
      --  ??? customisable test case type
      Insert
        (Translation, Assoc ("TEST_CASE_TYPE", "Test_Case"));
      Insert
        (Translation, Assoc ("TEST_CASE_DESCRIPTION", Description));
      Insert
        (Translation,
         Assoc ("OVERRIDE_SET_UP", Get_Active (Window.Override_Set_Up)));
      Insert
        (Translation,
         Assoc
           ("OVERRIDE_TEAR_DOWN", Get_Active (Window.Override_Tear_Down)));

      if Get_Active (Window.Aunit1_Button) then
         Insert
           (Translation,
            Assoc ("AUNIT", "AUNIT1.X"));
      end if;

      Create_Files
        (Window.Kernel,
         "test_case",
         Translation,
         Directory_Name,
         Name,
         Success);

      if Success then
         Recompute_View (Window.Kernel);
         Hide (Window);
      end if;
   end On_Ok_Clicked;

end Make_Test_Window_Pkg.Callbacks;
