-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_dialog.adb,v $
--  Description     : Top level class for all dialog windows
--  Author          : Michael Erdmann                                        --
--  Created         : 25.9.2001                                              --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/08 20:05:35 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;         use Ada.Text_IO;

with Gtk.Box;             use Gtk.Box;
with Gtk.Button;          use Gtk.Button;
with Gtk.Dialog;          use Gtk.Dialog;
with Gtk.Handlers;        use Gtk.Handlers;
with Gtk.Label;           use Gtk.Label;
with Gtk.Widget;          use Gtk.Widget;
with Gtk;                 use Gtk;
with Glib;                use Glib;
with Gdk;                 use Gdk;

with GUI_Logging;

package body GUI_Dialog is

   Version    : constant String := "$Id: gui_dialog.adb,v 1.4 2001/10/08 20:05:35 me Exp $";

   Active_Dlg : Gtk_Dialog;

   package Destroy_Dialog_Handler is new Handlers.User_Callback
     (Gtk_Dialog_Record, Handle);
   package Widget_Handler is new Handlers.Callback (Gtk_Widget_Record);

   --------------------------
   -- Dialog_Button_Record --
   --------------------------
   type Dialog_Button_Record is new Gtk_Button_Record with record
         Receiver : Handle  := null;
         Cmd      : Natural := 0;
      end record;

   type Dialog_Button is access all Dialog_Button_Record'Class;

   package Button_Cb is new Handlers.Callback (Dialog_Button_Record);

   --- ************************************************************************** ---
   --- ***                P R I V A T E    M E T H O D S                      *** ---
   --- ************************************************************************** ---

   --------------------
   -- Button pressed --
   --------------------
   procedure CB_Button_Pressed(
      Pressed : access Dialog_Button_Record'Class ) is
   begin
      if  Pressed.Receiver /= null then
         Command(Pressed.Receiver.all, Pressed.Cmd );
      else
         Put_Line("Command not executed");
      end if;
   end CB_Button_Pressed;

   ----------------
   -- Add_Button --
   ----------------
   procedure Add_Button(
      Receiver : in Object'Class;
      Title    : in String;
      Cmd      : in Natural;
      Box      : in out Gtk_Box ) is
      Result   : Dialog_Button := new Dialog_Button_Record;
   begin
      Gtk.Button.Initialize( Result, Title );
      Result.Receiver := Receiver.Self;
      Result.Cmd      := Cmd;

      Pack_Start (Box, Result, Expand => False );

      Button_CB.Object_Connect(
         result,
         "clicked",
         Button_CB.To_Marshaller (CB_Button_Pressed'Access ),
         Slot_Object => Result
      );
   end Add_Button;

   --------------------
   -- Destroy_Dialog --
   --------------------
   procedure Destroy_Dialog (
      Win : access Gtk.Dialog.Gtk_Dialog_Record'Class;
      Ptr : in Handle) is
   begin
      Active_DLG := null;
   end Destroy_Dialog;

   --- ************************************************************************** ---
   --- ***                 P U B L I C     M E T H O D S                      *** ---
   --- ************************************************************************** ---

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize(
      This : in out Object ) is
   begin
      This.Self := This'Unchecked_Access;
      Gtk_New( This.Dialog );
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize(
      This : in out Object ) is
   begin
      Active_DLG := null;
      Destroy( This.Dialog );
   end Finalize;

   ---------------------
   -- Dialog_Contents --
   ---------------------
   procedure Dialog_Contents(
      This  : in out Object;
      Vbox  : in Gtk_Box ) is
      -- this procedure has to be redefined in the application.
      Label : Gtk_Label;
   begin
      Gtk_New (Label, "Dialog_contents not yet implemented " );
      Pack_Start( Vbox, Label, Expand => False );
   end Dialog_Contents;

   ----------------
   -- Add_Dialog --
   ----------------
   procedure Add_Dialog(
      This   : in out Object'Class;
      Title  : in String;
      SizeX  : in Integer := 0;
      SizeY  : in Integer := 0 ) is
      -- add a dialog window
      Area   : Gtk_Box renames This.Area;
      Vbox   : Gtk_Box renames This.Vbox;
   begin
      if Active_DLG /= null then
         GUI_Logging.Error("*** Internal error 001 in GUI_Dialog ***");
         return;
      end if;

      Gtk_New (This.Dialog);
      Active_Dlg := This.Dialog;

      Destroy_Dialog_Handler.Connect
           (This.Dialog, "destroy",
            Destroy_Dialog_Handler.To_Marshaller (Destroy_Dialog'Access),
            This.Self);

      Set_Title (This.Dialog, Title );
      Set_Border_Width (This.Dialog, 0);
      if SizeX > 0 and SizeY > 0 then
         Set_Usize (This.Dialog, GInt(SizeX), GInt(SizeY));
      end if;

      Area := Get_Action_Area(This.Dialog);
      Show_All( Area );
      Add_Command( This, "DISMISS", Dlg_Cmd_Dismiss );

      Vbox := Get_VBox(This.Dialog);
      Dialog_Contents( This, Vbox );
      Show_All( Vbox );

      Show (This.Dialog);
   end Add_Dialog;

   -----------------
   -- Add_Command --
   -----------------
   procedure Add_Command(
      This : in out Object'Class;
      Text : in String;
      Cmd  : in Natural ) is
   begin
      Add_Button( This, Text,Cmd, This.Area);
   end Add_Command;

   -------------
   -- Command --
   -------------
   procedure Command(
      This : in out Object;
      Cmd  : in Natural ) is
   begin
      if Cmd = Dlg_Cmd_Dismiss then
         Finalize( This );
      end if;
   end Command;

end GUI_Dialog;
