
"Modelview matrix transformations."

import OpenGL.GL as gl

import glitch

class Transform(glitch.Node):
    "A transformation of the modelview matrix."

    def render(self, ctx):
        gl.glMatrixMode(gl.GL_MODELVIEW)
        gl.glPushMatrix()

        glitch.Node.render(self, ctx)

        gl.glMatrixMode(gl.GL_MODELVIEW)
        gl.glPopMatrix()

class Translate(Transform):
    "A translation."

    def __init__(self, x=0, y=0, z=0, **kwargs):
        """
        @param x: X translation.
        @param y: Y translation.
        @param z: Z translation.
        """

        Transform.__init__(self, **kwargs)
        self.x=x
        self.y=y
        self.z=z

    def draw(self, ctx):
        gl.glTranslate(self.x, self.y, self.z)

class Scale(Transform):
    "A scaling."

    def __init__(self, x=1, y=1, z=1, **kwargs):
        """
        @param x: X dimension scale.
        @param y: Y dimension scale.
        @param z: Z dimension scale.
        """

        Transform.__init__(self, **kwargs)
        self.x=x
        self.y=y
        self.z=z

    def draw(self, ctx):
        gl.glScale(self.x, self.y, self.z)

class Rotate(Transform):
    "A rotation."

    def __init__(self, angle=0, x=0, y=0, z=0, **kwargs):
        """
        @param angle: The rotation angle.
        @param x: X magnitude.
        @param y: Y magnitude.
        @param z: Z magnitude.
        """

        Transform.__init__(self, **kwargs)
        self.angle=angle
        self.x=x
        self.y=y
        self.z=z

    def draw(self, ctx):
        gl.glRotate(self.angle, self.x, self.y, self.z)
