# Contributing Guide

Contributions to gittuf can be of several types:
* changes to the [design document](/docs/design-document.md) or
  [gittuf Augmentation Proposals (GAPs)](/docs/gaps/README.md) stored in the
  `docs/` folder
* code changes for bug fixes, new features, documentation, and other
  enhancements to the implementation
* new issues or feature requests

[Join our community](https://github.com/gittuf/community/?tab=readme-ov-file#join-us)
to get started!

## Contributor Workflow

When submitting changes to the gittuf docs or implementation, contributors must
open a GitHub pull request to the repository. If a proposed change is a
significant deviation from gittuf's [design document](/docs/design-document.md),
a [GAP](/docs/gaps/README.md) may be necessary. When in doubt, contributors are
advised to file an issue in the repository for the
[maintainers](MAINTAINERS.txt) to determine the best way forward.

gittuf uses the NYU Secure Systems Lab [development
workflow](https://github.com/secure-systems-lab/lab-guidelines/blob/master/dev-workflow.md).
Pull requests must include tests for the changes in behavior they introduce.
They are reviewed by one or more [maintainers](MAINTAINERS.txt) and undergo
automated testing such as (but not limited to):
* Unit and build testing
* Static analysis using linters
* Developer Certificate of Origin (DCO) check

In future, as gittuf matures, this repository will also be secured using gittuf.
At that point, the contributor workflow may evolve to record gittuf specific
information.

## Other Guidelines

Contributors to gittuf must abide by the project's
[code of conduct](https://github.com/gittuf/community/blob/main/CODE-OF-CONDUCT.md).
Any questions regarding the gittuf community's governance and code of conduct
may be directed to the project's
[Technical Steering Committee](https://github.com/gittuf/community/blob/main/TECHNICAL-STEERING-COMMITTEE.md).
