/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.Complex;
import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.ModelPanel;
import hypergraph.hyperbolic.ModelPanelUI;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.Projector;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class PoincareProjector
implements Projector {
    public Point[] getLineSegments(ModelPoint modelPoint, ModelPoint modelPoint2, JComponent jComponent) {
        ModelPanelUI modelPanelUI = ((ModelPanel)jComponent).getUI();
        modelPanelUI.applyViewMatrix(modelPoint, jComponent);
        modelPanelUI.applyViewMatrix(modelPoint2, jComponent);
        if (modelPanelUI.isDraft() || ((Complex)modelPoint).dist((Complex)modelPoint2) < 0.1) {
            Point[] pointArray = new Point[]{modelPanelUI.map(modelPoint, jComponent), modelPanelUI.map(modelPoint2, jComponent)};
            return pointArray;
        }
        Complex complex = (Complex)modelPoint;
        int n = 6;
        if (((Complex)modelPoint).dist((Complex)modelPoint2) > 1.0) {
            n = 30;
        }
        Point[] pointArray = new Point[n + 1];
        pointArray[0] = modelPanelUI.map(complex, jComponent);
        Isometry isometry = ((ModelPanel)jComponent).getModel().getTranslation(modelPoint, modelPoint2, 1.0 / (double)n);
        for (int i = 1; i < n + 1; ++i) {
            isometry.apply(complex);
            pointArray[i] = modelPanelUI.map(complex, jComponent);
        }
        return pointArray;
    }

    public Point map(ModelPoint modelPoint, JComponent jComponent) {
        Complex complex = (Complex)modelPoint;
        return new Point((int)Math.floor((complex.real + 1.0) * 0.5 * (double)jComponent.getWidth()), (int)Math.floor((1.0 - complex.imag) * 0.5 * (double)jComponent.getHeight()));
    }

    public ModelPoint inversMap(Point point, JComponent jComponent) {
        Complex complex = new Complex();
        if (jComponent.getWidth() != 0) {
            complex.real = point.getX() * 2.0 / (double)jComponent.getWidth() - 1.0;
        }
        if (jComponent.getHeight() != 0) {
            complex.imag = 1.0 - point.getY() * 2.0 / (double)jComponent.getHeight();
        }
        if (complex.norm2() < 1.0) {
            return complex;
        }
        return null;
    }

    public Point2D getScale(ModelPoint modelPoint, JComponent jComponent) {
        double d = 1.0 - ((Complex)modelPoint).norm2();
        return new Point2D.Double(d, d);
    }
}

