/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.graphApi.io.CSSColourParser;
import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.LineRenderer;
import hypergraph.hyperbolic.Model;
import hypergraph.hyperbolic.ModelPanelUI;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.Projector;
import hypergraph.hyperbolic.PropertyManager;
import hypergraph.hyperbolic.Renderer;
import hypergraph.hyperbolic.TextRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModelPanel
extends JComponent
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private Model model;
    private LineRenderer lineRenderer;
    private TextRenderer textRenderer;
    private Projector projector;
    private PropertyManager properties;
    private ModelPoint draggingStartPoint;

    public ModelPanel() {
        this.refreshProperties();
        if (UIManager.get("ModelPanelUI") == null) {
            UIManager.put("ModelPanelUI", "hypergraph.hyperbolic.ModelPanelUI");
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.updateUI();
    }

    public void loadProperties(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        this.refreshProperties();
    }

    public void refreshProperties() {
        if (this.properties == null) {
            this.properties = new PropertyManager();
        }
        Model model = null;
        try {
            model = (Model)this.properties.getClass("model.class").newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setModel(model);
        this.getModel().addChangeListener(this);
        String string = this.getPropertyManager().getString("hypergraph.hyperbolic.background.color");
        if (string != null) {
            Color color = CSSColourParser.stringToColor(string);
            this.setBackground(color);
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    public PropertyManager getPropertyManager() {
        return this.properties;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public Isometry getInversViewMatrix() {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().getInversViewMatrix();
    }

    public Isometry getViewMatrix() {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().getViewMatrix();
    }

    public void setViewMatrix(Isometry isometry) {
        if (this.getModel() == null) {
            return;
        }
        this.getModel().setViewMatrix(isometry);
    }

    public void setProjector(Projector projector) {
        Projector projector2 = this.projector;
        this.projector = projector;
        this.firePropertyChange("Projector", projector2, this.projector);
    }

    public Projector getProjector() {
        if (this.projector != null) {
            return this.projector;
        }
        try {
            this.projector = (Projector)this.properties.getClass("projector.class").newInstance();
        }
        catch (Exception exception) {
            System.out.println("Couldn't load projector");
            System.out.println("Classname for projector is : " + this.properties.getString("projector.class"));
            exception.printStackTrace();
            return null;
        }
        return this.projector;
    }

    public void paintRenderer(Graphics graphics, Renderer renderer) {
        this.getUI().paintRenderer(graphics, this, renderer);
    }

    public void paintLine(Graphics graphics, ModelPoint modelPoint, ModelPoint modelPoint2) {
        this.getUI().paintLine(graphics, this, modelPoint, modelPoint2);
    }

    public void paintText(Graphics graphics, ModelPoint modelPoint, String string) {
        this.getUI().paintText(graphics, this, modelPoint, string);
    }

    public void setModel(Model model) {
        Model model2 = this.getModel();
        this.model = model;
        this.firePropertyChange("Model", model2, model);
    }

    public Model getModel() {
        return this.model;
    }

    public ModelPanelUI getUI() {
        return (ModelPanelUI)this.ui;
    }

    public void setUI(ModelPanelUI modelPanelUI) {
        super.setUI(modelPanelUI);
    }

    public void updateUI() {
        this.setUI((ModelPanelUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ModelPanelUI";
    }

    public Point2D getScale(ModelPoint modelPoint) {
        return this.getUI().getScale(modelPoint, this);
    }

    public Point project(ModelPoint modelPoint) {
        return this.getUI().project(modelPoint, this);
    }

    public ModelPoint unProject(Point point) {
        return this.getUI().unProject(point, this);
    }

    public void center(Point point) {
        this.getUI().center(point, (JComponent)this);
    }

    public LineRenderer getLineRenderer() {
        if (this.lineRenderer == null) {
            try {
                this.lineRenderer = (LineRenderer)this.properties.getClass("linerenderer.class").newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.lineRenderer;
    }

    public TextRenderer getTextRenderer() {
        if (this.textRenderer == null) {
            try {
                this.textRenderer = (TextRenderer)this.properties.getClass("textrenderer.class").newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.textRenderer;
    }

    public void setLineRenderer(LineRenderer lineRenderer) {
        this.lineRenderer = lineRenderer;
    }

    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1 && (mouseEvent.getModifiers() & 0x10) != 0) {
            this.center(mouseEvent.getPoint());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.draggingStartPoint = this.getUI().unProject(mouseEvent.getPoint(), (JComponent)mouseEvent.getSource());
            this.getUI().setAnimation(false);
            this.getUI().setDraft(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            jComponent.setCursor(Cursor.getDefaultCursor());
            this.draggingStartPoint = null;
            this.getUI().setAnimation(true);
            this.getUI().setDraft(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        if ((mouseEvent.getModifiers() & 0x10) != 0 && this.draggingStartPoint != null) {
            jComponent.setCursor(Cursor.getPredefinedCursor(12));
            this.getUI().move(this.draggingStartPoint, mouseEvent.getPoint(), jComponent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

