/*
    Copyright (C) 1996 Alistair Conkie
 
    You may distribute under the terms of the GNU General Public
    Licence as specified in the README file.
*/

#include "t2s.h"

 
unsigned char hdr16k[] =  {
  0x2e, 0x73, 0x6e, 0x64, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x3e, 0x80, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
 
unsigned char hdr10k[] =  {
  0x2e, 0x73, 0x6e, 0x64, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x25, 0x80, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
 
unsigned char hdr8k[] =  {
  0x2e, 0x73, 0x6e, 0x64, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


export void output_open(CONFIG *config)
{

  if(!strcmp(config->output_file,"-")) {
    config->ofd = stdout;
  } else if((config->ofd=fopen(config->output_file,"w")) == NULL) {
    (void)fprintf(stderr,"Cannot open output file: %s\n",config->output_file);
    exit(2);
  }
  if(!strcmp(config->prog,"high_level")) {
    return;
  }	/* the formats son't matter  */


  if(!strcmp(config->format,"sun10k")) {
    fwrite(hdr10k,1,32,config->ofd);
  } else if(!strcmp(config->format,"sun16k")) {
    fwrite(hdr16k,1,32,config->ofd);
  } else if(!strcmp(config->format,"sun8k")) {
    fwrite(hdr8k,1,32,config->ofd);
  } else if(!strcmp(config->format,"soundblaster8")) {
    ; /* nothing, as far as I know  */
  }

}

export void output_close(CONFIG *config)
{
  if(config->ofd != stdout) 
    fclose(config->ofd);
}
