function y=sscanf_test( f )

if f
    s = { ...
        { 'abc 1 2 3','%s%d'},...
        { 'abc 1 2 3\n\n','%s%d'},...
        { 'abc 1 2 3','abc %d'},...
        { 'abc 1 2 3\n','abc %d'},...
        { 'abc 1 2 3\n','%s %d'},...
        { '1 2 3 4 5','%f%g%d%i'},...
        { 'abc 1 2 3','%c%s'},...
        { 'abc 1 2 3','%s%c%d'},...
        { 'abc 1 2 3','%s%d',3},...
        { 'abc 1 2 3\n\n','%s%d',[3 2]},...
        { 'abc 1 2 3','abc %d 2 3',[3 inf]},...
        { 'abc 1 2 3\n','abc %d',[2 5]},...
        { 'abc 1 2 3\n','%s %d',[1 1]},...
        { '1 2 3 4 5','%f%g%d%i',[3 3]},...
        { 'abc 1 2 3','%c%4s',[4 2]},...
        { 'abc 1 2 3','%s%c%d',[5 inf]},...
        { '123456','%3d%1d%g'},...
        };
    ra={};
    rb={};
    rc={};
    rd={};
    for k=1:length(s)
        if length(s{k})==2
            [ra{k} rb{k} rc{k} rd{k}] = sscanf(s{k}{1},s{k}{2});
        else
            [ra{k} rb{k} rc{k} rd{k}] = sscanf(s{k}{1},s{k}{2},s{k}{3});
        end
    end
    save('sscanf_ref.mat','-V6','ra','rb','rc','rd','s');
      
else
    load('sscanf_ref.mat','ra','rb','rc','rd','s');
    for k=1:length(s)
        if length(s{k})==2
            [a b c d] = sscanf(s{k}{1},s{k}{2});
        else
            [a b c d] = sscanf(s{k}{1},s{k}{2},s{k}{3});
        end
        try
            if any(any(a~=ra{k})) || any(b~=rb{k}) ||  any(c~=rc{k}) || any(d~=rd{k}) %
                sprintf('Mismatch in %d: %s %s\n', k, s{k}{1},s{k}{2})
                {a b c d}
                {ra{k} rb{k} rc{k} rd{k}}
            end
        catch
            sprintf('Error in %d: %s %s\n', k, s{k}{1},s{k}{2})
        end
            
    end

end
y=0;