#include "print_visitor.hpp"

#include "build_tree.hpp"

#include <sys/types.h>
#include <dirent.h>

int main(int, char **)
{
        using namespace foundry::build;

        project_ptr proj = new project;

        {
                DIR *d = ::opendir(".");
                if(!d)
                        return 1;

                for(dirent *ent; ent = ::readdir(d);)
                {
                        if(ent->d_type != DT_REG)
                                continue;
                        file_ptr f = new file;
                        f->name = ent->d_name;
                        proj->inputs.push_back(f);
                }

                ::closedir(d);
        }

        print_visitor p;
        p.descend(proj);

        return 0;
}
