/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#include "dlgtest3.h"
#include "ui_dlgtest3.h"
#include "common.h"

dlgTest3::dlgTest3(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dlgTest3)
{
    ui->setupUi(this);
    sPrompt = "correctly - ";
    sResult = " effots total\nsuccess - ";
    sResultComplete = "Test completed wtith success ";
    sResultLeft = "\nwords left: ";
}

dlgTest3::~dlgTest3()
{
    delete ui;
}

void dlgTest3::Init()
{
    vSucceedTrigger = 0;
    vTotalEfforts = 0;
    vSucceedEfforts =0;
    aDictIndex.clear();
    int lenth = lTopicData->count();
    srand(time(0));
    vDictRandVal = fRandom(&lenth);
    int i = 0;
    while (i < lenth)
    {
        aDictIndex.append(i);
        i++;
    }
    ui->lbQuestion->setText(lTopicData->at(vDictRandVal)[1]);
    ui->lbPrompt->setText("");
    ui->leAnswer->setText("");
    ui->lbResult->setText("0" + sResult + "0%" + sResultLeft
                          + QString().setNum(aDictIndex.count()));
    ui->leAnswer->setFocus();
}

void dlgTest3::TestStart(QList<QStringList> *lsl)
{
    lTopicData = lsl;
    Init();
    this->show();
}

void dlgTest3::check()
{
    if(ui->leAnswer->text()=="")
        return;
    QString written;
    ui->lbPrompt->setText("");
    int lent = aDictIndex.count();
    if (lent < 1)
    {
        fShowMsg(sResultComplete + fPercent(&vTotalEfforts, &vSucceedEfforts));
        return;
    }
    int vInd = aDictIndex[vDictRandVal];
    written = ui->leAnswer->text();
    vTotalEfforts++;
    if (written == lTopicData->at(vInd)[0])
    {
        if (vSucceedTrigger < 1)
        {
            aDictIndex.removeAt(vDictRandVal);
            vSucceedEfforts++;
            ui->lbResult->setText(QString().setNum(vSucceedEfforts));
        }
        else
        {
            vSucceedTrigger--;
            vTotalEfforts--;
        }
        if (lent < 2)
            vDictRandVal = 0;
        else
            if (vSucceedTrigger < 1)
            {
                lent--;
                vDictRandVal = fRandom(&lent);
                vInd = aDictIndex[vDictRandVal];
            }
    }
    else
    {
        vSucceedTrigger = 2;
        ui->lbPrompt->setText(sPrompt + lTopicData->at(vInd)[0]);
    }
    ui->lbResult->setText(QString().setNum(vTotalEfforts) + sResult
                          + fPercent(&vTotalEfforts, &vSucceedEfforts) + sResultLeft + QString().setNum(lent));
    lent = aDictIndex.count();
    if (lent < 1)
    {
        ui->lbResult->setText(sResultComplete + fPercent(&vTotalEfforts, &vSucceedEfforts));
        ui->lbQuestion->setText("");
        return;
    }
    ui->lbQuestion->setText(lTopicData->at(vInd)[1]);
    ui->leAnswer->setText("");
    ui->leAnswer->setFocus();
}

void dlgTest3::GetUiText(QJsonObject *uitext)
{
    QJsonObject jobj;
    jobj.insert("answerTitle", QJsonValue(ui->gbAnswer->title()));
    jobj.insert("questionTitle", QJsonValue(ui->gbQuestion->title()));
    jobj.insert("exit", QJsonValue(ui->pbExit->text()));
    jobj.insert("result", QJsonValue(sResult));
    jobj.insert("resultComplete", QJsonValue(sResultComplete));
    jobj.insert("resultLeft", QJsonValue(sResultLeft));
    jobj.insert("prompt", QJsonValue(sPrompt));
    uitext->insert("test3",QJsonValue(jobj));
}

void dlgTest3::SetUiText(QJsonObject *uitext)
{
    QJsonObject jobj = uitext->value("test3").toObject();
    ui->gbAnswer->setTitle(jobj.value("answerTitle").toString());
    ui->gbQuestion->setTitle(jobj.value("questionTitle").toString());
    ui->pbExit->setText(jobj.value("exit").toString());
    sResult = jobj.value("result").toString();
    sResultComplete = jobj.value("resultComplete").toString();
    sResultLeft = jobj.value("resultLeft").toString();
    sPrompt = jobj.value("prompt").toString();
}

void dlgTest3::on_leAnswer_editingFinished()
{
    check();
}

void dlgTest3::on_pbOk_clicked()
{
    check();
}

void dlgTest3::on_pbExit_clicked()
{
    this->close();
}

