/* font-manager-database-error.h
 *
 * Copyright (C) 2009-2024 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#pragma once

#include <glib.h>
#include <glib-object.h>

GQuark font_manager_database_error_quark ();
#define FONT_MANAGER_DATABASE_ERROR (font_manager_database_error_quark ())

/**
 * FontManagerDatabaseError:
 * @FONT_MANAGER_DATABASE_ERROR_OK:             SQLITE_OK
 * @FONT_MANAGER_DATABASE_ERROR_ERROR:          SQLITE_ERROR
 * @FONT_MANAGER_DATABASE_ERROR_INTERNAL:       SQLITE_INTERNAL
 * @FONT_MANAGER_DATABASE_ERROR_PERM:           SQLITE_PERM
 * @FONT_MANAGER_DATABASE_ERROR_ABORT:          SQLITE_ABORT
 * @FONT_MANAGER_DATABASE_ERROR_BUSY:           SQLITE_BUSY
 * @FONT_MANAGER_DATABASE_ERROR_LOCKED:         SQLITE_LOCKED
 * @FONT_MANAGER_DATABASE_ERROR_NOMEM:          SQLITE_NOMEM
 * @FONT_MANAGER_DATABASE_ERROR_READONLY:       SQLITE_READONLY
 * @FONT_MANAGER_DATABASE_ERROR_INTERRUPT:      SQLITE_INTERRUPT
 * @FONT_MANAGER_DATABASE_ERROR_IOERR:          SQLITE_IOERR
 * @FONT_MANAGER_DATABASE_ERROR_CORRUPT:        SQLITE_CORRUPT
 * @FONT_MANAGER_DATABASE_ERROR_NOTFOUND:       SQLITE_NOTFOUND
 * @FONT_MANAGER_DATABASE_ERROR_FULL:           SQLITE_FULL
 * @FONT_MANAGER_DATABASE_ERROR_CANTOPEN:       SQLITE_CANTOPEN
 * @FONT_MANAGER_DATABASE_ERROR_PROTOCOL:       SQLITE_PROTOCOL
 * @FONT_MANAGER_DATABASE_ERROR_EMPTY:          SQLITE_EMPTY
 * @FONT_MANAGER_DATABASE_ERROR_SCHEMA:         SQLITE_SCHEMA
 * @FONT_MANAGER_DATABASE_ERROR_TOOBIG:         SQLITE_TOOBIG
 * @FONT_MANAGER_DATABASE_ERROR_CONSTRAINT:     SQLITE_CONSTRAINT
 * @FONT_MANAGER_DATABASE_ERROR_MISMATCH:       SQLITE_MISMATCH
 * @FONT_MANAGER_DATABASE_ERROR_MISUSE:         SQLITE_MISUSE
 * @FONT_MANAGER_DATABASE_ERROR_NOLFS:          SQLITE_NOLFS
 * @FONT_MANAGER_DATABASE_ERROR_AUTH:           SQLITE_AUTH
 * @FONT_MANAGER_DATABASE_ERROR_FORMAT:         SQLITE_FORMAT
 * @FONT_MANAGER_DATABASE_ERROR_RANGE:          SQLITE_RANGE
 * @FONT_MANAGER_DATABASE_ERROR_NOTADB:         SQLITE_NOTADB
 * @FONT_MANAGER_DATABASE_ERROR_NOTICE:         SQLITE_NOTICE
 * @FONT_MANAGER_DATABASE_ERROR_WARNING:        SQLITE_WARNING
 * @FONT_MANAGER_DATABASE_ERROR_ROW:            SQLITE_ROW
 * @FONT_MANAGER_DATABASE_ERROR_DONE:           SQLITE_DONE
 *
 * These errors map directly to SQLite error codes.
 * See https://sqlite.org/rescode.html for more detailed information.
 */
typedef enum
{
    FONT_MANAGER_DATABASE_ERROR_OK,
    FONT_MANAGER_DATABASE_ERROR_ERROR,
    FONT_MANAGER_DATABASE_ERROR_INTERNAL,
    FONT_MANAGER_DATABASE_ERROR_PERM,
    FONT_MANAGER_DATABASE_ERROR_ABORT,
    FONT_MANAGER_DATABASE_ERROR_BUSY,
    FONT_MANAGER_DATABASE_ERROR_LOCKED,
    FONT_MANAGER_DATABASE_ERROR_NOMEM,
    FONT_MANAGER_DATABASE_ERROR_READONLY,
    FONT_MANAGER_DATABASE_ERROR_INTERRUPT,
    FONT_MANAGER_DATABASE_ERROR_IOERR,
    FONT_MANAGER_DATABASE_ERROR_CORRUPT,
    FONT_MANAGER_DATABASE_ERROR_NOTFOUND,
    FONT_MANAGER_DATABASE_ERROR_FULL,
    FONT_MANAGER_DATABASE_ERROR_CANTOPEN,
    FONT_MANAGER_DATABASE_ERROR_PROTOCOL,
    FONT_MANAGER_DATABASE_ERROR_EMPTY,
    FONT_MANAGER_DATABASE_ERROR_SCHEMA,
    FONT_MANAGER_DATABASE_ERROR_TOOBIG,
    FONT_MANAGER_DATABASE_ERROR_CONSTRAINT,
    FONT_MANAGER_DATABASE_ERROR_MISMATCH,
    FONT_MANAGER_DATABASE_ERROR_MISUSE,
    FONT_MANAGER_DATABASE_ERROR_NOLFS,
    FONT_MANAGER_DATABASE_ERROR_AUTH,
    FONT_MANAGER_DATABASE_ERROR_FORMAT,
    FONT_MANAGER_DATABASE_ERROR_RANGE,
    FONT_MANAGER_DATABASE_ERROR_NOTADB,
    FONT_MANAGER_DATABASE_ERROR_NOTICE,
    FONT_MANAGER_DATABASE_ERROR_WARNING,
    FONT_MANAGER_DATABASE_ERROR_ROW = 100,
    FONT_MANAGER_DATABASE_ERROR_DONE = 101
}
FontManagerDatabaseError;

GType font_manager_database_error_get_type (void);
#define FONT_MANAGER_TYPE_DATABASE_ERROR (font_manager_database_error_get_type ())

