/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.AnimationControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.RealType;
import visad.Set;
import visad.ToggleControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.java2d.AVControlJ2D;
import visad.java2d.AnimationSetControlJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;
import visad.util.Delay;

public class AnimationControlJ2D
extends AVControlJ2D
implements Runnable,
AnimationControl {
    private int current = 0;
    private boolean direction;
    private long step;
    private long[] stepValues = new long[]{500L};
    private transient AnimationSetControlJ2D animationSet;
    private ToggleControl animate;
    private RealType real;
    private boolean no_tick = false;
    private boolean computeSet = true;
    private transient VisADCanvasJ2D canvas;
    private transient Thread animationThread;

    public AnimationControlJ2D(DisplayImplJ2D d, RealType r) {
        super(d);
        this.real = r;
        this.current = 0;
        this.direction = true;
        this.step = 500L;
        this.stepValues = new long[]{this.step};
        if (d != null) {
            this.canvas = ((DisplayRendererJ2D)d.getDisplayRenderer()).getCanvas();
            this.animationSet = new AnimationSetControlJ2D(d, this);
            d.addControl(this.animationSet);
            this.animate = new ToggleControl(d, this);
            d.addControl(this.animate);
            try {
                this.animate.setOn(false);
            }
            catch (VisADException v) {
            }
            catch (RemoteException v) {
                // empty catch block
            }
            new Delay();
            try {
                Set set = this.animationSet.getSet();
                if (set != null) {
                    this.stepValues = new long[set.getLength()];
                }
            }
            catch (VisADException v) {
                // empty catch block
            }
            for (int i = 0; i < this.stepValues.length; ++i) {
                this.stepValues[i] = this.step;
            }
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public void nullControl() {
        this.stop();
        super.nullControl();
    }

    public void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        while (this.animationThread == me) {
            try {
                if (this.animate != null && this.animate.getOn() && !this.no_tick) {
                    this.takeStep();
                }
            }
            catch (VisADException v) {
                v.printStackTrace();
                throw new VisADError("AnimationControlJ2D.run: " + v.toString());
            }
            catch (RemoteException v) {
                v.printStackTrace();
                throw new VisADError("AnimationControlJ2D.run: " + v.toString());
            }
            try {
                AnimationControlJ2D v = this;
                synchronized (v) {
                    if (0 <= this.current && this.current < this.stepValues.length) {
                        this.wait(this.stepValues[this.current]);
                    } else {
                        this.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void setNoTick(boolean nt) {
        this.no_tick = nt;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int c) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(c);
            this.canvas.renderTrigger();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setCurrent(double value) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.getIndex(value);
            this.canvas.renderTrigger();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setDirection(boolean dir) throws VisADException, RemoteException {
        this.direction = dir;
        this.changeControl(false);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public long getStep() {
        if (this.stepValues == null || this.current < 0 || this.stepValues.length <= this.current) {
            return 500L;
        }
        return this.stepValues[this.current];
    }

    public long[] getSteps() {
        return this.stepValues;
    }

    public void setStep(int st) throws VisADException, RemoteException {
        if (st <= 0) {
            throw new DisplayException("AnimationControlJ2D.setStep: step must be > 0");
        }
        this.step = st;
        for (int i = 0; i < this.stepValues.length; ++i) {
            this.stepValues[i] = this.step;
        }
        this.changeControl(false);
    }

    public void setSteps(int[] steps) throws VisADException, RemoteException {
        for (int i = 0; i < this.stepValues.length; ++i) {
            long l = this.stepValues[i] = i < steps.length ? (long)steps[i] : (long)steps[steps.length - 1];
            if (this.stepValues[i] > 0L) continue;
            throw new DisplayException("AnimationControlJ2D.setSteps: step " + i + " must be > 0");
        }
        this.changeControl(false);
    }

    public void takeStep() throws VisADException, RemoteException {
        this.current = this.direction ? ++this.current : --this.current;
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(this.current);
            this.canvas.renderTrigger();
        }
        this.changeControl(false);
    }

    public void init() throws VisADException {
        if (this.animationSet != null && this.animationSet.getSet() != null) {
            double value = this.animationSet.getValue(this.current);
            Set set = this.animationSet.getSet();
            this.animation_string(this.real, set, value, this.current);
            this.selectSwitches(value, set);
        }
    }

    public Set getSet() {
        if (this.animationSet != null) {
            return this.animationSet.getSet();
        }
        return null;
    }

    public void setSet(Set s) throws VisADException, RemoteException {
        if (s == null && this.animationSet != null && this.animationSet.getSet() == null) {
            return;
        }
        if (this.animationSet == null || s == null || s != null && !s.equals(this.animationSet.getSet())) {
            this.setSet(s, false);
            if (s == null) {
                this.stepValues = new long[]{this.step};
                this.current = 0;
            } else if (s.getLength() != this.stepValues.length) {
                this.stepValues = new long[s.getLength()];
                for (int i = 0; i < this.stepValues.length; ++i) {
                    this.stepValues[i] = this.step;
                }
            }
        }
    }

    public void setSet(Set s, boolean noChange) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            if (s == null) {
                this.stepValues = new long[]{this.step};
                this.current = 0;
            } else if (s.getLength() != this.stepValues.length) {
                this.stepValues = new long[s.getLength()];
                for (int i = 0; i < this.stepValues.length; ++i) {
                    this.stepValues[i] = this.step;
                }
            }
            this.animationSet.setSet(s, noChange);
        }
    }

    public boolean getOn() {
        if (this.animate != null) {
            return this.animate.getOn();
        }
        return false;
    }

    public void setOn(boolean o) throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(o);
        }
    }

    public void toggle() throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(!this.animate.getOn());
        }
    }

    public void subSetTicks() {
        if (this.animationSet != null) {
            this.animationSet.setTicks();
        }
        if (this.animate != null) {
            this.animate.setTicks();
        }
    }

    public boolean subCheckTicks(DataRenderer r, DataDisplayLink link) {
        boolean flag = false;
        if (this.animationSet != null) {
            flag |= this.animationSet.checkTicks(r, link);
        }
        if (this.animate != null) {
            flag |= this.animate.checkTicks(r, link);
        }
        return flag;
    }

    public boolean subPeekTicks(DataRenderer r, DataDisplayLink link) {
        boolean flag = false;
        if (this.animationSet != null) {
            flag |= this.animationSet.peekTicks(r, link);
        }
        if (this.animate != null) {
            flag |= this.animate.peekTicks(r, link);
        }
        return flag;
    }

    public void subResetTicks() {
        if (this.animationSet != null) {
            this.animationSet.resetTicks();
        }
        if (this.animate != null) {
            this.animate.resetTicks();
        }
    }

    public String getSaveString() {
        long[] steps;
        int numSteps;
        if (this.stepValues == null) {
            numSteps = 1;
            steps = new long[]{500L};
        } else {
            numSteps = this.stepValues.length;
            steps = this.stepValues;
        }
        StringBuffer sb = new StringBuffer(35 + 12 * numSteps);
        sb.append(this.animate != null && this.animate.getOn());
        sb.append(' ');
        sb.append(this.direction);
        sb.append(' ');
        sb.append(this.current);
        sb.append(' ');
        sb.append(numSteps);
        for (int i = 0; i < numSteps; ++i) {
            sb.append(' ');
            sb.append((int)steps[i]);
        }
        sb.append(' ');
        sb.append(this.computeSet);
        return sb.toString();
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        int numTokens = st.countTokens();
        if (numTokens < 4) {
            throw new VisADException("Invalid save string");
        }
        boolean on = Convert.getBoolean(st.nextToken());
        boolean dir = Convert.getBoolean(st.nextToken());
        int cur = Convert.getInt(st.nextToken());
        int numSteps = Convert.getInt(st.nextToken());
        if (numSteps <= 0) {
            throw new VisADException("Number of steps is not positive");
        }
        if (numTokens < 4 + numSteps) {
            throw new VisADException("Not enough step entries");
        }
        int[] steps = new int[numSteps];
        for (int i = 0; i < numSteps; ++i) {
            steps[i] = Convert.getInt(st.nextToken());
            if (steps[i] > 0) continue;
            throw new VisADException("Step #" + (i + 1) + "is not positive");
        }
        boolean cs = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getComputeSet();
        this.setOn(on);
        this.setDirection(dir);
        this.setSteps(steps);
        this.setCurrent(cur);
        this.setComputeSet(cs);
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof AnimationControlJ2D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        AnimationControlJ2D ac = (AnimationControlJ2D)rmt;
        boolean changed = false;
        if (this.direction != ac.direction) {
            changed = true;
            this.direction = ac.direction;
        }
        if (this.animate != ac.animate) {
            changed = true;
            this.animate = ac.animate;
        }
        if (this.real != ac.real) {
            changed = true;
            this.real = ac.real;
        }
        if (this.no_tick != ac.no_tick) {
            changed = true;
            this.no_tick = ac.no_tick;
        }
        if (this.computeSet != ac.computeSet) {
            changed = true;
            this.computeSet = ac.computeSet;
        }
        if (changed) {
            try {
                this.changeControl(false);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AnimationControlJ2D ac = (AnimationControlJ2D)o;
        if (this.direction != ac.direction) {
            return false;
        }
        if (this.animate != ac.animate) {
            return false;
        }
        if (this.real != ac.real) {
            return false;
        }
        if (this.no_tick != ac.no_tick) {
            return false;
        }
        return this.computeSet == ac.computeSet;
    }

    public String toString() {
        return "AnimationControlJ2D: current = " + this.current + " set = " + this.animationSet.getSet();
    }

    public void setComputeSet(boolean compute) {
        this.computeSet = compute;
    }

    public boolean getComputeSet() {
        return this.computeSet;
    }
}

